/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.statemachine;

import com.wily.util.clock.MasterClock;
import com.wily.util.statemachine.IState;
import com.wily.util.statemachine.InvalidFollowStateException;
import com.wily.util.statemachine.InvalidStateMachineException;
import com.wily.util.statemachine.NotInExpectedStateException;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.wilyassert.Assertion;

public class StateMachine {
    private final IState[] fStateList;
    private volatile IState fCurrentState;
    private volatile int fNumThreadsWaiting;
    private final StateMachineLock fStateLock = new StateMachineLock();

    public StateMachine(IState[] stateList, IState startState) throws InvalidStateMachineException {
        this.validateStateList(stateList);
        this.validateStartState(stateList, startState);
        this.fStateList = stateList;
        this.fCurrentState = startState;
        this.fNumThreadsWaiting = 0;
    }

    private void validateStateList(IState[] stateList) throws InvalidStateMachineException {
        if (stateList == null || stateList.length == 0) {
            throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Empty_State_List_Key"));
        }
        int i = 0;
        while (i < stateList.length) {
            if (stateList[i] == null) {
                throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Missing_State_Key"));
            }
            int j = 0;
            while (j < i) {
                if (stateList[i].equals(stateList[j])) {
                    throw new InvalidStateMachineException(new FormattedLocalizableMessage("State_Machine_Duplicate_State_Key", stateList[i].IState_getName()));
                }
                ++j;
            }
            ++i;
        }
    }

    private void validateStartState(IState[] stateList, IState state) throws InvalidStateMachineException {
        if (state == null) {
            throw new InvalidStateMachineException(new SimpleLocalizableMessage("State_Machine_Missing_Start_State_Key"));
        }
        if (!this.containsState(stateList, state)) {
            throw new InvalidStateMachineException(new FormattedLocalizableMessage("State_Machine_Invalid_Start_State_Key", state.IState_getName()));
        }
    }

    private StateMachineLock getStateMachineLock() {
        return this.fStateLock;
    }

    private boolean isValidState(IState state) {
        if (state != null) {
            int i = 0;
            while (i < this.fStateList.length) {
                if (this.fStateList[i].equals(state)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean hasValidState(IState[] states) {
        if (states != null) {
            int i = 0;
            while (i < states.length) {
                if (this.isValidState(states[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean containsState(IState[] states, IState state) {
        if (states != null && state != null) {
            int i = 0;
            while (i < states.length) {
                if (state == states[i]) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public IState getState() {
        return this.fCurrentState;
    }

    public int getNumThreadsWaiting() {
        return this.fNumThreadsWaiting;
    }

    private void addWaitingThread() {
        ++this.fNumThreadsWaiting;
    }

    private void removeWaitingThread() {
        --this.fNumThreadsWaiting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(IState state) throws InvalidFollowStateException {
        StateMachineLock lock;
        if (state == null) {
            throw new InvalidFollowStateException(new SimpleLocalizableMessage("State_Machine_Missing_Follow_State_Key"));
        }
        if (!this.isValidState(state)) {
            throw new InvalidFollowStateException(new FormattedLocalizableMessage("State_Machine_Invalid_State_Key", state.IState_getName()));
        }
        StateMachineLock stateMachineLock = lock = this.getStateMachineLock();
        synchronized (stateMachineLock) {
            if (!this.getState().IState_isValidFollowState(state)) {
                throw new InvalidFollowStateException(new FormattedLocalizableMessage("State_Machine_Invalid_Follow_State_Key", state.IState_getName()));
            }
            this.fCurrentState = state;
            lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void followTransition(IState currentState, IState targetState) throws InvalidFollowStateException, NotInExpectedStateException {
        if (currentState == null) {
            throw new NotInExpectedStateException(new FormattedLocalizableMessage("State_Machine_Not_In_Expected_State_Key", this.getState().IState_getName(), null));
        }
        StateMachineLock stateMachineLock = this.getStateMachineLock();
        synchronized (stateMachineLock) {
            if (this.getState() != currentState) {
                throw new NotInExpectedStateException(new FormattedLocalizableMessage("State_Machine_Not_In_Expected_State_Key", this.getState().IState_getName(), currentState.IState_getName()));
            }
            this.setState(targetState);
        }
    }

    public void waitForStates(IState[] states) throws InterruptedException {
        this.waitForStates(states, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void waitForStates(IState[] states, long timeout) throws InterruptedException {
        StateMachineLock lock;
        Assertion.wilyAssert(false);
        if (timeout < 0L) return;
        if (!this.hasValidState(states)) return;
        StateMachineLock stateMachineLock = lock = this.getStateMachineLock();
        // MONITORENTER : stateMachineLock
        try {
            this.addWaitingThread();
            long endTime = MasterClock.currentTimeMillis() + timeout;
            while (!this.containsState(states, this.getState())) {
                if (this.timeoutExpired(timeout, endTime)) {
                    return;
                }
                lock.wait(timeout);
            }
            return;
        }
        finally {
            this.removeWaitingThread();
        }
    }

    private boolean timeoutExpired(long timeout, long endTime) {
        if (timeout > 0L) {
            return MasterClock.currentTimeMillis() >= endTime;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUnderStateMachineLock(Runnable runnable) {
        if (runnable != null) {
            StateMachineLock stateMachineLock = this.getStateMachineLock();
            synchronized (stateMachineLock) {
                runnable.run();
            }
        }
    }

    private static class StateMachineLock {
        private StateMachineLock() {
        }
    }
}

