/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.text;

import com.wily.util.text.AStringLocalizer;
import com.wily.util.text.IStringLocalizer;
import java.util.Locale;

public class StringLocalizerHandle {
    private static IStringLocalizer sStringLocalizer = new EmptyLocalizer();

    private StringLocalizerHandle() {
    }

    public static IStringLocalizer getStringLocalizer() {
        return sStringLocalizer;
    }

    public static void setStringLocalizer(IStringLocalizer stringLocalizer) {
        sStringLocalizer = stringLocalizer;
    }

    private static class EmptyLocalizer
    extends AStringLocalizer {
        private EmptyLocalizer() {
        }

        @Override
        public String getFormattedLocalizedString(String key, String[] parameters) {
            return this.getFormattedLocalizedString(Locale.getDefault(), key, parameters);
        }

        @Override
        public String getFormattedLocalizedString(Locale locale, String key, String[] parameters) {
            StringBuilder buf = new StringBuilder(key);
            if (parameters != null && parameters.length > 0) {
                buf.append("[");
                int i = 0;
                while (i < parameters.length) {
                    buf.append(parameters[i]);
                    if (i < parameters.length - 1) {
                        buf.append("; ");
                    }
                    ++i;
                }
                buf.append("]");
            }
            return buf.toString();
        }

        @Override
        protected String getLocalizedString(String key) {
            return key;
        }

        @Override
        protected String getLocalizedString(Locale locale, String key) {
            return key;
        }
    }
}

