/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonItem;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;

public class DBMonChain
implements Runnable {
    private final DBMonMetricsContext dbContext;
    private List<DBMonCommand> commands = new ArrayList<DBMonCommand>();
    private IModuleFeedbackChannel logger;
    private DBMonItem monitoringItem;

    public DBMonChain(IModuleFeedbackChannel logger, DBMonMetricsContext dbContext, DBMonItem monitoringItem) {
        this.logger = logger;
        this.dbContext = dbContext;
        this.monitoringItem = monitoringItem;
    }

    public void add(DBMonCommand dbCommand) {
        this.commands.add(dbCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.toggleRunState(this.monitoringItem, true);
            for (DBMonCommand command : this.commands) {
                boolean shouldContinue = command.execute(this.dbContext);
                if (shouldContinue) continue;
                break;
            }
        }
        catch (Exception exe) {
            this.logger.error((Throwable)exe);
        }
        finally {
            this.recordLastExecutionTime(this.monitoringItem);
            this.toggleRunState(this.monitoringItem, false);
        }
    }

    private void recordLastExecutionTime(DBMonItem monitoringItem) {
        this.dbContext.setLastExecutionTime(monitoringItem, System.currentTimeMillis());
    }

    private void toggleRunState(DBMonItem monitoringItem, boolean runState) {
        this.dbContext.setRunning(monitoringItem, runState);
    }
}

