/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon;

import com.ca.agent.extensions.dbmon.DBMonAPMAttribute;
import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonItem;
import com.ca.agent.extensions.dbmon.DBMonRunState;
import com.ca.agent.extensions.dbmon.InstallCert;
import com.ca.agent.extensions.dbmon.atc.DBMonATCManager;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonEventResource;
import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlanSnapshot;
import com.ca.agent.extensions.dbmon.entity.query.snapshot.DBMonGenericSnapshot;
import com.ca.agent.extensions.dbmon.helper.CommonEncryptionProvider;
import com.ca.agent.extensions.dbmon.schema.DBMonDetailsSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonInfoSchema;
import com.wily.introscope.agent.IAgent;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.NoSuchPaddingException;

public class DBMonMetricsContext {
    public static final Module DBMON_MODULE = new Module("DBMonitor");
    private static final String SNOWFLAKE_DB_STR = "SNOWFLAKE_DB";
    private static final String USER_STR = "user";
    private static final String PASSWORD_STR = "password";
    private static final String ROLE_STR = "role";
    private static final String DOMAIN = "domain";
    private static final String WINDOWS = "windows";
    private static final String AUTH_SCHEME = "authenticationscheme";
    private static final String DEFAULT_INSTANCE = "Default_Instance";
    private static final String PRIVATEKEYFILE_STR = "private_key_file";
    private static final String PRIVATEKEYFILEPWD_STR = "private_key_file_pwd";
    private static final String ACCOUNTIDENTIFIERHOST_STR = "{accountIdentifierHost}";
    private static final String INTEGRATED_SECURITY = "integratedSecurity";
    private static final String SQLSERVER_AD_USER_CONN_STRING = ";encrypt=true;trustServerCertificate=true;";
    public static final String DEFAULT_HOST_NAME = "localhost";
    private static final String APMIA_EXTN_HOME = "{ApmExtensionHome}";
    private static Set<String> driverClasses = new HashSet<String>();
    private final DBMonInfoSchema dbInfoSchema;
    private final DBMonDetailsSchema dbDetailsSchema;
    private final IAgent agent;
    private long lastATCSentTime;
    private CommonEncryptionProvider cep = new CommonEncryptionProvider();
    private DBMonATCManager dbMonATCManager;
    private List<DBMonAPMMetric> apmMetrics = new CopyOnWriteArrayList<DBMonAPMMetric>();
    private Map<String, DBMonAPMMetric> dbAllMetrics = new ConcurrentHashMap<String, DBMonAPMMetric>();
    private List<DBMonAPMAttribute> apmAttributes = new CopyOnWriteArrayList<DBMonAPMAttribute>();
    private Map<String, List<DBMonAPMAttribute>> apmClusterAttributes = new ConcurrentHashMap<String, List<DBMonAPMAttribute>>();
    private Map<String, DBMonResultSet> dbResultSet = new ConcurrentHashMap<String, DBMonResultSet>();
    private Map<String, DBMonResultSet> dbAttributeResultSet = new ConcurrentHashMap<String, DBMonResultSet>();
    private final Map<String, DBMonResultSet> dbTraceResultSet = new ConcurrentHashMap<String, DBMonResultSet>();
    private Map<DBMonEventResource, DBMonQueryPlanSnapshot> dbQueryPlanResultSet = new ConcurrentHashMap<DBMonEventResource, DBMonQueryPlanSnapshot>();
    private Map<String, DBMonGenericSnapshot> dbMonSnapshot = new LinkedHashMap<String, DBMonGenericSnapshot>();
    private final EnumMap<DBMonItem, DBMonRunState> runState;
    private Map<String, Long> queryExecutionCache = new ConcurrentHashMap<String, Long>();
    private Map<String, Long> traceQueryExecutionCache = new ConcurrentHashMap<String, Long>();
    private long dbLastUpdateTime = 0L;
    private final IModuleFeedbackChannel logger;

    public DBMonMetricsContext(DBMonInfoSchema dbInfo, DBMonDetailsSchema dbMetrics, IAgent agent) {
        this.dbInfoSchema = dbInfo;
        this.dbDetailsSchema = dbMetrics;
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
        this.runState = this.initializeRunState();
    }

    public String getRootPath() {
        String dbName = this.dbInfoSchema.getDatabaseType().substring(0, this.dbInfoSchema.getDatabaseType().indexOf("_DB"));
        if (dbName != null && !dbName.equals("")) {
            String[] dbNameTokens = dbName.split("_");
            dbName = dbNameTokens[0].substring(0, 1) + dbNameTokens[0].substring(1).toLowerCase();
            for (int i = 1; i < dbNameTokens.length; ++i) {
                dbName = dbName + " " + dbNameTokens[i];
            }
            dbName = dbName.replaceAll("(?i)sql", "SQL");
            String dbHostName = this.dbInfoSchema.getHostName();
            String dbInstanceName = this.dbInfoSchema.getInstanceName();
            if (this.dbInfoSchema.getDatabaseType().equals("SQL_SERVER_DB")) {
                if (dbHostName == null || dbHostName != null && dbHostName.isEmpty()) {
                    dbHostName = DEFAULT_HOST_NAME;
                }
                if (dbInstanceName == null || dbInstanceName != null && dbInstanceName.isEmpty()) {
                    dbInstanceName = DEFAULT_INSTANCE;
                }
            }
            if (this.getDbDetailsSchema().isCluster()) {
                dbName = dbName + " @ " + dbInstanceName + "|";
            } else {
                dbName = dbName + " Databases";
                dbName = dbName + "|" + dbHostName + "|" + dbInstanceName + "|";
            }
        }
        return dbName;
    }

    public DBMonInfoSchema getDbInfoSchema() {
        return this.dbInfoSchema;
    }

    public DBMonDetailsSchema getDbDetailsSchema() {
        return this.dbDetailsSchema;
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public List<DBMonAPMMetric> getApmMetrics() {
        return this.apmMetrics;
    }

    public void setApmMetrics(List<DBMonAPMMetric> apmMetrics) {
        this.apmMetrics = apmMetrics;
    }

    public Map<String, DBMonAPMMetric> getDbAllMetrics() {
        return this.dbAllMetrics;
    }

    public void setDbAllMetrics(Map<String, DBMonAPMMetric> dbAllMetrics) {
        this.dbAllMetrics = dbAllMetrics;
    }

    public void addApmMetrics(List<DBMonAPMMetric> apmMetrics) {
        this.apmMetrics.addAll(apmMetrics);
    }

    public void addDbAllMetrics(String key, DBMonAPMMetric apmMetric) {
        this.dbAllMetrics.put(key, apmMetric);
    }

    public Map<String, DBMonResultSet> getDbResultSet() {
        return this.dbResultSet;
    }

    public void setDbResultSet(Map<String, DBMonResultSet> dbResultSet) {
        this.dbResultSet = dbResultSet;
    }

    public Map<String, DBMonResultSet> getDbTraceResultSet() {
        return this.dbTraceResultSet;
    }

    public Map<DBMonEventResource, DBMonQueryPlanSnapshot> getDbQueryPlanResultSet() {
        return this.dbQueryPlanResultSet;
    }

    public Map<String, DBMonGenericSnapshot> getDbMonSnapshot() {
        return this.dbMonSnapshot;
    }

    public void setDbMonSnapshot(Map<String, DBMonGenericSnapshot> dbMonSnapshot) {
        this.dbMonSnapshot = dbMonSnapshot;
    }

    public Connection initializeConnection() throws ClassNotFoundException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, BadPaddingException, DBMonException, SQLException {
        this.loadDBClass(this.getDbDetailsSchema().getDriverName());
        String jdbcUrl = this.getDbDetailsSchema().getJdbcUrl();
        jdbcUrl = jdbcUrl.replace("{hostName}", this.getDbInfoSchema().getHostName());
        jdbcUrl = jdbcUrl.replace("{port}", "" + this.getDbInfoSchema().getPort());
        jdbcUrl = jdbcUrl.replace("{instanceName}", "" + this.getDbInfoSchema().getInstanceName());
        String password = "";
        Properties properties = new Properties();
        String dbSchemaPassword = this.getDbInfoSchema().getPassword();
        if (!StringUtils.isEmpty((String)dbSchemaPassword)) {
            password = this.cep.getDecryptedPassword(dbSchemaPassword);
        }
        if (this.getDbDetailsSchema().getDriverName().contains("SQLServerDriver")) {
            if (this.getDbInfoSchema().getAuthType() != null && !this.getDbInfoSchema().getAuthType().isEmpty() && this.getDbInfoSchema().getAuthType().equalsIgnoreCase(WINDOWS)) {
                jdbcUrl = jdbcUrl.concat(";encrypt=true;trustServerCertificate=true;integratedSecurity=true");
            }
            if (this.getDbInfoSchema().getAuthenticationScheme() != null && !this.getDbInfoSchema().getAuthenticationScheme().isEmpty()) {
                jdbcUrl = jdbcUrl.contains(SQLSERVER_AD_USER_CONN_STRING) ? jdbcUrl.concat(";authenticationscheme=" + this.getDbInfoSchema().getAuthenticationScheme()) : jdbcUrl.concat(";encrypt=true;trustServerCertificate=true;authenticationscheme=" + this.getDbInfoSchema().getAuthenticationScheme());
            }
            if (this.getDbInfoSchema().getUserName().contains("\\")) {
                String[] userArr = this.getDbInfoSchema().getUserName().split("\\\\");
                jdbcUrl = jdbcUrl.concat(";domain=" + userArr[0]);
                properties.put(USER_STR, userArr[1]);
            } else {
                properties.put(USER_STR, this.getDbInfoSchema().getUserName());
            }
        } else {
            properties.put(USER_STR, this.getDbInfoSchema().getUserName());
        }
        if (!StringUtils.isEmpty((String)password)) {
            properties.put(PASSWORD_STR, password);
        }
        if (this.getDbInfoSchema().getDatabaseType().contains(SNOWFLAKE_DB_STR)) {
            jdbcUrl = jdbcUrl.replace(ACCOUNTIDENTIFIERHOST_STR, this.getDbInfoSchema().getAccountIdentifierHost());
            properties.put(ROLE_STR, this.getDbInfoSchema().getRoleName());
            String privateKeyPath = this.getDbInfoSchema().getPrivateKey();
            String privateKeyPassword = this.getDbInfoSchema().getPrivateKeyPassPhrase();
            String apmiaFilePath = this.getDbInfoSchema().getExtensionDirectory() + File.separator;
            String privateKeyFilePath = privateKeyPath.replace(APMIA_EXTN_HOME, apmiaFilePath);
            if (!StringUtils.isEmpty((String)privateKeyPath) && this.checkFileExists(privateKeyFilePath)) {
                properties.put(PRIVATEKEYFILE_STR, privateKeyFilePath);
            } else {
                this.logger.warn(DBMON_MODULE, "Provided SnowFlake PrivateKey path [ " + privateKeyFilePath + "] is not valid. Will not connect to snowflake database");
            }
            if (!StringUtils.isEmpty((String)privateKeyPassword)) {
                properties.put(PRIVATEKEYFILEPWD_STR, this.cep.getDecryptedPassword(privateKeyPassword));
            }
            InstallCert.installCertificate(this.logger, this.getDbInfoSchema().getAccountIdentifierHost(), this.getDbInfoSchema().getPort(), this.getDbInfoSchema().getExtensionDirectory() + File.separator + ".." + File.separator + ".." + File.separator + "jre" + File.separator + "lib" + File.separator + "security" + File.separator + "cacerts");
        }
        return DriverManager.getConnection(jdbcUrl, properties);
    }

    private boolean checkFileExists(String resolvedPath) {
        Path path = Paths.get(resolvedPath, new String[0]);
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDBClass(String driverName) throws ClassNotFoundException {
        if (!driverClasses.contains(driverName)) {
            Set<String> set = driverClasses;
            synchronized (set) {
                Class.forName(driverName);
                driverClasses.add(driverName);
            }
        }
    }

    public long getLastATCSentTime() {
        return this.lastATCSentTime;
    }

    public void setLastATCSentTime(long lastATCSentTime) {
        this.lastATCSentTime = lastATCSentTime;
    }

    public void initializeDBMonATCManager() {
        this.dbMonATCManager = new DBMonATCManager(this);
        this.dbMonATCManager.initialize();
    }

    public DBMonATCManager getDbMonATCManager() {
        return this.dbMonATCManager;
    }

    public boolean isDbTracesEnabled() {
        return this.dbInfoSchema.isDbSnapsotTracesEnabled();
    }

    public List<DBMonAPMAttribute> getApmAttributes() {
        return this.apmAttributes;
    }

    public void setApmAttributes(List<DBMonAPMAttribute> apmAttributes) {
        this.apmAttributes = apmAttributes;
    }

    public Map<String, List<DBMonAPMAttribute>> getAPMClusterAttributes() {
        return this.apmClusterAttributes;
    }

    public void setAPMClusterAttributes(Map<String, List<DBMonAPMAttribute>> apmClusterAttributes) {
        this.apmClusterAttributes = apmClusterAttributes;
    }

    public boolean isRunning(DBMonItem item) {
        try {
            return item == null ? false : this.runState.get(item).isRunning();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setRunning(DBMonItem item, Boolean running) {
        DBMonRunState itemRunState = this.runState.get(item);
        if (itemRunState != null) {
            itemRunState.setRunning(running);
        }
    }

    public long getLastExecutionTime(DBMonItem item) {
        try {
            return item == null ? 0L : this.runState.get(item).getLastExecutionTime();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public void setLastExecutionTime(DBMonItem item, long lastExecutionTime) {
        DBMonRunState itemRunState = this.runState.get(item);
        if (itemRunState != null) {
            itemRunState.setLastExecutionTime(lastExecutionTime);
        }
    }

    private EnumMap<DBMonItem, DBMonRunState> initializeRunState() {
        EnumMap<DBMonItem, DBMonRunState> runStateMap = new EnumMap<DBMonItem, DBMonRunState>(DBMonItem.class);
        for (DBMonItem item : DBMonItem.values()) {
            runStateMap.put(item, new DBMonRunState());
        }
        return runStateMap;
    }

    public Map<String, DBMonResultSet> getDbAttributeResultSet() {
        return this.dbAttributeResultSet;
    }

    public void setDbAttributeResultSet(Map<String, DBMonResultSet> dbAttributeResultSet) {
        this.dbAttributeResultSet = dbAttributeResultSet;
    }

    public long getDbLastUpdateTime() {
        return this.dbLastUpdateTime;
    }

    public void setDbLastUpdateTime(long dbLastUpdateTime) {
        this.dbLastUpdateTime = dbLastUpdateTime;
    }

    public Map<String, Long> getQueryExecutionCache() {
        return this.queryExecutionCache;
    }

    public void setQueryExecutionCache(Map<String, Long> queryExecutionCache) {
        this.queryExecutionCache = queryExecutionCache;
    }

    public Map<String, Long> getTraceQueryExecutionCache() {
        return this.traceQueryExecutionCache;
    }

    public void setTraceQueryExecutionCache(Map<String, Long> traceQueryExecutionCache) {
        this.traceQueryExecutionCache = traceQueryExecutionCache;
    }

    public String printDbConnectionDetails() {
        if (this.dbInfoSchema != null) {
            return this.dbInfoSchema.getDBConnectionDetails();
        }
        return "";
    }
}

