/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon;

import com.ca.agent.extensions.dbmon.DBMonChain;
import com.ca.agent.extensions.dbmon.DBMonItem;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.commands.DBMonCalculatedMetricsCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonCheckDBAvailabilityCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonClearAttributesCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonClearMetricValuesCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonCreateVertexCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonExecuteAttributeQueryCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonExecuteQueryCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonPopulateAPMAttributesCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonPopulateAPMMetricsCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonPushMetricsToEMCommand;
import com.ca.agent.extensions.dbmon.commands.DBMonRemoveStaleMetricsCommand;
import com.ca.agent.extensions.dbmon.commands.traces.DBMonClearSnapshotValuesCommand;
import com.ca.agent.extensions.dbmon.commands.traces.DBMonExecuteTraceQueryCommand;
import com.ca.agent.extensions.dbmon.commands.traces.DBMonExplainPlanQueryCommand;
import com.ca.agent.extensions.dbmon.commands.traces.DBMonPushTraceSnapshotToEMCommand;
import com.ca.agent.extensions.dbmon.commands.traces.DBMonSnapshotCommand;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.List;
import java.util.concurrent.ExecutorService;

public class DBMonitorTasksCreator
implements Runnable {
    private List<DBMonMetricsContext> dbs;
    private ExecutorService dbExecutorPool;
    private IModuleFeedbackChannel logger;

    public DBMonitorTasksCreator(IModuleFeedbackChannel logger, List<DBMonMetricsContext> dbs, ExecutorService dbExecutorPool) {
        this.dbs = dbs;
        this.dbExecutorPool = dbExecutorPool;
        this.logger = logger;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        while (true) lbl-1000:
        // 5 sources

        {
            for (DBMonMetricsContext dbContext : this.dbs) {
                if (DBMonItem.METRIC.shouldRun(dbContext)) {
                    dbChain = new DBMonChain(this.logger, dbContext, DBMonItem.METRIC);
                    dbChain.add(new DBMonCheckDBAvailabilityCommand());
                    dbChain.add(new DBMonExecuteQueryCommand());
                    dbChain.add(new DBMonPopulateAPMMetricsCommand());
                    dbChain.add(new DBMonCalculatedMetricsCommand());
                    dbChain.add(new DBMonPushMetricsToEMCommand());
                    dbChain.add(new DBMonClearMetricValuesCommand());
                    dbChain.add(new DBMonRemoveStaleMetricsCommand());
                    this.dbExecutorPool.execute(dbChain);
                }
                if (DBMonItem.ATTRIBUTE.shouldRun(dbContext)) {
                    dbChain = new DBMonChain(this.logger, dbContext, DBMonItem.ATTRIBUTE);
                    dbChain.add(new DBMonExecuteAttributeQueryCommand());
                    dbChain.add(new DBMonPopulateAPMAttributesCommand());
                    dbChain.add(new DBMonCreateVertexCommand());
                    dbChain.add(new DBMonClearAttributesCommand());
                    this.dbExecutorPool.execute(dbChain);
                }
                if (!dbContext.isDbTracesEnabled() || !DBMonItem.SNAPSHOT.shouldRun(dbContext)) continue;
                dbTraceChain = new DBMonChain(this.logger, dbContext, DBMonItem.SNAPSHOT);
                dbTraceChain.add(new DBMonExecuteTraceQueryCommand());
                dbTraceChain.add(new DBMonExplainPlanQueryCommand());
                dbTraceChain.add(new DBMonSnapshotCommand());
                dbTraceChain.add(new DBMonPushTraceSnapshotToEMCommand());
                dbTraceChain.add(new DBMonClearSnapshotValuesCommand());
                this.dbExecutorPool.execute(dbTraceChain);
            }
            try {
                Thread.sleep(4000L);
                ** continue;
            }
            catch (InterruptedException e) {
                this.logger.error((Throwable)e);
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public List<DBMonMetricsContext> getDbs() {
        return this.dbs;
    }

    public ExecutorService getDbExecutorPool() {
        return this.dbExecutorPool;
    }
}

