/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.atc;

import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpCallClient;
import com.wily.introscope.spec.server.appmap.remotehttp.RemoteHttpResponse;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class DBMonATCManager
implements IServerConnectionNotification {
    private final IAgent agent;
    private final IsengardServerConnectionManager manager;
    private final IModuleFeedbackChannel logger;
    public static final String STORE_ENDPOINT = "/apm/appmap/ats/graph/store";
    public static final String CONFIGURE_ENDPOINT = "/apm/appmap/ats/extension/configure";
    public static final String GET_ENDPOINT = "/apm/appmap/graph/vertex";
    private volatile boolean isConnectionUp;
    private DBMonMetricsContext dbMonMetricsContext;
    private static boolean atcGraphDataSent = false;

    public DBMonATCManager(DBMonMetricsContext dbContext) {
        this.dbMonMetricsContext = dbContext;
        this.agent = dbContext.getAgent();
        this.logger = this.agent.IAgent_getModuleFeedback();
        this.manager = this.agent.IAgent_getIsengardServerConnection();
    }

    public boolean initialize() {
        this.manager.addConnectionObserver((IServerConnectionNotification)this);
        return true;
    }

    public int postATCData(String endPoint, String jsonData) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "sending json to " + endPoint);
        }
        int responseCode = 0;
        String errorMethod = "RemoteHttpCallClient.doPost()";
        try {
            HashMap map;
            if (this.manager.getConnectedServer() != null && !this.manager.getConnectedServer().isConnected()) {
                return -1;
            }
            PostOffice po = this.manager.getPostOffice();
            RemoteHttpCallClient client = new RemoteHttpCallClient(po, 15);
            RemoteHttpResponse response = client.doPost(endPoint, jsonData, map = new HashMap());
            responseCode = response.getHttpCode();
            if (responseCode == 409) {
                this.logger.warn(DBMonMetricsContext.DBMON_MODULE, "Configuration is already stored in the database. No new configuration changes detected");
                return responseCode;
            }
            if (responseCode != 200) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Failed to POST " + jsonData + " to " + endPoint + ". Return code " + responseCode);
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, new String(response.getResponseBody(), "UTF8"));
            }
            if (responseCode == 200) {
                this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Successfully sent to :" + endPoint);
            }
        }
        catch (ConnectionException e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, errorMethod + e.getMessage());
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, errorMethod, (Throwable)e);
        }
        catch (ServiceException e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, errorMethod + e.getMessage());
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, errorMethod, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, errorMethod + e.getMessage());
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, errorMethod, (Throwable)e);
        }
        return responseCode;
    }

    public void connectionDown() {
        this.isConnectionUp = false;
        this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Agent/EM Connection is down.");
    }

    public void connectionUp() {
        if (this.manager.shouldSendData()) {
            String jsonStringForSlave;
            this.isConnectionUp = true;
            this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Agent/EM Connection is up. Posting new Configuration");
            String jsonString = this.loadConfigureJson("");
            this.postATCData(CONFIGURE_ENDPOINT, jsonString);
            if (this.dbMonMetricsContext.getDbDetailsSchema().isCluster() && (jsonStringForSlave = this.loadConfigureJson("Cluster")) != null && !jsonStringForSlave.isEmpty()) {
                this.postATCData(CONFIGURE_ENDPOINT, jsonStringForSlave);
            }
            DBMonATCManager.checkForGraphData(this);
        }
    }

    public static void checkForGraphData(DBMonATCManager mgr) {
        if (!atcGraphDataSent && mgr.isConnectionUp()) {
            atcGraphDataSent = true;
        }
    }

    public boolean isConnectionUp() {
        return this.isConnectionUp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String loadConfigureJson(String fileType) {
        File f = new File(this.dbMonMetricsContext.getDbInfoSchema().getExtensionDirectory() + File.separator + "config" + File.separator + "configure" + fileType + ".json");
        if (!f.exists()) {
            return "";
        }
        BufferedReader in = null;
        try {
            StringBuilder sb = new StringBuilder();
            in = new BufferedReader(new FileReader(f));
            String line = null;
            while ((line = in.readLine()) != null) {
                if (line.trim().startsWith("#")) continue;
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, f + " file does not exist");
            String string = null;
            return string;
        }
        catch (IOException e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, f + " file read error");
            String string = null;
            return string;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)e);
            }
        }
    }

    public DBMonMetricsContext getDbMonMetricsContext() {
        return this.dbMonMetricsContext;
    }

    public void setDbMonMetricsContext(DBMonMetricsContext dbMonMetricsContext) {
        this.dbMonMetricsContext = dbMonMetricsContext;
    }
}

