/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLMetricMapping;
import com.google.gson.Gson;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DBMonExecuteQueryCommand
implements DBMonCommand {
    public static final String DB_TIMESTAMP_COLUMN = "DB_TIME";
    public static final String TIMESTAMP_COLUMN_PARAM = ":timestampColumn:";
    private IModuleFeedbackChannel logger;
    private Connection conn;
    private DBMonMetricsContext dbContext;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Connecting to database...");
        try {
            this.conn = dbContext.initializeConnection();
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, dbContext.printDbConnectionDetails(), (Throwable)exe);
            return true;
        }
        try {
            for (DBMonSQLMetricMapping sqlMetricMapping : dbContext.getDbDetailsSchema().getSqlMetricMappings()) {
                String groupsInSchemaFile = sqlMetricMapping.getGroup();
                List<String> groupsFromBundleProperties = dbContext.getDbInfoSchema().getGroups();
                if (groupsInSchemaFile != null && (groupsFromBundleProperties == null || !groupsFromBundleProperties.contains(groupsInSchemaFile))) continue;
                if (sqlMetricMapping.getCustomIntervalSec() != null && sqlMetricMapping.getCustomIntervalSec() > 0) {
                    long executionInterval = (dbContext.getDbInfoSchema().getTraceInterval() > sqlMetricMapping.getCustomIntervalSec() ? dbContext.getDbInfoSchema().getTraceInterval() : sqlMetricMapping.getCustomIntervalSec()).intValue();
                    if (System.currentTimeMillis() - executionInterval * 1000L <= sqlMetricMapping.getLastExecutionTime()) continue;
                    this.fireAndUpdateMetric(sqlMetricMapping);
                    sqlMetricMapping.setLastExecutionTime(System.currentTimeMillis());
                    continue;
                }
                this.fireAndUpdateMetric(sqlMetricMapping);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Closed Database Connection Successfully...");
                    this.conn.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAndUpdateMetric(DBMonSQLMetricMapping sqlMetricMapping) {
        String query = sqlMetricMapping.getQuery();
        String parameterizedQuery = this.preProcessQuery(sqlMetricMapping, query);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query to be executed is:" + query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(parameterizedQuery != null ? parameterizedQuery : query);
            DBMonResultSet dbResultSet = new DBMonResultSet();
            this.createResultSetObject(rs, dbResultSet);
            this.cacheExecutionTimestamp(sqlMetricMapping, query, dbResultSet);
            this.dbContext.getDbResultSet().put(query, dbResultSet);
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
    }

    private void cacheExecutionTimestamp(DBMonSQLMetricMapping sqlMetricMapping, String query, DBMonResultSet dbResultSet) {
        if (sqlMetricMapping.getTimestampColumn() != null && !sqlMetricMapping.getTimestampColumn().isEmpty() && dbResultSet.getResultSet().size() > 0) {
            String timeStampString = dbResultSet.getResultSet().get(0).get(DB_TIMESTAMP_COLUMN);
            this.dbContext.getQueryExecutionCache().put(query, Timestamp.valueOf(timeStampString).getTime());
        }
    }

    private String preProcessQuery(DBMonSQLMetricMapping sqlMetricMapping, String query) {
        Map<String, String> queryVariables;
        String processedQuery = query;
        if (processedQuery != null && !processedQuery.isEmpty() && processedQuery.contains("full_table_scan_min_row_count_placeholder")) {
            processedQuery = processedQuery.replace("full_table_scan_min_row_count_placeholder", this.dbContext.getDbInfoSchema().getFullTableScanMinRowCount());
        }
        if (sqlMetricMapping.getTimestampColumn() != null) {
            long tsOffset = this.dbContext.getQueryExecutionCache().get(query) != null ? this.dbContext.getQueryExecutionCache().get(query) : 0L;
            processedQuery = processedQuery.replace(TIMESTAMP_COLUMN_PARAM, DATE_FORMAT.format(new Date(tsOffset)));
        }
        if ((queryVariables = sqlMetricMapping.getQueryVariables()) != null && queryVariables.size() > 0) {
            for (String variable : queryVariables.keySet()) {
                processedQuery = processedQuery.replace(variable, queryVariables.get(variable));
            }
        }
        return processedQuery;
    }

    private void createResultSetObject(ResultSet rs, DBMonResultSet dbResultSet) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            for (int col = 1; col <= colCount; ++col) {
                Object value = rs.getObject(col);
                if (value == null) continue;
                if (value instanceof Clob) {
                    Clob clobVal = (Clob)value;
                    String strVal = clobVal.getSubString(1L, (int)clobVal.length());
                    row.put(meta.getColumnName(col), strVal);
                    continue;
                }
                row.put(meta.getColumnName(col), value.toString());
            }
            dbResultSet.addToResultSet(row);
        }
        Gson gson = new Gson();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query output:" + gson.toJson(dbResultSet));
        }
    }
}

