/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands;

import com.ca.agent.extensions.dbmon.DBMonAPMMetric;
import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.StringEventDataRecorder;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class DBMonPushMetricsToEMCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private DBMonMetricsContext dbContext;
    private int metricPushed;

    @Override
    public boolean execute(DBMonMetricsContext dbContext) {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        if (dbContext.getApmMetrics() != null) {
            for (DBMonAPMMetric dbMonitorMetric : dbContext.getApmMetrics()) {
                this.reportMetric(dbMonitorMetric.getMetricName(), dbMonitorMetric.getMetricType(), dbMonitorMetric.getMetricValue() + "", dbMonitorMetric);
            }
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, dbContext.getDbInfoSchema().getDatabaseType() + ":" + dbContext.getDbInfoSchema().getHostName() + ":" + dbContext.getDbInfoSchema().getInstanceName() + ":" + dbContext.getDbInfoSchema().getPort() + " metric pushed:" + this.metricPushed);
        }
        return true;
    }

    private void reportMetric(String path, String type, String value, DBMonAPMMetric apmMetric) {
        if (value == null || value.equals("") || value.equalsIgnoreCase("null")) {
            return;
        }
        try {
            ILongIntervalCounterDataAccumulator accumulator;
            String rootPath = this.dbContext.getRootPath();
            String pathWithPrefix = "";
            if (this.isRootLevelMetric(path)) {
                pathWithPrefix = rootPath.substring(0, rootPath.length() - 1) + ":" + path;
            } else {
                pathWithPrefix = rootPath + path;
                String pathTillLastColon = pathWithPrefix.substring(0, pathWithPrefix.lastIndexOf(58));
                String pathFromLastColon = pathWithPrefix.substring(pathWithPrefix.lastIndexOf(58));
                pathTillLastColon = pathTillLastColon.replace(':', '_');
                pathWithPrefix = pathTillLastColon + pathFromLastColon;
            }
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "MetricName:" + pathWithPrefix + " Value:" + value + " Type:" + type);
            if (type.equals("LongCounter")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(pathWithPrefix);
                accumulator.ILongAggregatingDataAccumulator_recordDataPoint((long)Double.parseDouble(value));
                ++this.metricPushed;
            } else if (type.equals("CumulativeCounter")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetCumulativeCounterDataAccumulator(pathWithPrefix);
                accumulator.ILongCounterDataAccumulator_addOnlyDelta((long)Double.parseDouble(value));
                ++this.metricPushed;
            } else if (type.equals("IntAverage")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(pathWithPrefix);
                accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint((int)Double.parseDouble(value));
                ++this.metricPushed;
            } else if (type.equals("LongAverage")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(pathWithPrefix);
                accumulator.ILongAggregatingDataAccumulator_recordDataPoint((long)Double.parseDouble(value));
                ++this.metricPushed;
            } else if (type.equals("StringEvent")) {
                StringEventDataRecorder dr = DataRecorderFactory.createStringEventDataRecorder((String)pathWithPrefix);
                dr.recordDataPoint(value);
                ++this.metricPushed;
            } else if (type.equals("IntFluctuatingCounter")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(pathWithPrefix);
                accumulator.IIntegerCounterDataAccumulator_setValue((int)Double.parseDouble(value));
                ++this.metricPushed;
            } else if (type.equals("LongFluctuatingCounter")) {
                accumulator = this.dbContext.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(pathWithPrefix);
                accumulator.ILongCounterDataAccumulator_setValue((long)Double.parseDouble(value));
                ++this.metricPushed;
            }
            apmMetric.updateLastAccessedTime(System.currentTimeMillis());
            this.dbContext.addDbAllMetrics(pathWithPrefix, apmMetric);
        }
        catch (Exception e) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)e);
        }
    }

    private boolean isRootLevelMetric(String path) {
        return path != null && !path.equals("") && !path.contains("|") && !path.contains(":");
    }
}

