/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands.traces;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.entity.query.snapshot.DBMonGenericSnapshot;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLTraceMapping;
import com.ca.agent.extensions.dbmon.schema.DBMonTrace;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DBMonSnapshotCommand
implements DBMonCommand {
    private static final String TRACE_TYPE = "GenerateSnapshot";
    private IModuleFeedbackChannel logger;
    private DBMonMetricsContext dbContext;
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy hh:mm:ss a");

    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        List<DBMonSQLTraceMapping> sqlTraceMappings = dbContext.getDbDetailsSchema().getSqlTraceMappings();
        for (DBMonSQLTraceMapping traceMapping : sqlTraceMappings) {
            if (traceMapping.getTraceType() == null || !traceMapping.getTraceType().equalsIgnoreCase(TRACE_TYPE) || !this.hasTraceDbResultToProcess(traceMapping)) continue;
            this.generateTraceSnapshots(traceMapping);
        }
        return true;
    }

    private void generateTraceSnapshots(DBMonSQLTraceMapping traceMapping) {
        DBMonResultSet dbMonResultSet = this.dbContext.getDbTraceResultSet().get(traceMapping.getQuery());
        DBMonGenericSnapshot dbMonSnapshot = new DBMonGenericSnapshot();
        DBMonTrace traceConfig = this.getTraceConfigAtIndex(traceMapping, 0);
        dbMonSnapshot.setTraceResourcePath(traceConfig.getTraceResourcePath());
        dbMonSnapshot.setTraceResourcePathPrefix(traceConfig.getTraceResourcePathPrefix());
        dbMonSnapshot.setTraceType(traceConfig.getTraceType());
        dbMonSnapshot.setMetaAttributes(traceMapping.getTraceDetails());
        for (Map<String, String> entry : dbMonResultSet.getResultSet()) {
            dbMonSnapshot.add(this.buildSnashotEntry(entry, traceConfig.getSnapshotFields()));
        }
        if (traceConfig.getSplitSnapshot().booleanValue()) {
            this.splitSnapshot(dbMonSnapshot, this.dbContext, traceMapping, traceConfig);
        } else {
            this.dbContext.getDbMonSnapshot().put(traceMapping.getQuery(), dbMonSnapshot);
        }
    }

    private void splitSnapshot(DBMonGenericSnapshot dbMonSnapshot, DBMonMetricsContext dbContext, DBMonSQLTraceMapping traceMapping, DBMonTrace traceConfig) {
        DBMonGenericSnapshot splitSnapshot = new DBMonGenericSnapshot();
        for (Map<String, Object> entry : dbMonSnapshot.getSnapshot()) {
            if (splitSnapshot.getSnapshot() != null && splitSnapshot.getSnapshot().size() > 0 && this.shouldSplit(entry, traceConfig.getSplitSnapshotFields())) {
                String customResource = this.buildCustomResourcePath(splitSnapshot, traceConfig.getCustomResourcePath());
                splitSnapshot.setTraceResourcePath(customResource);
                splitSnapshot.setTraceType(traceConfig.getTraceType());
                splitSnapshot.setMetaAttributes(traceMapping.getTraceDetails());
                splitSnapshot.setDuration(this.retrieveDuration(splitSnapshot, traceMapping));
                dbContext.getDbMonSnapshot().put(customResource, splitSnapshot);
                splitSnapshot = new DBMonGenericSnapshot();
            }
            splitSnapshot.add(entry);
        }
        if (splitSnapshot.getSnapshot() != null && splitSnapshot.getSnapshot().size() > 0) {
            String customResource = this.buildCustomResourcePath(splitSnapshot, traceConfig.getCustomResourcePath());
            splitSnapshot.setTraceResourcePath(customResource);
            splitSnapshot.setTraceType(traceConfig.getTraceType());
            splitSnapshot.setMetaAttributes(traceMapping.getTraceDetails());
            splitSnapshot.setDuration(this.retrieveDuration(splitSnapshot, traceMapping));
            dbContext.getDbMonSnapshot().put(customResource, splitSnapshot);
        }
    }

    private String buildCustomResourcePath(DBMonGenericSnapshot dbMonSnapshot, List<String> customResourcePath) {
        String customPath = "";
        Map<String, Object> topEntry = dbMonSnapshot.getSnapshot().get(0);
        for (String field : customResourcePath) {
            customPath = customPath + field + ":" + topEntry.get(field).toString() + " ";
        }
        return customPath;
    }

    private boolean shouldSplit(Map<String, Object> entry, Map<String, Object> splitSnapshotFields) {
        try {
            ArrayList<String> fields = new ArrayList<String>(splitSnapshotFields.keySet());
            String splitField = (String)fields.get(0);
            return entry.get(splitField).toString().equals(splitSnapshotFields.get(splitField).toString());
        }
        catch (Exception e) {
            return false;
        }
    }

    private long retrieveDuration(DBMonGenericSnapshot splitSnapshot, DBMonSQLTraceMapping traceMapping) {
        long duration = 0L;
        if (traceMapping.getSortField() != null && !traceMapping.getSortField().isEmpty()) {
            try {
                duration = Long.valueOf(splitSnapshot.getSnapshot().get(0).get(traceMapping.getSortField()).toString());
            }
            catch (Exception e) {
                this.logger.trace("Invalid sortField mapped or invalid number for sortField : " + traceMapping.getSortField());
            }
        }
        return duration;
    }

    private Map<String, Object> buildSnashotEntry(Map<String, String> dbMonResultSet, List<String> snapshotFields) {
        LinkedHashMap<String, Object> entry = new LinkedHashMap<String, Object>();
        boolean isSQLServerDB = this.dbContext.getDbDetailsSchema().getDatabaseName().equalsIgnoreCase("SQL_SERVER_DB");
        boolean isOracleDB = this.dbContext.getDbDetailsSchema().getDatabaseName().equalsIgnoreCase("ORACLE_DB");
        boolean isOracleRACDB = this.dbContext.getDbDetailsSchema().getDatabaseName().equalsIgnoreCase("ORACLE_RAC_DB");
        for (String key : snapshotFields) {
            String snapShotField = key.toUpperCase();
            if (dbMonResultSet.get(snapShotField) == null || dbMonResultSet.get(snapShotField) == null) continue;
            if ((isSQLServerDB || isOracleDB || isOracleRACDB) && snapShotField.equalsIgnoreCase("TIMESTAMP")) {
                entry.put(snapShotField, DATE_FORMAT.format(System.currentTimeMillis()));
                continue;
            }
            if ((isOracleDB || isOracleRACDB) && snapShotField.equalsIgnoreCase("SQL_FULLTEXT")) {
                entry.put("RESOURCE", dbMonResultSet.get(snapShotField));
                continue;
            }
            entry.put(snapShotField, dbMonResultSet.get(snapShotField));
        }
        return entry;
    }

    private DBMonTrace getTraceConfigAtIndex(DBMonSQLTraceMapping traceMapping, int index) {
        if (traceMapping.getTraces() != null && traceMapping.getTraces().size() > index) {
            return traceMapping.getTraces().get(index);
        }
        return new DBMonTrace();
    }

    private boolean hasTraceDbResultToProcess(DBMonSQLTraceMapping traceMapping) {
        if (traceMapping.getQuery() == null || traceMapping.getQuery().isEmpty()) {
            this.logger.info("No Source Query mentioned for trace of type - GenerateSnapshot");
            return false;
        }
        return this.dbContext.getDbTraceResultSet().get(traceMapping.getQuery()) != null;
    }
}

