/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.helper;

import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLTraceMapping;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;

public class DBMonCommonHelper {
    private DBMonCommonHelper() {
    }

    public static void createResultSetObject(ResultSet rs, DBMonResultSet dbResultSet) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        int colCount = meta.getColumnCount();
        while (rs.next()) {
            HashMap<String, String> row = new HashMap<String, String>();
            for (int col = 1; col <= colCount; ++col) {
                Object value = rs.getObject(col);
                if (value == null) continue;
                if (value instanceof Clob) {
                    Clob clobVal = (Clob)value;
                    String strVal = clobVal.getSubString(1L, (int)clobVal.length());
                    row.put(meta.getColumnName(col), strVal);
                    continue;
                }
                row.put(meta.getColumnName(col), value.toString());
            }
            dbResultSet.addToResultSet(row);
        }
    }

    public static boolean isCustomeIntervalElapsed(DBMonSQLTraceMapping traceMapping) {
        return System.currentTimeMillis() - (long)(traceMapping.getCustomIntervalSec() * 1000) > traceMapping.getLastExecutionTime();
    }

    public static boolean isCustomIntervalEnabled(DBMonSQLTraceMapping traceMapping) {
        return traceMapping.getCustomIntervalSec() != null && traceMapping.getCustomIntervalSec() > 0;
    }
}

