/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.helper;

import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.helper.CommonEncryptionProvider;
import com.ca.agent.extensions.dbmon.helper.FileHelper;
import com.wily.introscope.agent.IAgent;
import java.io.File;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class DBMonEncryptionHelper {
    private static final Pattern passwordRelacementPattern = Pattern.compile("(\\bpassword=|privateKeyPassPhrase=)(.*)");
    public static final String APM_ENCRYPTION_PREFIX = "ENC(";
    private FileHelper fileHelper = new FileHelper();
    private CommonEncryptionProvider cep = new CommonEncryptionProvider();

    public void encryptPasswordsAndUpdateFile(IAgent agent, List<DBMonMetricsContext> dbs) throws IOException, InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        HashSet<String> bundlePropertiesFile = new HashSet<String>();
        for (DBMonMetricsContext db : dbs) {
            bundlePropertiesFile.add(db.getDbInfoSchema().getExtensionDirectory() + File.separator + "bundle.properties");
        }
        for (String bundleFile : bundlePropertiesFile) {
            String file = this.fileHelper.readFileAsString(bundleFile);
            String updatedFile = this.encryptPasswordFromFile(file);
            this.updateDbMonFile(agent, bundleFile, updatedFile);
        }
    }

    private void updateDbMonFile(IAgent agent, String file, String updatedContent) throws IOException {
        this.fileHelper.reWriteFile(agent.IAgent_getModuleFeedback(), file, updatedContent);
    }

    private String encryptPasswordFromFile(String file) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher myMatcher = passwordRelacementPattern.matcher(file);
        while (myMatcher.find()) {
            String password = myMatcher.group(2);
            myMatcher.appendReplacement(stringBuffer, myMatcher.group(1) + this.encryptPassword(password));
        }
        myMatcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private String encryptPassword(String password) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        String encryptedPassword = password;
        if (encryptedPassword != null && !encryptedPassword.equals("") && !encryptedPassword.startsWith(APM_ENCRYPTION_PREFIX)) {
            encryptedPassword = APM_ENCRYPTION_PREFIX + this.cep.encrypt(password);
        }
        return encryptedPassword;
    }
}

