/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.helper;

import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DBMonJsonPathHelper {
    private static final Pattern regex = Pattern.compile("[$&+,:;=\\\\?@#|/'<>.^*()%!-]");

    public String evaluate(IModuleFeedbackChannel logger, Object document, int index, String expression) throws DBMonException {
        List returnVals;
        if (logger.isDebugEnabled()) {
            logger.debug(DBMonMetricsContext.DBMON_MODULE, "Printing index and expression:" + index + " " + expression);
        }
        if (index >= (returnVals = (List)JsonPath.read((Object)document, (String)expression, (Predicate[])new Predicate[0])).size()) {
            throw new DBMonException("Can't find index: " + index + " while generating metricPath. returnVals is : " + returnVals);
        }
        if (regex.matcher((CharSequence)returnVals.get(index)).find()) {
            return ((String)returnVals.get(index)).replaceAll(regex.toString(), "_");
        }
        return (String)returnVals.get(index);
    }

    public List<String> evaluate(Object document, String expression) {
        ArrayList<String> returnData = new ArrayList<String>();
        if (Integer.valueOf(JsonPath.read((Object)document, (String)"$.resultSet.length()", (Predicate[])new Predicate[0]).toString()) > 0) {
            Object returnValue = JsonPath.read((Object)document, (String)expression, (Predicate[])new Predicate[0]);
            if (returnValue instanceof List) {
                for (Object obj : (List)returnValue) {
                    returnData.add(obj.toString());
                }
            } else if (returnValue instanceof String) {
                returnData.add(returnValue.toString());
            }
        }
        return returnData;
    }

    public List<String> evaluateMultipleExpressions(IModuleFeedbackChannel logger, Object document, String expression) {
        ArrayList<String> evaluatedExpressions = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\$\\.resultSet\\[[^]]+\\][^ ]+");
        Matcher originalMatcher = pattern.matcher(expression);
        StringBuffer sb = new StringBuffer();
        if (originalMatcher.find()) {
            String group = originalMatcher.group();
            List<String> resultSet = this.evaluate(document, group);
            for (int itr = 0; itr < resultSet.size(); ++itr) {
                Matcher matcher = pattern.matcher(expression);
                sb.delete(0, sb.length());
                while (matcher.find()) {
                    group = matcher.group();
                    List<String> evaluated = this.evaluate(document, group);
                    if (evaluated != null && !evaluated.isEmpty()) {
                        matcher.appendReplacement(sb, Matcher.quoteReplacement(String.valueOf(evaluated.get(itr))));
                        continue;
                    }
                    logger.warn("Log as error...unable to evaluate expression:" + group);
                }
                matcher.appendTail(sb);
                evaluatedExpressions.add(sb.toString());
            }
        }
        return evaluatedExpressions;
    }
}

