/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.helper;

import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class FileHelper {
    private static final String UNIX_FILE_SEPARATOR = "/";
    private static final String WINDOWS_FILE_SEPARATOR = "\\";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readFileAsString(String filePath) throws IOException {
        StringBuilder fileData = new StringBuilder();
        try (BufferedReader reader = null;){
            reader = new BufferedReader(new FileReader(filePath));
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
            }
        }
        return fileData.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reWriteFile(IModuleFeedbackChannel iModuleFeedbackChannel, String filePathAndName, String updatedContent) throws IOException {
        BufferedWriter out = null;
        FileWriter fstream = null;
        try {
            fstream = new FileWriter(filePathAndName, false);
            out = new BufferedWriter(fstream);
            out.write(updatedContent);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exe) {
                iModuleFeedbackChannel.error((Throwable)exe);
            }
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (Exception exe) {
                iModuleFeedbackChannel.error((Throwable)exe);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getPropertiesFromFile(String fileName) throws IOException {
        Properties prop = new Properties();
        try (FileInputStream input = null;){
            input = new FileInputStream(fileName);
            prop.load(input);
        }
        return prop;
    }

    public String extractFileName(String parseString) {
        if (parseString.lastIndexOf(UNIX_FILE_SEPARATOR) > parseString.lastIndexOf(WINDOWS_FILE_SEPARATOR)) {
            return parseString.substring(parseString.lastIndexOf(UNIX_FILE_SEPARATOR) + 1);
        }
        return parseString.substring(parseString.lastIndexOf(WINDOWS_FILE_SEPARATOR) + 1);
    }

    public boolean ifMetricContainsPath(String evaluatedPath) {
        return evaluatedPath != null && !evaluatedPath.equals("") && (evaluatedPath.contains(UNIX_FILE_SEPARATOR) || evaluatedPath.contains(WINDOWS_FILE_SEPARATOR));
    }

    public List<String> getFoldersInDirectory(String configDirectory) {
        File directory = new File(configDirectory);
        FileFilter directoryFileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
        File[] directoryListAsFile = directory.listFiles(directoryFileFilter);
        ArrayList<String> foldersInDirectory = new ArrayList<String>(directoryListAsFile.length);
        for (File directoryAsFile : directoryListAsFile) {
            foldersInDirectory.add(directoryAsFile.getName());
        }
        return foldersInDirectory;
    }
}

