/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.schema;

import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.helper.FileHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonDetailsSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonInfoSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonMetricContextFactory;
import com.ca.agent.extensions.dbmon.schema.DBMonMetricPath;
import com.ca.agent.extensions.dbmon.schema.DBMonMetrics;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLMetricMapping;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLTraceMapping;
import com.ca.agent.extensions.dbmon.schema.DBMonSchema;
import com.ca.agent.extensions.dbmon.schema.DBMonSchemaType;
import com.google.gson.Gson;
import com.wily.introscope.agent.IAgent;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.io.ExtendedFile;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DBMonSchemaInitializer {
    public static final String INTROSCOPE_AGENT_DBMONITOR = "introscope.agent.dbmonitor.";
    public static final String PROFILES = ".profiles.";
    private static final int HTTPS_PORT = 443;
    public static final int DEFAULT_PORT = 1433;
    private final IAgent agent;
    private final IModuleFeedbackChannel logger;
    private final DBMonMetricContextFactory dbMetricContextFactory = new DBMonMetricContextFactory();
    private Map<DBMonSchemaType, DBMonDetailsSchema> metricsSchemaMap = new HashMap<DBMonSchemaType, DBMonDetailsSchema>();
    private DBMonSchema dbMonitorSchema = new DBMonSchema();
    private final FileHelper fileHelper = new FileHelper();
    private static final String CONFIG_DIRECTORY = "config";
    public static final String DEFAULT_HOST_NAME = "localhost";
    private static final String DEFAULT_INSTANCE = "Default_Instance";
    public static final String SAP_HANA_DEFAULT_PORT = "39017";

    public DBMonSchemaInitializer(IAgent agent) {
        this.agent = agent;
        this.logger = agent.IAgent_getModuleFeedback();
    }

    public List<DBMonMetricsContext> initialize(ExtendedFile extensionDir, String schemaFile) {
        String extensionPath = extensionDir.getAbsolutePath();
        try {
            this.initializeDBMonitorExtension(extensionPath, schemaFile);
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Unable to initialize DBMonitor extension:" + extensionDir.getName(), (Throwable)exe);
        }
        return this.dbMetricContextFactory.createDbContext(this.agent, this.dbMonitorSchema, this.metricsSchemaMap);
    }

    private boolean isAuthenticDB(String databaseType) {
        boolean isSQLServerDB = databaseType.contains("SQL_SERVER_DB");
        boolean isOracleDB = databaseType.contains("ORACLE_DB");
        boolean isOracleRACDB = databaseType.contains("ORACLE_RAC_DB");
        return isSQLServerDB || isOracleDB || isOracleRACDB;
    }

    private void initializeDBMonitorExtension(String extensionDirectory, String schemaFileName) throws IOException {
        Properties prop = this.fileHelper.getPropertiesFromFile(extensionDirectory + File.separator + "bundle.properties");
        String schemaFile = extensionDirectory + File.separator + CONFIG_DIRECTORY + File.separator + schemaFileName;
        Gson gson = new Gson();
        String jsonFile = this.fileHelper.readFileAsString(schemaFile);
        DBMonDetailsSchema metricsSchema = gson.fromJson(jsonFile, DBMonDetailsSchema.class);
        String databaseType = metricsSchema.getDatabaseName();
        String databaseNameAlias = metricsSchema.getDatabaseNameAlias();
        String monitoredDatabases = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".profiles");
        if (monitoredDatabases != null && !monitoredDatabases.trim().isEmpty()) {
            Integer queryInterval = this.getQueryInterval(databaseNameAlias, prop);
            Integer traceInterval = this.getTraceInterval(databaseNameAlias, prop);
            for (String db : monitoredDatabases.trim().split(",")) {
                db = db.trim();
                String hostName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".hostName");
                String port = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".port");
                String instanceName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".instanceName");
                String serviceName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".serviceName");
                String userName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".userName");
                String password = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".password");
                String version = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".version");
                String accountIdentifierHost = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".accountIdentifierHost");
                String privateKey = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".privateKey");
                String warehouseName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".warehouseName");
                String roleName = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".roleName");
                String privateKeyPassPhrase = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".privateKeyPassPhrase");
                String insecureMode = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".insecureMode");
                String authenticationScheme = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".authenticationScheme");
                String authType = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".authType");
                ArrayList<String> schemasList = new ArrayList<String>();
                if (version == null || version.isEmpty()) {
                    schemasList.add(schemaFileName.substring(0, schemaFileName.length() - 5));
                } else {
                    String[] schemas = version.split(",");
                    schemasList.addAll(Arrays.asList(schemas));
                }
                String groups = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".groups");
                if (serviceName != null && !serviceName.isEmpty()) {
                    instanceName = serviceName;
                }
                String pdbs = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + PROFILES + db + ".pdbs");
                for (String schemaName : schemasList) {
                    DBMonInfoSchema schema = new DBMonInfoSchema();
                    schema.setDatabaseType(databaseType);
                    schema.setQueryInterval(queryInterval);
                    schema.setTraceInterval(traceInterval);
                    if (databaseType.contains("SAP_HANA_DB")) {
                        if (null == hostName || hostName.isEmpty()) {
                            hostName = DEFAULT_HOST_NAME;
                            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Assigned Default Host: localhost");
                        }
                        if (null == instanceName || instanceName.isEmpty()) {
                            instanceName = DEFAULT_INSTANCE;
                            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Assigned Default Instance Name: Default_Instance");
                        }
                        if (null == port || port.isEmpty()) {
                            port = SAP_HANA_DEFAULT_PORT;
                            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Assigned Default Port: 39017");
                        }
                    }
                    schema.setHostName(hostName);
                    if (databaseType.contains("SQL_SERVER_DB") && (null == port || port.isEmpty())) {
                        schema.setPort(1433);
                        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Assigned Default Port: 1433");
                    } else if (null != port) {
                        schema.setPort(Integer.parseInt(port.trim()));
                    }
                    schema.setInstanceName(instanceName);
                    schema.setUserName(userName);
                    schema.setPassword(password);
                    schema.setPrivateKey(privateKey);
                    schema.setWarehouseName(warehouseName);
                    schema.setRoleName(roleName);
                    if (!StringUtils.isEmpty((String)roleName)) {
                        schema.setInstanceName(roleName);
                    }
                    schema.setPrivateKeyPassPhrase(privateKeyPassPhrase);
                    schema.setInsecureMode(Boolean.valueOf(insecureMode));
                    schema.setAccountIdentifierHost(accountIdentifierHost);
                    if (!StringUtils.isEmpty((String)accountIdentifierHost)) {
                        schema.setHostName(accountIdentifierHost);
                        schema.setPort(443);
                    }
                    if (!StringUtils.isEmpty((String)authenticationScheme)) {
                        schema.setAuthenticationScheme(authenticationScheme);
                    }
                    if (!StringUtils.isEmpty((String)authType)) {
                        schema.setAuthType(authType);
                    }
                    schema.setExtensionDirectory(extensionDirectory);
                    schema.setDbSnapsotTracesEnabled(this.isDbTracesEnabled(databaseNameAlias, prop));
                    if (this.isAuthenticDB(databaseType)) {
                        schema.setShowExplainPlan(this.isShowExplainPlan(databaseNameAlias, prop));
                        if (databaseType.contains("SQL_SERVER_DB")) {
                            schema.setShowTableScanQueries(this.isShowTableScanQueries(databaseNameAlias, prop));
                            schema.setShowBlockingQueries(this.isShowBlockingQueries(databaseNameAlias, prop));
                        }
                    }
                    if (databaseType.contains("SQL_SERVER_DB") && this.isDbTracesEnabled(databaseNameAlias, prop)) {
                        String executionCount = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.executionCount");
                        if (null == executionCount || executionCount.isEmpty()) {
                            executionCount = "0";
                        }
                        schema.setExecutionCount(executionCount);
                    }
                    if (databaseType.contains("SQL_SERVER_DB")) {
                        String fullTableScanMinRowCount = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.fullTableScanMinRowCount");
                        if (null == fullTableScanMinRowCount || fullTableScanMinRowCount.isEmpty()) {
                            fullTableScanMinRowCount = "100000";
                        }
                        schema.setFullTableScanMinRowCount(fullTableScanMinRowCount);
                    }
                    schema.setGroups(groups);
                    schema.setSchemaName(schemaName.trim());
                    schema.setDbSchemaType(new DBMonSchemaType(schema.getDatabaseType(), schema.getSchemaName()));
                    if (pdbs != null && !pdbs.isEmpty()) {
                        schema.setPdbs(pdbs);
                    }
                    this.dbMonitorSchema.getDatabases().add(schema);
                    this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Loading metrics for schema name: " + schema.getSchemaName());
                    this.initializeDBMetricsSchema(schema, extensionDirectory);
                }
            }
        } else {
            this.logger.info(DBMonMetricsContext.DBMON_MODULE, "No database selected for monitoring in extension folder:" + extensionDirectory + ". Property 'introscope.agent.dbmonitor." + databaseNameAlias + ".profiles' is empty !!!");
        }
    }

    private String getProperty(Properties properties, String propertyName) {
        String dockerEnvPropertyName = "APMENV_" + propertyName.toUpperCase().replaceAll("\\.", "_");
        String value = System.getenv(dockerEnvPropertyName);
        if (value != null && !value.trim().isEmpty()) {
            value = value.trim();
        } else {
            value = properties.getProperty(propertyName);
            if (value != null && !value.trim().isEmpty()) {
                value = value.trim();
            }
        }
        return value;
    }

    private Integer getQueryInterval(String databaseNameAlias, Properties properties) {
        int queryIntervalInSec = 7;
        String queryInterval = this.getProperty(properties, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".queryInterval");
        if (queryInterval != null && !queryInterval.isEmpty()) {
            try {
                queryIntervalInSec = Integer.parseInt(queryInterval);
                if (queryIntervalInSec < 7) {
                    this.logger.warn(DBMonMetricsContext.DBMON_MODULE, "Monitoring interval is less than 7 sec. This could have performance overhead on DB.");
                }
            }
            catch (Exception exe) {
                this.logger.warn(DBMonMetricsContext.DBMON_MODULE, "Unable to parse property introscope.agent.dbmonitor." + databaseNameAlias + ".queryInterval, value:" + queryInterval + " . Using default value 7 sec");
            }
        }
        return queryIntervalInSec;
    }

    private Integer getTraceInterval(String databaseNameAlias, Properties properties) {
        int traceIntervalInSec = 30;
        String traceInterval = this.getProperty(properties, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".traceInterval");
        if (traceInterval != null && !traceInterval.isEmpty()) {
            try {
                traceIntervalInSec = Integer.parseInt(traceInterval);
                if (traceIntervalInSec < 30) {
                    this.logger.warn(DBMonMetricsContext.DBMON_MODULE, "Monitoring interval is less than " + traceIntervalInSec + " sec. This could have performance overhead on DB.");
                }
            }
            catch (Exception exe) {
                this.logger.warn(DBMonMetricsContext.DBMON_MODULE, "Unable to parse property introscope.agent.dbmonitor." + databaseNameAlias + ".traceInterval, value:" + traceInterval + " . Using default value " + traceIntervalInSec + " sec");
            }
        }
        return traceIntervalInSec;
    }

    private boolean isDbTracesEnabled(String databaseNameAlias, Properties prop) {
        return Boolean.parseBoolean(this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.snapshots"));
    }

    private boolean isShowExplainPlan(String databaseNameAlias, Properties prop) {
        String showExplainPlanProp = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showExplainPlan");
        if (showExplainPlanProp != null && !showExplainPlanProp.trim().isEmpty()) {
            return Boolean.parseBoolean(this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showExplainPlan"));
        }
        return false;
    }

    private boolean isShowTableScanQueries(String databaseNameAlias, Properties prop) {
        String showTableScanQueriesProp = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showTableScanQueries");
        if (showTableScanQueriesProp != null && !showTableScanQueriesProp.trim().isEmpty()) {
            return Boolean.parseBoolean(this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showTableScanQueries"));
        }
        return false;
    }

    private boolean isShowBlockingQueries(String databaseNameAlias, Properties prop) {
        String showBlockingQueriesProp = this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showBlockingQueries");
        if (showBlockingQueriesProp != null && !showBlockingQueriesProp.trim().isEmpty()) {
            return Boolean.parseBoolean(this.getProperty(prop, INTROSCOPE_AGENT_DBMONITOR + databaseNameAlias + ".query.showBlockingQueries"));
        }
        return false;
    }

    private void updateSchema(DBMonDetailsSchema metricsSchema, DBMonInfoSchema profile) {
        Iterator<DBMonSQLTraceMapping> iterator = metricsSchema.getSqlTraceMappings().iterator();
        while (iterator.hasNext()) {
            DBMonSQLTraceMapping dbMonSQLTraceMapping = iterator.next();
            String metricName = dbMonSQLTraceMapping.getMetric().getMetricPath().get(0).getName();
            String traceType = dbMonSQLTraceMapping.getTraceType();
            if (metricName.equalsIgnoreCase("Top N:Top N Slow Queries")) {
                if (!profile.isShowExplainPlan() && traceType.equalsIgnoreCase("ExplainPlan")) {
                    iterator.remove();
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Slow queries explain plan query is removed");
                    continue;
                }
                if (!profile.isShowExplainPlan() || !traceType.equalsIgnoreCase("GenerateSnapshot")) continue;
                iterator.remove();
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Slow queries GenerateSnapshot query is removed");
                continue;
            }
            if (metricName.equalsIgnoreCase("Top N:Top 5 TableScanQueries") && !profile.isShowTableScanQueries()) {
                iterator.remove();
                this.logger.debug(DBMonMetricsContext.DBMON_MODULE, " FullTableScan Queries query is removed");
                continue;
            }
            if (!metricName.equalsIgnoreCase("Top N:Top 5 BlockingQueries") || profile.isShowBlockingQueries()) continue;
            iterator.remove();
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, " Blocking Queries query is removed");
        }
    }

    private void initializeDBMetricsSchema(DBMonInfoSchema profile, String extensionPath) throws IOException {
        String dbMonitorMetricFile = extensionPath + File.separator + CONFIG_DIRECTORY + File.separator + profile.getSchemaName() + ".json";
        boolean check = new File(dbMonitorMetricFile).exists();
        if (!check) {
            String olderVersionFileName = extensionPath + File.separator + CONFIG_DIRECTORY + File.separator + "schema" + profile.getSchemaName() + ".json";
            boolean checkIfOldVersion = new File(olderVersionFileName).exists();
            if (checkIfOldVersion) {
                dbMonitorMetricFile = olderVersionFileName;
                check = true;
                this.logger.info(DBMonMetricsContext.DBMON_MODULE, "Using previous schema version file: " + dbMonitorMetricFile);
            } else {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Unable to find other schema version file: " + olderVersionFileName);
            }
        }
        if (check) {
            if (!this.metricsSchemaMap.containsKey(profile.getDbSchemaType())) {
                this.logger.info("Loading metric schema from file: " + dbMonitorMetricFile);
                String jsonFile = this.fileHelper.readFileAsString(dbMonitorMetricFile);
                Gson gson = new Gson();
                DBMonDetailsSchema metricsSchema = gson.fromJson(jsonFile, DBMonDetailsSchema.class);
                if (this.isAuthenticDB(metricsSchema.getDatabaseName()) && profile.isDbSnapsotTracesEnabled()) {
                    this.updateSchema(metricsSchema, profile);
                }
                if (profile.getDatabaseType().toUpperCase().startsWith("ORACLE") && profile.getSchemaName().contains("CDB") && profile.getPdbs() != null) {
                    this.logger.info("Updating queries for Oracle multitenancy");
                    this.modifyQueryWithPDBs(profile, metricsSchema);
                }
                this.metricsSchemaMap.put(profile.getDbSchemaType(), metricsSchema);
            }
        } else {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Wrong value given for the property - version for the profile - " + profile.getDatabaseType() + ":" + profile.getHostName() + ":" + profile.getInstanceName() + ":" + profile.getPort());
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "Unable to find schema version file: " + dbMonitorMetricFile);
        }
    }

    private void modifyQueryWithPDBs(DBMonInfoSchema profile, DBMonDetailsSchema metricsSchema) {
        if (profile.getPdbs() != null) {
            List<String> pdbsInBundle = profile.getPdbs();
            StringBuffer appendPDBS = new StringBuffer(".pdb_name IN (");
            for (int i = 0; i < pdbsInBundle.size() - 1; ++i) {
                appendPDBS = appendPDBS.append("'" + pdbsInBundle.get(i) + "',");
            }
            appendPDBS = appendPDBS.append("'" + pdbsInBundle.get(pdbsInBundle.size() - 1) + "') ");
            for (DBMonSQLMetricMapping sqlMetricMapping : metricsSchema.getSqlMetricMappings()) {
                for (DBMonMetrics dbMonMetrics : sqlMetricMapping.getMetrics()) {
                    this.updateQuery(dbMonMetrics, sqlMetricMapping, appendPDBS);
                }
            }
        }
    }

    private void updateQuery(DBMonMetrics dbMonMetrics, DBMonSQLMetricMapping sqlMetricMapping, StringBuffer appendPDBS) {
        for (DBMonMetricPath dbMonMetricPath : dbMonMetrics.getMetricPath()) {
            if (!dbMonMetricPath.getName().contains("$.resultSet[*].PDB_NAME")) continue;
            String query = sqlMetricMapping.getQuery();
            int lastIndexOfWHERE = query.toUpperCase().lastIndexOf("WHERE");
            int groupByIndex = query.toUpperCase().indexOf("GROUP BY", lastIndexOfWHERE);
            int orderByIndex = query.toUpperCase().indexOf("ORDER BY", lastIndexOfWHERE);
            int endIndex = groupByIndex != -1 ? groupByIndex : orderByIndex;
            String appendPDBSStr = appendPDBS.toString();
            if (sqlMetricMapping.getQuery().contains("V$PDBS")) {
                String alias_name_of_V$PDBS_in_query = query.substring(query.indexOf("V$PDBS", query.toUpperCase().lastIndexOf("FROM"))).split(" |\\,", 3)[1];
                appendPDBSStr = " AND " + alias_name_of_V$PDBS_in_query + appendPDBSStr;
                appendPDBSStr = appendPDBSStr.replace("pdb_name", "name");
            } else {
                String alias_name_of_DBA_PDBS_in_query = query.substring(query.indexOf("DBA_PDBS", query.toUpperCase().lastIndexOf("FROM"))).split(" |\\,", 3)[1];
                appendPDBSStr = " AND " + alias_name_of_DBA_PDBS_in_query + appendPDBSStr;
            }
            if (query.contains(appendPDBSStr)) break;
            query = endIndex == -1 ? query.concat(appendPDBSStr) : query.substring(0, endIndex).concat(appendPDBSStr).concat(query.substring(endIndex));
            sqlMetricMapping.setQuery(query);
            break;
        }
    }

    public IAgent getAgent() {
        return this.agent;
    }

    public Map<DBMonSchemaType, DBMonDetailsSchema> getMetricsSchemaMap() {
        return this.metricsSchemaMap;
    }

    public void setMetricsSchemaMap(Map<DBMonSchemaType, DBMonDetailsSchema> metricsSchemaMap) {
        this.metricsSchemaMap = metricsSchemaMap;
    }

    public void setDBMonitorSchema(DBMonSchema dbMonitorSchema) {
        this.dbMonitorSchema = dbMonitorSchema;
    }

    public DBMonSchema getDBMonitorSchema() {
        return this.dbMonitorSchema;
    }
}

