#! /bin/bash 
# description: CA APM Infrastructure Agent
# Author - vj028584
# Edited on - 30-October-2021
########################################################################
#
# 	Version: 1.0
#   Copyright (c) 2011 CA. All rights reserved.
#
#   This software and all information contained therein is confidential and
#   proprietary and shall not be duplicated, used, disclosed or disseminated
#   in any way except as authorized by the applicable license agreement,
#   without the express written permission of CA. All authorized
#   reproductions must be marked with this language.
#
#   EXCEPT AS SET FORTH IN THE APPLICABLE LICENSE AGREEMENT, TO THE
#   EXTENT PERMITTED BY APPLICABLE LAW, CA PROVIDES THIS SOFTWARE
#   WITHOUT WARRANTY OF ANY KIND, INCLUDING WITHOUT LIMITATION, ANY
#   IMPLIED WARRANTIES OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR
#   PURPOSE. IN NO EVENT WILL CA BE LIABLE TO THE END USER OR ANY
#   THIRD PARTY FOR ANY LOSS OR DAMAGE, DIRECT OR INDIRECT, FROM THE
#   USE OF THIS SOFTWARE, INCLUDING WITHOUT LIMITATION, LOST PROFITS,
#   BUSINESS INTERRUPTION, GOODWILL, OR LOST DATA, EVEN IF CA IS EXPRESSLY
#   ADVISED OF SUCH LOSS OR DAMAGE.
#
########################################################################
#
# APMIACtrl.sh
# Master script for installing CA Host Monitoring Agent and  CA APM Infrastructure Agent
# Usage:
# APMIACtrl.sh install
# APMIACtrl.sh uninstall
# APMIACtrl.sh clean_uninstall
# APMIACtrl.sh status
# APMIACtrl.sh start
# APMIACtrl.sh stop
# APMIACtrl.sh restart
# APMIACtrl.sh console_start
# APMIACtrl.sh console_stop
# APMIACtrl.sh -help
#
# Run "APMIACtrl.sh help" for usage info
# Set the home directory if it is unset.
# Different OS require different test statements


RETRUNCODE=0

SCRIPTNAME="$0"

# The time and date for the logs
timeAndDate=$(date)

# Variable to check directory of host monitor
dir_HostMonitor=0

# Variable to check port number
port_se=1691

# Variable to check installation mode
withHostMonitor=0

# Variable for clean uninstall
clean_del=0

#Variable for install hostmonitor on start and restart
install_hostmonitor=0

#variable to set console logs
LOGCONSOLE=0

#variable to check installation
isinstall=0

#variable to set OS
THIS_OS=$(uname -s)

#Variable to detact sysedge only installation
sysedge_only=0

#variable for sysedge to bind address
bind_address=0

#variable for HostMonitor only ecluding Sysedge
hostmonitor_only=0

arg_1=$1
if [ "X$arg_1" == "X" ]; then
	arg_1="console"
fi

default_min=16
min_heap_val=256
max_heap_val=512

console_start_sys=0

CLASSNAME=com.wily.introscope.agent.uma.UnifiedMonitoringAgent
OLDCLASSNAME=UnifiedMonitoringAgent.jar

CURRENT_DIR=$(pwd)
RELEASE_PATH=""
if [ -n "$RELEASE_DIR" ]; then
    RELEASE_PATH=$RELEASE_DIR
fi

# Set directories variables
if ! [ "$APMIA_HOME" ] ; then
	APMIA_HOME="$( cd "$( dirname "$SCRIPTNAME" )" && pwd )";
	UPDATE=true
	APMIA_AGENT_BIN_PATH="$APMIA_HOME/bin"
  	APMIA_SYSEDGE_ROOT_PATH="$APMIA_HOME"
	if [ -n "$scriptDir" ]; then
      APMIA_AGENT_BIN_PATH="$scriptDir/bin"
      APMIA_SYSEDGE_ROOT_PATH="$scriptDir"
  	fi

	while [ "X$UPDATE" != "X" ]
	do
		SYMLINK=$(echo $APMIA_HOME | sed -e 's; ;:;g')
		SYMLINK=$(echo $SYMLINK | sed -e 's;/; ;g')
		ABSOLUTEPATH=
		for C in $SYMLINK; do
			C=$(echo $C | sed -e 's;:; ;g')
			ABSOLUTEPATH="$ABSOLUTEPATH/$C"
			while [ -h "$ABSOLUTEPATH" ] ; do
				OUTPUTSTR=$(ls -ld "$ABSOLUTEPATH")
				OUTPUTSTR1=$(expr "$OUTPUTSTR" : '.*-> \(.*\)$')
				if expr "$OUTPUTSTR1" : '/.*' > /dev/null; then
					ABSOLUTEPATH="$OUTPUTSTR1"
				else
					ABSOLUTEPATH=$(dirname "$ABSOLUTEPATH")"/$OUTPUTSTR1"
				fi
			done
		done
		if [ "$ABSOLUTEPATH" != "$APMIA_HOME" ]; then
			APMIA_HOME="$ABSOLUTEPATH"
		else
			 UPDATE=""
		fi
	done
	APMIA_BASE=$APMIA_HOME
	SYSEDGE_BIN_PATH="$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE/bin/CA-SystemEDGE"
	SYSEDGE_PATH="$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE"
	eval "cd \"$APMIA_HOME\"" > /dev/null 2>&1
	if [  $? == 1 ]; then
		echo "Either you don't have permission for this path or path consists of special characters." 1>&2
		exit 1
	fi
	if [ -n "$RELEASE_DIR" ]; then
		HOSTMONITOR_HOME="$APMIA_SYSEDGE_ROOT_PATH/CA_SystemEDGE_Core"
	else
		HOSTMONITOR_HOME=CA_SystemEDGE_Core
	fi
fi

#variable for app name
APP_NAME=$(grep 'APP_NAME=[^,]*' "$APMIA_AGENT_BIN_PATH/APMIAgent.shconf" | awk '{print substr($1,11)}' | sed -e 's/"$//')
CA_Sysedge="sysedge"

#variable for linux file name
SYSTEMD_SERVICE_FILE="/etc/systemd/system/${APP_NAME}.service"
SYSTEMD_SERVICE_SYS="/etc/systemd/system/sysedge.service"

#service name validation
validate_and_update_service()
{
	if [ "X$APP_NAME" != "X" ]; then
		if [[ ! $APP_NAME =~ ^[[:alnum:]]+$ ]];then
			service_set_command=0
			echo "Service name is not valid, Please input valid Service Name."
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Service name is not valid, Please input valid Service Name. $SCRIPT_LOG"
		elif [[ $APP_NAME =~ ^[0-9]+$ ]] ;then
			service_set_command=0
			echo "Service name is not valid, Please input valid Service Name."
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Service name is not valid, Please input valid Service Name. $SCRIPT_LOG"
		elif [ -e /etc/service_name.txt ]; then
			OUTPUTSTR=$(grep -w "^$APP_NAME" /etc/service_name.txt)
			CMDSTATUS=$?
			if [ "$CMDSTATUS" -eq 0 ]; then
				echo "Service name already exist, Please input another Service Name."
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent Service name already exist, Please input another Service Name. $SCRIPT_LOG"
				service_set_command=0
			else
				service_set_command=1
			fi
		else
			service_set_command=1
		fi
	else
		service_set_command=2
	fi
}

#Variable for log files
LOG_FILE="$APMIA_HOME/APMIA_install.log"
SCRIPT_LOG=">> \"$LOG_FILE\""
APMIAgent_LOG="| tee -a \"$LOG_FILE\""

if [ "$AIOPS_INSTALL_ROLE" == "team" ]; then
	hostmonitor_only=1
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent installing HostMonitor only as SNMPCollector without CA SystemEDGE. $SCRIPT_LOG"
fi
eval "echo $timeAndDate [INFO] Host Monitoring Only : $AIOPS_INSTALL_ROLE  flag $hostmonitor_only. $SCRIPT_LOG"

if [ "$hostmonitor_only" == "0" ]; then
	OUTPUTSTR=$(grep -E '^['$'\t'' ]*introscope.agent.hostmonitor.sysedge.enabled=' core/config/IntroscopeAgent.profile | grep -i false)
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		hostmonitor_only=1
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent installing HostMonitor only as SNMPCollector without CA SystemEDGE. $SCRIPT_LOG"
	fi
	eval "echo $timeAndDate [INFO] Host Monitoring Only : flag $hostmonitor_only. $SCRIPT_LOG"
fi

IA_mode_file="${APMIA_AGENT_BIN_PATH}/IA_mode"
mode_file="> \"$IA_mode_file\""

#Set min java heap and max java heap using environment variables
if [ "$MIN_HEAP_VAL_IN_MB" ]; then
	min_heap_val=$MIN_HEAP_VAL_IN_MB
fi

if [ "$MAX_HEAP_VAL_IN_MB" ]; then
	max_heap_val=$MAX_HEAP_VAL_IN_MB
fi

#Set min java heap and max java heap using input parameters
for i in "$@"
do
case $i in
    min_heap=*)
    min_heap_val="${i#*=}"
	if [ "X${min_heap_val}" != "X" ]; then
		heap_set_command=1
	else
		echo min_heap value is missing, continuing with default value.
		eval "echo $timeAndDate [INFO] min_heap value is missing, continuing with default value. $SCRIPT_LOG"
		min_heap_val=256
	fi
    shift
    ;;
    max_heap=*)
    max_heap_val="${i#*=}"
	if [ "X${max_heap_val}" != "X" ]; then
		heap_set_command=1
	else
		echo max_heap value is missing, continuing with default value.
		eval "echo $timeAndDate [INFO] max_heap value is missing, continuing with default value. $SCRIPT_LOG"
		max_heap_val=512
	fi
    shift
    ;;
	user=*)
	change_user="${i#*=}"
	if [ "X${change_user}" != "X" ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation setting user $change_user. $SCRIPT_LOG"
		set_user=1
	else
		echo user value is missing, continuing with default value.
		eval "echo $timeAndDate [INFO] user value is missing, continuing with default value. $SCRIPT_LOG"
		change_user=root
	fi
	shift
	;;
	service_name=*)
	APP_NAME="${i#*=}"
	validate_and_update_service
	if [ "$service_set_command" == "1" ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation setting Service name as $APP_NAME. $SCRIPT_LOG"
	elif [ "$service_set_command" == "0" ]; then
		eval "echo $timeAndDate [INFO] Service name $APP_NAME is already present or not valid , Please input valid or another Service name. $SCRIPT_LOG"
		exit 1
	elif [ "$service_set_command" == "2" ]; then
		echo "Service name value is missing , Please input some value. "
		eval "echo $timeAndDate [INFO] Service name value is missing , Please input some value. $SCRIPT_LOG"
		exit 1
	fi
	shift
	;;
	group=*)

	change_group="${i#*=}"
	if [ "X${change_group}" != "X" ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation setting group $change_group. $SCRIPT_LOG"
		set_group=1
	else
		echo group value is missing, continuing with default value.
		eval "echo $timeAndDate [INFO] group value is missing, continuing with default value. $SCRIPT_LOG"
		change_group=root
	fi
	shift
	;;
	console)
		LOGCONSOLE=1
		eval "echo $timeAndDate [INFO] Enabling console logs. $SCRIPT_LOG"
	shift
	;;
	sysedge)
		sysedge_only=1
	shift
    ;;
	property=*)
		property_val="${i#*=}"
		property_set=1
    shift
    ;;
	service_name*)
	echo Service name value is missing , Please input some value.
	eval "echo $timeAndDate [INFO] Service name value is missing , Please input some value. $SCRIPT_LOG"
	exit 1
	shift
	;;
esac
done

# Set AGENTHOME to home
export AGENTHOME="$APMIA_SYSEDGE_ROOT_PATH"

############################Functions starts here############################

#This Fuction logs everthing here
 logMyAPMIA()
{
		eval "echo  $SCRIPT_LOG"
        eval "echo ********************\"$(date)\" [INFO]********************* $SCRIPT_LOG"
        eval "echo $timeAndDate [INFO] Current Shell: \"$SHELL\" $SCRIPT_LOG"
        eval "echo $timeAndDate [INFO] Home Directory: \"$HOME\" $SCRIPT_LOG"
        eval "echo $timeAndDate [INFO] Your O/s Type: \"$(uname -s)\" $SCRIPT_LOG"
        eval "echo $timeAndDate [INFO] Current directory: \"$(pwd)\" $SCRIPT_LOG"
}

 EXIT()
{
	eval "cd \"$CURRENT_DIR\""
	exit $1
}

 checkroot()
{
	 if [ $(id | sed 's/^uid=//;s/(.*$//') != "0" ] ; then
		echo "Must be root to perform this action." 1>&2
		eval "echo $timeAndDate [ERROR] Must be root to perform this action. $SCRIPT_LOG"
		EXIT 1
	fi
}

 checkOwnership()
{
	owner=$(ls -ld "$APMIA_BASE" | awk '{print $3}')
	group=$(ls -ld "$APMIA_BASE" | awk '{print $4}')
	eval "echo $timeAndDate [INFO] Owner of apmia folder is ${owner}:${group}. $SCRIPT_LOG"
	chown -R $owner:$group "$APMIA_BASE" > /dev/null 2>&1

#	if [ "$THIS_OS" == "Linux" ]; then
#		if [ -f /etc/os-release ]; then
#			#added additional check for Suse 15.x support
#			OUTPUTSTR=$(grep -E '^['$'\t'' ]*NAME="SLES"' /etc/os-release)
#			CMDSTATUS=$?
#			if [ "$CMDSTATUS" -eq 0 ]; then
#				`sudo chown -R $owner "$APMIA_BASE"` > /dev/null 2>&1
#			else
#				`sudo chown -R $owner:$owner "$APMIA_BASE"` > /dev/null 2>&1
#			fi
#		else
#			`sudo chown -R $owner:$owner "$APMIA_BASE"` > /dev/null 2>&1
#		fi
#	fi
}

 checkOldVersion()
{
	crontab -l > cronfile 2>/dev/null
	OUTPUTSTR=$(grep -F "apmia-ca-installer.sh start" cronfile)
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		OUTPUTSTR=$(grep -E 'apmia-ca-installer.sh' cronfile | sed 's/@reboot //' | sed 's/start//' | sed 's/apmia-ca-installer.sh//')
		echo "Cron based APM IA installation found on location "${OUTPUTSTR}""
		eval "echo $timeAndDate [ERROR] Cron based APM IA installation found on location "${OUTPUTSTR}" $SCRIPT_LOG"
		echo "Please uninstall/remove cron based APM IA to proceed."
		eval "echo $timeAndDate [ERROR] Please uninstall/remove cron based APM IA to proceed. $SCRIPT_LOG"
		rm -f cronfile
		EXIT 1
	fi

	rm -f cronfile

	OUTPUTSTR2=$(ps -ef | grep $CLASSNAME | grep -v grep)
	if [ $? == 0 ]; then
		filename=jre.txt
		ps axo ruser=WIDE-RUSER-COLUMN,command | grep -v grep | grep $CLASSNAME > $filename
		CURRENTUSER=$(whoami)
		while read p; do
			CRONUSER=$(echo $p | grep $CLASSNAME | awk '{ print $1 }')
			LOCATION1=$(echo $p|awk -F' /' '{print $2F}'|sed 's/jre\/bin\/java*/>/'|cut -d'>' -f1)
			OUTPUTSTR2=$(echo $p | grep wrapper)
			if [ $? != 0 ]; then
				if [ "$CRONUSER" == "$CURRENTUSER" ]; then
					echo "APM Infrastructure Agent is running using console_start option for user '$CRONUSER' of cron based IA from /${LOCATION1}"
					eval "echo $timeAndDate [ERROR] APM Infrastructure Agent is running using console_start option for user '$CRONUSER' of cron based IA from /${LOCATION1} Please stop/kill APM IA to proceed. $SCRIPT_LOG"
					oldVersion=1
				else
					echo "APM Infrastructure Agent is running user '$CRONUSER' of cron based IA from /${LOCATION1}"
					eval "echo $timeAndDate [ERROR] APM Infrastructure Agent is running for user '$CRONUSER' of cron based IA from /${LOCATION1} Please uninstall/stop APM IA to proceed. $SCRIPT_LOG"
					oldVersion=2
				fi
			fi
		done < $filename
		rm -rf $filename
		if [ "$oldVersion" == "1" ]; then
			echo "Please stop/kill APM IA to proceed."
			EXIT 1
		fi
		if [ "$oldVersion" == "2" ]; then
			echo "Please uninstall/stop APM IA to proceed."
			EXIT 1
		fi
	fi
}

 checkJRE()
{
	cd "$APMIA_HOME"
	if [ -d "jre" ]; then
		JREPATH=$(grep '^['$'\t'' ]*wrapper.java.command' conf/wrapper.conf | awk '{print substr($0,22,length($0)-0)}')
		eval "echo $timeAndDate [INFO] jre path is $JREPATH. $SCRIPT_LOG"
	else
		JREPATH=$(grep '^['$'\t'' ]*wrapper.java.command' conf/wrapper.conf | awk '{print substr($0,22,length($0)-0)}')
		if [ "$JREPATH" == "jre/bin/java" -o x"$JREPATH" == x ]; then
			sed "s/wrapper.java.command=.*/wrapper.java.command=/" conf/wrapper.conf > conf/wrapper.conf1
			cat conf/wrapper.conf1 > conf/wrapper.conf
			rm -f conf/wrapper.conf1
			eval "echo $timeAndDate [ERROR] jre path is not found, kindly add jdk 1.8 path in wrapper.java.command in conf/wrapper.conf $SCRIPT_LOG"
			echo "jre path is not found, kindly add jdk 1.8 path in wrapper.java.command in conf/wrapper.conf"
			EXIT 1
		else
			eval "echo $timeAndDate [INFO] jre path is $JREPATH. $SCRIPT_LOG"
		fi
	fi
}

 extractDIR()
{
	checkInstallDir
	if [ "$dir_HostMonitor" == "0" ]; then
		eval "echo $timeAndDate [INFO] Extracting tar files $SCRIPT_LOG"
		tar -xf casystemedge*.tar.gz -C "${APMIA_SYSEDGE_ROOT_PATH}"
	fi
}

 extractJRE()
{
	if [ -f "openjdk-1.8-linux-x64.tar.gz" ]; then
		eval "echo $timeAndDate [INFO] Extracting OoenJDK tar files $SCRIPT_LOG"
		tar -xf openjdk-1.8-linux-x64.tar.gz
	fi
}

 update_java_heap()
{
	echo $min_heap_val | grep "[^0-9]" > /dev/null 2>&1
	if [ "$?" -eq "0" ]; then
		eval "echo $timeAndDate [INFO] Incorrect input, setting min_heap to 256. $SCRIPT_LOG"
		echo "Incorrect input, setting min_heap to 256."
		min_heap_val=256
		RETRUNCODE=1
	else
		if [ ${min_heap_val} -lt ${default_min} ]
		then
			min_heap_val=$default_min
			eval "echo $timeAndDate [INFO] min_heap_val is set to $default_min $SCRIPT_LOG"
		fi
	fi

	echo $max_heap_val | grep "[^0-9]" > /dev/null 2>&1
	if [ "$?" -eq "0" ]; then
		eval "echo $timeAndDate [INFO] Incorrect input, setting max_heap to 512. $SCRIPT_LOG"
		echo "Incorrect input, setting max_heap to 512."
		max_heap_val=512
		RETRUNCODE=1
	else
		if [ ${max_heap_val} -lt ${default_min} ]
		then
			max_heap_val=$default_min
			eval "echo $timeAndDate [INFO] max_heap_val is set to $default_min $SCRIPT_LOG"
		fi
	fi

	if [ ${min_heap_val} -gt ${max_heap_val} ]
	then
		max_heap_val=$min_heap_val
		eval "echo $timeAndDate [INFO] max_heap_val is set to $min_heap_val $SCRIPT_LOG"
	fi

	eval "cd \"${APMIA_AGENT_BIN_PATH}\""
	if [  -f "java_heap" ]; then
		if [ "$heap_set_command" == "1" ]; then
			eval "echo min_heap=$min_heap_val" > java_heap
			eval "echo max_heap=$max_heap_val" >> java_heap
			eval "cd \"$APMIA_HOME\""
			sed "s/wrapper.java.initmemory=.*/wrapper.java.initmemory=$min_heap_val/" conf/wrapper.conf > conf/wrapper.conf1
			cat conf/wrapper.conf1 > conf/wrapper.conf
			sed "s/wrapper.java.maxmemory=.*/wrapper.java.maxmemory=$max_heap_val/" conf/wrapper.conf > conf/wrapper.conf1
			cat conf/wrapper.conf1 > conf/wrapper.conf
			rm -f conf/wrapper.conf1
		fi
	else
		eval "echo min_heap=$min_heap_val" >> java_heap
		eval "echo max_heap=$max_heap_val" >> java_heap
		eval "cd \"$APMIA_HOME\""
		sed "s/wrapper.java.initmemory=.*/wrapper.java.initmemory=$min_heap_val/" conf/wrapper.conf > conf/wrapper.conf1
		cat conf/wrapper.conf1 > conf/wrapper.conf
		sed "s/wrapper.java.maxmemory=.*/wrapper.java.maxmemory=$max_heap_val/" conf/wrapper.conf > conf/wrapper.conf1
		cat conf/wrapper.conf1 > conf/wrapper.conf
		rm -f conf/wrapper.conf1
	fi

	if [ "$property_set" == 1 ]; then
		eval "cd \"$APMIA_HOME\""
		if [ "X$property_val" == "X" ]; then
			eval "echo $timeAndDate [ERROR] Property value is not provided. Skipping property value. $SCRIPT_LOG"
			echo "Property value is not provided. Skipping property value."
		else
			OUTPUTSTR=$(grep -E '^['$'\t'' ]*wrapper.java.additional' conf/wrapper.conf)
			if [ "$?" == "0" ]; then
				sed "s/wrapper.java.additional.*/ /" conf/wrapper.conf > conf/wrapper.conf1
				cat conf/wrapper.conf1 > conf/wrapper.conf
				rm -f conf/wrapper.conf1
			fi
			values=( $property_val )
			len="${#values[@]}"
			for ((i=0; i<$len; i++))
			do
				j=$(($i+1))
				eval "echo wrapper.java.additional.$j=${values[$i]}" >> "conf/wrapper.conf"
			done
		fi
	fi
}

 update_user_APMIA()
{
	if [ "$(/usr/bin/id -u -n "$change_user" 2>/dev/null)" != "$change_user" ]
	then
		eval "echo $timeAndDate [ERROR] User $change_user does not exist, APMIA installation will continue with root user. $SCRIPT_LOG"
		echo "User $change_user does not exist, APMIA installation will continue with root user."
		RETRUNCODE=1
	else
		eval "cd \"$APMIA_HOME\""
		sed "s/#RUN_AS_USER=.*/RUN_AS_USER=$change_user/" $APMIA_AGENT_BIN_PATH/APMIAgent.shconf > $APMIA_AGENT_BIN_PATH/APMIAgent.sh1
		if [ $? != 0 ]
		then
			eval "echo $timeAndDate [ERROR] Error in updating user for APMIA. $SCRIPT_LOG"
			echo "Error in updating user for APMIA."
			RETRUNCODE=1
		fi
		sed "s/#RUN_AS_GROUP_IA=.*/RUN_AS_GROUP_IA=$change_group/" $APMIA_AGENT_BIN_PATH/APMIAgent.sh1 > $APMIA_AGENT_BIN_PATH/APMIAgent.sh2
		if [ $? != 0 ]
		then
			eval "echo $timeAndDate [ERROR] Error in updating group for APMIA. $SCRIPT_LOG"
			echo "Error in updating group for APMIA."
			RETRUNCODE=1
		fi
		cat ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh2 > ${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf
		rm -f ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh1 ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh2
		chmod +x ${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf
		eval "echo $change_user" > ${APMIA_AGENT_BIN_PATH}/apmia.user

	fi
}

 update_user_Sysedge()
 {
	eval "cd \"$APMIA_HOME\""
	if [ "$sysedge_only" == "1" ]; then
		if [ "$(/usr/bin/id -u -n "$change_user" 2>/dev/null)" != "$change_user" ]
		then
			eval "echo $timeAndDate [ERROR] User $change_user does not exist, Sysedge installed with root user. $SCRIPT_LOG"
			echo "User $change_user does not exist, Sysedge installed with root user."
			RETRUNCODE=1
		fi
	fi
	if [ "$status" == "1" ]; then
		if [ "$(/usr/bin/id -u -n "$change_user" 2>/dev/null)" == "$change_user" ]
		then
			eval "cd \"$APMIA_HOME\""
			echo "privilege_separation_user $change_user" >> "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/port${port_se}/sysedge.cf"
			if [ $? != 0 ]
			then
				eval "echo $timeAndDate [ERROR] Error in updating user for HostMonitor. $SCRIPT_LOG"
				echo "Error in updating user for HostMonitor."
				RETRUNCODE=1
			fi
			eval "cd \"${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin\""
			./CA-SystemEDGE restart > /dev/null 2>&1
		fi
	fi
 }

 remove_user()
 {
	eval "cd \"$APMIA_HOME\""
	if [ -f "$APMIA_AGENT_BIN_PATH/apmia.user" ]
	then
		sed "121s/RUN_AS_USER=.*/#RUN_AS_USER=/" "$APMIA_AGENT_BIN_PATH/APMIAgent.shconf" > "$APMIA_AGENT_BIN_PATH/APMIAgent.sh1"
		if [ $? != 0 ]
		then
			eval "echo $timeAndDate [ERROR] Error in removing user for APMIA. $SCRIPT_LOG"
			echo "Error in removing user for APMIA."
			RETRUNCODE=1
		fi
		sed "122s/RUN_AS_GROUP_IA=.*/#RUN_AS_GROUP_IA=/" "$APMIA_AGENT_BIN_PATH/APMIAgent.sh1" > "$APMIA_AGENT_BIN_PATH/APMIAgent.sh2"
		if [ $? != 0 ]
		then
			eval "echo $timeAndDate [ERROR] Error in removing group for APMIA. $SCRIPT_LOG"
			echo "Error in removing group for APMIA."
			RETRUNCODE=1
		fi
		cat "${APMIA_AGENT_BIN_PATH}/APMIAgent.sh2" > "${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf"
		rm -f "${APMIA_AGENT_BIN_PATH}/APMIAgent.sh1" "${APMIA_AGENT_BIN_PATH}/APMIAgent.sh2"
		chmod +x "${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf"
		rm -rf "${APMIA_AGENT_BIN_PATH}/apmia.user"
	fi
	eval "cd \"$APMIA_HOME\""
 }

 getAPMIARealpath()
{

	if [ -f "$SYSTEMD_SERVICE_FILE" ]; then
		REALPATH=$(grep -E '^['$'\t'' ]*ExecStart' ${SYSTEMD_SERVICE_FILE}  | awk '{print substr($0,11,length($0)-38)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/init/${APP_NAME}.conf" ]; then
		REALPATH=$(grep -E '^['$'\t'' ]*exec' /etc/init/${APP_NAME}.conf | awk '{print substr($0,7,length($0)-42)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/init.d/$APP_NAME" ]; then
		REALPATH=$(readlink /etc/init.d/$APP_NAME | awk '{print substr($0,1,length($0)-17)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/${APP_NAME}.conf" ]; then
		REALPATH=$(cat /etc/${APP_NAME}.conf)
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "$SYSTEMD_SERVICE_SYS" ]; then
		REALPATH=$(grep -E '^['$'\t'' ]*ExecStart' ${SYSTEMD_SERVICE_SYS}  | awk '{print substr($0,12,length($0)-52)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/init/${CA_Sysedge}.conf" ]; then
		REALPATH=$(grep -E '^['$'\t'' ]*exec' /etc/init/${CA_Sysedge}.conf | awk '{print substr($0,7,length($0)-42)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/init.d/$CA_Sysedge" ]; then
		REALPATH=$(readlink /etc/init.d/$CA_Sysedge | awk '{print substr($0,1,length($0)-29)}')
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

	if [ -f "/etc/${CA_Sysedge}.conf" ]; then
		REALPATH=$(cat /etc/${CA_Sysedge}.conf)
		REALPATH=$(echo $REALPATH | sed 's/[[:space:]]/\\\ /g')
		return 0
	fi

}

#Check init entry for start, uninstall, clean_uninstall and restart
 checkinstalled()
{
	getAPMIARealpath
	REAL_PATH_WITH_RELEASE="$REALPATH"
	if [ -n "$RELEASE_PATH" ]; then
		REAL_PATH_WITH_RELEASE="$REALPATH/$RELEASE_PATH"
	fi

	eval "cd \"${APMIA_AGENT_BIN_PATH}\""
	if [ "$THIS_OS" == "AIX" ]; then
		lsitab ${APP_NAME} > /dev/null 2>&1
		CMDSTATUS=$?
		if [ "$CMDSTATUS" -eq 0 ]; then
			isinstall=2
			if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
				isinstall=1
			fi
		elif [ -f "IA_mode" ]; then
			isinstall=2
			if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
				isinstall=1
			fi
		fi
	elif [ "$THIS_OS" == "Linux" ]; then
        if [ -f /etc/redhat-release -o -f /etc/redhat_version -o -f /etc/fedora-release -o -f /etc/lsb-release -o -f /etc/debian_version -o -f /etc/debian_release -o -f /etc/SuSE-release -o -f /etc/amazon-linux-release-cpe ] || ( [ -f /etc/os-release ] && grep -q 'SUSE' /etc/os-release ) ; then
			if [ -f "/etc/init.d/$APP_NAME" -o -L "/etc/init.d/$APP_NAME" ] ; then
				isinstall=2
				if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
					isinstall=1
				fi
            elif [ -f "${SYSTEMD_SERVICE_FILE}" ] ; then
				isinstall=2
                if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
					isinstall=1
				fi
            elif [ -f "/etc/init/${APP_NAME}.conf" ] ; then
				isinstall=2
                if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
					isinstall=1
				fi
			elif [ -f "$SYSTEMD_SERVICE_SYS" -o -f "/etc/init/${CA_Sysedge}.conf" -o -f "/etc/init.d/$CA_Sysedge" ]; then
				isinstall=2
                if [ "${REALPATH}/" == "$APMIA_SYSEDGE_ROOT_PATH/" ]; then
					isinstall=1
				fi
			fi
		elif [ -f "/etc/init.d/$APP_NAME" -o -L "/etc/init.d/$APP_NAME" ] ; then
			isinstall=2
			if [ "$REAL_PATH_WITH_RELEASE" == "$APMIA_HOME" ]; then
				isinstall=1
			fi
		fi
	else
		isinstall=0
	fi
}

 summary()
{
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent current working dir \"$(pwd)\" $SCRIPT_LOG"
	echo "APM Infrastructure Agent current working dir $(pwd)"
	crontab -l > cronfile 2>/dev/null
	OUTPUTSTR=$(grep -F "apmia-ca-installer.sh start" cronfile)
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		OUTPUTSTR=$(grep -E 'apmia-ca-installer.sh' cronfile | sed 's/@reboot //' | sed 's/start//' | sed 's/apmia-ca-installer.sh//')
		echo "Cron based APM IA installation found on location "${OUTPUTSTR}""
		eval "echo $timeAndDate [INFO] Cron based APM IA installation found on location "${OUTPUTSTR}" $SCRIPT_LOG"
	fi
	rm -f cronfile
	checkinstalled
	if [ "${isinstall}" == "1" ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent installed on $REALPATH $SCRIPT_LOG"
		echo "APM Infrastructure Agent installed on $REALPATH"
	elif [ "x${REALPATH}" != "x" ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent found on $REALPATH $SCRIPT_LOG"
		echo "APM Infrastructure Agent found on $REALPATH"
	fi
	ps -elf | grep $OLDCLASSNAME  | grep -v grep 1>/dev/null
	CMDOUT=$?
	if [ $CMDOUT == 0 ]; then
		filename=jre_tmp.txt
		ps -elf | grep $OLDCLASSNAME | grep -v grep | awk -F' /' '{print $2F}' | sed 's/jre\/bin\/java*/>/'|cut -d'>' -f1 > $filename
		while read p; do
		OUTPUTSTR=$(echo $p)
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is running from location /$OUTPUTSTR $SCRIPT_LOG"
		echo "APM Infrastructure Agent is running from location /$OUTPUTSTR"
		done < $filename
		rm -rf $filename
	else
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is service not found $SCRIPT_LOG"
		echo "APM Infrastructure Agent is service not found"
	fi
	eval "cd \"$APMIA_AGENT_BIN_PATH\""
	eval "./APMIAgent.sh status $APMIAgent_LOG"
	checkInstallDir
	if [ "$dir_HostMonitor" == "1" ]; then
		eval "cd \"$APMIA_HOME\""
		cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
		./CA-SystemEDGE status
		eval "echo $timeAndDate [INFO] $(./CA-SystemEDGE status) $SCRIPT_LOG"
	fi
	eval "cd \"$APMIA_HOME\""
}

 erase()
{
	getAPMIARealpath
	if [ "x$REALPATH" != "x" ]; then
		if [ -f "$REALPATH" ]; then
			APMIA_HOME=$REALPATH
		fi
	fi

	eval "cd \"$APMIA_AGENT_BIN_PATH\""
	eval "./APMIAgent.sh remove $SCRIPT_LOG"
	uninstallStatus=$?
	if [ ! $uninstallStatus == 0 ] ; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be uninstalled. $SCRIPT_LOG"
		echo APM Infrastructure Agent could not be uninstalled.
	fi

	if [ "$THIS_OS" == "AIX" ]; then
		/usr/sbin/rmitab $CA_Sysedge
		cd /etc
		rm -rf ${APP_NAME}.conf
	fi
	eval "cd \"$APMIA_AGENT_BIN_PATH\""
	rm -rf java_heap
	remove_user
	eval "cd \"$APMIA_HOME\""

	if [ -f "$APMIA_SYSEDGE_ROOT_PATH/CA_SystemEDGE_Core/ca-setup.sh" ]; then
		export AGENTHOME="$APMIA_SYSEDGE_ROOT_PATH"
		"$APMIA_SYSEDGE_ROOT_PATH/CA_SystemEDGE_Core/ca-setup.sh" uninstall 1>/dev/null
		remove
	fi
	ps -ef | grep "wrapper.name=${APP_NAME}" | grep -v grep 1>/dev/null
	if [ "$?" -eq 0 ]; then
		OUTPUTSTR1=$(ps -ef | grep "wrapper.name=${APP_NAME}" | grep -v grep | awk '{print $2}')
		eval "echo $timeAndDate [INFO] Removing wrapper service of PID $OUTPUTSTR1. $SCRIPT_LOG"
		kill -9 $OUTPUTSTR1
	fi

	ps -elf | grep $OLDCLASSNAME  | grep -v grep 1>/dev/null
	if [ $? == 0 ]; then
		filename=jre_tmp.txt
		ps -ef | grep $OLDCLASSNAME | grep -v grep | awk '{print $2}' > $filename
		while read p; do
		OUTPUTSTR=$(echo $p)
		kill -9 $OUTPUTSTR
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent was killed of PID $OUTPUTSTR $SCRIPT_LOG"
		done < $filename
		rm -rf $filename
	else
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is service not found $SCRIPT_LOG"
	fi

	ps -elf | grep sysedge  | grep -v grep 1>/dev/null
	if [ $? == 0 ]; then
		filename=jre_tmp.txt
		ps -ef | grep sysedge | grep -v grep | awk '{print $2}' > $filename
		while read p; do
		OUTPUTSTR=$(echo $p)
		kill -9 $OUTPUTSTR
		eval "echo $timeAndDate [INFO] Sysedge was killed of PID $OUTPUTSTR $SCRIPT_LOG"
		done < $filename
		rm -rf $filename
	else
		rm -rf "/etc/systemd/system/${CA_Sysedge}.service"  > /dev/null 2>&1
		eval "echo $timeAndDate [INFO] Sysedge is service not found $SCRIPT_LOG"
	fi

	eval "echo $timeAndDate [INFO] Clean-up completed. $SCRIPT_LOG"
	echo Clean-up completed.
}

 installerrmsg()
{
	eval "echo $timeAndDate [ERROR] APMIA is not installed/corrupt installation is present/APMIA is started using console start. $SCRIPT_LOG"
	echo "APMIA is not installed/corrupt installation is present/APMIA is started using console start."
	EXIT 1
}

 checkInstallDir()
{
    eval "cd \"$APMIA_HOME\""
	if [ -d "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE" ]; then
		dir_HostMonitor=1
	else
		dir_HostMonitor=0
	fi
}

#This  shall check if Port is available reurn 1 when available else return 0
 checkPortStatus()
{
	status=0

	# Lets check 1691 port
	if [ "$THIS_OS" == "AIX" ]; then
		netstat -an | grep -E "^udp[46]*[         ]+[0-9]+[       ]+[0-9]+[       ]+[0-9a-f\.:\*]+\.1691[        ]+" >/dev/null
		OUTPUTSTR=$?
	elif [ "$THIS_OS" == "Linux" ]; then
		netstat -an | grep -E "^udp[      ]+[0-9]+[       ]+[0-9]+[       ]+[0-9a-f\.:\*]+:1691[         ]+" >/dev/null
		OUTPUTSTR=$?
	fi

	if [ "$OUTPUTSTR" == "1" ]; then
		eval "echo $timeAndDate [INFO] 1691 port is free $SCRIPT_LOG"
		status=1
		port_se=1691
		return $status
	else
		eval "echo $timeAndDate [INFO] 1691 port is not free, lets check port 1791 $SCRIPT_LOG"
		status=0
	fi

	# Lets check 1791 port
	if [ "$THIS_OS" == "AIX" ]; then
		netstat -an | grep -E "^udp[46]*[         ]+[0-9]+[       ]+[0-9]+[       ]+[0-9a-f\.:\*]+\.1791[        ]+">/dev/null
		OUTPUTSTR=$?
	elif [ "$THIS_OS" == "Linux" ]; then
		netstat -an | grep -E "^udp[      ]+[0-9]+[       ]+[0-9]+[       ]+[0-9a-f\.:\*]+:1791[         ]+">/dev/null
		OUTPUTSTR=$?
	fi

	if [ "$OUTPUTSTR" == "1" ]; then
		eval "echo $timeAndDate [INFO] 1791 port is free $SCRIPT_LOG"
		status=1
		port_se=1791
		return $status
	else
		echo "1691 and 1791 ports are not free, Cannot install Host Monitoring Agent"
		eval "echo $timeAndDate [INFO] 1691 and 1791 ports are not free, Cannot install Host Monitoring Agent $SCRIPT_LOG"
		status=0
		RETRUNCODE=1
		return $status
	fi

}

 checkInstallMode()
{
	eval "cd \"$APMIA_HOME\""
	ls casystemedge* >/dev/null 2>&1
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		HM_NAME=$(ls -1 extensions/deploy | grep -i hostmonitor)
		if [ "X$HM_NAME" != "X" ]; then
			if [ -f "extensions/deploy/$HM_NAME" ]; then
				withHostMonitor=1
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent installation mode is with Host Monitoring Agent. $SCRIPT_LOG"
			else
				withHostMonitor=0
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent installation mode is without Host Monitoring Agent. $SCRIPT_LOG"
				eval "echo $timeAndDate [INFO] HostMonitor extension tar file is not found in deploy folder. $SCRIPT_LOG"
			fi
		fi
		HM_NAME=$(ls -1 extensions | grep -i hostmonitor)
		if [ "X$HM_NAME" != "X" ]; then
			if [ -d "extensions/$HM_NAME" ]; then
				OUTPUTSTR=$(grep -E '^['$'\t'' ]*introscope.agent.extensions.bundles.load=' extensions/Extensions.profile | grep -i hostmonitor)
				CMDSTATUS=$?
				if [ "$CMDSTATUS" -eq 0 ]; then
					withHostMonitor=1
					eval "echo $timeAndDate [INFO] APM Infrastructure Agent installation mode is with Host Monitoring Agent. $SCRIPT_LOG"
					eval "cd \"$APMIA_HOME\""
					return $withHostMonitor
				else
					withHostMonitor=0
					eval "echo $timeAndDate [INFO] APM Infrastructure Agent installation mode is without Host Monitoring Agent. $SCRIPT_LOG"
					eval "echo $timeAndDate [INFO] User did not loaded HostMonitor in Extensions.profile $SCRIPT_LOG"
					eval "cd \"$APMIA_HOME\""
					return $withHostMonitor
				fi
			fi
		fi
	else
		withHostMonitor=0
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent installation mode is without Host Monitoring Agent. $SCRIPT_LOG"
		eval "echo $timeAndDate [INFO] Host Monitor tar file is not found for installation. $SCRIPT_LOG"
	fi
}

 checkIAUser()
{
	checkinstalled
	if [ "$isinstall" == 1 ]; then
		eval "cd \"$APMIA_HOME\""
		if [ -f "$APMIA_AGENT_BIN_PATH/apmia.user" ]; then
			change_user=$(awk '{print $1}' "$APMIA_AGENT_BIN_PATH/apmia.user")
			set_user=1
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent installed on user $change_user. $SCRIPT_LOG"
		fi
	fi
}

 check_hostmonitor_mode()
{
	checkInstallMode
	if [ "$withHostMonitor" == "1" ]; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			install_hostmonitor=0
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Host Monitor found installed. $SCRIPT_LOG"
		fi
	fi

	if [ "$withHostMonitor" == "1" ]; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "0" ]; then
			install_hostmonitor=1
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Host Monitor to be install. $SCRIPT_LOG"
		fi
	fi

	if [ "$withHostMonitor" == "0" ]; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "0" ]; then
			install_hostmonitor=0
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent is without Host Monitor. $SCRIPT_LOG"
		fi
	fi

	if [ "$withHostMonitor" == "0" ]; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Host Monitor to be uninstall. $SCRIPT_LOG"
			uninstallSE
		fi
	fi

	if [ "$install_hostmonitor" == "1" ]; then
		if [ "$hostmonitor_only" == "0" ]; then
			installSE
			sleep 2
			checkIAUser
			if [ "$set_user" == 1 ]
			then
				update_user_Sysedge
			fi
		fi
	fi
}

 set_bundleProperties()
{
	if [ "$1" == "1791" ] ; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			echo "Please Update port number in bundle properties of HostMonitor extension as Host Monitoring agent installed on port $1 and RESTART the APMIA "
			eval "echo $timeAndDate [INFO] Please Update port number in bundle properties of HostMonitor extension as Host Monitoring agent installed on port $1 and RESTART the APMIA $SCRIPT_LOG"
		fi
	fi
	eval "cd \"$APMIA_HOME\""
	if [ -f extensions/HostMonitor/bundle.properties ]; then
		tr -d '\r' < extensions/HostMonitor/bundle.properties >  output.txt
		cat output.txt > extensions/HostMonitor/bundle.properties
		rm -f output.txt
	fi
}
 set_IntroscopeAgentprofile()
{
	eval "cd \"$APMIA_HOME\""
	LOGTYPE=$(grep -E '^['$'\t'' ]*log4j.logger.IntroscopeAgent=' core/config/IntroscopeAgent.profile|cut -d'=' -f2|cut -d',' -f1)
    if [ $LOGCONSOLE == 1 ]; then
		eval "echo $timeAndDate [INFO] Updating log4j in IntroscopeAgent.profile with console $SCRIPT_LOG"
		sed "s/^log4j.logger.IntroscopeAgent=.*/log4j.logger.IntroscopeAgent=$LOGTYPE, console/" core/config/IntroscopeAgent.profile > core/config/IntroscopeAgent.profile1
	else
		eval "echo $timeAndDate [INFO] Updating log4j in IntroscopeAgent.profile with logfile $SCRIPT_LOG"
		sed "s/^log4j.logger.IntroscopeAgent=.*/log4j.logger.IntroscopeAgent=$LOGTYPE, logfile/" core/config/IntroscopeAgent.profile > core/config/IntroscopeAgent.profile1
	fi
        tr -d '\r' < core/config/IntroscopeAgent.profile1 > core/config/IntroscopeAgent.profile
        rm -f core/config/IntroscopeAgent.profile1

	cd - >/dev/null
}

#display help for this script
 displayhelp()
{
	echo
	echo -e "Usage: <APMIACtrl.sh> {install|uninstall|clean_uninstall|start|stop|status|restart|console_start|console_stop|-help}" >&2
	echo "APM IA Run as different user:  <APMIACtrl.sh> install user=[user]"
	echo "java heap usage: <APMIACtrl.sh> install|start min_heap=[value] max_heap=[value]"
	echo "service name usage: <APMIACtrl.sh> install service_name=[value]"
	echo
	echo "  install                - install APM Infrastructure Agent
  uninstall              - uninstall APM Infrastructure Agent
  clean_uninstall        - uninstall and cleans directory of APM Infrastructure Agent
  start                  - start APM Infrastructure Agent
  stop                   - stop APM Infrastructure Agent
  status                 - status of APM Infrastructure Agent
  restart                - restart APM Infrastructure Agent
  console_start          - console_start to start APM Infrastructure Agent (Press ctrl+c to stop console_start)
  console_stop           - console_stop to stop APM Infrastructure Agent
  help                   - this screen
  min_heap               - minimum java heap memory in MB, default is 256
  max_heap               - maximum java heap memory in MB, default is 512
  service_name           - name of the service to run the insatance
  user                   - Make sure that the user has the required privileges to write the PID file and log files."
}

 remove_bind_address()
{
	eval "cd \"$APMIA_HOME\""
	if [[ -f "${APMIA_HOME}/${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/port${port_se}/sysedge.cf" ]]
	then
		bind=$(grep -E 'bind_address 127.0.0.1' "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/port${port_se}/sysedge.cf")
		if [[ $? == 0 ]]
		then
			sed -ie "s/^bind_address 127.0.0.1.*/ /" "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/port${port_se}/sysedge.cf"
		fi

		bind=$(grep -E 'bind_address 127.0.0.1' ${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/sysedge.cf)
		if [[ $? == 0 ]]
		then
			sed -ie "s/^bind_address 127.0.0.1.*/ /" ${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/sysedge.cf
		fi
	fi

}

 sysedge_service()
{
	SYSEDGE_CONF_PATH="${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/config/port${port_se}"
	SYSEDGE_PID_PATH="$SYSEDGE_CONF_PATH/sysedge.pid"
	if [ "$THIS_OS" == "Linux" ]; then
		if [ -d "/etc/systemd" ] ; then
			eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using systemd... $SCRIPT_LOG"
			echo "[Unit]"                            > "${SYSTEMD_SERVICE_SYS}"
			echo "Description=${CA_Sysedge}"	    >> "${SYSTEMD_SERVICE_SYS}"
			echo "After=syslog.target"              >> "${SYSTEMD_SERVICE_SYS}"
			echo ""                                 >> "${SYSTEMD_SERVICE_SYS}"
			echo "[Service]"                        >> "${SYSTEMD_SERVICE_SYS}"
			echo "Type=forking"                     >> "${SYSTEMD_SERVICE_SYS}"
			echo "ExecStart=\"${SYSEDGE_BIN_PATH}\" start sysd" >> "${SYSTEMD_SERVICE_SYS}"
			echo "ExecStop=\"${SYSEDGE_BIN_PATH}\" stop sysd"   >> "${SYSTEMD_SERVICE_SYS}"
			echo "PIDFile=${SYSEDGE_PID_PATH}"      >> "${SYSTEMD_SERVICE_SYS}"
			echo "KillMode=none"                    >> "${SYSTEMD_SERVICE_SYS}"
			echo ""                                 >> "${SYSTEMD_SERVICE_SYS}"
			echo "[Install]"                        >> "${SYSTEMD_SERVICE_SYS}"
			echo "WantedBy=multi-user.target"       >> "${SYSTEMD_SERVICE_SYS}"

			# If SELinux is present and enabled, then the context of the script needs to be updated for systemd to be allowed to execute it.
			getSELinuxStatus
			if [ $SELINUX_STATUS -ge 2 ] ; then
				# Use chcon rather than semanage because it is present on more installations and also allows us to restore the default context more easily.
				result=$(chcon -t bin_t "${SYSEDGE_BIN_PATH}" 2>/dev/null)
				if [ $? -ne 0 ] ; then
					# Print a warning, but the user can still configure SELinux manually.
					SCRIPT_BASENAME=$(basename "${SYSEDGE_BIN_PATH}")
					eval echo $(gettext ' WARNING: Could not update the SELinux context of $SCRIPT_BASENAME.')
				fi
				result=$(chcon -R -t bin_t "${SYSEDGE_CONF_PATH}" 2>/dev/null)
				if [ $? -ne 0 ] ; then
					eval "echo $(gettext ' WARNING: Could not update the SELinux context of \"${SYSEDGE_CONF_PATH}\".')"
				fi
			fi
			systemctl daemon-reload
			systemctl enable "$CA_Sysedge" > /dev/null 2>&1
			systemctl start "$CA_Sysedge"  > /dev/null 2>&1

		elif [  -d "/etc/init" ] ; then
			eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using upstart... $SCRIPT_LOG"
			echo "# ${CA_Sysedge}"                                            > "/etc/init/${CA_Sysedge}.conf"
			echo "description \"${CA_Sysedge}\""                             >> "/etc/init/${CA_Sysedge}.conf"
			echo "start on runlevel [0123456]"                               >> "/etc/init/${CA_Sysedge}.conf"
			echo "stop on runlevel [!2345]"                                  >> "/etc/init/${CA_Sysedge}.conf"
			echo "env LANG=${LANG}"                                          >> "/etc/init/${CA_Sysedge}.conf"
			echo "exec \"${SYSEDGE_BIN_PATH}\" start"  						 >> "/etc/init/${CA_Sysedge}.conf"

		elif [ -f /etc/redhat-release -o -f /etc/redhat_version -o -f /etc/fedora-release ] ; then
			eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using initd... $SCRIPT_LOG"
			ln -s "\"${SYSEDGE_BIN_PATH}\"" "/etc/init.d/$CA_Sysedge"
			/sbin/chkconfig --add "$CA_Sysedge"
			/sbin/chkconfig "$CA_Sysedge" on

		elif [ -f /etc/SuSE-release ] ; then
			eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using initd on SuSE... $SCRIPT_LOG"
			ln -s "\"${SYSEDGE_BIN_PATH}\"" "/etc/init.d/$CA_Sysedge"
			insserv "/etc/init.d/$CA_Sysedge"

		elif [ -f /etc/lsb-release -o -f /etc/debian_version -o -f /etc/debian_release ] ; then
			eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using initd on debian... $SCRIPT_LOG"
			ln -s "\"${SYSEDGE_BIN_PATH}\"" "/etc/init.d/$CA_Sysedge"
			update-rc.d "$CA_Sysedge" defaults
		fi
	elif [ "$THIS_OS" == "AIX" ]; then
		eval "echo $timeAndDate [INFO] creating default service file for ${CA_Sysedge} using SRC... $SCRIPT_LOG"
		/usr/sbin/mkitab "$CA_Sysedge":2:once:"/usr/bin/startsrc -s \"${CA_Sysedge}\" >/dev/console 2>&1"
	fi
}

 remove()
 {
	if [ "$THIS_OS" == "Linux" ]; then
		if [ -d "/etc/systemd" ] ; then
			eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using systemd... $SCRIPT_LOG"
			systemctl disable $CA_Sysedge > /dev/null 2>&1
			rm -f "/etc/systemd/system/${CA_Sysedge}.service"
			systemctl daemon-reload
		elif [  -d "/etc/init" ] ; then
			eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using upstart... $SCRIPT_LOG"
			rm "/etc/init/${CA_Sysedge}.conf"
		elif [ -f /etc/redhat-release -o -f /etc/redhat_version -o -f /etc/fedora-release ] ; then
			eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using initd... $SCRIPT_LOG"
			/sbin/chkconfig "$CA_Sysedge" off
			/sbin/chkconfig --del "$CA_Sysedge"
			rm -f "/etc/init.d/$CA_Sysedge"

		elif [ -f /etc/SuSE-release ] ; then
			eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using initd on SuSE... $SCRIPT_LOG"
			insserv -r "/etc/init.d/$CA_Sysedge"
			rm -f "/etc/init.d/$CA_Sysedge"

		elif [ -f /etc/lsb-release -o -f /etc/debian_version -o -f /etc/debian_release ] ; then
			eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using initd on debian... $SCRIPT_LOG"
			update-rc.d -f "$CA_Sysedge" remove
			rm -f "/etc/init.d/$CA_Sysedge"
		fi
	elif [ "$THIS_OS" == "AIX" ]; then
		eval "echo $timeAndDate [INFO] removing default service file for ${CA_Sysedge} using SRC... $SCRIPT_LOG"
		/usr/sbin/rmitab $CA_Sysedge
	fi
 }

getSELinuxStatus() {
	result=$(getenforce 2>/dev/null)
	if [ $? -ne 0 ] ; then
		# Not present
		SELINUX_STATUS=0
	else
		case "$result" in
			'Disabled')
				SELINUX_STATUS=1
				;;
			'Permissive')
				SELINUX_STATUS=2
				;;
			'Enforcing')
				SELINUX_STATUS=3
				;;
			*)
				SELINUX_STATUS=0
				;;
		esac
	fi
}

 installSE()
{
	checkInstallDir
	if [ "$dir_HostMonitor" == "1" ]; then
		eval "echo $timeAndDate [INFO] Host Monitor Agent folder present. $SCRIPT_LOG"
		rm -rf SystemEDGE
	fi

	OUTPUTSTR1=$(ps -ef | grep "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE" |grep -v grep)
	CMDSTATUS1=$?
	if [ "$CMDSTATUS1" -eq 0 ]; then
		OUTPUTSTR1=$(ps -ef | grep "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE" |grep -v grep | awk '{print $2}')
		eval "echo $timeAndDate [INFO] Removing Host Monitor Agent service. $SCRIPT_LOG"
		kill -9 $OUTPUTSTR1
	fi

	checkPortStatus
	if [ "$status" == "1" ]; then
		eval "cd \"$APMIA_HOME\""
		extractDIR
		eval "echo $timeAndDate [INFO] Calling installer to install sysedge $SCRIPT_LOG"
		eval "cd \"$HOSTMONITOR_HOME\""
		eval "echo $timeAndDate [INFO] Setting HOSTMONITOR_HOME to $HOSTMONITOR_HOME $SCRIPT_LOG"

		eval "export CASYSEDGE=$APMIA_HOME/SystemEDGE"
		echo "Installing Host Monitoring Agent on PORT $port_se"
		eval "echo $timeAndDate [INFO] ./ca-setup.sh install -p $port_se $SCRIPT_LOG"
		eval "./ca-setup.sh install -p $port_se $SCRIPT_LOG"
		checkSEinst=$?
		if [ ! "$checkSEinst" == "0" ] ; then
			echo "Host Monitoring Agent Installation is Completed with Exit Status as $checkSEinst. If exit status is non zero please check APMIA_install.log"
			RETRUNCODE=1
		fi
		eval "echo $timeAndDate [INFO] Host Monitoring Agent Installation is Completed with Exit Status as $checkSEinst. If exit status is non zero please check \"$APMIA_SYSEDGE_ROOT_PATH/CA_SystemEDGE_Core/sysedge_install.log\" and APMIA_install.log $SCRIPT_LOG"
		eval "cd \"$APMIA_HOME\""
		if [ "$console_start_sys" == 0 ]; then
			sysedge_service
		fi

		if [ "$sysedge_only" == 1 ]; then
			if [ "$THIS_OS" == "AIX" ]; then
				cd /etc
				touch $CA_Sysedge.conf
				eval  "echo $APMIA_HOME  > $CA_Sysedge.conf"
			fi
			echo "APM Infrastructure Agent Installation Completed."
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation Completed. $SCRIPT_LOG"
		fi

		eval "cd \"$APMIA_HOME\""
		set_bundleProperties "$port_se"
	fi
}

 installAPMIA()
{
	#check for supported platform
	case "$THIS_OS" in
	'AIX')
	;;
	'Linux')
		checkOldVersion
	;;
	*)
		eval "echo $timeAndDate [ERROR] Unsupported platform $SCRIPT_LOG"
		echo "Unsupported platform"
		EXIT 1
	;;
	esac

	checkinstalled
	if [ "$isinstall" == "1" ]; then
	eval "cd \"$APMIA_HOME\""
	EXISTING_APP_NAME=$(grep 'APP_NAME=[^,]*' "$APMIA_AGENT_BIN_PATH/APMIAgent.shconf" | awk '{print substr($1,11)}' | sed -e 's/"$//')
	eval "echo $timeAndDate [ERROR] APMIA is already installed at \"$REALPATH\" with service $EXISTING_APP_NAME. $SCRIPT_LOG"
	echo "APMIA is already installed at $REALPATH with service $EXISTING_APP_NAME"
	EXIT 1
	fi

	if [[ $APP_NAME == "apmia" ]] ; then
		if [ "$isinstall" == "2" ]; then
			ps -elf | grep $OLDCLASSNAME  | grep -v grep 1>/dev/null
			CMDOUT=$?
			if [ $CMDOUT == 0 ]; then
				filename=jre_tmp.txt
				ps -elf | grep $OLDCLASSNAME | grep -v grep | awk -F' /' '{print $2F}' | sed 's/jre\/bin\/java*/>/'|cut -d'>' -f1 > $filename
				while read p; do
				OUTPUTSTR=$(echo $p)
				eval "echo $timeAndDate [ERROR] APMIA is already installed/corrupt installation present at location /$OUTPUTSTR $SCRIPT_LOG"
				echo "APMIA is already installed/corrupt installation present at location /$OUTPUTSTR"
				done < $filename
				rm -rf $filename
			else
				eval "echo $timeAndDate [ERROR] APMIA is already installed $REALPATH. $SCRIPT_LOG"
				echo "APMIA is already installed $REALPATH"
			fi
			EXIT 1
		fi


		ps -elf | grep $OLDCLASSNAME  | grep -v grep 1>/dev/null
		CMDOUT=$?
		if [ $CMDOUT == 0 ]; then
			filename=jre_tmp.txt
			ps -elf | grep $OLDCLASSNAME | grep -v grep | awk -F' /' '{print $2F}' | sed 's/jre\/bin\/java*/>/'|cut -d'>' -f1 > $filename
			while read p; do
			OUTPUTSTR=$(echo $p)
			eval "echo $timeAndDate [ERROR] APMIA is already running using console_start/corrupt installation present at location /$OUTPUTSTR $SCRIPT_LOG"
			echo "APMIA is already running using console_start/corrupt installation present at location /$OUTPUTSTR"
			done < $filename
			rm -rf $filename
			EXIT 1
		fi
	fi
	eval "cd \"$APMIA_HOME\""
	if [ -d "java-agent" ]; then
        chmod -R 777 java-agent
    fi

	if [ -f "$APMIA_AGENT_BIN_PATH/java_heap" ]; then
		rm -rf ${APMIA_AGENT_BIN_PATH}/java_heap
	fi

	if [[ ${sysedge_only} == 0 ]]
	then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent home $APMIA_HOME $SCRIPT_LOG"
		echo "APM Infrastructure Agent Installation In Progress..."
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation In Progress... $SCRIPT_LOG"

		extractJRE
		checkInstallMode
		if [ "$withHostMonitor" == 1 ]; then
			if [ "$hostmonitor_only" == 0 ]; then
				installSE
				sleep 2
				if [ "$set_user" == 1 ]
				then
					update_user_Sysedge
				fi
				checkOwnership $SYSEDGE_PATH
			fi
		fi

		set_IntroscopeAgentprofile
		update_java_heap
		if [ "$set_user" == 1 ]
		then
			update_user_APMIA
		fi

		if [ "$THIS_OS" == "AIX" ]; then
			cd /etc
			touch ${APP_NAME}.conf
			eval  "echo $CURRNT_DIR  >${APP_NAME}.conf"
		fi

		eval "cd \"$APMIA_HOME\""
		sed "s/APP_NAME=.*/APP_NAME=\"$APP_NAME\"/" "$APMIA_AGENT_BIN_PATH/APMIAgent.shconf" > "$APMIA_AGENT_BIN_PATH/APMIAgent.sh1"
		cat "$APMIA_AGENT_BIN_PATH/APMIAgent.sh1" > "$APMIA_AGENT_BIN_PATH/APMIAgent.shconf"
		rm -f "$APMIA_AGENT_BIN_PATH/APMIAgent.sh1"
		eval "cd \"$APMIA_AGENT_BIN_PATH\""
		eval "./APMIAgent.sh installstart $SCRIPT_LOG"
		installStatus=$?
		if [ ! $installStatus == 0 ] ; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be installed/started.  $SCRIPT_LOG"
			echo "APM Infrastructure Agent could not be installed/started, please check APMIA_install.log"
			if [ "$withHostMonitor" == 1 ]; then
				uninstallSE
			fi
			checkinstalled
			if [ "$isinstall" == 1 ]; then
				uninstallAPMIA
			fi
			EXIT 1
		fi

		echo "APM Infrastructure Agent Installation Completed."
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Installation Completed. $SCRIPT_LOG"
	fi

	checkOwnership $APMIA_HOME/APMIA_install.log


	cd /etc
	if [[ $APP_NAME != "apmia" ]] ; then
		echo $APP_NAME-$APMIA_HOME >> "service_name.txt"
	fi

	eval "cd \"$APMIA_HOME\""
}

 console_start_APMIA()
{
	#check for supported platform
	case "$THIS_OS" in
	'AIX')
	;;
	'Linux')
		checkOldVersion
	;;
	*)
		eval "echo $timeAndDate [ERROR] Unsupported platform $SCRIPT_LOG"
		echo "Unsupported platform"
		EXIT 1
	;;
	esac

	if [ "$sysedge_only" == "1" -o -f "${APMIA_AGENT_BIN_PATH}/IA_mode" ]; then
		eval "echo $timeAndDate [ERROR] console_start is not supported with sysedge only enabled $SCRIPT_LOG"
		echo "console_start is not supported with sysedge only enabled"
		EXIT 1
	fi

	if [ -f "apmia.user"  -o "$set_user" == 1 ]
	then
		eval "echo $timeAndDate [ERROR] force_start is not supported with user enabled $SCRIPT_LOG"
		echo "force_start is not supported with user enabled"
		EXIT 1
	fi

	#checking APMIA service running at same location
	ls ${APMIA_AGENT_BIN_PATH}/*.pid >/dev/null 2>&1
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is already running. Please stop APM Infrastructure Agent then run console start. $SCRIPT_LOG"
		echo "APM Infrastructure Agent is already running. Please stop APM Infrastructure Agent then run console start."
		EXIT 1
	fi

	echo "APM Infrastructure Agent Console Start in Progress..."
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent Console Start in Progress... $SCRIPT_LOG"

	extractJRE
	check_hostmonitor_mode
	eval "cd \"$APMIA_HOME\""
	if [ -d "java-agent" ]; then
        chmod -R 777 java-agent
    fi
	if [ "$dir_HostMonitor" == "1" ]; then
		cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
		eval "echo $timeAndDate [INFO] Host Monitor Console Start in progress.. $SCRIPT_LOG"
		eval "./CA-SystemEDGE start $SCRIPT_LOG"
	fi
	if [ "$port_se" == "1791" ] ; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			echo "Please ignore above message if you have already updated port number. "
			eval "echo $timeAndDate [INFO] Please ignore above message if you have already updated port number. $SCRIPT_LOG"
		fi
	fi
	if [ "$dir_HostMonitor" == "1" ]; then
		eval "cd \"$APMIA_HOME\""
		"$APMIA_SYSEDGE_ROOT_PATH"/CA_SystemEDGE_Core/sysedge_signals &
		SYS_KILL_PID=$(echo $!)
	fi
	eval "cd \"$APMIA_HOME\""
	if [ -f extensions/HostMonitor/bundle.properties ]; then
		tr -d '\r' < extensions/HostMonitor/bundle.properties >  output.txt
		cat output.txt > extensions/HostMonitor/bundle.properties
		rm -f output.txt
	fi

	set_IntroscopeAgentprofile
	update_java_heap

	echo "Running APM Infrastructure Agent in console_start mode... (To stop console_start use ctrl+c)"
	if [ "$LOGCONSOLE" == "1" ]; then
		eval "\"$APMIA_AGENT_BIN_PATH/APMIAgent.sh\" console"
	else
		eval "\"$APMIA_AGENT_BIN_PATH/APMIAgent.sh\" console" > /dev/null 2>&1
	fi

	OUTPUTSTR1=$(ps -ef | grep "wrapper.name=${APP_NAME}" | grep -v grep | grep "${APMIA_HOME}")
	CMDSTATUS1=$?
	if [ "$CMDSTATUS1" -eq 0 ]; then
		OUTPUTSTR1=$(ps -ef | grep "wrapper.name=${APP_NAME}" | grep -v grep | grep "${APMIA_HOME}" | awk '{print $2}')
		OUTPUTSTR2=$(ps -ef | grep $CLASSNAME | grep -v grep | grep "${APMIA_HOME}" | awk '{print $2}')
		eval "echo $timeAndDate [INFO] Removing wrapper service. $SCRIPT_LOG"
		kill -9 $OUTPUTSTR1 $OUTPUTSTR2
	fi

	checkInstallDir
	if [ $dir_HostMonitor == 1 ]; then
		eval "cd \"$APMIA_HOME\""
		cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
		./CA-SystemEDGE status >/dev/null
		if ! [ $? -eq 1 ]; then
			eval "./CA-SystemEDGE stop $SCRIPT_LOG"
			echo "Stopping HostMonitor"
			eval "echo $timeAndDate [INFO] Stopping HostMonitor $SCRIPT_LOG"
			eval "cd \"$APMIA_HOME\""
		fi
		kill -HUP $SYS_KILL_PID > /dev/null 2>&1
	fi

	if [ "$property_set" == 1 ]; then
		sed "s/wrapper.java.additional.*/ /" conf/wrapper.conf > conf/wrapper.conf1
		cat conf/wrapper.conf1 > conf/wrapper.conf
		rm -f conf/wrapper.conf1
	fi

	echo "APM Infrastructure Agent console_start stopped"
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent console_start stopped $SCRIPT_LOG"

}
 console_stop_APMIA()
{
	checkInstallDir
	if [ $dir_HostMonitor == 1 ]; then
		"${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin/CA-SystemEDGE" status >/dev/null
		if ! [ $? -eq 1 ]; then
			eval "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE/bin/CA-SystemEDGE stop $SCRIPT_LOG"
			echo "Stopping HostMonitor"
			eval "echo $timeAndDate [INFO] Stopping HostMonitor $SCRIPT_LOG"
			eval "cd \"$APMIA_HOME\""
		fi
	fi

	ls ${APMIA_AGENT_BIN_PATH}/*.pid >/dev/null 2>&1
	CMDSTATUS=$?
	if [ "$CMDSTATUS" -eq 0 ]; then
		OUTPUTSTR=$(awk 'NR==1 {print; exit}' ${APMIA_AGENT_BIN_PATH}/*.pid)
		kill -9 $OUTPUTSTR > /dev/null 2>&1
		eval "$APMIA_AGENT_BIN_PATH/APMIAgent.sh status > /dev/null 2>&1"
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is stopped. $SCRIPT_LOG"
		echo  APM Infrastructure Agent is stopped.
	else
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent is not running. $SCRIPT_LOG"
		echo  APM Infrastructure Agent is not running.
	fi
}

 install_main()
{
	if [[ ${sysedge_only} == 1 ]]
	then
		eval "echo APM Infrastructure Agent user entered install with only sysedge option $SCRIPT_LOG"
		installAPMIA
		installSE
		eval "echo APM Infrastructure Agent installed on only sysedge mode $mode_file"
		sleep 1
		remove_bind_address
		if [ "$set_user" == 1 ]
		then
			update_user_Sysedge
		fi
	else
		installAPMIA
	fi
}
 uninstall_main()
{
	checkinstalled
	eval "cd \"${APMIA_AGENT_BIN_PATH}\""
	if [ -f "IA_mode" ]; then
		uninstallSE
	elif [ "$isinstall" == 1 ]; then
		echo "APM Infrastructure Agent Uninstallation In Progress..."
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent Uninstallation In Progress... $SCRIPT_LOG"
		uninstallSE
		uninstallAPMIA
	else
		installerrmsg
	fi
}

 uninstallSE()
{
	checkInstallDir
	if [ "$dir_HostMonitor" == "1" ]; then
		cd "$HOSTMONITOR_HOME"
		echo "Uninstalling HostMonitor $HOSTMONITOR_HOME"
		eval "echo $timeAndDate [INFO] Uninstalling HostMonitor $SCRIPT_LOG"
		eval "echo $timeAndDate [INFO] sh ca-setup.sh uninstall $SCRIPT_LOG"
		eval "./ca-setup.sh uninstall $SCRIPT_LOG"
		eval "cd \"$APMIA_SYSEDGE_ROOT_PATH\""
		rm -rf CA_SystemEDGE_Core
		if [ "$(id -u)" == "0" ]; then
			rm -rf /etc/sysedge.cf
			rm -rf /etc/sysedge.cf.bak
		fi
		if [ "$console_start_sys" == 0 ]; then
			remove
		fi
		eval "cd \"${APMIA_AGENT_BIN_PATH}\""
		if [ -f "IA_mode" ]; then
			rm -rf "IA_mode"
			clean_del=1
			eval "cd \"$APMIA_HOME\""
		fi
	else
		eval "echo $timeAndDate [INFO] Host Monitoring Agent is not present at $APMIA_HOME. $SCRIPT_LOG"
	fi
}

 uninstallAPMIA()
{
	eval "cd \"$APMIA_HOME\""

	eval "cd \"$APMIA_AGENT_BIN_PATH\""
	eval "./APMIAgent.sh remove $SCRIPT_LOG"
	uninstallStatus=$?
	if [ ! $uninstallStatus == 0 ] ; then
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be uninstalled. $SCRIPT_LOG"
		echo "APM Infrastructure Agent could not be uninstalled, please check APMIA_install.log"
		EXIT 1
	fi

	clean_del=1

	if [ "$THIS_OS" == "AIX" ]; then
		cd /etc
		rm -rf ${APP_NAME}.conf
	fi

	eval "cd \"$APMIA_HOME\""
	sed "s/wrapper.java.additional.*/ /" conf/wrapper.conf > conf/wrapper.conf1
	cat conf/wrapper.conf1 > conf/wrapper.conf
	rm -f conf/wrapper.conf1

	eval "cd \"$APMIA_HOME\""
	sed "s/APP_NAME=.*/APP_NAME=\"apmia\"/" ${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf > ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh1
	cat ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh1 > ${APMIA_AGENT_BIN_PATH}/APMIAgent.shconf
	rm -f ${APMIA_AGENT_BIN_PATH}/APMIAgent.sh1

	eval "cd \"$APMIA_AGENT_BIN_PATH\""
	rm -rf java_heap
	remove_user
	eval "cd \"$APMIA_HOME\""

	if [ -f /etc/service_name.txt ]; then
		OUTPUTSTR=$(grep -w "$APP_NAME-*" /etc/service_name.txt)
		CMDSTATUS=$?
		if [ "$CMDSTATUS" -eq 0 ]; then
			OUTPUTSTR=$(grep -wv "^$APP_NAME-*" /etc/service_name.txt) > temp_service.tmp
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent Uninstalled Servie name $APP_NAME. $SCRIPT_LOG"
			echo $OUTPUTSTR > temp_service.tmp
			cat temp_service.tmp |  tr ' ' '\n' > /etc/service_name.txt
			rm -rf temp_service.tmp
		fi
	fi

	echo "APM Infrastructure Agent Uninstallation Completed."
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent Uninstallation Completed. $SCRIPT_LOG"
}

 stop_APMIA()
{
	eval "cd \"${APMIA_AGENT_BIN_PATH}\""
	if [ -f "IA_mode" ]; then
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			eval "cd \"$APMIA_HOME\""
			eval cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
			./CA-SystemEDGE status >/dev/null
			if ! [ $? -eq 0 ]; then
				echo "Host Monitoring Agent service is not running"
				eval "echo $timeAndDate [INFO] Host Monitoring Agent service is not running $SCRIPT_LOG"
			else
				echo "APM Infrastructure Agent stop in progress.."
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent stop in progress.. $SCRIPT_LOG"
				if [ -f "$SYSTEMD_SERVICE_SYS" ]; then
					systemctl stop "$CA_Sysedge"  > /dev/null 2>&1
				else
					eval "./CA-SystemEDGE stop $SCRIPT_LOG"
				fi
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent stop completed $SCRIPT_LOG"
				echo "APM Infrastructure Agent stop completed."
			fi
		fi
	else
		checkInstallDir
		if [ "$dir_HostMonitor" == "1" ]; then
			eval "cd \"$APMIA_HOME\""
			cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
			./CA-SystemEDGE status >/dev/null
			if ! [ $? -eq 0 ]; then
				echo "Host Monitoring Agent service is not running"
				eval "echo $timeAndDate [INFO] Host Monitoring Agent service is not running $SCRIPT_LOG"
			else
				echo "APM Infrastructure Agent stop in progress.."
				eval "echo $timeAndDate [INFO] APM Infrastructure Agent stop in progress.. $SCRIPT_LOG"
				if [ -f "$SYSTEMD_SERVICE_SYS" ]; then
					systemctl stop "$CA_Sysedge"  > /dev/null 2>&1
				else
					eval "./CA-SystemEDGE stop $SCRIPT_LOG"
				fi
			fi
		fi
		eval "cd \"$APMIA_AGENT_BIN_PATH\""
		eval "./APMIAgent.sh stop $SCRIPT_LOG"
		stopStatus=$?
		if [ $stopStatus == 9 ] ; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent is not running. $SCRIPT_LOG"
			echo "APM Infrastructure Agent is not running"
		elif [ ! $stopStatus == 0 ] ; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be stopped. $SCRIPT_LOG"
			echo "APM Infrastructure Agent could not be stopped, please check APMIA_install.log"
			RETRUNCODE=1
		fi

		eval "echo $timeAndDate [INFO] APM Infrastructure Agent stop completed $SCRIPT_LOG"
		echo "APM Infrastructure Agent stop completed."
	fi
	eval "cd \"$APMIA_HOME\""
}

fixupStartupScript()
{
	echo "Executing fixupStartupScript()">> APMIA_install.log
	STARTUP_FILE="$SYSEDGE_INSTALL_DIR/bin/$1"
	SYSEDGE_INSTALL_DIR_1="$SYSEDGE_INSTALL_DIR"
  eval sed -ie 's!%%CASE_G_INSTALLDIR%%!\"'"${SYSEDGE_INSTALL_DIR}"'\"!g' $SYSEDGE_INSTALL_DIR/bin/CA-SystemEDGE
  if [ "$?" -ne 0 ]
  then
      echo Update of startup script "CASE_G_INSTALLDIR" failed
      return 1
  fi

  eval sed -i 's!%%CASE_G_PUBDATADIR%%!\"'"${SYSEDGE_INSTALL_DIR}"/config'\"!g' $SYSEDGE_INSTALL_DIR/bin/CA-SystemEDGE
  if [ "$?" -ne 0 ]
  then
      echo Update of startup script "CASE_G_PUBDATADIR" failed
      return 1
  fi

  eval sed -i 's!%%CASE_SNMP_PORT%%!'"${SYSEDGE_PORT}"'!g' $SYSEDGE_INSTALL_DIR/bin/CA-SystemEDGE
   if [ "$?" -ne 0 ]
  then
      echo Update of startup script "CASE_SNMP_PORT" failed
      return 1
  fi

  # fixing profile.CA
  eval sed -i 's!%%CASE_G_INSTALLDIR%%!\"'"${SYSEDGE_INSTALL_DIR}"'\"!g' $SYSEDGE_INSTALL_DIR/bin/profile.CA
   if [ "$?" -ne 0 ]
  then
      echo Update of startup script "CASE_G_INSTALLDIR" failed
      return 1
  fi

  return 0
}

upgrade_sysedge(){
	rm -rf "${APMIA_SYSEDGE_ROOT_PATH}/CA_SystemEDGE_Core"
	tar -xf casystemedge*.tar.gz -C "${APMIA_SYSEDGE_ROOT_PATH}"
	SYSEDGE_INSTALL_DIR="$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE"
	mv "$SYSEDGE_INSTALL_DIR/config" "$SYSEDGE_INSTALL_DIR/config_bp"
	tar -xf "${APMIA_SYSEDGE_ROOT_PATH}/CA_SystemEDGE_Core/SystemEDGE.tar" -C "$APMIA_SYSEDGE_ROOT_PATH"
	rm -rf "$SYSEDGE_INSTALL_DIR/config"
	mv "$SYSEDGE_INSTALL_DIR/config_bp" "$SYSEDGE_INSTALL_DIR/config"
	temp="$(basename "$SYSEDGE_INSTALL_DIR"/config/port*)"
    SYSEDGE_PORT="${temp:4}"
	fixupStartupScript
	rm -rf "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE/bin/sysedgectl"
	ln -s "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE/bin/CA-SystemEDGE" "$APMIA_SYSEDGE_ROOT_PATH/SystemEDGE/bin/sysedgectl"
}

start_HostMonitor()
{
	checkInstallDir
	if [ "$dir_HostMonitor" == "1" ]; then
      eval "cd \"$APMIA_HOME\""
	  if [ -n "$RELEASE_DIR" ]; then
		upgrade_sysedge
	  fi
      cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
      echo "APM Infrastructure Agent start in progress.."
      eval "echo $timeAndDate [INFO] APM Infrastructure Agent start in progress.. $SCRIPT_LOG"
      if [ -f "$SYSTEMD_SERVICE_SYS" ]; then
		 systemctl set-environment CASYSEDGE=$APMIA_HOME/SystemEDGE
         systemctl start "$CA_Sysedge"  > /dev/null 2>&1
      else
	     eval export CASYSEDGE="${APMIA_HOME}/SystemEDGE"
         eval "./CA-SystemEDGE start $SCRIPT_LOG"
         eval "echo $timeAndDate [INFO] APM Infrastructure Agent start completed $SCRIPT_LOG"
      fi
	fi
}

restart_apmia_service()
{
  if [ -f "$SYSTEMD_SERVICE_FILE" ]; then
    eval "cd \"${APMIA_AGENT_BIN_PATH}\""
    check_hostmonitor_mode
    if [ "$install_hostmonitor" == "0" ]; then
      start_HostMonitor
    fi
    update_java_heap
    eval "systemctl restart ${APP_NAME}.service $SCRIPT_LOG"
    restartStatus=$?
    if [ $restartStatus == 9 ] ; then
      eval "echo $timeAndDate [INFO] APM Infrastructure Agent is not restarted. $SCRIPT_LOG"
      echo "APM Infrastructure Agent is not restarted"
    elif [ ! $restartStatus == 0 ] ; then
      eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be restarted. $SCRIPT_LOG"
      echo "APM Infrastructure Agent could not be restarted, please check APMIA_install.log"
      RETRUNCODE=1
    fi
    eval "echo $timeAndDate [INFO] APM Infrastructure Agent restarted completed $SCRIPT_LOG"
    echo "APM Infrastructure Agent restarted completed."
    eval "cd \"$APMIA_HOME\""
  else
    echo "Manual restart of the APM Infrastructure Agent is required. The Agent Controller is currently running within the same Agent instance."
    eval "echo $timeAndDate [INFO] Manual restart of the APM Infrastructure Agent is required. The Agent Controller is currently running within the same Agent instance. $SCRIPT_LOG"
  fi
}

 start_APMIA()
{
	eval "cd \"${APMIA_AGENT_BIN_PATH}\""
	if [ -f "IA_mode" ]; then
		start_HostMonitor
	else
		check_hostmonitor_mode
		if [ "$install_hostmonitor" == "0" ]; then
			start_HostMonitor
		fi
		#set_IntroscopeAgentprofile
		update_java_heap
		eval "cd \"$APMIA_AGENT_BIN_PATH\""
		eval "./APMIAgent.sh start $SCRIPT_LOG"
		startStatus=$?
		if [ $startStatus == 9 ] ; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent is already running. $SCRIPT_LOG"
			echo "APM Infrastructure Agent is already running"
		elif [ ! $startStatus == 0 ] ; then
			eval "echo $timeAndDate [INFO] APM Infrastructure Agent could not be started. $SCRIPT_LOG"
			echo "APM Infrastructure Agent could not be started, please check APMIA_install.log"
			RETRUNCODE=1
		fi
	fi
	eval "echo $timeAndDate [INFO] APM Infrastructure Agent start completed $SCRIPT_LOG"
	echo "APM Infrastructure Agent start completed."
	eval "cd \"$APMIA_HOME\""
}

 status_APMIA()
{
	eval "cd \"$APMIA_AGENT_BIN_PATH\""

	checkinstalled
	if [ "$isinstall" == "1" ]; then
		eval "echo $timeAndDate [ERROR] APM Infrastructure Agent installed on $REALPATH $SCRIPT_LOG"
	fi

	eval "./APMIAgent.sh status $APMIAgent_LOG"
	CMDSTATUS=$?
	if [ ! "$CMDSTATUS" -eq 0 ]; then
		eval "echo $timeAndDate [ERROR] APM Infrastructure Agent status could not shown ${APMIA_HOME}/$SCRIPT_LOG"
		echo "APM Infrastructure Agent status could not shown, please check ${APMIA_HOME}/APMIA_install.log"
		EXIT 1
	fi

	checkInstallDir
	if [ "$dir_HostMonitor" == "1" ]; then
		eval "cd \"$APMIA_HOME\""
		cd "${APMIA_SYSEDGE_ROOT_PATH}/SystemEDGE/bin"
		./CA-SystemEDGE status
		eval "echo $timeAndDate [INFO] $(./CA-SystemEDGE status) $SCRIPT_LOG"
	fi
	eval "cd \"$APMIA_HOME\""
}

####################Main starts here################
#lets log the Basic information about the system first
logMyAPMIA

eval "cd \"$APMIA_HOME\""

#lets start the execution based on the command arguments
case "$arg_1" in
	'install')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered install $SCRIPT_LOG"
		install_main
	;;
	'uninstall')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered uninstall $SCRIPT_LOG"
		uninstall_main
	;;
	'clean_uninstall')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered clean_uninstall $SCRIPT_LOG"
		uninstall_main
		if [ "$clean_del" == 1 ]; then
			rm -rf * 
			EXIT 0
		else
			echo "Could not remove file/folders of APM IA"
			eval "echo $timeAndDate [INFO] Could not remove file/folders of APM IA $SCRIPT_LOG"
		fi
	;;
	'console_start')
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered console_start $SCRIPT_LOG"
		console_start_sys=1
		console_start_APMIA
	;;
	'console_stop')
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered console_stop $SCRIPT_LOG"
		#console_start_sys=1
		console_stop_APMIA
	;;
	'start')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered start $SCRIPT_LOG"
		checkinstalled
		if [ "$isinstall" == 1 ]; then
			start_APMIA
		else
			installerrmsg
		fi
	;;
	'restart_service')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered restart_via_acc $SCRIPT_LOG"
		checkinstalled
		if [ "$isinstall" == 1 ]; then
			restart_apmia_service
		else
			installerrmsg
		fi
	;;
	'stop')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered stop $SCRIPT_LOG"
		checkinstalled
		if [ "$isinstall" == 1 ]; then
			stop_APMIA
		else
			installerrmsg
		fi
	;;
	'restart')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered restart $SCRIPT_LOG"
		checkinstalled
		if [ "$isinstall" == 1 ]; then
			stop_APMIA
			sleep 5
			start_APMIA
		else
			installerrmsg
		fi
				
	;;
	'detail_status')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered detail_status $SCRIPT_LOG"
		summary
	;;
	'clean_up')
		checkroot
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered clean_up $SCRIPT_LOG"
		erase
	;;
	'status')
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered status $SCRIPT_LOG"
		status_APMIA
	;;
	'-help')
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered help $SCRIPT_LOG"
		echo "User Need Help"	
		displayhelp
		EXIT 0
	;;
	'console')
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered no args $SCRIPT_LOG"
		console_start_sys=1
		LOGCONSOLE=1
		console_start_APMIA
	;;
	*)
		eval "echo $timeAndDate [INFO] APM Infrastructure Agent user entered default $SCRIPT_LOG"
		echo "User Need Help"	
		displayhelp
		EXIT 0
	;;
esac
	
EXIT $RETRUNCODE
