/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.arf.ArfException;
import com.wily.introscope.agent.arf.internal.ArfParser;
import com.wily.introscope.agent.arf.internal.ArfWriter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class ArfMap {
    private static final long serialVersionUID = 2177971717756813484L;
    private Map fMap = new LinkedHashMap();
    static ArfParser sParser = new ArfParser();
    static ArfWriter sWriter = new ArfWriter();

    public static ArfMap parseObject(String msg) throws ArfException {
        ArfMap m = new ArfMap();
        sParser.parseMap(m.fMap, msg);
        return m;
    }

    public String writeObject() {
        return sWriter.writeMap(this.fMap);
    }

    public String toString() {
        return this.writeObject();
    }

    public String getString(String key) {
        Object result = this.fMap.get(key);
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        return (Boolean)this.fMap.get(key);
    }

    public Integer getInteger(String key) {
        return ((Number)this.fMap.get(key)).intValue();
    }

    public Long getLong(String key) {
        return (Long)this.fMap.get(key);
    }

    public ArfMap getObject(String key) {
        return (ArfMap)this.fMap.get(key);
    }

    public Object get(String key) {
        return this.fMap.get(key);
    }

    public void putString(String key, String value) {
        this.fMap.put(key, value);
    }

    public void putBoolean(String key, Boolean value) {
        this.fMap.put(key, value);
    }

    public void putInteger(String key, int value) {
        this.fMap.put(key, value);
    }

    public void putLong(String key, long value) {
        this.fMap.put(key, value);
    }

    public void putObject(String key, ArfMap value) {
        this.fMap.put(key, value);
    }

    public Iterator iterator_keys() {
        return this.fMap.keySet().iterator();
    }

    public Iterator iterator_values() {
        return this.fMap.values().iterator();
    }

    public int getSize() {
        return this.fMap.size();
    }
}

