/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.ArfLibTypeSetter;
import com.wily.introscope.agent.arf.ArfMessageLibType;
import com.wily.introscope.agent.arf.TCPArfTransport;
import com.wily.introscope.agent.collector.CollectorAgentCommandLine;
import com.wily.introscope.agent.collector.CollectorAgentWarmUp;
import com.wily.introscope.agent.collector.JsonParserCommandLineOption;
import com.wily.introscope.agent.collector.ProbeManager;
import com.wily.introscope.agent.runtime.java.enterprise.Java15AgentInitializationCallBackFactory;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.agent.sustainability.ISustainabilityMetricsCallback;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.util.AgentCommandLine;
import com.wily.introscope.etc.AIntroscopeInstalledApplication;
import com.wily.introscope.install.IntroscopeInstallation;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CollectorAgent {
    private static CollectorAgent sSelf = null;
    static final Module kModule = new Module("CollectorAgent");
    private static final String kUnknown = "unknown";
    private IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private IVersion fVersion;
    private CollectorAgentCommandLine fCommandLine;
    private JsonParserCommandLineOption fJsonParserOption;
    private AIntroscopeInstalledApplication fApplication;
    private static final long kMaxInitTime = 15000L;
    private IAgent fAgent;
    private ProbeManager fProbeManager;
    private static boolean bSustainabilityMetricsEnabled = true;
    private static final int kMetricPollingPeriod = 7500;
    private static final String sFileSeparator = System.getProperty("file.separator");

    public CollectorAgent(AgentCommandLine cmdline) throws IOException {
        sSelf = this;
        this.fLocalizer = new MultipleResourceBundleStringLocalizer(this.fFeedback, CollectorAgent.class.getClassLoader(), new String[]{"com.wily.introscope.agent.remote.properties.CollectorAgentReleaseStrings", "com.wily.introscope.agent.remote.properties.CollectorAgentStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.properties.CoreCommonStrings"});
        this.fJsonParserOption = new JsonParserCommandLineOption();
        cmdline.addParser(this.fJsonParserOption);
    }

    @Deprecated
    private CollectorAgent(String[] args) throws IOException {
        sSelf = this;
        try {
            Java2PostConstructionInitializationHelper.initialize(Java15AgentInitializationCallBackFactory.createObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApplicationFeedback appFeedback = new ApplicationFeedback("CollectorAgent", false);
        this.fFeedback = appFeedback;
        this.fLocalizer = new MultipleResourceBundleStringLocalizer(this.fFeedback, CollectorAgent.class.getClassLoader(), new String[]{"com.wily.introscope.agent.remote.properties.CollectorAgentReleaseStrings", "com.wily.introscope.agent.remote.properties.CollectorAgentStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.properties.CoreCommonStrings"});
        this.fVersion = new IntroscopeVersion(this.fLocalizer);
        this.fCommandLine = new CollectorAgentCommandLine(args, this.fLocalizer);
        this.fJsonParserOption = this.fCommandLine.getJsonParserOption();
        this.fApplication = new CollectorAgentIntrocopeInstalledApplication(appFeedback, this.fLocalizer, this.fVersion, this.fCommandLine.getInstallBase());
    }

    public boolean start(IAgent agent) throws IOException, AgentNotAvailableException {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fAgent = agent;
        String port = this.fAgent.IAgent_getIndexedProperties().getProperty("introscope.remoteagent.collector.tcp.port");
        boolean localOnly = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.remoteagent.collector.tcp.local.only", false);
        int collectorTCPPort = 0;
        if (!localOnly) {
            CollectorAgent.GetFeedback().info(kModule, "Probe connections from remote hosts have been enabled.");
        }
        ArfLibTypeSetter.type = this.fJsonParserOption.shouldUseInternalJsonParser() ? ArfMessageLibType.INTERNAL : ArfMessageLibType.GSON;
        this.fFeedback.info(kModule, "ARF Communication Parser-Writer in current use : " + ArfLibTypeSetter.type.toString() + " module");
        CollectorAgentWarmUp.getInstance().agentWarmUp(this.fAgent);
        if (null == port || port.isEmpty()) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("failed_to_start_1P", "introscope.remoteagent.collector.tcp.port is null or empty ");
            CollectorAgent.GetFeedback().warn(kModule, s);
            return false;
        }
        try {
            collectorTCPPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("failed_to_start_1P", "introscope.remoteagent.collector.tcp.port is not a valid port number. ");
            this.fFeedback.error(kModule, s);
            return false;
        }
        TCPArfTransport transport = new TCPArfTransport(this.fAgent, collectorTCPPort, localOnly);
        if (!transport.initServer()) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("failed_to_start_1P", "ARF Server Initialization failed.");
            this.fFeedback.error(kModule, s);
            return false;
        }
        this.fProbeManager = new ProbeManager(this.fAgent, localOnly);
        this.startMetricsReporting();
        transport.startServer(this.fProbeManager, null);
        String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Collector_Startup_Succeeded_Message", "CollectorAgent");
        CollectorAgent.GetFeedback().info(kModule, s);
        return true;
    }

    private void startMetricsReporting() {
        SustainabilityService.addSustainabilityMetricCallback(new ISustainabilityMetricsCallback(){

            @Override
            public void sustainabilityMetricsEnabled() {
                bSustainabilityMetricsEnabled = true;
            }

            @Override
            public void sustainabilityMetricsDisabled() {
                bSustainabilityMetricsEnabled = false;
            }

            @Override
            public void sustainabilityMetricInterval(long nowInMillis) {
                CollectorAgent.this.fProbeManager.getProbeCollectorMetrics();
            }
        });
    }

    public static CollectorAgent GetInstance() {
        return sSelf;
    }

    static IModuleFeedbackChannel GetFeedback() {
        return CollectorAgent.GetInstance().getFeedback();
    }

    static IStringLocalizer GetLocalizer() {
        return CollectorAgent.GetInstance().getLocalizer();
    }

    IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    private String getAgentBuildAndReleaseVersion() {
        String agentBuildAndReleaseVersion = "Release " + this.fVersion.IVersion_getReleaseString() + " ( " + this.fVersion.IVersion_getBuildNumberString() + " ) ";
        return agentBuildAndReleaseVersion;
    }

    private String getCollectorAgentPid() {
        int atSymbol;
        String cAgentProcessID = System.getProperty("sun.java.launcher.pid");
        if (cAgentProcessID != null && (atSymbol = cAgentProcessID.indexOf("@")) > 0) {
            return cAgentProcessID.substring(0, atSymbol);
        }
        return kUnknown;
    }

    @Deprecated
    private File getPrefsFile(IntroscopeInstallation install) throws FileNotFoundException {
        File prefsFile;
        String prefsFileName = System.getProperty("com.wily.fieldeng.collector.profile");
        if (prefsFileName == null) {
            prefsFileName = System.getProperty("com.wily.introscope.collector.profile");
        }
        if (prefsFileName == null) {
            prefsFile = new File(install.getInstallationSubDirectoryPath(0) + sFileSeparator + "core" + sFileSeparator + "config", "IntroscopeCollectorAgent.profile");
            if (!prefsFile.exists()) {
                if (this.fFeedback.isVerboseEnabled()) {
                    this.fFeedback.verbose("CollecotrAgent cannot find " + prefsFile.getPath() + ", will now try CollectorAgent root directory");
                }
                prefsFile = new File("IntroscopeCollectorAgent.profile");
            }
        } else {
            String dir = new File(prefsFileName).getParent();
            prefsFile = dir == null ? new File(install.getInstallationSubDirectoryPath(6), prefsFileName) : new File(prefsFileName);
        }
        if (!prefsFile.exists()) {
            String message = CollectorAgent.GetLocalizer().IStringLocalizer_getFormattedLocalizedString("Collector_Config_File_Err_File_Not_Found", prefsFile.getPath());
            throw new FileNotFoundException(message);
        }
        if (this.fFeedback.isVerboseEnabled()) {
            try {
                this.fFeedback.verbose("CollectorAgent using preferences file " + prefsFile.getCanonicalPath());
            }
            catch (IOException e) {
                this.fFeedback.verbose(e);
            }
        }
        return prefsFile;
    }

    private static class CollectorAgentIntrocopeInstalledApplication
    extends AIntroscopeInstalledApplication {
        CollectorAgentIntrocopeInstalledApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String installationBase) throws IOException {
            super(feedback, localizer, version, localizer.IStringLocalizer_getLocalizedString("Collector_Long_Name"), localizer.IStringLocalizer_getLocalizedString("Collector_Short_Name"), installationBase);
        }

        @Override
        protected void doStart() throws Exception {
        }

        @Override
        protected void doStop() throws Exception {
        }
    }
}

