/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wily.EDU.oswego.cs.dl.util.concurrent.CopyOnWriteArraySet;
import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.AArfConnection;
import com.wily.introscope.agent.arf.ArfAppException;
import com.wily.introscope.agent.arf.ArfCommandConnection;
import com.wily.introscope.agent.arf.ArfDataConnection;
import com.wily.introscope.agent.arf.ArfException;
import com.wily.introscope.agent.arf.ArfMap;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.arf.ArfMessageFactory;
import com.wily.introscope.agent.arf.ArfMessageStatus;
import com.wily.introscope.agent.arf.IArfMessageListener;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.collector.ProbeManager;
import com.wily.introscope.agent.collector.RemoteTracerWrapper;
import com.wily.introscope.agent.collector.http.WrapperHttpServletRequest;
import com.wily.introscope.agent.collector.http.WrapperHttpServletResponse;
import com.wily.introscope.agent.collector.http.WrapperHttpSession;
import com.wily.introscope.agent.collector.http.WrapperHttpURLConnection;
import com.wily.introscope.agent.collector.http.WrapperServlet;
import com.wily.introscope.agent.collector.http.WrapperServletConfig;
import com.wily.introscope.agent.collector.http.WrapperServletContext;
import com.wily.introscope.agent.collector.sql.WrapperDatabaseMetadata;
import com.wily.introscope.agent.collector.sql.WrapperSqlConnection;
import com.wily.introscope.agent.collector.sql.WrapperSqlStatement;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.remote.RemoteModeledMethod;
import com.wily.introscope.agent.service.ProbeAttributeDecorationService;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongMonotonicallyIncreasingCounterDataAccumulator;
import com.wily.introscope.agent.stat.IStringEveryEventDataAccumulator;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationMethodTracer;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IParameterizedMethodTracer;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.TracerEncoding;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transformer.dynamic.ITracerProviderService;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.util.HashCodeUtils;
import com.wily.util.StringUtils;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.CanonicalObjectPool;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.net.MalformedURLException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ProbeCollector
implements IArfMessageListener {
    protected final IAgent fAgent;
    protected final IModuleFeedbackChannel fFeedback;
    protected static final Module kModule = new Module("ProbeCollector");
    protected final ITracerProviderService fTracerProvider;
    protected final ComponentTracer fComponentTracer;
    protected final ProbeManager fManager;
    protected final DataAccumulatorFactory kDataAccuFactory;
    private final Map<String, RemoteTracerWrapper> fSequenceIdMap;
    private String fInstId = null;
    private String fProbe = null;
    private String fProgram = null;
    private String fPid = null;
    private String fTid = null;
    private String fHost = null;
    private String fApp = null;
    private String fContainerId = null;
    protected String fContainerName = null;
    protected String fPodName = null;
    protected String fPodNamespace = null;
    protected String fPodIpAddress = null;
    protected String fRoute = null;
    private static final long kPingInterval = 5000L;
    private static final long kMaxMissedPingIntervals = 12L;
    private long fLastPingSent = 0L;
    private ArfCommandConnection fCommandConn;
    private boolean fIsClosed = false;
    private Set fDataConnSet;
    private boolean fIsProbeFilteringEnabled = false;
    private String fLastProbelFilteringCommandSent = null;
    private boolean fIsProbeMappingEnabled = false;
    private String fLastProbeMappingCommandSent = null;
    private String fDeepTracerEncodingPattern = null;
    private static final int kLongDurationSetDirect = 1058;
    private static final String kDeepTracerEncodingPatternUnformatted = ",DeepTracer,name=na&probe=%s";
    private static final String kDeepTracerEncodingPlaceHolder = "DeepTT";
    private static final String kContainerIdParamKey = "TTPlugin.globalAttribute.containerId";
    private static final String kContainerNameParamKey = "TTPlugin.globalAttribute.k8s_pod_container_name";
    private static final String kPodNameParamKey = "TTPlugin.globalAttribute.k8s_pod_name";
    private static final String kPodNamespaceParamKey = "TTPlugin.globalAttribute.k8s_project";
    private static final String kPodIpAddressParamKey = "TTPlugin.globalAttribute.k8s_pod_podIP";
    private ProbeAttributeDecorationService probeAttributeDecorationService = ProbeAttributeDecorationService.instance();
    public static final String kProgramNamePlaceHolder = "{program}";
    public static final String kProbeTypePlaceHolder = "{type}";
    public static final String kProbeAppNamePlaceHolder = "{application}";
    public static final String kCollectorNamePlaceHolder = "{collector}";

    public ProbeCollector(IAgent agent, ProbeManager manager) {
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fTracerProvider = this.fAgent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getTracerProviderService();
        this.fComponentTracer = this.fAgent.IAgent_getComponentTracer();
        this.fManager = manager;
        this.kDataAccuFactory = agent.IAgent_getDataAccumulatorFactory();
        this.fSequenceIdMap = new ConcurrentHashMap<String, RemoteTracerWrapper>();
        this.fCommandConn = null;
        this.fDataConnSet = new CopyOnWriteArraySet();
        this.fIsProbeFilteringEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.remoteagent.collector.probeid.filtering.enabled", false);
        this.fIsProbeMappingEnabled = this.fAgent.IAgent_getIndexedProperties().getBooleanProperty("introscope.remoteagent.collector.probeid.mapping.enabled", false);
        InvocationData.getCacheHelper().setUseExternalThreadId();
    }

    public static int calculateProbeHashCode(String probeClassName, String probeMethodName, String probeMethodDescriptor, String tracerEncoding) {
        int result = 17;
        result = HashCodeUtils.accumulateHashCode(result, probeClassName.hashCode());
        result = HashCodeUtils.accumulateHashCode(result, probeMethodName.hashCode());
        result = HashCodeUtils.accumulateHashCode(result, probeMethodDescriptor.hashCode());
        result = HashCodeUtils.accumulateHashCode(result, tracerEncoding.hashCode());
        return result;
    }

    protected abstract String getDefaultAppName();

    protected abstract void processMethod(RemoteTracerWrapper var1, ArfMessage var2);

    protected abstract Throwable processException(ArfAppException var1);

    protected String getCorrelationId(RemoteTracerWrapper info, ArfMessage m) {
        if ("http".equals(info.fProbeClassName) && m.isParamsSet()) {
            String txTrcId;
            info.fTrxTraceId = txTrcId = m.getParams().getString("traceId");
            String corId = m.getParams().getString("corId");
            if (corId != null) {
                return corId;
            }
        }
        return null;
    }

    protected RemoteTracerWrapper checkForSpecialTracers(RemoteTracerWrapper wrapper, ArfMap params, String tid) {
        if (wrapper.fTracerEncoding.contains("com.wily.introscope.agent.sqlagent.StatementNameFormatter") || wrapper.fTracerEncoding.contains("com.wily.introscope.agent.sqlagent.ProbeStatementToSQLMappingTracer")) {
            String url = params.getString("url");
            String database = url != null && url.startsWith("jdbc") ? url : "jdbc:" + url;
            String query = params.getString("query");
            WrapperDatabaseMetadata dbm = new WrapperDatabaseMetadata(database, wrapper);
            WrapperSqlConnection c = new WrapperSqlConnection(database, dbm, wrapper);
            WrapperSqlStatement s = null;
            try {
                s = (WrapperSqlStatement)c.createStatement();
                c.close();
            }
            catch (SQLException e) {
                return wrapper;
            }
            s.fProbeMethodDescriptor = "(Ljava/lang/String;)Ljava/sql/ResultSet;";
            s.fNumArgs = 1;
            s.fArgs = new Object[]{query};
            return s;
        }
        if (wrapper.fTracerEncoding.contains("com.wily.introscope.agent.sqlagent.ProbeStatementNameFormatter")) {
            String statementId = params.getString("stmtid");
            if (statementId != null) {
                wrapper.fProbeMethodDescriptor = "(Ljava/lang/String;)V;";
                wrapper.fNumArgs = 1;
                wrapper.fArgs = new Object[]{statementId + tid};
            }
            return wrapper;
        }
        if (wrapper.fTracerEncoding.contains("com.wily.introscope.agent.trace.hc2.HttpServletTracer") || wrapper.fTracerEncoding.contains("HttpServletTracerWithAgentRouteProperties")) {
            String url = params.getString("url");
            String hostName = params.getString("hostName");
            int hostPort = 80;
            String hostPortStr = params.getString("hostPort");
            try {
                hostPort = Integer.parseInt(hostPortStr);
            }
            catch (NumberFormatException ex) {
                this.fFeedback.debug(kModule, "Failed to parse number string for hostPort; default hostPort value to 80.", ex);
                hostPort = 80;
            }
            String method = params.getString("httpMethod");
            String application = ProbeCollector.getParametersString(params.getString("attributes")).get("application");
            if (method == null) {
                method = wrapper.fProbeMethodName;
            }
            String app = null;
            app = application != null ? application : (this.fApp != null ? this.fApp : (wrapper.fProgramName != null ? wrapper.fProgramName : this.getDefaultAppName()));
            HashMap<String, String> headersMap = null;
            ArfMap headers = params.getObject("hdrs");
            if (headers != null && headers.getSize() > 0) {
                Iterator it = headers.iterator_keys();
                headersMap = new HashMap<String, String>();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = headers.getString(key);
                    if (value == null) continue;
                    headersMap.put(key, headers.getString(key));
                }
            }
            WrapperServletContext context = new WrapperServletContext(app);
            WrapperServletConfig config = new WrapperServletConfig(context);
            WrapperHttpSession session = new WrapperHttpSession(context);
            WrapperHttpServletRequest request = new WrapperHttpServletRequest(session, method, url, hostName, hostPort, headersMap);
            WrapperHttpServletResponse res = new WrapperHttpServletResponse();
            WrapperServlet s = new WrapperServlet(config, wrapper);
            s.fProbeMethodDescriptor = "(LRequest;LResponse;)V";
            s.fNumArgs = 2;
            s.fArgs = new Object[]{request, res};
            return s;
        }
        if (wrapper.fTracerEncoding.contains("com.wily.introscope.agent.trace.backend.http.tracer") && (wrapper.fTracerEncoding.contains("HttpURLConnectionBackendTracer") || wrapper.fTracerEncoding.contains("HttpURLConnectionBlamePointTracer") || wrapper.fTracerEncoding.contains("HttpClientMethodThrewErrorReportingTracer"))) {
            String url = params.getString("url");
            String method = params.getString("method");
            WrapperHttpURLConnection conn = null;
            try {
                conn = new WrapperHttpURLConnection(url, method);
                wrapper.setTracedObject(conn);
                wrapper.fProbeMethodDescriptor = "()V";
            }
            catch (MalformedURLException e) {
                this.fFeedback.error(kModule, "could not create wrapper for HttpURLConnection", e);
            }
            return wrapper;
        }
        return wrapper;
    }

    protected void UpdatesForSpecialTracers(String tid, RemoteTracerWrapper wrapper, ArfMap params) {
        if (wrapper.fTracerEncoding.contains("com.wily.introscope.agent.sqlagent.ProbeStatementToSQLMappingTracer")) {
            String statementId;
            WrapperSqlStatement s = (WrapperSqlStatement)wrapper;
            if (params != null && (statementId = params.getString("stmtid")) != null) {
                try {
                    int id = Integer.parseInt(statementId);
                    s.setStatementId(id);
                    wrapper.setReturnValueObject((IParameterizedMethodTracer)wrapper.fTracer, statementId + tid);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    protected RemoteTracerWrapper updateTracedObjectOnFinishTraceEvent(RemoteTracerWrapper wrapper, ArfMessage message) {
        if (wrapper.getTracedObject() instanceof WrapperHttpURLConnection) {
            WrapperHttpURLConnection urlConn = (WrapperHttpURLConnection)wrapper.getTracedObject();
            ArfMap map = message.getParams();
            if (map != null) {
                String resMsg;
                Integer resCode = map.getInteger("resCode");
                if (resCode != null) {
                    urlConn.setResponseCode(resCode);
                }
                if ((resMsg = map.getString("resMsg")) != null) {
                    urlConn.setResponseMessage(resMsg);
                }
            }
        }
        return wrapper;
    }

    protected void addEventParamsToSharedStorage(IMethodTracer tracer, ArfMap params) {
        if (params != null && tracer instanceof InvocationData) {
            InvocationData data = (InvocationData)tracer;
            Iterator keysIter = params.iterator_keys();
            while (keysIter.hasNext()) {
                String key = (String)keysIter.next();
                data.put(key, params.get(key));
            }
            this.addBridgeParameterIfNotPresent(data);
            this.setInvocationDataParameterCallback(data);
        }
    }

    private void setInvocationDataParameterCallback(InvocationData data) {
        boolean shouldCheck;
        final String containerId = this.fContainerId;
        final String podIpAddress = this.fPodIpAddress;
        final String podName = this.fPodName;
        final String podNamespace = this.fPodNamespace;
        final String containerName = this.fContainerName;
        boolean bl = shouldCheck = containerId != null && !containerId.isEmpty() || podName != null && !podName.isEmpty();
        if (shouldCheck) {
            data.setParameterCallback(new IInvocationDataParameterCallback(){

                @Override
                public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
                    if (containerId != null && !containerId.isEmpty()) {
                        parameters.put(ProbeCollector.kContainerIdParamKey, containerId);
                    }
                    if (containerName != null && !containerName.isEmpty()) {
                        parameters.put(ProbeCollector.kContainerNameParamKey, containerName);
                    }
                    if (podNamespace != null && !podNamespace.isEmpty()) {
                        parameters.put(ProbeCollector.kPodNamespaceParamKey, podNamespace);
                    }
                    if (podName != null && !podName.isEmpty()) {
                        parameters.put(ProbeCollector.kPodNameParamKey, podName);
                    }
                    if (podIpAddress != null && !podIpAddress.isEmpty()) {
                        parameters.put(ProbeCollector.kPodIpAddressParamKey, podIpAddress);
                    }
                }
            });
        }
    }

    protected void addBridgeParameterIfNotPresent(InvocationData data) {
        String bridgeRoute = (String)data.get("!BRIDGE!");
        if (bridgeRoute == null || bridgeRoute.isEmpty()) {
            data.put("!BRIDGE!", this.fRoute);
        }
    }

    @Override
    public ArfMessageStatus processMessage(AArfConnection conn, ArfMessage m) {
        if (conn instanceof ArfDataConnection) {
            try {
                return this.processDataMessage(conn, m);
            }
            catch (Exception e) {
                this.fFeedback.error(kModule, conn.toString() + " message parsing excpetion: " + e.getMessage());
                this.fFeedback.debug(kModule, "ARF exception", e);
                ArfMessageStatus messageStatus = new ArfMessageStatus(0, m.getOp());
                messageStatus.setErrorMessage(e.getMessage());
                return messageStatus;
            }
        }
        if (conn instanceof ArfCommandConnection) {
            return this.processCommandMessage(this.fAgent, conn, m);
        }
        if (this.fFeedback.isTraceEnabled(kModule)) {
            this.fFeedback.trace(kModule, conn.toString() + " Rx: " + m);
        }
        return ArfMessageStatus.MSG_FAILED;
    }

    protected ArfMessageStatus processCommandMessage(IAgent fAgent, AArfConnection conn, ArfMessage m) {
        this.probeAttributeDecorationService.processProbeAttributes(fAgent, conn, m);
        return ArfMessageStatus.MSG_SUCCESS;
    }

    private void logArfMsg(AArfConnection conn, ArfMessage m) {
        ArfMap arfMap = m.getParams();
        if (m.getOp().equals("fnC") && arfMap != null && arfMap.get("query") != null) {
            String maskedMsg = m.toString().replace((String)arfMap.get("query"), "**********");
            this.fFeedback.trace(kModule, conn.toString() + " Rx: " + maskedMsg);
        } else {
            this.fFeedback.trace(kModule, conn.toString() + " Rx: " + m);
        }
    }

    private ArfMessageStatus processDataMessage(AArfConnection conn, ArfMessage m) throws Exception {
        String pid = conn.getPid();
        String host = this.getHost();
        String ltid = null;
        ltid = m.isTidSet() ? m.getTid() : conn.getTid();
        if (this.fFeedback.isTraceEnabled(kModule) && !m.getOp().equals("m")) {
            this.logArfMsg(conn, m);
        }
        ArfMessageStatus messageStatus = ArfMessageStatus.MSG_SUCCESS;
        String tid = ltid + "@" + host + ":" + pid;
        if (m.getOp().equals("fnC")) {
            messageStatus = this.processFunctionStartMessage(conn, m, tid);
        } else if (m.getOp().equals("fnR")) {
            messageStatus = this.processFunctionReturnMessage(conn, m, tid);
        } else if (m.getOp().equals("m")) {
            messageStatus = this.processPassThruMetricMessage(conn, m, tid);
        } else if (m.getOp().equals("require")) {
            messageStatus = new ArfMessageStatus(1);
            messageStatus.setOperation(m.getOp());
            this.fFeedback.debug("Require module message:" + m.getMod());
            ArfMap methods = m.getParams();
            int methodCount = methods.getSize();
            ArfMessage msg = ArfMessageFactory.getWriterInstance("config");
            msg.setCmd("require");
            msg.setMod(m.getMod());
            msg.setParams(methods);
            boolean hasInstrumentation = false;
            for (int i = 0; i < methodCount; ++i) {
                RemoteTracerWrapper rtw = new RemoteTracerWrapper();
                String indexStr = Integer.toString(i);
                String classMethod = methods.getString(indexStr);
                String[] parts = classMethod.split("#");
                rtw.fProbeClassName = parts[0];
                rtw.fProbeMethodName = parts[1];
                if (this.shouldInstrument(rtw)) {
                    hasInstrumentation = true;
                    continue;
                }
                methods.putString(indexStr, "skip_instrument");
            }
            if (hasInstrumentation) {
                String response = msg.writeMessage();
                messageStatus.setResponse(response);
                this.fCommandConn.send(response);
            }
        } else {
            this.fFeedback.error(kModule, "Received unknown event " + m.getOp() + "from probe" + conn.getProbe());
            messageStatus = ArfMessageStatus.MSG_FAILED;
        }
        return messageStatus;
    }

    private ArfMessageStatus processFunctionStartMessage(AArfConnection conn, ArfMessage m, String tid) {
        long startTime = m.getTs();
        ArfMessageStatus messageStatus = ArfMessageStatus.MSG_SUCCESS;
        RemoteTracerWrapper wrapper = new RemoteTracerWrapper();
        Long seq = m.getSeq();
        String seqId = tid + ";" + seq;
        if (m.isFnidSet()) {
            if (!this.getInstrumentationInfo(m.getFnid(), wrapper)) {
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, conn.toString() + ", received unknown function id.");
                }
                return ArfMessageStatus.MSG_FAILED;
            }
        } else {
            wrapper.fFunctionName = m.getFn();
            wrapper.fConn = conn;
            this.processMethod(wrapper, m);
            if (wrapper.fProbeClassName != null) {
                wrapper.fProbeClassName = CanonicalObjectPool.getCanonicalString(wrapper.fProbeClassName);
            }
            if (wrapper.fProbeMethodName != null) {
                wrapper.fProbeMethodName = CanonicalObjectPool.getCanonicalString(wrapper.fProbeMethodName);
            }
            if (wrapper.fProbeMethodDescriptor != null) {
                wrapper.fProbeMethodDescriptor = CanonicalObjectPool.getCanonicalString(wrapper.fProbeMethodDescriptor);
            }
            wrapper.fTracerEncoding = this.getTracerEncoding(wrapper);
        }
        int probeHashCode = ProbeCollector.calculateProbeHashCode(wrapper.fProbeClassName, wrapper.fProbeMethodName, wrapper.fProbeMethodDescriptor, wrapper.fTracerEncoding);
        wrapper.fClockDelegate = new RemoteWallClockDelegate(startTime);
        if (wrapper.fTracerEncoding != null && wrapper.fTracerEncoding.length() > 0) {
            Object cache;
            InvocationData.getCacheHelper().setExternalThreadId(tid, conn, true);
            wrapper.fCorrId = this.getCorrelationId(wrapper, m);
            if (wrapper.fTrxTraceId != null) {
                cache = this.fComponentTracer.getCrossProcessDataCache();
                ((SharedCrossProcessData)cache).addParamOut("TxnTraceId", wrapper.fTrxTraceId);
            }
            if (wrapper.fCorrId != null) {
                cache = new CorrelationId(wrapper.fCorrId, true);
            }
            wrapper = this.checkForSpecialTracers(wrapper, m.getParams(), tid);
            IMethodTracer tracer = null;
            if (wrapper.fTracerEncoding.equals(kDeepTracerEncodingPlaceHolder) && this.fManager.getSIService() != null) {
                tracer = this.fManager.getSIService().getIntelligentInstrumentationTracerForIntelligentShim(wrapper.fFunctionId, wrapper.fClockDelegate);
            } else {
                tracer = this.fAgent.IAgent_loadParameterizedTracer(probeHashCode, wrapper.fProbeClassName, wrapper.fProbeMethodName, wrapper.fProbeMethodDescriptor, wrapper.getTracedObject(), wrapper.fTracerEncoding, wrapper.fClockDelegate);
                wrapper.setTracerParameters((IParameterizedMethodTracer)tracer);
                this.addEventParamsToSharedStorage(tracer, m.getParams());
                tracer.IMethodTracer_startTrace();
            }
            wrapper.fTracer = tracer;
            messageStatus = ArfMessageStatus.MSG_SUCCESS;
        } else {
            wrapper.fTracer = null;
            messageStatus = ArfMessageStatus.MSG_FAILED;
        }
        this.fSequenceIdMap.put(seqId, wrapper);
        return messageStatus;
    }

    private ArfMessageStatus processFunctionReturnMessage(AArfConnection conn, ArfMessage m, String tid) {
        ArfMessageStatus messageStatus = ArfMessageStatus.MSG_SUCCESS;
        Long seq = m.getCseq();
        String seqId = tid + ";" + seq;
        long finishTime = m.getTs();
        RemoteTracerWrapper wrapper = this.fSequenceIdMap.get(seqId);
        if (wrapper != null) {
            wrapper.fClockDelegate.setFinishTime(finishTime);
            this.UpdatesForSpecialTracers(tid, wrapper, m.getParams());
            this.updateTracedObjectOnFinishTraceEvent(wrapper, m);
            if (wrapper.fTracer != null) {
                this.addEventParamsToSharedStorage(wrapper.fTracer, m.getParams());
                boolean isThreadAlive = InvocationData.getCacheHelper().setExternalThreadId(tid, conn, false);
                Throwable exception = null;
                if (m.isExceptionSet()) {
                    exception = this.processException(m.getException());
                }
                if (wrapper.fTracer instanceof IIntelligentInstrumentationMethodTracer) {
                    if (exception != null) {
                        ((IIntelligentInstrumentationMethodTracer)wrapper.fTracer).IIntelligentInstrumentationMethodTracer_setThrownException(exception);
                    }
                    ((IIntelligentInstrumentationMethodTracer)wrapper.fTracer).IMethodTracer_finishTrace(wrapper.fFunctionId);
                } else {
                    if (wrapper.fTracer instanceof IParameterizedMethodTracer && exception != null) {
                        ((IParameterizedMethodTracer)wrapper.fTracer).IParameterizedMethodTracer_setThrownException(exception);
                    }
                    wrapper.fTracer.IMethodTracer_finishTrace();
                }
                if (!isThreadAlive || this.checkIfThreadIsDone(wrapper)) {
                    InvocationData.getCacheHelper().clearExternalThread();
                }
            }
            this.fSequenceIdMap.remove(seqId);
            messageStatus = ArfMessageStatus.MSG_SUCCESS;
        } else {
            this.fFeedback.warn(kModule, String.format("Received function return message with unknown cseq=%s from %s probe instance %s", seqId, conn.getProbe(), conn.getInstanceId()));
            messageStatus = new ArfMessageStatus(999, m.getOp());
            messageStatus.setResponse(seqId);
        }
        return messageStatus;
    }

    private ArfMessageStatus processPassThruMetricMessage(AArfConnection conn, ArfMessage m, String tid) {
        try {
            if (this.fFeedback.isDebugEnabled(kModule)) {
                this.fFeedback.debug(kModule, "Processing pass-through metrics: " + m);
            }
            return this.reportMetricData(m);
        }
        catch (Exception e) {
            this.fFeedback.error(kModule, "error setting pass through metric id " + m.getMetricId(), e);
            ArfMessageStatus messageStatus = new ArfMessageStatus(0, m.getOp());
            messageStatus.setErrorMessage(m.getMetricId() + ": " + e.getMessage());
            return messageStatus;
        }
    }

    private ArfMessageStatus reportMetricData(ArfMessage m) throws IncompatibleTypesException {
        String metricName = this.insertRoutingPrefix(m.getMetricId());
        int metricType = m.isMetricTypeSet() ? m.getMetricType() : 15;
        switch (metricType) {
            case 258: {
                ILongFluctuatingCounterDataAccumulator accu = this.kDataAccuFactory.safeGetLongFluctuatingCounterDataAccumulator(metricName);
                accu.ILongCounterDataAccumulator_setValue(m.getMetricValueAsLong());
                break;
            }
            case 8194: {
                ILongIntervalCounterDataAccumulator accu = this.kDataAccuFactory.safeGetLongIntervalCounterDataAccumulator(metricName);
                accu.ILongAggregatingDataAccumulator_recordDataPoint(m.getMetricValueAsLong());
                break;
            }
            case 0x100102: {
                ILongMonotonicallyIncreasingCounterDataAccumulator accu = this.kDataAccuFactory.safeGetLongMonotonicallyIncreasingCounterDataAccumulator(metricName);
                accu.ILongCounterDataAccumulator_setValue(m.getMetricValueAsLong());
                break;
            }
            case 1026: {
                ILongAverageDataAccumulator accu = this.kDataAccuFactory.safeGetLongAverageDataAccumulator(metricName);
                accu.ILongAggregatingDataAccumulator_recordDataPoint(m.getMetricValueAsLong());
                break;
            }
            case 1058: {
                IGatherer gatherer = this.kDataAccuFactory.safeGetLongAverageDataAccumulator(metricName).IDataAccumulator_getGatherer();
                gatherer.IGatherer_acceptAggregateTimeslicedValue(new LongTimeslicedValue(metricType, m.getTs(), m.getTe(), BlameStackSnapshot.kEmptyBlameStackSnapshot, m.getCount(), false, m.getMetricValueAsLong(), m.getMin(), m.getMax()));
                break;
            }
            case 2050: {
                ILongMonotonicallyIncreasingCounterDataAccumulator accu = this.kDataAccuFactory.safeGetTimestampDataAccumulator(metricName);
                accu.ILongCounterDataAccumulator_setValue(m.getMetricValueAsLong());
                break;
            }
            case 18: {
                this.kDataAccuFactory.safeGetLongConstantDataAccumulator(metricName, m.getMetricValueAsLong());
                break;
            }
            case 21: {
                this.kDataAccuFactory.safeGetStringConstantDataAccumulator(metricName, m.getMetricValue());
                break;
            }
            case 4101: {
                IStringEveryEventDataAccumulator accu = this.kDataAccuFactory.safeGetStringEveryEventDataAccumulator(metricName);
                accu.IStringEveryEventDataAccumulator_addString(m.getMetricValue());
                break;
            }
            default: {
                if (!m.isAverageSet()) break;
                IGatherer gatherer = this.kDataAccuFactory.safeGetLongFluctuatingCounterDataAccumulator(metricName).IDataAccumulator_getGatherer();
                gatherer.IGatherer_acceptAggregateTimeslicedValue(new LongTimeslicedValue(258, m.getTs(), m.getTe(), BlameStackSnapshot.kEmptyBlameStackSnapshot, m.getCount(), false, m.getAverage(), m.getMin(), m.getMax()));
            }
        }
        return ArfMessageStatus.MSG_SUCCESS;
    }

    private String insertRoutingPrefix(String metricName) {
        if (!metricName.startsWith("!BRIDGE!")) {
            WilyStringBuilder sb = new WilyStringBuilder("!BRIDGE!");
            sb.append(this.fRoute);
            if (metricName.contains(":")) {
                sb.append("|");
            } else {
                sb.append(":");
            }
            sb.append(metricName);
            metricName = sb.toString();
        }
        return metricName;
    }

    protected boolean checkIfThreadIsDone(RemoteTracerWrapper wrapper) {
        return false;
    }

    private void resetSequenceMapForConnection(AArfConnection conn) {
        Set<Map.Entry<String, RemoteTracerWrapper>> entries = this.fSequenceIdMap.entrySet();
        for (Map.Entry<String, RemoteTracerWrapper> entry : entries) {
            RemoteTracerWrapper w = entry.getValue();
            if (w == null || w.fConn != conn) continue;
            this.fSequenceIdMap.remove(entry.getKey());
        }
        InvocationData.getCacheHelper().invalidateThreadsFromConnection(conn);
    }

    @Override
    public int removeOrphanSequences(int expiry) {
        int count = 0;
        if (expiry <= 0) {
            expiry = 60;
        }
        int expiryInSecs = expiry * 1000;
        long currentTime = System.currentTimeMillis() - (long)expiryInSecs;
        Set<Map.Entry<String, RemoteTracerWrapper>> entries = this.fSequenceIdMap.entrySet();
        for (Map.Entry<String, RemoteTracerWrapper> entry : entries) {
            RemoteTracerWrapper wrapper = entry.getValue();
            if (wrapper.getStartTime() >= currentTime) continue;
            this.fSequenceIdMap.remove(entry.getKey());
            ++count;
        }
        return count;
    }

    @Override
    public void resetConnection(AArfConnection conn) {
        if (conn instanceof ArfDataConnection) {
            this.fFeedback.debug(kModule, "Data Connection from pid(" + conn.getPid() + ") for " + conn.getProbe() + "(" + conn.getInstanceId() + ") has been reset.");
            this.resetSequenceMapForConnection(conn);
        } else {
            this.fFeedback.debug(kModule, "Command Connection from " + conn.getProgram() + " for " + conn.getProbe() + "(" + conn.getInstanceId() + ") has been reset.");
        }
        if (conn.isClosed()) {
            this.removeConnection(conn);
        }
    }

    @Override
    public void processMessageError(AArfConnection conn, String raw, ArfException e) {
        this.fFeedback.error(kModule, e.getMessage());
        this.fFeedback.debug(kModule, "Exception while parsing message: " + raw, e);
    }

    public String getInstId() {
        return this.fInstId;
    }

    public void setInstId(String fInstId) {
        this.fInstId = fInstId;
    }

    public String getProbe() {
        return this.fProbe;
    }

    public void setProbe(String fProbe) {
        this.fProbe = fProbe;
        this.fDeepTracerEncodingPattern = String.format(kDeepTracerEncodingPatternUnformatted, fProbe);
    }

    public String getProgram() {
        return this.fProgram;
    }

    public void setProgram(String fProgram) {
        this.fProgram = fProgram;
    }

    public String getPid() {
        return this.fPid;
    }

    public void setPid(String fPid) {
        this.fPid = fPid;
    }

    public String getTid() {
        return this.fTid;
    }

    public void setTid(String fTid) {
        this.fTid = fTid;
    }

    public String getHost() {
        return this.fHost;
    }

    public void setHost(String host) {
        this.fHost = host;
    }

    public String getAppName() {
        return this.fApp;
    }

    public void setAppName(String app) {
        this.fApp = app;
    }

    public String getContainerId() {
        return this.fContainerId;
    }

    public void setContainerId(String containerId) {
        this.fContainerId = containerId;
    }

    public String getContainerName() {
        return this.fContainerName;
    }

    public void setContainerName(String fContainerName) {
        this.fContainerName = fContainerName;
    }

    public String getPodName() {
        return this.fPodName;
    }

    public void setPodName(String fPodName) {
        this.fPodName = fPodName;
    }

    public String getPodNamespace() {
        return this.fPodNamespace;
    }

    public void setPodNamespace(String fPodNamespace) {
        this.fPodNamespace = fPodNamespace;
    }

    public String getPodIpAddress() {
        return this.fPodIpAddress;
    }

    public void setPodIpAddress(String fPodIpAddress) {
        this.fPodIpAddress = fPodIpAddress;
    }

    public int getTracerMapSize() {
        return this.fSequenceIdMap.size();
    }

    protected boolean getInstrumentationInfo(int instrumentationId, RemoteTracerWrapper wrapper) {
        String[] values;
        String[] stringArray = values = this.fManager.getSIService() != null ? this.fManager.getSIService().getIntelligentInstrumentationInfoForSequentialHashCode(instrumentationId) : null;
        if (values == null) {
            return false;
        }
        wrapper.fProbeClassName = values[0];
        wrapper.fProbeMethodName = values[1];
        wrapper.fProbeMethodDescriptor = values[2];
        wrapper.fTracerEncoding = values[3];
        return true;
    }

    private String fixTracerEncoding(String te) {
        String result = te;
        String expParam = String.format("probe=%s", this.fProbe);
        String[] s = te.split(",");
        StringBuilder sb = new StringBuilder();
        for (int i = 2; i < s.length; i += 2) {
            if (!s[i].contains(expParam)) continue;
            sb.append(",").append(s[i - 1]).append(",").append(s[i]);
        }
        result = sb.toString();
        if (result.equals(this.fDeepTracerEncodingPattern)) {
            result = kDeepTracerEncodingPlaceHolder;
        } else if (result.startsWith(this.fDeepTracerEncodingPattern)) {
            result = result.substring(this.fDeepTracerEncodingPattern.length());
        }
        return result;
    }

    private String addBridgeRouting(String te) {
        String result = te;
        int pos = 0;
        int prev = 0;
        String kNamePattern = "name=";
        WilyStringBuilder sb = null;
        pos = result.indexOf("name=");
        while (pos > 0) {
            if (!result.startsWith("!BRIDGE!", pos += "name=".length())) {
                if (sb == null) {
                    sb = new WilyStringBuilder();
                }
                sb.append(result.substring(prev, pos));
                sb.append("!BRIDGE!");
                sb.append(this.fRoute);
                sb.append("|");
                prev = pos;
            }
            pos = result.indexOf("name=", pos);
        }
        if (sb != null) {
            sb.append(result.substring(prev));
            result = sb.toString();
            result = CanonicalObjectPool.getCanonicalString(result);
        }
        return result;
    }

    protected boolean shouldInstrument(RemoteTracerWrapper wrapper) {
        RemoteModeledMethod m;
        boolean retVal = false;
        Map cache = this.fManager.getMethodCache();
        Integer instrumentationId = (Integer)cache.get(m = new RemoteModeledMethod(this.fAgent, wrapper.fProbeMethodName, wrapper.fProbeClassName, wrapper.fProbeMethodDescriptor, this.getProbeName()));
        if (instrumentationId == null) {
            return this.fTracerProvider.isTraced(m);
        }
        retVal = true;
        return retVal;
    }

    private String getProbeName() {
        return this.fCommandConn != null ? this.fCommandConn.getProbe() : null;
    }

    protected String getTracerEncoding(RemoteTracerWrapper wrapper) {
        Map cache = this.fManager.getMethodCache();
        RemoteModeledMethod m = new RemoteModeledMethod(this.fAgent, wrapper.fProbeMethodName, wrapper.fProbeClassName, wrapper.fProbeMethodDescriptor, this.getProbeName());
        Integer instrumentationId = (Integer)cache.get(m);
        String tracerEncoding = "";
        if (instrumentationId == null) {
            IIntelligentInstrumentationTracerHelper sis;
            TracerEncoding te = this.fTracerProvider.getTracerEncoding(m);
            if (te != null && te.getEncoding() != null) {
                tracerEncoding = this.fixTracerEncoding(te.getEncoding());
                tracerEncoding = CanonicalObjectPool.getCanonicalString(tracerEncoding);
            }
            if ((sis = this.fManager.getSIService()) != null) {
                int id = sis.getDeepInstrumentationId(wrapper.fProbeClassName, wrapper.fProbeMethodName, wrapper.fProbeMethodDescriptor, tracerEncoding);
                instrumentationId = new Integer(id);
                wrapper.fFunctionId = id;
                cache.put(m, instrumentationId);
            } else {
                this.fFeedback.debug(kModule, "Probe id not cached due to IntelligentInstrumentationService not available.");
            }
        } else {
            String[] values;
            wrapper.fFunctionId = instrumentationId;
            String[] stringArray = values = this.fManager.getSIService() != null ? this.fManager.getSIService().getIntelligentInstrumentationInfoForSequentialHashCode(wrapper.fFunctionId) : null;
            if (values == null) {
                if (this.fFeedback.isDebugEnabled(kModule)) {
                    this.fFeedback.debug(kModule, "Inconsistent probe cache state.");
                }
                return "";
            }
            if (values[3] == null) {
                TracerEncoding te = this.fTracerProvider.getTracerEncoding(m);
                if (te != null && te.getEncoding() != null) {
                    tracerEncoding = this.fixTracerEncoding(te.getEncoding());
                    tracerEncoding = CanonicalObjectPool.getCanonicalString(tracerEncoding);
                }
                values[3] = tracerEncoding;
            } else {
                tracerEncoding = values[3];
            }
        }
        if (this.isOpen()) {
            ArfMessage msg;
            if (tracerEncoding.length() == 0) {
                if (this.fIsProbeFilteringEnabled && !wrapper.fFunctionName.equals(this.fLastProbelFilteringCommandSent)) {
                    try {
                        msg = ArfMessageFactory.getWriterInstance("config");
                        msg.setFn(wrapper.fFunctionName);
                        msg.setCmd("flt");
                        this.fCommandConn.send(msg.writeMessage());
                        this.fLastProbelFilteringCommandSent = wrapper.fFunctionName;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.fIsProbeMappingEnabled && !wrapper.fFunctionName.equals(this.fLastProbeMappingCommandSent)) {
                try {
                    msg = ArfMessageFactory.getWriterInstance("config");
                    msg.setFn(wrapper.fFunctionName);
                    msg.setCmd("map");
                    msg.setFnid(wrapper.fFunctionId);
                    this.fCommandConn.send(msg.writeMessage());
                    this.fLastProbeMappingCommandSent = wrapper.fFunctionName;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        tracerEncoding = this.addBridgeRouting(tracerEncoding);
        return tracerEncoding;
    }

    public void sendProbeFilterResetMsg() {
        if (this.isOpen()) {
            try {
                ArfMessage msg = ArfMessageFactory.getWriterInstance("config");
                msg.setCmd("rst");
                this.fCommandConn.send(msg.writeMessage());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void addConnection(AArfConnection conn) {
        if (conn instanceof ArfCommandConnection) {
            IsengardServerConnectionManager isengardConn = this.fAgent.IAgent_getIsengardServerConnection();
            if (this.fCommandConn != null && conn != this.fCommandConn) {
                this.fFeedback.info(kModule, "Recieved new command connection for existing probe instance, closing old connection: " + conn.toString());
                this.fCommandConn.close();
                if (isengardConn != null) {
                    isengardConn.removeNamedAgentBridge(this.fRoute);
                }
            }
            this.fCommandConn = (ArfCommandConnection)conn;
            String host = this.fCommandConn.getHost();
            String ipAddr = this.fCommandConn.getIpAddr();
            if (this.fManager.allowLocalProbesOnly() || this.shouldUseCollectorHost(host, ipAddr)) {
                host = null;
                ipAddr = null;
            }
            if (host != null && host.contains(":")) {
                host = host.replace(':', '_');
            }
            if (host != null && host.contains(":")) {
                host = host.replace(':', '_');
            }
            this.fRoute = this.fProgram + "@" + host;
            if (isengardConn != null) {
                NamedAgentBridgeInfo namedAgentBridgeInfo = new NamedAgentBridgeInfo(this.fRoute, host, ipAddr, this.formatProbeProcessName(), this.formatProbeAgentName(), this.fCommandConn.getProbe(), null, null);
                namedAgentBridgeInfo.setContainerDetails(this.fCommandConn.getContainerId(), this.fCommandConn.getContainerName(), this.fCommandConn.getPodName(), this.fCommandConn.getPodNamespace(), this.fCommandConn.getPodIpAddress());
                namedAgentBridgeInfo.setAppName(this.fCommandConn.getAppName());
                isengardConn.addNamedAgentBridge(namedAgentBridgeInfo);
            }
        } else {
            this.fDataConnSet.add(conn);
        }
    }

    public void removeConnection(AArfConnection conn) {
        if (conn instanceof ArfCommandConnection) {
            if (conn == this.fCommandConn) {
                this.fCommandConn = null;
                IsengardServerConnectionManager isengardConn = this.fAgent.IAgent_getIsengardServerConnection();
                if (isengardConn != null) {
                    isengardConn.removeNamedAgentBridge(this.fRoute);
                }
                if (!this.fIsClosed) {
                    this.close();
                }
            }
        } else {
            this.fDataConnSet.remove(conn);
        }
    }

    private void close() {
        this.closeProbe();
        this.fManager.removeCollector(this.fInstId);
    }

    private void closeProbe() {
        if (this.fCommandConn != null) {
            this.fCommandConn.close();
            IsengardServerConnectionManager isengardConn = this.fAgent.IAgent_getIsengardServerConnection();
            if (isengardConn != null) {
                isengardConn.removeNamedAgentBridge(this.fRoute);
            }
            this.fCommandConn = null;
        }
        for (ArfDataConnection dc : this.fDataConnSet) {
            dc.close();
        }
        this.fDataConnSet.clear();
    }

    public boolean isOpen() {
        return this.fCommandConn != null;
    }

    public boolean isClosed() {
        return this.fCommandConn == null && this.fDataConnSet.isEmpty();
    }

    public boolean serviceProbe() throws Exception {
        long now = System.currentTimeMillis();
        if (this.isOpen() && this.fLastPingSent + 5000L < now) {
            this.fLastPingSent = now;
            if (!this.fCommandConn.pingConnection(60000L)) {
                this.fFeedback.info(kModule, "Connection from " + this.fCommandConn.getProbe() + "(" + this.fCommandConn.getInstanceId() + ") has failed to respond to ping.");
                this.fIsClosed = true;
                this.closeProbe();
                return false;
            }
        }
        return true;
    }

    protected String formatProbeName(String fmt) {
        String name = fmt;
        if (name != null) {
            if (name.indexOf(kProgramNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kProgramNamePlaceHolder, this.fProgram);
            }
            if (name.indexOf(kProbeAppNamePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kProbeAppNamePlaceHolder, this.fApp == null ? this.getDefaultAppName() : this.fApp);
            }
            if (name.indexOf(kProbeTypePlaceHolder, 0) >= 0) {
                name = StringUtils.replace(name, kProbeTypePlaceHolder, this.fCommandConn.getProbe());
            }
            if (name.indexOf(kCollectorNamePlaceHolder, 0) >= 0) {
                String agentName = this.fAgent.IAgent_getName();
                if (agentName == null) {
                    if (this.fAgent instanceof ACommonAgent) {
                        agentName = ((ACommonAgent)this.fAgent).debug_returnConfiguredAgentName();
                    }
                    if (this.fFeedback.isTraceEnabled(kModule)) {
                        this.fFeedback.trace(kModule, "AGENT-NAME: formatProbeName - Agent Name: " + agentName);
                    }
                }
                if (agentName == null) {
                    agentName = "UnknownAgent";
                }
                name = StringUtils.replace(name, kCollectorNamePlaceHolder, agentName);
            }
        }
        return name;
    }

    protected String formatProbeProcessName() {
        String fmt = this.fManager.getProbeProcessNameFormat();
        return this.formatProbeName(fmt);
    }

    protected String formatProbeAgentName() {
        String fmt = this.fManager.getProbeAgentNameFormat();
        return this.formatProbeName(fmt);
    }

    private boolean shouldUseCollectorHost(String host, String ipAddress) {
        return "localhost".equalsIgnoreCase(host) || "127.0.0.1".equals(host) || "0::1".equals(host) || "0:0:0:0:0:0:0:1".equals(host);
    }

    public static String convertToValidJavaIdentifier(String str) {
        int len = str.length();
        if (len == 0) {
            return "_";
        }
        char c = str.charAt(0);
        if (!Character.isJavaIdentifierStart(c)) {
            str = "_".concat(str);
            ++len;
        }
        for (int i = 1; i < len; ++i) {
            c = str.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            str = str.replace(c, '_');
        }
        return str;
    }

    private static Map<String, String> getParametersString(String attributes) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (attributes == null || attributes.isEmpty()) {
            return parameters;
        }
        JsonObject attributesJSON = new Gson().fromJson(attributes, JsonObject.class);
        Set<Map.Entry<String, JsonElement>> entrySet = attributesJSON.entrySet();
        for (Map.Entry<String, JsonElement> entry : entrySet) {
            parameters.put(entry.getKey(), attributesJSON.get(entry.getKey()).getAsString());
        }
        return parameters;
    }

    @Override
    public boolean isSequenceExists(String sequenceKey) {
        return this.fSequenceIdMap.containsKey(sequenceKey);
    }

    public static class RemoteWallClockDelegate
    implements IWallClockDelegate {
        private final long fStartTime;
        private volatile long fFinishTime;

        public RemoteWallClockDelegate(long startTime) {
            this.fStartTime = startTime;
        }

        @Override
        public long getStartTime() {
            return this.fStartTime;
        }

        @Override
        public long getFinishTime() {
            return this.fFinishTime;
        }

        @Override
        public void setFinishTime(long finishTime) {
            this.fFinishTime = finishTime;
        }
    }
}

