/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.epagent.EPAgent;
import com.wily.introscope.epagent.HttpAgentOps;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IStaleMetricsProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.HttpDataRecorder;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalMetricTypeException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.IntAverageDataRecorder;
import com.wily.introscope.epagent.api.IntCounterDataRecorder;
import com.wily.introscope.epagent.api.MetricClampExceededException;
import com.wily.introscope.epagent.api.PerIntervalCounterDataRecorder;
import java.util.Map;

public class AgentAccessor
implements HttpAgentOps,
IStaleMetricsProcessor {
    private IntCounterDataRecorder hitsTotal;
    private PerIntervalCounterDataRecorder hitsPerInterval;
    private IntAverageDataRecorder responseTime;
    private IntCounterDataRecorder concurrentConnections;
    private IPluginProcessor processor;

    @Override
    public void setProcessor(IPluginProcessor p) {
        this.processor = p;
    }

    @Override
    public void createSupportabilityMetrics() throws IllegalConfigurationException {
        try {
            this.hitsTotal = DataRecorderFactory.createIntCounterDataRecorder("EPAgent|HTTP Server:Hits Total");
            this.hitsPerInterval = DataRecorderFactory.createPerIntervalCounterDataRecorder("EPAgent|HTTP Server:Hits Per Interval");
            this.responseTime = DataRecorderFactory.createIntAverageDataRecorder("EPAgent|HTTP Server:Response Time (ms)");
            this.concurrentConnections = DataRecorderFactory.createIntCounterDataRecorder("EPAgent|HTTP Server:Concurrency");
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
    }

    @Override
    public void recordMetric(String name, String type, String value, String route) throws IllegalMetricNameException, IllegalMetricTypeException, IllegalValueException, MetricClampExceededException {
        if (this.processor != null) {
            HttpDataRecorder dr;
            String fullName = name;
            if (route != null) {
                fullName = "!BRIDGE!" + route + "|" + name;
            }
            if ((dr = (HttpDataRecorder)this.processor.findOrCreateMetric(fullName, type)).hasBackingMetric()) {
                allMetrics.put(fullName, System.currentTimeMillis());
                dr.recordValue(value);
            } else {
                throw new MetricClampExceededException();
            }
        }
    }

    @Override
    public void recordTrace(String source, String trace) {
        this.processor.parseResults(source, trace);
    }

    @Override
    public void recordHit(long elapsedTime) {
        this.hitsTotal.add(1);
        this.hitsPerInterval.recordIncident();
        this.responseTime.recordDataPoint((int)elapsedTime);
    }

    @Override
    public void startHttpRequest() {
        this.concurrentConnections.add(1);
    }

    @Override
    public void endHttpRequest() {
        this.concurrentConnections.subtract(1);
    }

    @Override
    public String[] getHostProcessAgent() {
        try {
            return AgentShim.getAgent().IAgent_getHostProcessAgentTriplet();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void logError(String msg, Exception exception) {
        if (this.processor != null) {
            this.processor.getFeedback().error(EPAgent.kModule, msg, (Throwable)exception);
        }
    }

    @Override
    public boolean addNamedAgentBridge(String routeName, String host, String process, String agentName) {
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException e) {
            return false;
        }
        IsengardServerConnectionManager isengardConn = agent.IAgent_getIsengardServerConnection();
        String ipAddr = null;
        if (isengardConn != null) {
            NamedAgentBridgeInfo namedAgentBridgeInfo = new NamedAgentBridgeInfo(routeName, host, ipAddr, process, agentName, "epagent", null, null);
            return true;
        }
        return false;
    }

    public Map<String, Long> getAllMetrics() {
        return allMetrics;
    }
}

