/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.agent.epa.IXMLHandler;
import com.wily.introscope.epagent.EPAConfig;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IStaleMetricsProcessor;
import com.wily.introscope.epagent.IllegalDataFormatException;
import com.wily.introscope.epagent.api.DataRecorder;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.EventRecorder;
import com.wily.introscope.epagent.api.EventRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalMetricTypeException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EPAPluginProcessor
implements IPluginProcessor,
IStaleMetricsProcessor {
    public Module fModule;
    public IModuleFeedbackChannel fFeedback;
    public IStringLocalizer fLocalizer;
    private IndexedProperties fProperties;
    private EPAConfig fConfig;
    private static final int kSimpleDataStream = 1;
    private static final int kXMLDataStream = 2;
    private static final String kEventPrefix = "event";
    private static final String kEventPrefixDelimiter = ":";
    private static final String kMETRIC_XML_TAG = "metric";
    private static final String kNAME_XML_ATTR = "name";
    private static final String kVALUE_XML_ATTR = "value";
    private static final String kTYPE_XML_ATTR = "type";
    private static final String kEVENT_XML_TAG = "event";
    private static final String kTIMESTAMP_XML_ATTR = "startTime";
    private static final String kOFFSET_XML_ATTR = "offset";
    private static final String kDURATION_XML_ATTR = "duration";
    private static final String kRESOURCE_XML_ATTR = "resource";
    private static final String kPARAM_XML_TAG = "param";
    private static final String kCALLED_COMPONENT_XML_TAG = "calledComponent";
    private static final String kDISALLOW_DOC_TPE = "http://apache.org/xml/features/disallow-doctype-decl";
    private static final String kGENERAL_EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String kPARAMETER_EXTERNAL_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";
    private static final Map fMetricTable = Collections.synchronizedMap(new HashMap());
    private static boolean fMetricCaseSensitive;
    private static final long INITALIZATION_WAIT = 1000L;
    private static final int INITALIZATION_RETRY = 30;
    private static final char REPLACEMENT_CHAR = '\ufffd';
    public DocumentBuilder docBuilder;
    public Map fXMLDataHandlers;
    public DateFormat fDateFormat;
    public Object lockRegister = new Object();

    public EPAPluginProcessor(IndexedProperties props, IModuleFeedbackChannel feedback, IStringLocalizer localizer, EPAConfig config) {
        this.fProperties = props;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fModule = new Module("EPAPluginProcessor");
        this.fConfig = config;
        fMetricCaseSensitive = this.fConfig.getMetricCaseSensitive();
        this.initializeDocumentBuilder();
    }

    @Override
    public Object parseResults(String source, String data) {
        try {
            int formatType = this.getType(data);
            if (formatType == 1) {
                return this.parseSimpleResults(data);
            }
            if (formatType == 2) {
                return this.parseXMLResults(data);
            }
        }
        catch (IllegalDataFormatException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_metric_data_2P", source, e.getMessage());
            this.fFeedback.error(this.fModule, s);
        }
        catch (IllegalValueException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_metric_value_2P", source, e.getMessage());
            this.fFeedback.error(this.fModule, s);
        }
        catch (IllegalMetricNameException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_metric_name_2P", source, e.getMessage());
            this.fFeedback.error(this.fModule, s);
        }
        catch (IllegalMetricTypeException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("invalid_metric_type_2P", source, e.getMessage());
            this.fFeedback.error(this.fModule, s);
        }
        return null;
    }

    private int getType(String inString) {
        if (inString != null && inString.length() > 0 && (inString.charAt(0) == '<' || inString.charAt(inString.length() - 1) == '>')) {
            return 2;
        }
        return 1;
    }

    private Object parseSimpleResults(String inString) throws IllegalValueException, IllegalDataFormatException, IllegalMetricNameException, IllegalMetricTypeException {
        if (!this.getIfDataValid(inString)) {
            throw new IllegalDataFormatException("Bad data, string " + inString + " contains invalid characters");
        }
        int eventDataStart = this.getEventDataStartIndex(inString);
        if (eventDataStart == -1) {
            return this.parseSimpleMetricResults(inString);
        }
        return this.parseSimpleEventResults(inString, eventDataStart);
    }

    private int getEventDataStartIndex(String inString) {
        String maybeEventPrefix;
        int delimIndex = inString.indexOf(kEventPrefixDelimiter);
        if (delimIndex > 0 && (maybeEventPrefix = inString.substring(0, delimIndex).trim().toLowerCase()).equals("event")) {
            while (Character.isWhitespace(inString.charAt(++delimIndex))) {
            }
            return delimIndex;
        }
        return -1;
    }

    private boolean getIfDataValid(String inString) {
        return inString.indexOf(65533) == -1;
    }

    EventRecorder parseSimpleEventResults(String inString, int fromWhere) throws IllegalDataFormatException {
        String decoded = inString;
        try {
            decoded = URLDecoder.decode(inString);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HashMap<String, String> eventData = new HashMap<String, String>();
        int startIndex = fromWhere;
        int endString = decoded.length();
        int endIndex = decoded.indexOf(38, startIndex);
        String eventType = null;
        boolean timeToFinish = false;
        do {
            int equalsIndex;
            if ((equalsIndex = decoded.indexOf(61, startIndex)) < endIndex) {
                String key = decoded.substring(startIndex, equalsIndex);
                String value = decoded.substring(equalsIndex + 1, endIndex);
                eventData.put(key, value);
                if (key.equals(kTYPE_XML_ATTR)) {
                    eventType = value;
                }
                if ((startIndex = endIndex + 1) < endString) {
                    endIndex = decoded.indexOf(38, startIndex);
                    if (endIndex != -1) continue;
                    endIndex = endString;
                    continue;
                }
                timeToFinish = true;
                continue;
            }
            throw new IllegalDataFormatException("Bad event data format: missing '='");
        } while (!timeToFinish);
        if (eventType == null) {
            throw new IllegalDataFormatException("Missing event type");
        }
        EventRecorder recorder = EventRecorderFactory.getEventRecorder(eventType);
        recorder.addEventData(eventData);
        return recorder;
    }

    private DataRecorder parseSimpleMetricResults(String inString) throws IllegalValueException, IllegalDataFormatException, IllegalMetricNameException, IllegalMetricTypeException {
        int length = inString.length();
        int index = inString.indexOf(61);
        if (index == -1) {
            throw new IllegalDataFormatException(inString);
        }
        String name = inString.substring(0, index).trim();
        String value = "";
        String type = "IntCounter";
        if (index < length) {
            value = inString.substring(index + 1);
        }
        try {
            Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            type = "StringEvent";
        }
        DataRecorder result = this.findOrCreateMetric(name, type);
        result.recordValue(value);
        allMetrics.put(name, System.currentTimeMillis());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataRecorder findOrCreateMetric(String name, String type) throws IllegalMetricNameException, IllegalMetricTypeException {
        Map map = fMetricTable;
        synchronized (map) {
            String key = null;
            key = fMetricCaseSensitive ? name + '_' + type : (name + '_' + type).toLowerCase();
            DataRecorder result = (DataRecorder)fMetricTable.get(key);
            if (null == result || result.isRemoved()) {
                DataRecorder recorder;
                result = recorder = DataRecorderFactory.createDataRecorderForType(type, name);
                fMetricTable.put(key, result);
            }
            return result;
        }
    }

    Object parseXMLResults(String inString) throws IllegalValueException, IllegalDataFormatException, IllegalMetricNameException, IllegalMetricTypeException {
        try {
            Element docRoot;
            String strName = null;
            String strValue = null;
            String strType = null;
            Element metric = docRoot = this.getXMLDocRoot(inString);
            if (metric.getNodeType() == 1) {
                if (metric.getNodeName().equals(kMETRIC_XML_TAG)) {
                    strName = metric.getAttribute(kNAME_XML_ATTR);
                    strValue = metric.getAttribute(kVALUE_XML_ATTR);
                    strType = metric.getAttribute(kTYPE_XML_ATTR);
                    if (strName == null || strValue == null || strType == null) {
                        throw new IllegalDataFormatException(inString);
                    }
                    DataRecorder result = this.findOrCreateMetric(strName, strType);
                    result.recordValue(strValue);
                    allMetrics.put(strName, System.currentTimeMillis());
                    return result;
                }
                if (metric.getNodeName().equals("event")) {
                    TransactionComponentData data = this.buildComponentData(metric, System.currentTimeMillis());
                    String eventType = data.getResource();
                    EventRecorder recorder = EventRecorderFactory.getEventRecorder(eventType);
                    recorder.addEvent(data);
                    return recorder;
                }
            } else {
                throw new IllegalDataFormatException(inString);
            }
            this.parseWithRegXMLHandler(docRoot, inString);
        }
        catch (DOMException e) {
            throw new IllegalDataFormatException(inString, e);
        }
        catch (SAXException e) {
            throw new IllegalDataFormatException(inString, e);
        }
        catch (IOException e) {
            throw new IllegalDataFormatException(inString, e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Element getXMLDocRoot(String inString) throws IllegalDataFormatException, SAXException, IOException {
        if (this.docBuilder != null) {
            DocumentBuilder documentBuilder = this.docBuilder;
            synchronized (documentBuilder) {
                Document doc = this.docBuilder.parse(new ByteArrayInputStream(inString.getBytes()));
                if (doc != null) {
                    return doc.getDocumentElement();
                }
            }
        }
        return null;
    }

    TransactionComponentData buildComponentData(Node node, long startTime) throws IllegalDataFormatException {
        TransactionComponentData result = null;
        try {
            TransactionComponentData[] calledComponents;
            Map params;
            SortedNodes sorted = this.sortNodeInfo(node);
            AttributeInfo info = this.getAttributeInfo(sorted.attrs, startTime);
            if (info != null) {
                params = this.getParams(sorted.params);
                if (params == null) {
                    params = TransactionComponentData.kNoParameters;
                }
                if ((calledComponents = this.getCalledComponents(sorted.calledComponents, info.getStartTime())) == null) {
                    calledComponents = TransactionComponentData.kNoCalledComponents;
                }
            } else {
                throw new IllegalDataFormatException("No resource element in stream");
            }
            result = new TransactionComponentData(info.resource, info.getStartTime(), info.duration, params, calledComponents);
        }
        catch (Exception e) {
            this.fFeedback.error((Throwable)e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWithRegXMLHandler(Element docRoot, String inString) throws IllegalDataFormatException {
        if (docRoot.getNodeType() == 1) {
            String docRootName = docRoot.getNodeName();
            IXMLHandler handler = (IXMLHandler)this.fXMLDataHandlers.get(docRootName);
            if (handler == null) {
                for (int retry = 0; handler == null && retry < 30; ++retry) {
                    Object object = this.lockRegister;
                    synchronized (object) {
                        try {
                            this.fFeedback.verbose(retry + " Waiting " + 1000L + "ms for initialization of extension able to handle " + docRootName);
                            this.lockRegister.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    handler = (IXMLHandler)this.fXMLDataHandlers.get(docRootName);
                }
                if (handler == null) {
                    this.fXMLDataHandlers.put(docRootName, new MissingXMLHandlerPlaceholder());
                }
            }
            if (handler != null) {
                if (handler instanceof MissingXMLHandlerPlaceholder) {
                    throw new IllegalDataFormatException(inString);
                }
                handler.handleData(inString);
                return;
            }
        }
        throw new IllegalDataFormatException(inString);
    }

    private void initializeDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature(kDISALLOW_DOC_TPE, true);
            documentBuilderFactory.setFeature(kGENERAL_EXTERNAL_ENTITIES, false);
            documentBuilderFactory.setFeature(kPARAMETER_EXTERNAL_ENTITIES, false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            this.docBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.fFeedback.error((Throwable)e);
        }
        this.fXMLDataHandlers = new Hashtable();
        this.fDateFormat = DateFormat.getDateInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerXMLDataHandlerInternal(String name, IXMLHandler handler) {
        Object object = this.lockRegister;
        synchronized (object) {
            this.fXMLDataHandlers.put(name, handler);
            this.lockRegister.notifyAll();
        }
    }

    private AttributeInfo getAttributeInfo(List attrs, long startTime) {
        AttributeInfo result = null;
        AttributeInfo workingCopy = new AttributeInfo(startTime);
        if (attrs != null) {
            for (Node attr : attrs) {
                if (attr.getNodeName().equals(kRESOURCE_XML_ATTR)) {
                    workingCopy.resource = attr.getNodeValue();
                    continue;
                }
                if (attr.getNodeName().equals(kTIMESTAMP_XML_ATTR)) {
                    String nodeVal = attr.getNodeValue();
                    try {
                        Date realTimestamp = this.fDateFormat.parse(nodeVal);
                        workingCopy.setStartTime(realTimestamp.getTime());
                    }
                    catch (ParseException pe) {
                        try {
                            long timeInMillis = Long.parseLong(nodeVal);
                            workingCopy.setStartTime(timeInMillis);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    continue;
                }
                if (attr.getNodeName().equals(kOFFSET_XML_ATTR)) {
                    try {
                        long offset = Long.parseLong(attr.getNodeValue());
                        workingCopy.setOffset(offset);
                    }
                    catch (NumberFormatException offset) {}
                    continue;
                }
                if (!attr.getNodeName().equals(kDURATION_XML_ATTR)) continue;
                try {
                    long realDuration;
                    workingCopy.duration = realDuration = Long.parseLong(attr.getNodeValue());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (workingCopy.resource != null) {
            result = workingCopy;
        }
        return result;
    }

    private Map getParams(List params) throws IllegalDataFormatException {
        HashMap<String, String> result = null;
        if (params != null) {
            result = new HashMap<String, String>();
            for (Node paramNode : params) {
                NamedNodeMap paramAttrs = paramNode.getAttributes();
                Node paramAttrNameNode = paramAttrs.getNamedItem(kNAME_XML_ATTR);
                Node paramAttrValueNode = paramAttrs.getNamedItem(kVALUE_XML_ATTR);
                if (paramAttrNameNode == null || paramAttrValueNode == null) {
                    throw new IllegalDataFormatException("Badly-formed param node");
                }
                result.put(paramAttrNameNode.getNodeValue(), paramAttrValueNode.getNodeValue());
            }
        }
        return result;
    }

    private TransactionComponentData[] getCalledComponents(List children, long startTime) throws IllegalDataFormatException {
        TransactionComponentData[] result = null;
        if (children != null) {
            ArrayList<TransactionComponentData> calledComponents = new ArrayList<TransactionComponentData>();
            for (Node calledComponentNode : children) {
                TransactionComponentData childData = this.buildComponentData(calledComponentNode, startTime);
                calledComponents.add(childData);
            }
            if (calledComponents.size() > 0) {
                result = new TransactionComponentData[calledComponents.size()];
                result = calledComponents.toArray(result);
            }
        }
        return result;
    }

    private SortedNodes sortNodeInfo(Node parent) {
        SortedNodes result = new SortedNodes();
        ArrayList<Node> attrs = new ArrayList<Node>(3);
        ArrayList<Node> params = new ArrayList<Node>();
        ArrayList<Node> calledComponents = new ArrayList<Node>();
        result.attrs = attrs;
        result.params = params;
        result.calledComponents = calledComponents;
        NodeList childList = parent.getChildNodes();
        int nChildren = childList.getLength();
        block3: for (int i = 0; i < nChildren; ++i) {
            Node childNode = childList.item(i);
            switch (childNode.getNodeType()) {
                case 1: {
                    if (childNode.getNodeName().equals(kPARAM_XML_TAG)) {
                        params.add(childNode);
                        continue block3;
                    }
                    if (!childNode.getNodeName().equals(kCALLED_COMPONENT_XML_TAG)) continue block3;
                    calledComponents.add(childNode);
                    continue block3;
                }
            }
        }
        NamedNodeMap nodeAttrs = parent.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < nodeAttrs.getLength(); ++i) {
                attrs.add(nodeAttrs.item(i));
            }
        }
        return result;
    }

    @Override
    public IndexedProperties getProperties() {
        return this.fProperties;
    }

    @Override
    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    @Override
    public IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    @Override
    public EPAConfig getConfig() {
        return this.fConfig;
    }

    private static class SortedNodes {
        List attrs;
        List params;
        List calledComponents;

        private SortedNodes() {
        }
    }

    private static class AttributeInfo {
        String resource = null;
        private long startTime;
        private long offset;
        long duration;

        AttributeInfo(long startTime) {
            this.startTime = startTime;
            this.offset = 0L;
            this.duration = 0L;
        }

        void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        void setOffset(long offset) {
            this.offset = offset;
        }

        long getStartTime() {
            return this.startTime + this.offset;
        }
    }

    private static class MissingXMLHandlerPlaceholder
    implements IXMLHandler {
        private MissingXMLHandlerPlaceholder() {
        }

        public void handleData(String content) {
        }
    }
}

