/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.EPAPlugin;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.DataRecorder;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.StringEventDataRecorder;
import com.wily.introscope.epagent.api.TimestampDataRecorder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class ProcessPlugin
extends EPAPlugin {
    public static final List listOfPluginThreads = Collections.synchronizedList(new ArrayList(11));
    private static final int ACTION_SAME = 0;
    private static final int ACTION_ZERO = 1;
    private static final int ACTION_STOP = 2;
    private static final String[] metricNotReportedActionValue = new String[]{"same", "zero", "stop"};
    private static Object threadCountLock = new Object();
    private static int threadCount = 0;
    private static boolean beingShutdown = false;
    private String fCommand;
    private String[] fCommandArray;
    private Process fProcess;
    private BufferedReader inBuffer;
    private BufferedReader errReader;
    private int metricNotReportedAction = 0;
    private Map currentRecorders = new HashMap();
    private Map previousRecorders = new HashMap();
    private StringEventDataRecorder fCommandRecorder;
    private boolean fIsRunning;

    ProcessPlugin(IPluginProcessor processor, String myKey, String myName, String cmd) throws IllegalConfigurationException {
        super(processor, myKey, myName);
        this.fCommand = cmd;
        this.fCommandArray = ProcessPlugin.QuotedStringToStringArray(this.fCommand);
        String metricNotReportedActionPropName = myKey + "metricNotReportedAction";
        String notReportedActionStr = processor.getProperties().getProperty(metricNotReportedActionPropName);
        if (notReportedActionStr != null) {
            boolean valueValid = false;
            for (int i = 0; i < metricNotReportedActionValue.length; ++i) {
                if (!notReportedActionStr.equals(metricNotReportedActionValue[i])) continue;
                this.metricNotReportedAction = i;
                valueValid = true;
                this.fFeedback.info(this.fModule, "Plugin " + this.fName + " metric not reported action set to '" + notReportedActionStr + "'");
                break;
            }
            if (!valueValid) {
                this.fFeedback.warn(this.fModule, "Plugin " + this.fName + " invalid value '" + notReportedActionStr + "' for configuration property '" + metricNotReportedActionPropName + "'");
            }
        }
        try {
            this.fCommandRecorder = DataRecorderFactory.createStringEventDataRecorder(this.fThisPluginMetricPath + ":Command");
            this.fCommandRecorder.recordDataPoint(this.fCommand);
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRunPlugin() throws InterruptedException {
        block70: {
            ProcessPlugin processPlugin = this;
            synchronized (processPlugin) {
                if (this.fIsRunning) {
                    return;
                }
                this.fIsRunning = true;
            }
            if (!this.isStateless()) {
                processPlugin = this;
                synchronized (processPlugin) {
                    if (beingShutdown) {
                        this.fIsRunning = false;
                        return;
                    }
                    listOfPluginThreads.add(new WeakReference<Thread>(Thread.currentThread()));
                    ++threadCount;
                }
            }
            this.fProcess = null;
            this.startProcess();
            boolean running = this.fProcess != null;
            try {
                while (!Thread.currentThread().isInterrupted() && running) {
                    try {
                        int status = this.fProcess.exitValue();
                        running = false;
                        this.fFeedback.debug(this.fModule, "Process has exited with: " + status);
                    }
                    catch (IllegalThreadStateException status) {
                        // empty catch block
                    }
                    this.processResults();
                    if (Thread.currentThread().isInterrupted() || !running) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.closeIOStreams();
                }
                finally {
                    Object object;
                    if (Thread.currentThread().isInterrupted()) {
                        this.fFeedback.info(this.fModule, "Plugin " + this.fName + " is stopping...");
                    }
                    if (!this.isStateless()) {
                        this.destroyOSProcess();
                        object = threadCountLock;
                        synchronized (object) {
                            if (--threadCount == 0) {
                                threadCountLock.notify();
                            }
                        }
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException("EPAgentSubProcessDestroyed");
                        }
                    } else {
                        this.processMissingResults();
                        if (this.fProcess != null) {
                            try {
                                this.fProcess.waitFor();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    object = this;
                    synchronized (object) {
                        this.fIsRunning = false;
                    }
                }
                throw throwable;
            }
            try {
                this.closeIOStreams();
                if (!Thread.currentThread().isInterrupted()) break block70;
            }
            catch (Throwable throwable) {
                Object object;
                if (Thread.currentThread().isInterrupted()) {
                    this.fFeedback.info(this.fModule, "Plugin " + this.fName + " is stopping...");
                }
                if (!this.isStateless()) {
                    this.destroyOSProcess();
                    object = threadCountLock;
                    synchronized (object) {
                        if (--threadCount == 0) {
                            threadCountLock.notify();
                        }
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException("EPAgentSubProcessDestroyed");
                    }
                } else {
                    this.processMissingResults();
                    if (this.fProcess != null) {
                        try {
                            this.fProcess.waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                object = this;
                synchronized (object) {
                    this.fIsRunning = false;
                }
                throw throwable;
            }
            this.fFeedback.info(this.fModule, "Plugin " + this.fName + " is stopping...");
        }
        if (!this.isStateless()) {
            this.destroyOSProcess();
            Object object = threadCountLock;
            synchronized (object) {
                if (--threadCount == 0) {
                    threadCountLock.notify();
                }
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("EPAgentSubProcessDestroyed");
            }
        } else {
            this.processMissingResults();
            if (this.fProcess != null) {
                try {
                    this.fProcess.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        ProcessPlugin processPlugin = this;
        synchronized (processPlugin) {
            this.fIsRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void startProcess() {
        this.fFeedback.debug(this.fModule, "Starting plugin process: " + this.fCommand);
        IOException ex = null;
        try {
            this.fProcess = Runtime.getRuntime().exec(this.fCommandArray);
            return;
        }
        catch (IOException e) {
            ex = e;
            this.fFeedback.error(this.fModule, "Error starting plugin process: " + e.getMessage());
            this.fFeedback.debug(this.fModule, "Error starting plugin process: " + e.getMessage() + ProcessPlugin.stack2string(e));
            return;
        }
        finally {
            if (this.fProcess != null) {
                try {
                    this.fProcess.getOutputStream().close();
                }
                catch (IOException e) {
                    this.fFeedback.debug(this.fModule, "Error closing outputStream. Plugin " + this.fName + ProcessPlugin.stack2string(e));
                }
                finally {
                    if (ex != null) {
                        this.closeIOStreams();
                    }
                }
            }
        }
    }

    private void processResults() {
        this.inBuffer = new BufferedReader(new InputStreamReader(this.fProcess.getInputStream()));
        this.errReader = new BufferedReader(new InputStreamReader(this.fProcess.getErrorStream()));
        try {
            String errString;
            String inString;
            while (!Thread.currentThread().isInterrupted() && this.inBuffer.ready() && (inString = this.inBuffer.readLine()) != null) {
                if ((inString = inString.trim()).length() == 0) continue;
                this.fFeedback.debug("Process plugin parsing line: " + inString);
                Object result = this.fProcessor.parseResults("Plugin " + this.getName(), inString);
                if (result == null || !(result instanceof DataRecorder)) continue;
                DataRecorder recorder = (DataRecorder)result;
                String name = recorder.getMetricName();
                if (this.metricNotReportedAction == 0) continue;
                this.currentRecorders.put(name, new WeakReference<DataRecorder>(recorder));
                this.previousRecorders.remove(name);
            }
            while (!Thread.currentThread().isInterrupted() && this.errReader.ready() && (errString = this.errReader.readLine()) != null) {
                this.fFeedback.error(this.fModule, "[ stderr ] " + errString);
            }
        }
        catch (InterruptedIOException ioe) {
            this.fFeedback.debug(this.fModule, "Plugin " + this.getName() + ", got an InterruptedIOException while stopping this plugin", (Throwable)ioe);
            Thread.currentThread().interrupt();
        }
        catch (IOException e) {
            this.fFeedback.error(this.fModule, "Error in plugin " + this.getName(), (Throwable)e);
        }
    }

    private void processMissingResults() {
        if (this.metricNotReportedAction != 0) {
            for (WeakReference wref : this.previousRecorders.values()) {
                DataRecorder recorder;
                if (wref == null || (recorder = (DataRecorder)wref.get()) == null) continue;
                switch (this.metricNotReportedAction) {
                    case 1: {
                        if (recorder instanceof StringEventDataRecorder || recorder instanceof TimestampDataRecorder) break;
                        try {
                            recorder.recordValue("0");
                        }
                        catch (IllegalValueException illegalValueException) {}
                        break;
                    }
                    case 2: {
                        recorder.reinitialize();
                    }
                }
            }
            this.previousRecorders.clear();
            this.previousRecorders.putAll(this.currentRecorders);
            this.currentRecorders.clear();
        }
    }

    public void destroyOSProcess() {
        try {
            this.fProcess.destroy();
        }
        finally {
            if (this.fProcess != null) {
                this.fProcess = null;
            }
        }
        this.fFeedback.info(this.fModule, "The process started by plugin " + this.fName + " was destroyed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIOStreams() {
        block18: {
            try {
                if (this.inBuffer == null) break block18;
                try {
                    this.inBuffer.close();
                }
                catch (IOException e) {
                    this.fFeedback.debug(this.fModule, "Error closing inBuffer. Plugin " + this.fName + ProcessPlugin.stack2string(e));
                }
                finally {
                    this.inBuffer = null;
                }
            }
            finally {
                if (this.errReader != null) {
                    try {
                        this.errReader.close();
                    }
                    catch (IOException e) {
                        this.fFeedback.debug(this.fModule, "Error closing errReader. Plugin " + this.fName + ProcessPlugin.stack2string(e));
                    }
                    finally {
                        this.errReader = null;
                    }
                }
            }
        }
    }

    public static String stack2string(Exception e) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            return "------\r\n" + sw.toString() + "------\r\n";
        }
        catch (Exception e2) {
            return "bad stack2string";
        }
    }

    static {
        try {
            Class[] paramTypes = new Class[]{Thread.class};
            Method addShutdownHookMethod = Runtime.class.getMethod("addShutdownHook", paramTypes);
            Object[] args = new Object[]{new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = threadCountLock;
                    synchronized (object) {
                        beingShutdown = true;
                        for (WeakReference weakReference : listOfPluginThreads) {
                            Thread thread = (Thread)weakReference.get();
                            if (thread == null) continue;
                            thread.interrupt();
                        }
                        if (threadCount > 0) {
                            try {
                                threadCountLock.wait(90000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                }
            }};
            addShutdownHookMethod.invoke((Object)Runtime.getRuntime(), args);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

