/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.api;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.epagent.api.EventRecorder;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import java.util.HashMap;
import java.util.Map;

public class EventRecorderImpl
implements EventRecorder {
    protected Map fEventData = new HashMap();

    public EventRecorderImpl(String eventType) {
        this.fEventData.put("type", eventType);
    }

    @Override
    public String getEventType() {
        return (String)this.fEventData.get("type");
    }

    @Override
    public void addEventData(Map data) {
        String resource = (String)data.remove("resource");
        if (resource == null) {
            resource = "_UNKNOWN_";
        }
        long startTime = System.currentTimeMillis();
        long duration = 0L;
        String durationString = (String)data.remove("duration");
        if (durationString != null) {
            try {
                duration = Long.parseLong(durationString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fEventData.putAll(data);
        String type = (String)data.get("type");
        if (type != null) {
            this.fEventData.put("Trace Type", type);
        }
        TransactionComponentData tcData = new TransactionComponentData(resource, startTime, duration, this.fEventData);
        this.addEvent(tcData);
    }

    @Override
    public void addEvent(TransactionComponentData tcData) {
        try {
            AgentShim.getAgent().IAgent_queueEvent(tcData);
        }
        catch (AgentNotAvailableException agentNotAvailableException) {
            // empty catch block
        }
    }
}

