/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.http;

import com.google.gson.Gson;
import com.wily.introscope.epagent.http.FeedBundle;
import com.wily.introscope.epagent.http.HttpServer;
import com.wily.introscope.epagent.http.HttpServerError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class EPAgentBaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONTENT = "application/json";
    private static final String CT_HEADER = "Content-Type";
    private static final String ENC_HEADER = "Content-Encoding";
    private static final String IDENTITY_ENCODING = "identity";
    private static final List<String> GZIP_ENCODINGS = Arrays.asList("gzip", "x-gzip");
    private Gson gson = new Gson();
    private Map<String, RouteEntry> routemap = new ConcurrentHashMap<String, RouteEntry>();
    private static final int kRestAPIMaxAgentLimit = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPayload(HttpServletRequest req, Class<?> feedClass) throws Exception {
        Object obj;
        if (!this.isJson(req)) {
            throw new Exception("Content must be JSON");
        }
        StringBuilder sb = new StringBuilder();
        BufferedReader rdr = null;
        GZIPInputStream gis = null;
        InputStreamReader isr = null;
        try {
            String line;
            if (this.isGzipped(req)) {
                gis = new GZIPInputStream((InputStream)req.getInputStream());
                isr = new InputStreamReader(gis);
                rdr = new BufferedReader(isr);
            } else {
                rdr = req.getReader();
            }
            while ((line = rdr.readLine()) != null) {
                sb.append(String.format("%s%n", line));
            }
            obj = this.gson.fromJson(sb.toString(), feedClass);
        }
        catch (Throwable throwable) {
            for (Reader r : new Reader[]{rdr, isr}) {
                if (r == null) continue;
                try {
                    r.close();
                }
                catch (IOException ioe) {
                    HttpServer.logError("error closing reader", ioe);
                }
            }
            if (gis != null) {
                try {
                    gis.close();
                }
                catch (IOException ioe) {
                    HttpServer.logError("error closing inputstream", ioe);
                }
            }
            throw throwable;
        }
        for (Reader r : new Reader[]{rdr, isr}) {
            if (r == null) continue;
            try {
                r.close();
            }
            catch (IOException ioe) {
                HttpServer.logError("error closing reader", ioe);
            }
        }
        if (gis != null) {
            try {
                gis.close();
            }
            catch (IOException ioe) {
                HttpServer.logError("error closing inputstream", ioe);
            }
        }
        return obj;
    }

    private boolean isGzipped(HttpServletRequest req) throws UnsupportedEncodingException {
        boolean isGzipped = false;
        ArrayList<String> otherEncodings = new ArrayList<String>();
        Enumeration headers = req.getHeaders(ENC_HEADER);
        while (headers.hasMoreElements()) {
            String encoding = (String)headers.nextElement();
            if (encoding == null) continue;
            if (GZIP_ENCODINGS.contains(encoding = encoding.toLowerCase().trim())) {
                isGzipped = true;
                break;
            }
            if (encoding.startsWith(IDENTITY_ENCODING)) break;
            otherEncodings.add(encoding);
        }
        this.validateEncodings(isGzipped, otherEncodings);
        return isGzipped;
    }

    private boolean isJson(HttpServletRequest req) {
        boolean isJson = false;
        Enumeration headers = req.getHeaders(CT_HEADER);
        block0: while (headers.hasMoreElements()) {
            String cth = (String)headers.nextElement();
            for (String s : cth.split(";")) {
                if (!CONTENT.equalsIgnoreCase(s.trim())) continue;
                isJson = true;
                continue block0;
            }
        }
        return isJson;
    }

    private void validateEncodings(boolean encoded, List<String> otherEncodings) throws UnsupportedEncodingException {
        if (!encoded && otherEncodings.size() > 0) {
            throw new UnsupportedEncodingException(String.format("Invalid Content-Encoding value(s): %s.  Only gzip encoding is supported.", this.formatEncodings(otherEncodings)));
        }
    }

    private String formatEncodings(List<String> encs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String enc : encs) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(enc);
        }
        return sb.toString();
    }

    protected void outputResult(HttpServletResponse res, HttpServerError errors, boolean caughtErrors, int numCorrect, int totals) throws IOException {
        if (caughtErrors) {
            if (numCorrect > 0) {
                errors.setValidCount(numCorrect);
                errors.setInvalidCount(totals - numCorrect);
            } else {
                errors.setInvalidCount(totals);
            }
            res.setStatus(409);
            res.addHeader(CT_HEADER, CONTENT);
            res.getWriter().append(this.gson.toJson(errors));
        } else {
            res.setStatus(200);
            res.getWriter().append(this.gson.toJson(new HttpServerError().setValidCount(totals)));
        }
    }

    protected void outputInvalidResult(HttpServletResponse res, Exception ex) throws IOException {
        HttpServerError hse = new HttpServerError(ex);
        if (ex instanceof UnsupportedEncodingException) {
            res.setStatus(415);
        } else {
            res.setStatus(400);
        }
        res.addHeader(CT_HEADER, CONTENT);
        res.getWriter().append(this.gson.toJson(hse));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String routeBundle(FeedBundle fb) throws IllegalArgumentException {
        String reqmsg;
        StringBuilder sb = new StringBuilder();
        boolean error = false;
        String[] hpa = HttpServer.getHostProcessAgent();
        String configHost = hpa[0];
        String configProcess = hpa[1];
        String configAgent = hpa[2];
        String requireTemplate = "(require: '%s')";
        String host = fb.getHost();
        if (host == null) {
            host = configHost;
        } else if (host.length() == 0) {
            error = true;
            sb.append("Invalid host " + String.format(requireTemplate, configHost));
        }
        String process = fb.getProcess();
        if (process == null) {
            process = configProcess;
        } else if (process.length() == 0) {
            reqmsg = String.format(requireTemplate, configProcess);
            if (error) {
                sb.append(" and invalid process " + reqmsg);
            } else {
                error = true;
                sb.append("Invalid process " + reqmsg);
            }
        }
        String agent = fb.getAgent();
        if (agent == null) {
            agent = configAgent;
        } else if (agent.length() == 0) {
            reqmsg = String.format(requireTemplate, configAgent);
            if (error) {
                sb.append(" and invalid agent " + reqmsg);
            } else {
                error = true;
                sb.append("Invalid agent " + reqmsg);
            }
        }
        if (error) {
            throw new IllegalArgumentException(sb.toString());
        }
        if (host.equals(configHost) && process.equals(configProcess) && agent.equals(configAgent)) {
            return null;
        }
        String route = host + "@" + process + "@" + agent;
        RouteEntry entry = this.routemap.get(route);
        if (entry == null) {
            EPAgentBaseServlet ePAgentBaseServlet = this;
            synchronized (ePAgentBaseServlet) {
                entry = this.routemap.get(route);
                if (entry == null) {
                    if (this.routemap.size() < 100) {
                        if (HttpServer.addNamedAgentBridge(route, host, process, agent)) {
                            entry = new RouteEntry();
                            entry.createTime = System.currentTimeMillis();
                            this.routemap.put(route, entry);
                        }
                    } else {
                        sb.append("Exceeded maximum allowed agent count ");
                        sb.append(100);
                        throw new IllegalArgumentException(sb.toString());
                    }
                }
            }
        }
        if (entry != null) {
            ++entry.operationCount;
            entry.accessTime = System.currentTimeMillis();
            return route;
        }
        return null;
    }

    private static class RouteEntry {
        public long createTime;
        public long accessTime;
        public long operationCount;

        private RouteEntry() {
        }
    }
}

