/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.http;

import com.wily.introscope.epagent.AgentAccessor;
import com.wily.introscope.epagent.EPAConfig;
import com.wily.introscope.epagent.HttpAgentOps;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalMetricTypeException;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.MetricClampExceededException;
import com.wily.introscope.epagent.http.HealthServlet;
import com.wily.introscope.epagent.http.LegacyServlet;
import com.wily.introscope.epagent.http.MetricServlet;
import com.wily.introscope.epagent.http.ServletFilter;
import com.wily.introscope.epagent.http.TraceServlet;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.BlockingQueue;
import javax.servlet.DispatcherType;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlet.ServletMapping;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;

public class HttpServer {
    private boolean running = false;
    private int port;
    private boolean issslEnabled = false;
    public String fPathToKeyStore = null;
    public String fPathToKeyStorePassword = null;
    public String fPathToKeyMngrPassword = null;
    private int fHttpServerMinThreadCount;
    private int fHttpServerMaxThreadCount;
    private int fHttpServerMaxQueuedCount;
    private int fHttpServerMaxIdleTimeMS;
    private int fHttpServerMaxIdleTime;
    private int fHttpServerAcceptQueueSize;
    private Server server;
    private ServletContextHandler handler;
    private EPAConfig fConfig;
    private static HttpAgentOps agentAccessor = new AgentAccessor();
    private static HttpServer self;
    private static HashMap<String, ServletHolder> servlets;

    public HttpServer(int inport) throws IllegalConfigurationException {
        this.port = inport;
        HttpServer.createSupportabilityMetrics();
        self = this;
    }

    public HttpServer(IPluginProcessor processor, int inport, int httpServerMinThreadCount, int httpServerMaxThreadCount, int httpServerMaxQueuedCount, int httpServerMaxIdleTimeMS, int httpServerMaxIdleTime, int httpServerAcceptQueueSize) throws IllegalConfigurationException {
        agentAccessor.setProcessor(processor);
        this.port = inport;
        this.fHttpServerMinThreadCount = httpServerMinThreadCount;
        this.fHttpServerMaxThreadCount = httpServerMaxThreadCount;
        this.fHttpServerMaxQueuedCount = httpServerMaxQueuedCount;
        this.fHttpServerMaxIdleTimeMS = httpServerMaxIdleTimeMS;
        this.fHttpServerMaxIdleTime = httpServerMaxIdleTime;
        this.fHttpServerAcceptQueueSize = httpServerAcceptQueueSize;
        if (processor.getConfig() != null) {
            this.fConfig = processor.getConfig();
            if (this.fConfig.isSslEnabled()) {
                this.issslEnabled = this.fConfig.isSslEnabled();
                if (this.fConfig.getKeyStorePath() != null && !this.fConfig.getKeyStorePath().isEmpty()) {
                    this.fPathToKeyStore = this.fConfig.getKeyStorePath();
                }
                if (this.fConfig.getKeyStorePassword() != null && !this.fConfig.getKeyStorePassword().isEmpty()) {
                    this.fPathToKeyStorePassword = this.fConfig.getKeyStorePassword();
                }
                if (this.fConfig.getKeyManagerPassword() != null && !this.fConfig.getKeyManagerPassword().isEmpty()) {
                    this.fPathToKeyMngrPassword = this.fConfig.getKeyManagerPassword();
                }
            }
        }
        HttpServer.createSupportabilityMetrics();
        self = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            HttpConfiguration configuration = new HttpConfiguration();
            configuration.setSendServerVersion(false);
            if (this.issslEnabled) {
                configuration.setSecurePort(this.port);
                configuration.setSecureScheme("https");
                SecureRequestCustomizer src = new SecureRequestCustomizer();
                src.setSniHostCheck(false);
                configuration.addCustomizer((HttpConfiguration.Customizer)src);
            }
            HttpConnectionFactory factory = new HttpConnectionFactory(configuration);
            SslContextFactory.Server sslContextFactory = null;
            BlockingArrayQueue queue = new BlockingArrayQueue(this.fHttpServerMinThreadCount, 8, this.fHttpServerMaxQueuedCount);
            QueuedThreadPool tp = new QueuedThreadPool(this.fHttpServerMaxThreadCount, this.fHttpServerMinThreadCount, this.fHttpServerMaxIdleTimeMS, (BlockingQueue)queue);
            this.server = new Server((ThreadPool)tp){

                public void handle(HttpChannel connection) throws IOException, ServletException {
                    Request request = connection.getRequest();
                    Response response = connection.getResponse();
                    if ("TRACE".equals(request.getMethod())) {
                        request.setHandled(true);
                        response.setStatus(405);
                    } else {
                        super.handle(connection);
                    }
                }
            };
            if (this.issslEnabled) {
                sslContextFactory = new SslContextFactory.Server();
                sslContextFactory.setKeyStorePath(this.fPathToKeyStore);
                sslContextFactory.setKeyStorePassword(this.fPathToKeyStorePassword);
                sslContextFactory.setKeyManagerPassword(this.fPathToKeyMngrPassword);
                sslContextFactory.setSniRequired(false);
            }
            this.handler = new ServletContextHandler((HandlerContainer)this.server, "/", true, false);
            this.handler.addFilter(new FilterHolder(ServletFilter.class), "/*", EnumSet.of(DispatcherType.REQUEST));
            HashMap<String, ServletHolder> hashMap = servlets;
            synchronized (hashMap) {
                for (String path : servlets.keySet()) {
                    this.handler.addServlet(servlets.get(path), path);
                }
                ServletHolder healthServlet = new ServletHolder(HealthServlet.class);
                ServletHolder traceHolder = new ServletHolder(TraceServlet.class);
                this.handler.addServlet(traceHolder, "/apm/traceFeed");
                this.handler.addServlet(healthServlet, "/healthz");
                ServerConnector connector = null;
                connector = this.issslEnabled ? new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), factory}) : new ServerConnector(this.server, new ConnectionFactory[]{factory});
                connector.setIdleTimeout((long)this.fHttpServerMaxIdleTime);
                connector.setAcceptQueueSize(this.fHttpServerAcceptQueueSize);
                connector.setPort(this.port);
                connector.setHost(null);
                this.server.setConnectors(new Connector[]{connector});
                this.server.start();
                this.running = true;
            }
        }
        catch (Exception e) {
            agentAccessor.logError("jetty start fail", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addServlet(String name, Class<? extends Servlet> servletClass, String path) {
        HashMap<String, ServletHolder> hashMap = servlets;
        synchronized (hashMap) {
            if (self != null && HttpServer.self.running) {
                HttpServer.self.handler.getServletHandler().addServletWithMapping(servletClass, path);
            } else {
                ServletHolder sh = new ServletHolder(name, servletClass);
                servlets.put(path, sh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeServlet(String path) {
        HashMap<String, ServletHolder> hashMap = servlets;
        synchronized (hashMap) {
            if (self == null || !HttpServer.self.running) {
                servlets.remove(path);
            } else {
                ServletMapping[] mappings = HttpServer.self.handler.getServletHandler().getServletMappings();
                HashSet<ServletMapping> sms = new HashSet<ServletMapping>();
                for (ServletMapping sm : mappings) {
                    String[] paths = sm.getPathSpecs();
                    HashSet<String> pa = new HashSet<String>();
                    for (String p : paths) {
                        if (p.equals(path)) continue;
                        pa.add(p);
                    }
                    if (pa.size() == paths.length) continue;
                    if (!pa.isEmpty()) {
                        sms.add(sm);
                        continue;
                    }
                    sm.setPathSpecs(pa.toArray(new String[0]));
                }
                HttpServer.self.handler.getServletHandler().setServletMappings(sms.toArray(new ServletMapping[0]));
            }
        }
    }

    static void recordMetric(String name, String type, String value, String route) throws IllegalMetricNameException, IllegalMetricTypeException, IllegalValueException, MetricClampExceededException {
        agentAccessor.recordMetric(name, type, value, route);
    }

    static void recordTrace(String source, String trace) {
        agentAccessor.recordTrace(source, trace);
    }

    static void createSupportabilityMetrics() throws IllegalConfigurationException {
        agentAccessor.createSupportabilityMetrics();
    }

    static void recordHit(long elapsedTime) {
        agentAccessor.recordHit(elapsedTime);
    }

    static void startRequest() {
        agentAccessor.startHttpRequest();
    }

    static void endRequest() {
        agentAccessor.endHttpRequest();
    }

    static String[] getHostProcessAgent() {
        return agentAccessor.getHostProcessAgent();
    }

    public static void logError(String msg, Exception e) {
        agentAccessor.logError(msg, e);
    }

    public static boolean addNamedAgentBridge(String routeName, String host, String process, String agentName) {
        return agentAccessor.addNamedAgentBridge(routeName, host, process, agentName);
    }

    public static HttpServer getServer() {
        return self;
    }

    static {
        servlets = new HashMap();
        ServletHolder sh = new ServletHolder("EPAgentLegacy", LegacyServlet.class);
        servlets.put("/", sh);
        sh = new ServletHolder("ApmMetricFeed", MetricServlet.class);
        servlets.put("/apm/metricFeed", sh);
    }
}

