/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.http;

import com.wily.introscope.epagent.http.EPAgentBaseServlet;
import com.wily.introscope.epagent.http.HttpServer;
import com.wily.introscope.epagent.http.HttpServerError;
import com.wily.introscope.epagent.http.MetricFeedBundle;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class MetricServlet
extends EPAgentBaseServlet {
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.sendError(403);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        long start = System.currentTimeMillis();
        try {
            MetricFeedBundle mfb = (MetricFeedBundle)this.getPayload(req, MetricFeedBundle.class);
            String route = this.routeBundle(mfb);
            this.submitMetrics(res, mfb, route);
        }
        catch (Exception ex) {
            this.outputInvalidResult(res, ex);
        }
        finally {
            HttpServer.recordHit(System.currentTimeMillis() - start);
        }
    }

    private void submitMetrics(HttpServletResponse res, MetricFeedBundle mfb, String route) throws Exception {
        HttpServerError metricErrors = new HttpServerError("One or more metric specifications were invalid", 1010);
        int numCorrectMetrics = 0;
        int totalMetrics = 0;
        boolean caughtMetricErrs = false;
        int indexCounter = 0;
        List<MetricFeedBundle.MetricInfo> metrics = mfb.getMetrics();
        if (metrics == null) {
            throw new RuntimeException("Missing keyword \"metrics\" in JSON payload");
        }
        totalMetrics = numCorrectMetrics = metrics.size();
        for (MetricFeedBundle.MetricInfo m : mfb.getMetrics()) {
            try {
                if (m != null) {
                    HttpServer.recordMetric(m.getName(), m.getType(), m.getValue(), route);
                } else {
                    --indexCounter;
                }
            }
            catch (Exception ex) {
                --numCorrectMetrics;
                caughtMetricErrs = true;
                metricErrors.addMetricError(m.getName(), ex, indexCounter, m);
            }
            ++indexCounter;
        }
        this.outputResult(res, metricErrors, caughtMetricErrs, numCorrectMetrics, totalMetrics);
    }
}

