/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.epa;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.introscope.epagent.EPAConfig;
import com.wily.introscope.epagent.EPAPlugin;
import com.wily.introscope.epagent.EPAgent;
import com.wily.introscope.epagent.IPluginClassLookupHelper;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.NetworkServer;
import com.wily.introscope.epagent.StaleMetricsProcessor;
import com.wily.introscope.epagent.cron.CronEntryScheduleException;
import com.wily.introscope.epagent.cron.CronService;
import com.wily.introscope.epagent.cron.ICronJob;
import com.wily.introscope.epagent.http.HttpServer;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class EPAPluginRunner
implements IPluginClassLookupHelper {
    protected final Module fModule = new Module("EPAgent");
    protected IModuleFeedbackChannel fFeedback = null;
    protected IStringLocalizer fLocalizer = null;
    private EPAConfig fConfig;
    private NetworkServer fNetworkServer;
    private HttpServer fHttpServer;
    private IntervalHeartbeat fHeartbeat;
    private CronService fCronService;
    private ExecutorService fThreadPool = null;
    private IAgent fAgent;

    public void start(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fLocalizer = agent.IAgent_getStringLocalizer();
        this.fAgent = agent;
        MultipleResourceBundleStringLocalizer epaLocalizer = new MultipleResourceBundleStringLocalizer(this.fFeedback, EPAgent.class.getClassLoader(), new String[]{"com.wily.introscope.epagent.properties.EPAgentReleaseStrings", "com.wily.introscope.epagent.properties.EPAgentStrings", "com.wily.introscope.epagent.cron.CronStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.properties.CoreCommonStrings"});
        this.fConfig = new EPAConfig(this.fFeedback, (IStringLocalizer)epaLocalizer, (IPluginClassLookupHelper)this);
        try {
            this.fConfig.parseConfig(agent.IAgent_getIndexedProperties());
        }
        catch (IllegalConfigurationException e1) {
            e1.printStackTrace();
        }
        int threadPoolSize = 0;
        boolean didSomething = false;
        if (this.fConfig.createNetworkServer()) {
            try {
                this.fNetworkServer = new NetworkServer(this.fConfig.getPluginProcessor(), this.fConfig.getNetworkPort());
            }
            catch (IllegalConfigurationException e) {
                this.fFeedback.error(this.fModule, "Invalid EPAgent Network Server configuration");
                this.fFeedback.debug(this.fModule, "NetworkServer(): ", (Throwable)e);
            }
            catch (IOException e) {
                this.fFeedback.error(this.fModule, "Failed to Create Network Server");
                this.fFeedback.debug(this.fModule, "NetworkServer(): ", (Throwable)e);
            }
            didSomething = true;
        }
        if (this.fConfig.createHttpServer()) {
            try {
                this.fHttpServer = new HttpServer(this.fConfig.getPluginProcessor(), this.fConfig.getHttpPort(), this.fConfig.getHttpServerMinThreadCount(), this.fConfig.getHttpServerMaxThreadCount(), this.fConfig.getHttpServerMaxQueuedCount(), this.fConfig.getHttpServerMaxIdleTimeMS(), this.fConfig.getHttpServerMaxIdleTime(), this.fConfig.getHttpServerAcceptQueueSize());
            }
            catch (IllegalConfigurationException e) {
                this.fFeedback.error(this.fModule, "Invalid EPAgent Http Server configuration");
                this.fFeedback.debug(this.fModule, "HttpServer(): ", (Throwable)e);
            }
            didSomething = true;
        }
        this.fHeartbeat = new IntervalHeartbeat("EPA Heartbeat", this.fFeedback, (IStringLocalizer)epaLocalizer, 1000L);
        this.fHeartbeat.start();
        this.fCronService = new CronService(this.fFeedback, (IStringLocalizer)epaLocalizer, this.fHeartbeat);
        threadPoolSize = this.fConfig.getPlugins().size();
        if (threadPoolSize > 0) {
            this.fThreadPool = Executors.newFixedThreadPool(threadPoolSize, new EPAPluginThreadFactory());
        }
        if (this.fConfig.createNetworkServer()) {
            this.fNetworkServer.start();
            didSomething = true;
        }
        if (this.fConfig.createHttpServer()) {
            this.fHttpServer.start();
            didSomething = true;
        }
        Iterator iter = this.fConfig.getPlugins().iterator();
        while (iter.hasNext()) {
            didSomething = true;
            final EPAPlugin p = (EPAPlugin)iter.next();
            if (p.isStateless()) {
                if (null != p.getSchedule()) {
                    ICronJob job = new ICronJob(){

                        public String ICronJob_getName() {
                            return p.getName();
                        }

                        public void ICronJob_run() {
                            EPAPluginRunner.this.executeInPool((Runnable)p);
                        }
                    };
                    try {
                        this.fCronService.addJob(job, p.getSchedule());
                    }
                    catch (CronEntryScheduleException e) {
                        this.fFeedback.error(this.fModule, "Invalid EPAgent Plugin configuration");
                        this.fFeedback.debug(this.fModule, "CronService.addJob()", (Throwable)e);
                    }
                    continue;
                }
                ITimestampedRunnable behavior = new ITimestampedRunnable(){

                    public void ITimestampedRunnable_execute(long millis) {
                        EPAPluginRunner.this.executeInPool((Runnable)p);
                    }
                };
                this.fHeartbeat.addBehavior(behavior, p.getName(), true, (long)p.getInterval(), true);
                continue;
            }
            new Thread((Runnable)p).start();
        }
        this.removeStaleMetrics();
        if (!didSomething) {
            this.fFeedback.warn(this.fModule, "No Usable EPAgent Servers or Plugins configured.");
        } else {
            this.fFeedback.info(this.fModule, "EPAgent Plugins successfully loaded.");
        }
    }

    void executeInPool(Runnable r) {
        try {
            if (this.fThreadPool == null) {
                this.fFeedback.debug(this.fModule, "Cannot execute plugin as thread pool has not yet been created: " + r.toString());
            } else {
                this.fThreadPool.execute(r);
            }
        }
        catch (Exception e) {
            this.fFeedback.trace(this.fModule, "Error executing plugin: " + r.toString(), (Throwable)e);
        }
    }

    public Class findClass(String className) {
        IPlugin[] plugins;
        ExtensionAdministrator admin = this.fAgent.IAgent_getExtensionAdministrator();
        for (IPlugin plugin : plugins = admin.getAgentPluginsByType("epaplugin")) {
            if (!plugin.IPlugin_getEntryPointClassName().equals(className)) continue;
            return ExtensionUtilities.loadEntryPointClass((IModuleFeedbackChannel)this.fFeedback, (IStringLocalizer)this.fLocalizer, (IPlugin)plugin, (int)-1, null, (IValidationFeedbackChannel)AInstrumentationHelper.getValidationFeedbackChannel());
        }
        return null;
    }

    public void removeStaleMetrics() {
        try {
            ScheduledExecutorService scheduledThreadPool = Executors.newScheduledThreadPool(1);
            scheduledThreadPool.scheduleAtFixedRate((Runnable)new StaleMetricsProcessor(this.fFeedback, this.fLocalizer, this.fConfig), 60L, 120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.fFeedback.error(this.fModule, "Error executing StaleMetricsProcessor", (Throwable)e);
        }
    }

    static class EPAPluginThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        EPAPluginThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "EPAgent Plugin Service " + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

