/*
 * Decompiled with CFR 0.152.
 */
package com.wily.EDU.oswego.cs.dl.util.concurrent;

import java.util.Comparator;

public class Heap {
    protected Object[] nodes_;
    protected int count_ = 0;
    protected final Comparator cmp_;

    public Heap(int capacity, Comparator cmp) throws IllegalArgumentException {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes_ = new Object[capacity];
        this.cmp_ = cmp;
    }

    public Heap(int capacity) {
        this(capacity, null);
    }

    protected int compare(Object a, Object b) {
        if (this.cmp_ == null) {
            return ((Comparable)a).compareTo(b);
        }
        return this.cmp_.compare(a, b);
    }

    protected final int parent(int k) {
        return (k - 1) / 2;
    }

    protected final int left(int k) {
        return 2 * k + 1;
    }

    protected final int right(int k) {
        return 2 * (k + 1);
    }

    public synchronized void insert(Object x) {
        if (this.count_ >= this.nodes_.length) {
            int newcap = 3 * this.nodes_.length / 2 + 1;
            Object[] newnodes = new Object[newcap];
            System.arraycopy(this.nodes_, 0, newnodes, 0, this.nodes_.length);
            this.nodes_ = newnodes;
        }
        int k = this.count_++;
        while (k > 0) {
            int par = this.parent(k);
            if (this.compare(x, this.nodes_[par]) >= 0) break;
            this.nodes_[k] = this.nodes_[par];
            k = par;
        }
        this.nodes_[k] = x;
    }

    public synchronized Object extract() {
        int l;
        if (this.count_ < 1) {
            return null;
        }
        int k = 0;
        Object least = this.nodes_[k];
        --this.count_;
        Object x = this.nodes_[this.count_];
        while ((l = this.left(k)) < this.count_) {
            int child;
            int r = this.right(k);
            int n = child = r >= this.count_ || this.compare(this.nodes_[l], this.nodes_[r]) < 0 ? l : r;
            if (this.compare(x, this.nodes_[child]) <= 0) break;
            this.nodes_[k] = this.nodes_[child];
            k = child;
        }
        this.nodes_[k] = x;
        return least;
    }

    public synchronized Object peek() {
        if (this.count_ > 0) {
            return this.nodes_[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count_;
    }

    public synchronized void clear() {
        this.count_ = 0;
    }
}

