/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.blame;

import com.wily.introscope.agent.blame.ThreadLocals;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.ICrossProcessCallback;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.IIntegerFluctuatingCounterDataAccumulatorWrapper;
import com.wily.introscope.agent.trace.cas.INotAnOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IOldModeStallSubscriber;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.WilyStringBuilder;
import com.wily.util.clock.MasterClock;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VirtualElement
implements IStackElement,
IOldModeStallSubscriber {
    private long fWallClockElapsedTime;
    private long fWallClockFinishTime;
    private final long fWallClockStartTime;
    private long fWallClockStartTransactionTime;
    private final IStackElement fParent;
    private final String fComponentName;
    private final Runnable fThread;
    private String fstallDefaultBackendComponentName;
    private ITransactionElement fStartCursor;
    private volatile ITransactionElement fCursor;
    private volatile boolean fIsStalled;
    private IInvocationDataParameterCallback fCallback;
    private int position;
    private final ITransactionCache fCache;
    private Set fSocketSet;
    private final BlameStackSnapshot snap;
    private volatile BlameStackSnapshot fUsedForStall;
    private Map<String, Object> fDataStorage = new HashMap<String, Object>(4);

    VirtualElement(String componentName, IStackElement parent, ITransactionCache cache) {
        this.fComponentName = componentName;
        this.fParent = parent;
        this.fCache = cache;
        if (this.fParent == null) {
            this.fThread = Thread.currentThread();
        } else {
            Runnable t = this.fParent.getMyThread();
            if (t == null) {
                t = Thread.currentThread();
            }
            this.fThread = t;
            this.fCursor = this.fParent.getCursor();
        }
        this.fWallClockStartTime = MasterClock.currentTimeMillis();
        this.fWallClockStartTransactionTime = -1L;
        this.fWallClockFinishTime = -1L;
        this.fWallClockElapsedTime = -1L;
        this.snap = this.computeSnapshot();
    }

    private BlameStackSnapshot computeSnapshot() {
        BlameStackSnapshot result = BlameStackSnapshot.kEmptyBlameStackSnapshot;
        if (this.fCache.getFrontend() != null) {
            result = BlameStackSnapshot.getBlameStackSnapshot(BlameStackSnapshot.kEmptyBlameStackSnapshot, this.fCache.getFrontend());
        }
        return result;
    }

    @Override
    public Object get(String name) {
        return this.fDataStorage.get(name);
    }

    @Override
    public Object put(String name, Object value) {
        return this.fDataStorage.put(name, value);
    }

    @Override
    public String getComponentName() {
        return this.fComponentName;
    }

    @Override
    public ITransactionElement getCursor() {
        return this.fCursor;
    }

    @Override
    public Iterator<ITransactionElement> getStartCursorsIterator() {
        return Arrays.asList(this.fStartCursor).iterator();
    }

    @Override
    public Runnable getMyThread() {
        return this.fThread;
    }

    @Override
    public IStackElement getParent() {
        return this.fParent;
    }

    @Override
    public ITransactionElement getStartCursorAt(int j) {
        return this.fStartCursor;
    }

    @Override
    public int getStartCursorsCount() {
        return 1;
    }

    @Override
    public long getWallClockElapsedTime() {
        if (this.fWallClockElapsedTime < 0L) {
            this.fWallClockElapsedTime = this.getWallClockFinishTime() - this.getWallClockStartTime();
        }
        return this.fWallClockElapsedTime;
    }

    @Override
    public long getWallClockFinishTime() {
        if (this.fWallClockFinishTime < 0L) {
            this.setWallClockFinishTime(MasterClock.currentTimeMillis());
        }
        return this.fWallClockFinishTime;
    }

    @Override
    public long getWallClockStartTime() {
        return this.fWallClockStartTime;
    }

    public void setWallClockFinishTime(long value) {
        this.fWallClockFinishTime = value;
    }

    @Override
    public boolean hasInvocationThrownException() {
        return false;
    }

    @Override
    public boolean isStalled() {
        return this.fIsStalled;
    }

    @Override
    public void unsetStalled() {
        this.fIsStalled = false;
    }

    public void setEndCursor(ITransactionElement cursor) {
    }

    @Override
    public void setParameterCallback(IInvocationDataParameterCallback invocationDataCallback) {
        if (invocationDataCallback instanceof ICrossProcessCallback) {
            this.fCallback = invocationDataCallback;
        }
    }

    @Override
    public void setStalled() {
        this.fIsStalled = true;
    }

    public void addParameterCallbacks(Map parameters) {
        if (this.fCallback != null) {
            ICrossProcessCallback callback = (ICrossProcessCallback)((Object)this.fCallback);
            callback.IInvocationDataParameterCallback_addParameters(this, parameters);
        }
    }

    @Override
    public void setCursor(ITransactionElement cursor) {
        this.fCursor = cursor;
    }

    public void setStartCursor(ITransactionElement cursor) {
        this.fStartCursor = cursor;
    }

    @Override
    public void markStartTransaction() {
        if (this.fWallClockStartTransactionTime < 0L) {
            this.fWallClockStartTransactionTime = MasterClock.currentTimeMillis();
        }
    }

    @Override
    public boolean hasFrontBoundary() {
        return this.fCache.getFrontend() != null;
    }

    @Override
    public ITransactionElement getLastFrontendCursor() {
        return null;
    }

    @Override
    public void setLastFrontendCursor(ITransactionElement frontendCursor) {
    }

    @Override
    public void setStartInstancePositionAt(int pos, int tracerIndex) {
        this.position = pos;
    }

    @Override
    public int getStartInstancePositionAt(int tracerIndex) {
        return this.position;
    }

    public Map getParameterCallbacks(Map parameters) {
        this.addParameterCallbacks(parameters);
        return parameters;
    }

    @Override
    public List<ITransactionInstance> getTransactionInstanceList() {
        return ThreadLocals.getStack().transactionCache.transactionInstanceList;
    }

    @Override
    public boolean isTransactionAborted() {
        if (this.fCache == null) {
            if (this.fCursor == null) {
                return false;
            }
            return this.fCursor.isNotValid();
        }
        if (this.fCache.isTransactionAborted()) {
            return true;
        }
        if (this.fCursor == null) {
            return false;
        }
        return this.fCursor.isNotValid();
    }

    @Override
    public TransactionCollectStatus getTransactionCollectionStatus() {
        return this.fCache.getTransactionCollectionStatus();
    }

    @Override
    public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
        this.fCache.setTransactionCollectStatus(tcs);
    }

    @Override
    public ITransactionElement getStartTransactionElement() {
        return this.fCache.getStartTransactionElement();
    }

    @Override
    public void setStartTransactionElement(ITransactionElement element) {
        this.fCache.setStartTransactionElement(element);
    }

    @Override
    public IStallPoint getStallPoint() {
        return this.fCache.getStallPoint();
    }

    public BlameStackSnapshot getBlameSnapshot() {
        if (this.fUsedForStall == null) {
            this.fUsedForStall = this.computeStallSnapshot();
        }
        return this.fUsedForStall;
    }

    @Override
    public IIntegerFluctuatingCounterDataAccumulatorWrapper getSubscriptionStallAccumulator(boolean isStalledItself) {
        final BlameStackSnapshot fUsedForStallLocal = this.computeStallSnapshot();
        if (isStalledItself) {
            if (this.fstallDefaultBackendComponentName != null) {
                return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                    @Override
                    public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                        return VirtualStack.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.fstallDefaultBackendComponentName);
                    }

                    @Override
                    public BlameStackSnapshot getSnapshot() {
                        return fUsedForStallLocal;
                    }
                };
            }
            return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                @Override
                public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                    return VirtualStack.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.getStallComponentName());
                }

                @Override
                public BlameStackSnapshot getSnapshot() {
                    return fUsedForStallLocal;
                }
            };
        }
        if (this.fComponentName.equals(this.fCache.getFrontend()) || this.fComponentName.equals(this.fCache.getBackend())) {
            return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                @Override
                public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                    return VirtualStack.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.getStallComponentName());
                }

                @Override
                public BlameStackSnapshot getSnapshot() {
                    return fUsedForStallLocal;
                }
            };
        }
        if (this.fstallDefaultBackendComponentName != null) {
            return new IIntegerFluctuatingCounterDataAccumulatorWrapper(){

                @Override
                public IIntegerFluctuatingCounterDataAccumulator getAccumulator() {
                    return VirtualStack.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAggregatingFluctuatingCounterDataAccumulator(VirtualElement.this.fstallDefaultBackendComponentName);
                }

                @Override
                public BlameStackSnapshot getSnapshot() {
                    return fUsedForStallLocal;
                }
            };
        }
        return null;
    }

    private String getStallComponentName() {
        return new WilyStringBuilder(128).append(this.fComponentName).append(":").append("Stall Count").toString();
    }

    private BlameStackSnapshot computeStallSnapshot() {
        if (this.snap == BlameStackSnapshot.kEmptyBlameStackSnapshot) {
            return this.snap;
        }
        if (this.fComponentName.equals(this.fCache.getBackend()) || this.fstallDefaultBackendComponentName != null) {
            return this.snap;
        }
        return BlameStackSnapshot.kEmptyBlameStackSnapshot;
    }

    @Override
    public void addAppMapSocketCursor(ITransactionElement result) {
        if (this.fSocketSet == null) {
            this.fSocketSet = new HashSet(2);
        }
        this.fSocketSet.add(result);
        this.fstallDefaultBackendComponentName = ((SocketTransactionElement)result).getComponentName() + ":" + "Stall Count";
    }

    @Override
    public Iterator getAppMapSocketCursors() {
        if (this.fSocketSet != null) {
            return this.fSocketSet.iterator();
        }
        return null;
    }

    @Override
    public void notifyStackElementOfNewCrossCorrelation(Object key) {
        this.fCache.notifyStackElementOfNewCrossCorrelation(key);
    }

    @Override
    public boolean isFinished() {
        return false;
    }

    @Override
    public void setFinished(boolean finished) {
    }

    @Override
    public void setMarkedForDiscoveryTrace(boolean discoveryTrace) {
        this.fCache.setMarkedForDiscoveryTrace(discoveryTrace);
    }

    @Override
    public boolean isMarkedForDiscoveryTrace() {
        return this.fCache.isMarkedForDiscoveryTrace();
    }

    public static class Dummy
    extends VirtualElement
    implements INotAnOldModeStallSubscriber {
        private IStackElement immediateNonDummyParent;

        protected Dummy(String componentName, IStackElement parent, ITransactionCache cache) {
            super(componentName, parent, cache);
            this.immediateNonDummyParent = parent instanceof Dummy ? ((Dummy)parent).getImmediateNonDummyParent() : parent;
        }

        public IStackElement getImmediateNonDummyParent() {
            return this.immediateNonDummyParent;
        }
    }
}

