/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.ConcurrentAgentMetricPool;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.beans.autotracing.AutoTracingTriggerServiceBean;
import com.wily.introscope.agent.connection.AgentMessageServiceRegistry;
import com.wily.introscope.agent.connection.AsyncAgentControlChannel;
import com.wily.introscope.agent.connection.AsyncObserverCallback;
import com.wily.introscope.agent.connection.ClientInfo;
import com.wily.introscope.agent.connection.CommandQueue;
import com.wily.introscope.agent.connection.ConnectedServer;
import com.wily.introscope.agent.connection.ConnectionThread;
import com.wily.introscope.agent.connection.HarvestThread;
import com.wily.introscope.agent.connection.IAgentBridgeCommand;
import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IAgentHarvester;
import com.wily.introscope.agent.connection.IAppMapAgentServiceCommand;
import com.wily.introscope.agent.connection.IConsolidableAgentCommand;
import com.wily.introscope.agent.connection.IConsolidatedAgentCommand;
import com.wily.introscope.agent.connection.IServerConnectionNotification;
import com.wily.introscope.agent.connection.IServerFailoverPolicy;
import com.wily.introscope.agent.connection.IsengardClientConnection;
import com.wily.introscope.agent.connection.NamedAgentBridgeInfo;
import com.wily.introscope.agent.connection.NamedAgentBridgeVisitor;
import com.wily.introscope.agent.connection.RenameAgentCommand;
import com.wily.introscope.agent.connection.ReportingQueue;
import com.wily.introscope.agent.connection.ServerConnectionManager;
import com.wily.introscope.agent.connection.SyncAgentControlChannel;
import com.wily.introscope.agent.connection.TimesliceAgentCommand;
import com.wily.introscope.agent.connection.TransactionAgentCommand;
import com.wily.introscope.agent.enterprise.IServerConnectionManager;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.stalemetric.StaleMetricService;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.Frequency;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.introscope.spec.server.beans.agent.IAgentManager;
import com.wily.introscope.spec.server.beans.agent.IAppMapAgentService;
import com.wily.introscope.spec.server.beans.agent.IAsyncAgentControlChannel;
import com.wily.introscope.spec.server.beans.loadbalancing.AdvancedReconnectInfo;
import com.wily.introscope.spec.server.beans.loadbalancing.ILoadBalancer;
import com.wily.introscope.spec.server.beans.loadbalancing.ILoadBalancerNotificationListener;
import com.wily.introscope.spec.server.beans.loadbalancing.LoadBalancerNotificationCallback;
import com.wily.introscope.spec.server.beans.loadbalancing.NoCollectorAvailableException;
import com.wily.introscope.spec.server.beans.loadbalancing.ReconnectInfo;
import com.wily.introscope.spec.server.beans.loadbalancing.WaitException;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.KTransactionTraceConstants;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.blame.BlameStackToCalledMetricConverter;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.IntegerTimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.isengard.IsengardException;
import com.wily.isengard.api.IIsengardClient;
import com.wily.isengard.api.ServerInstanceLocator;
import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.container.BeanActivationException;
import com.wily.isengard.container.MessageServiceRegistry;
import com.wily.isengard.message.MessageUndeliverableException;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.InvalidIsengardInterface;
import com.wily.isengard.messageprimitives.pipe.AAsyncMessagePipeEndpoint;
import com.wily.isengard.messageprimitives.pipe.EndpointNotFoundException;
import com.wily.isengard.messageprimitives.service.MessageServiceFactory;
import com.wily.isengard.messageprimitives.service.MessageServiceInfo;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.util.INameChangeListener;
import com.wily.util.ObserverAction;
import com.wily.util.ObserverTracker;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.thread.IThreadFactory;
import com.wily.wilyassert.Assertion;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;

public class IsengardServerConnectionManager
extends ServerConnectionManager
implements IIsengardClient,
IServerConnectionManager {
    private static final int kDefaultAgentBridgeCommandTimeout = 30000;
    public static final int[] kSupportedTransactionTraceFilterTypes = KTransactionTraceConstants.kAgentTransactionTraceFilterTypes;
    private static final Module sModule = new Module("IsengardServerConnectionManager");
    private volatile String fRequestedAgentName;
    private volatile String fActualAgentName;
    private volatile String fLastUsedAgentName;
    private final ObserverTracker fClientObservers;
    private final Thread fConnectionThread;
    private final ConnectionThread fConnectionRunnable;
    private final Thread fHarvestThread;
    private final HarvestThread fHarvestRunnable;
    private final IModuleFeedbackChannel fFeedbackChannel;
    private final IStringLocalizer fLocalizer;
    private final TransportConfiguration fTransportConfig;
    private final IThreadFactory fThreadFactory;
    private IExecutionQueue fExecutionQueue;
    private final IServerFailoverPolicy fFailoverPolicy;
    private ConnectedServer fConnectedServer;
    private final ReportingQueue fReportingQueue;
    private final CommandQueue fCommandQueue;
    private final BlameStackToCalledMetricConverter fMetricConverter;
    private final TransactionTraceController fTransactionTraceController;
    private final List fConnectionNotification;
    private volatile boolean fShouldSendData;
    private static boolean fSendHistoricalData = true;
    private final ClientInfo fClientInfo;
    private AsyncAgentControlChannel fAsyncAgentControlChannel;
    private SyncAgentControlChannel fSyncAgentControlChannel;
    private IAgentManager fAgentManager;
    private IAgentBridgeService fAgentBridge;
    private IAppMapAgentService fAppMapAgentService;
    private static final Map sNamedAgentBridgeMetricCache = new ConcurrentHashMap();
    private static int sMetricClampSize = 10000;
    private volatile ServerInstanceLocator fServerLocator;
    private LinkedList fNameChangeListeners;
    private Map fClassLoaderMap;
    private IsengardClientConnection fConnectionInProgress;
    private final AgentMessageServiceRegistry fMessageServiceRegistry;
    private IAgentHarvester fHarvester;
    private AtomicInteger fCommandCount;
    private volatile int fWatchdogCommandCount;
    private static StaleMetricService fStaleMetricsService = null;

    public IsengardServerConnectionManager(IServerFailoverPolicy failoverPolicy, String hostname, String ipAddress, String processName, String requestedAgentName, boolean clonedAgent, int serializationMode, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IThreadFactory threadFactory, IExecutionQueue executionQueue, TransactionTraceController transactionTraceController, IAgentHarvester harvester, IntervalHeartbeat heartbeat) throws IsengardException {
        this(failoverPolicy, hostname, ipAddress, processName, requestedAgentName, clonedAgent, serializationMode, feedback, localizer, threadFactory, executionQueue, transactionTraceController, harvester, heartbeat, null);
    }

    public IsengardServerConnectionManager(IServerFailoverPolicy failoverPolicy, String hostname, String ipAddress, String processName, String requestedAgentName, boolean clonedAgent, int serializationMode, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IThreadFactory threadFactory, IExecutionQueue executionQueue, TransactionTraceController transactionTraceController, IAgentHarvester harvester, IntervalHeartbeat heartbeat, ConfigurationManager manager) throws IsengardException {
        super(feedback);
        this.fFeedbackChannel = feedback;
        this.fLocalizer = localizer;
        this.fHarvester = harvester;
        this.fMessageServiceRegistry = new AgentMessageServiceRegistry(feedback, this);
        this.fRequestedAgentName = requestedAgentName;
        this.fClientInfo = new ClientInfo(hostname, ipAddress, processName, clonedAgent);
        this.fTransportConfig = TransportConfiguration.getDefaultClientConfiguration();
        this.fTransportConfig.setSerializationMode(serializationMode);
        this.initializeCaptureLogStream(manager);
        this.fExecutionQueue = executionQueue;
        this.fThreadFactory = threadFactory;
        this.fClientObservers = new ObserverTracker(feedback);
        this.fConnectionNotification = new LinkedList();
        this.fNameChangeListeners = new LinkedList();
        this.fTransactionTraceController = transactionTraceController;
        this.fFailoverPolicy = failoverPolicy;
        this.fReportingQueue = new ReportingQueue(manager, localizer, feedback);
        this.fCommandQueue = new CommandQueue(manager, threadFactory, localizer, feedback);
        this.fCommandQueue.start();
        this.addConnectionObserver(this.fReportingQueue);
        this.addConnectionObserver(this.fCommandQueue);
        this.addConnectionObserver(this.fMessageServiceRegistry);
        this.addNegotiatedNameChangeListener(this.fMessageServiceRegistry);
        this.fConnectionRunnable = new ConnectionThread(this, manager);
        this.fConnectionThread = threadFactory.IThreadFactory_createNewThread("Agent ServerConnection", this.fConnectionRunnable);
        this.fHarvestRunnable = new HarvestThread(this, this.fReportingQueue, manager);
        this.fHarvestThread = threadFactory.IThreadFactory_createNewThread("Agent Harvest", this.fHarvestRunnable);
        this.fMetricConverter = BlameStackToCalledMetricConverter.getInstance();
        this.fClassLoaderMap = new HashMap();
    }

    void initializeCaptureLogStream(ConfigurationManager cm) {
        ConfigurationProperty captureLogFileProperty = new ConfigurationProperty("introscope.agent.connection.capture.log.file", null, this.getFeedbackChannel(), sModule, this.fLocalizer){

            @Override
            public void set(Object value) {
                String captureLogFile = null;
                if (value instanceof String) {
                    captureLogFile = (String)value;
                }
                if (captureLogFile != null) {
                    if (captureLogFile.equals("stdout")) {
                        IsengardServerConnectionManager.this.fTransportConfig.setCaptureLogStream(System.out);
                    } else {
                        try {
                            IsengardServerConnectionManager.this.fTransportConfig.setCaptureLogStream(new FileOutputStream(captureLogFile, true));
                        }
                        catch (FileNotFoundException e) {
                            IsengardServerConnectionManager.this.fFeedbackChannel.warn("Failed to set Isengard Capture Logfile: " + e.toString());
                        }
                    }
                } else {
                    IsengardServerConnectionManager.this.fTransportConfig.setCaptureLogStream(null);
                }
            }
        };
        cm.add(captureLogFileProperty, true);
        PositiveLongConfigurationProperty limitProperty = new PositiveLongConfigurationProperty("introscope.agent.connection.capture.log.limit", null, this.getFeedbackChannel(), sModule, this.fLocalizer){

            @Override
            public void set(Object value) {
                if (value instanceof Long) {
                    long limit = (Long)value;
                    IsengardServerConnectionManager.this.fTransportConfig.setCaptureLogLimit(limit);
                }
            }
        };
        cm.add(limitProperty, true);
    }

    public void addBean(Class beanClass, Object param) throws BeanActivationException {
        ConnectedServer server = this.getConnectedServer();
        if (server == null) {
            throw new BeanActivationException("No server is connected");
        }
        server.addBean(beanClass, param);
    }

    public MessageServiceRegistry getMessageServiceRegistry() {
        return this.fMessageServiceRegistry;
    }

    public synchronized ConnectedServer getConnectedServer() {
        return this.fConnectedServer;
    }

    @Override
    public void addConnectionObserver(IServerConnectionObserver observer) {
        this.fClientObservers.addObserver(observer);
    }

    public synchronized void addConnectionObserver(IServerConnectionNotification notification) {
        if (this.isConnected()) {
            try {
                notification.connectionUp();
            }
            catch (Exception exe) {
                this.getFeedbackChannel().warn(sModule, "Error in connection observer " + notification.getClass().getName() + " while added: " + exe.toString());
                this.getFeedbackChannel().debug(sModule, "Exception: ", exe);
            }
        }
        this.fConnectionNotification.add(notification);
    }

    public synchronized void removeConnectionObserver(IServerConnectionNotification notification) {
        this.fConnectionNotification.remove(notification);
    }

    @Override
    public void connect() {
        if (!this.fConnectionThread.isAlive()) {
            this.getFeedbackChannel().trace(sModule, "connect");
            this.fConnectionThread.start();
        } else {
            this.getFeedbackChannel().trace(sModule, "ServerConnection thread is alive: not connecting");
        }
        if (!this.fHarvestThread.isAlive()) {
            this.fHarvestThread.start();
        }
    }

    @Override
    public void disconnect() {
        this.getFeedbackChannel().info(sModule, "disconnect");
        this.getFeedbackChannel().warn(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Disconnect_Message", this.getConnectedServer() == null ? "unknown" : this.getConnectedServer().getServerLocator().toString()));
        this.serverWentAway();
    }

    public synchronized void registerClassloader(String loaderName, ClassLoader loader) {
        if (this.isConnected()) {
            PostOfficeHub poHub = this.getPostOffice().getPostOfficeHub();
            poHub.registerClassLoader(loader, loaderName);
        }
        this.fClassLoaderMap.put(loaderName, loader);
    }

    public synchronized void unregisterClassloader(String loaderName) {
        ClassLoader loader = (ClassLoader)this.fClassLoaderMap.remove(loaderName);
        if (loader != null && this.isConnected()) {
            PostOfficeHub poHub = this.getPostOffice().getPostOfficeHub();
            poHub.unregisterClassLoader(loader, loaderName);
        }
    }

    public boolean addToReportingQueue(IAgentCommand command) {
        this.getFeedbackChannel().trace(sModule, "addToReportingQueue");
        return this.fReportingQueue.add(command, this.fAgentBridge);
    }

    public boolean isConnected() {
        ConnectedServer server = this.getConnectedServer();
        return server != null && server.isConnected();
    }

    public boolean isConnectedToPrimaryEM() {
        ConnectedServer server = this.getConnectedServer();
        return server != null && server.isConnectedToPrimaryEM();
    }

    public PostOffice getPostOffice() {
        ConnectedServer server = this.getConnectedServer();
        if (server == null) {
            return null;
        }
        return server.getPostOffice();
    }

    @Override
    public void connectedToIsengardServer() {
    }

    @Override
    public void lostConnectionToIsengardServer() {
        this.setStartSendingData(false);
        if (this.fAsyncAgentControlChannel != null) {
            this.fAsyncAgentControlChannel.close();
        }
        if (this.fSyncAgentControlChannel != null) {
            this.fSyncAgentControlChannel.close();
        }
        this.notifyListenersConnectionDown();
        this.fConnectionRunnable.setLostConnection(true);
    }

    private void doInitialHandshake(IsengardClientConnection connection, boolean advanced, boolean okToDisconnect) throws NoCollectorAvailableException {
        try {
            this.fAsyncAgentControlChannel = new AsyncAgentControlChannel(this, connection.getPostOffice());
            this.fSyncAgentControlChannel = new SyncAgentControlChannel(this, connection.getPostOffice());
            this.fAgentManager = MessageServiceFactory.getService(connection.getPostOffice(), IAgentManager.class);
            MessageServiceInfo agentBridgeInfo = this.fAgentManager.createNewAgentBridgeService(this.fAsyncAgentControlChannel.getPipeAddress(), this.fSyncAgentControlChannel.getServiceInfo());
            this.fAgentBridge = MessageServiceFactory.getService(this.getPostOffice(), IAgentBridgeService.class, agentBridgeInfo, 30000L);
            this.fAppMapAgentService = MessageServiceFactory.getService(this.getPostOffice(), IAppMapAgentService.class);
            this.fActualAgentName = this.fAgentBridge.handleRegisterAgent(this.fClientInfo.getHostName(), this.fClientInfo.getIPAddress(), this.fClientInfo.getProcessName(), this.fRequestedAgentName, this.fClientInfo.isClonedAgent(), okToDisconnect, this.fServerLocator.getSocketType(), this.getSupportedTransactionTraceFilterTypes());
            if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
                this.getFeedbackChannel().trace(sModule, "AGENT-NAME: doInitialHandshake - Actual Agent Name: " + this.fActualAgentName);
            }
            this.fLastUsedAgentName = this.fRequestedAgentName;
            if (!this.fRequestedAgentName.equals(this.getActualAgentName())) {
                this.negotiatedNameChanged(this.fActualAgentName);
                this.getFeedbackChannel().warn(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Reassigned_Agent_Name_Message", this.fRequestedAgentName, this.getActualAgentName()));
            }
            this.fAgentBridge.handleClientReadyToSendData();
            this.reconnectNamedAgentBridges();
        }
        catch (Exception e) {
            this.getFeedbackChannel().debug(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Isengard_Protocol_Handshake_Exception_Message"));
            this.getFeedbackChannel().debug(e);
            if (this.fAsyncAgentControlChannel != null) {
                this.fAsyncAgentControlChannel.close();
            }
            if (this.fSyncAgentControlChannel != null) {
                this.fSyncAgentControlChannel.close();
            }
            throw new NoCollectorAvailableException();
        }
    }

    private int[] getSupportedTransactionTraceFilterTypes() {
        ArrayList typesList = new ArrayList(this.fTransactionTraceController.getSupportedTransactionTraceFilterTypes());
        int[] types = new int[typesList.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = (Integer)typesList.get(i);
        }
        return types;
    }

    ClientInfo getClientInfo() {
        return this.fClientInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersConnectionUp() {
        IsengardServerConnectionManager isengardServerConnectionManager = this;
        synchronized (isengardServerConnectionManager) {
            IServerConnectionNotification[] listeners = this.fConnectionNotification.toArray(new IServerConnectionNotification[0]);
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].connectionUp();
                    continue;
                }
                catch (Exception exe) {
                    this.getFeedbackChannel().warn(sModule, "Error in connection observer " + listeners[i].getClass().getName() + " while connectionUp: " + exe.toString());
                    this.getFeedbackChannel().debug(sModule, "Exception: ", exe);
                }
            }
        }
        this.asyncNotifyObservers(new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                ((IServerConnectionObserver)observer).serverConnected();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersConnectionDown() {
        IsengardServerConnectionManager isengardServerConnectionManager = this;
        synchronized (isengardServerConnectionManager) {
            IServerConnectionNotification[] listeners = this.fConnectionNotification.toArray(new IServerConnectionNotification[0]);
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    listeners[i].connectionDown();
                    continue;
                }
                catch (Exception exe) {
                    this.getFeedbackChannel().warn(sModule, "Error in connection observer " + listeners[i].getClass().getName() + " while connectionDown: " + exe.toString());
                    this.getFeedbackChannel().debug(sModule, "Exception: ", exe);
                }
            }
        }
        this.asyncNotifyObservers(new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                ((IServerConnectionObserver)observer).serverDisconnected();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReconnectInfo connectInternal(ServerInstanceLocator serverLocator, boolean isLoadBalanced) throws IOException, IsengardException, NoCollectorAvailableException, Exception {
        this.getFeedbackChannel().trace(sModule, "connectInternal");
        this.fServerLocator = serverLocator;
        IsengardClientConnection localConnection = this.fConnectionInProgress = new IsengardClientConnection(this.getTransportConfig(), serverLocator, null, this.getThreadFactory(), this.getFeedbackChannel(), this);
        try {
            localConnection.connect();
            this.registerClassLoaders(localConnection.getPostOffice());
            IsengardServerConnectionManager isengardServerConnectionManager = this;
            synchronized (isengardServerConnectionManager) {
                this.fConnectedServer = new ConnectedServer(localConnection, this.getFailoverPolicy(), this.fServerLocator);
                this.fWatchdogCommandCount = 0;
            }
            int metricCount = 0;
            this.getAgent().IAgent_getMetricRecordingAdministrator().getMetricCount();
            ILoadBalancer loadBalancer = MessageServiceFactory.getServiceSafe(localConnection.getPostOffice(), ILoadBalancer.class);
            ReconnectInfo reconnectInfo = null;
            while (true) {
                try {
                    reconnectInfo = loadBalancer.getCollectorToReconnectTo(this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), this.fRequestedAgentName, metricCount, serverLocator.getSocketType());
                }
                catch (WaitException e) {
                    this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Wait_Message", String.valueOf(e.getWaitTime()), this.getConnectedServer().getServerLocator().toString()));
                    if (e.getWaitTime() <= 0L) continue;
                    try {
                        Thread.sleep(e.getWaitTime());
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            if (reconnectInfo != null) {
                return reconnectInfo;
            }
            this.fTransactionTraceController.restartRecording();
            this.doInitialHandshake(localConnection, false, isLoadBalanced);
            this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Connection_Successful_Message", this.getCurrentServer().toString(), this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), this.getActualAgentName()));
            this.notifyListenersConnectionUp();
            return null;
        }
        catch (Exception e) {
            localConnection.tearDownConnection();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AdvancedReconnectInfo connectInternalAdvanced(ServerInstanceLocator serverLocator, boolean hasFallbacks) throws IOException, IsengardException, NoCollectorAvailableException, Exception {
        this.getFeedbackChannel().trace(sModule, "connectInternalAdvanced");
        this.fServerLocator = serverLocator;
        String credential = this.getAgent().IAgent_getIndexedProperties().getProperty("agentManager.credential");
        IsengardClientConnection localConnection = this.fConnectionInProgress = new IsengardClientConnection(this.getTransportConfig(), serverLocator, credential, this.getThreadFactory(), this.getFeedbackChannel(), this);
        try {
            localConnection.connect();
            this.registerClassLoaders(localConnection.getPostOffice());
            IsengardServerConnectionManager isengardServerConnectionManager = this;
            synchronized (isengardServerConnectionManager) {
                this.fConnectedServer = new ConnectedServer(localConnection, this.getFailoverPolicy(), this.fServerLocator);
                this.fWatchdogCommandCount = 0;
            }
            int metricCount = 0;
            try {
                metricCount = AgentShim.getAgent().IAgent_getMetricRecordingAdministrator().getMetricCount();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                // empty catch block
            }
            ILoadBalancer loadBalancer = MessageServiceFactory.getServiceSafe(localConnection.getPostOffice(), ILoadBalancer.class);
            AdvancedReconnectInfo advancedReconnectInfo = null;
            while (true) {
                try {
                    advancedReconnectInfo = loadBalancer.getCollectorReconnectList(this.fClientInfo.getHostName(), this.fClientInfo.getIPAddress(), this.fClientInfo.getProcessName(), this.fRequestedAgentName, metricCount, serverLocator.getSocketType(), hasFallbacks);
                }
                catch (WaitException e) {
                    this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Enterprise_Manager_Connection_Wait_Message", String.valueOf(e.getWaitTime()), this.getConnectedServer().getServerLocator().toString()));
                    if (e.getWaitTime() <= 0L) continue;
                    try {
                        Thread.sleep(e.getWaitTime());
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
            boolean sendData = advancedReconnectInfo.getAllowSend();
            this.doInitialize(localConnection, loadBalancer, sendData);
            return advancedReconnectInfo;
        }
        catch (Exception e) {
            localConnection.tearDownConnection();
            throw e;
        }
    }

    private void doInitialize(IsengardClientConnection localConnection, ILoadBalancer loadBalancer, boolean sendData) throws ConnectionException, EndpointNotFoundException, NoCollectorAvailableException {
        this.fTransactionTraceController.restartRecording();
        if (sendData) {
            this.doInitialHandshake(localConnection, true, true);
        }
        this.fCommandCount = new AtomicInteger(0);
        this.fWatchdogCommandCount = -1;
        this.setStartSendingData(sendData);
        this.notifyListenersConnectionUp();
        String agentName = this.fActualAgentName == null ? this.fRequestedAgentName : this.fActualAgentName;
        String qualifiedAgentName = this.getQualifiedAgentName(this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), agentName);
        LoadBalancerNotificationCallback callback = new LoadBalancerNotificationCallback(localConnection.getPostOffice(), new LoadBalancerNotificationListener());
        loadBalancer.registerLoadBalancerNotification(callback, qualifiedAgentName);
        this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Advanced_Connection_Successful_Message", this.getCurrentServer().toString(), this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), agentName, String.valueOf(sendData)));
    }

    private String getQualifiedAgentName(String agentHost, String agentProcess, String agentName) {
        String SEPARATOR = "|";
        StringBuilder qualifiedAgentName = new StringBuilder();
        qualifiedAgentName.append(agentHost);
        qualifiedAgentName.append("|");
        qualifiedAgentName.append(agentProcess);
        qualifiedAgentName.append("|");
        qualifiedAgentName.append(agentName);
        return qualifiedAgentName.toString();
    }

    private final synchronized void registerClassLoaders(PostOffice po) {
        PostOfficeHub poHub = po.getPostOfficeHub();
        for (Map.Entry entry : this.fClassLoaderMap.entrySet()) {
            poHub.registerClassLoader((ClassLoader)entry.getValue(), (String)entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serverWentAway() {
        this.getFeedbackChannel().info(sModule, "serverWentAway");
        IsengardServerConnectionManager isengardServerConnectionManager = this;
        synchronized (isengardServerConnectionManager) {
            if (this.isConnected()) {
                this.getFeedbackChannel().warn(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Connection_Lost_Message", this.fConnectionInProgress.getClientTransportString()));
                this.fConnectionInProgress.tearDownConnection();
                this.fConnectionInProgress = null;
            }
        }
        this.getFeedbackChannel().trace(sModule, "serverWentAway after tearing down connection");
    }

    void setStartSendingData(boolean sendData) {
        if (sendData && !this.fShouldSendData && !this.fReportingQueue.isWaitingForInitialTimeSlice() && this.fReportingQueue.isBufferingWhileOffline()) {
            this.fHarvester.resendConstantMetricsAtNextHarvest();
        }
        this.fShouldSendData = sendData;
    }

    @Override
    public boolean shouldSendData() {
        return this.fShouldSendData;
    }

    boolean sendNextItem() throws Exception {
        if (this.getFeedbackChannel().isTraceEnabled(sModule)) {
            this.getFeedbackChannel().trace(sModule, "sendNextItem");
        }
        boolean isSuccessful = this.fReportingQueue.handleNextAgentCommand();
        this.fCommandCount.incrementAndGet();
        return isSuccessful;
    }

    void handleReceiveActualAgentName(String agentName) {
        this.fActualAgentName = agentName;
        this.negotiatedNameChanged(agentName);
        this.getFeedbackChannel().info(sModule, this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Actual_Agent_Name_Change_Message", this.getActualAgentName()));
    }

    void tellObserversAboutMetricShutoff(final AgentMetric metric, boolean isShutoff) {
        this.getFeedbackChannel().trace(sModule, "tellObserversAboutMetricShutoff : metric = " + metric.toString() + " ; isShutoff = " + isShutoff);
        ObserverAction action = null;
        action = isShutoff ? new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                typedObserver.agentControlStopReportingMetric(metric);
            }
        } : new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                typedObserver.agentControlStartReportingMetric(metric);
            }
        };
        this.asyncNotifyObservers(action);
    }

    void tellObserversToUpdateTTFilter(final ITransactionTraceFilter filter, boolean add) {
        ObserverAction action = null;
        if (add) {
            this.getFeedbackChannel().trace(sModule, "tellObserversToAddTransactionTraceFilter");
            action = new ObserverAction(){

                @Override
                public void doAction(Object observer, Object unused) {
                    IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                    typedObserver.agentControlAddTTFilter(filter);
                }
            };
        } else {
            this.getFeedbackChannel().trace(sModule, "tellObserversToRemoveTransactionTraceFilter");
            action = new ObserverAction(){

                @Override
                public void doAction(Object observer, Object unused) {
                    IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                    typedObserver.agentControlRemoveTTFilter(filter);
                }
            };
        }
        this.asyncNotifyObservers(action);
    }

    void tellObserversAboutEnablingChange(final boolean isEnabled) {
        this.getFeedbackChannel().trace(sModule, "tellObserversAboutEnablingChange : isEnabled = " + isEnabled);
        this.asyncNotifyObservers(new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                typedObserver.agentControlSetReportingState(isEnabled);
            }
        });
    }

    void tellObserversAboutFailedConnectionCycle(final int cycleCount) {
        this.getFeedbackChannel().trace(sModule, "tellObserversAboutFailedConnectionCycle");
        this.asyncNotifyObservers(new ObserverAction(){

            @Override
            public void doAction(Object observer, Object unused) {
                IServerConnectionObserver typedObserver = (IServerConnectionObserver)observer;
                typedObserver.serverConnectionCycleFailed(cycleCount);
            }
        });
    }

    IServerFailoverPolicy getFailoverPolicy() {
        return this.fFailoverPolicy;
    }

    @Override
    IModuleFeedbackChannel getFeedbackChannel() {
        return this.fFeedbackChannel;
    }

    IStringLocalizer getStringLocalizer() {
        return this.fLocalizer;
    }

    ServerInstanceLocator getCurrentServer() {
        return this.fServerLocator;
    }

    public TransportConfiguration getTransportConfig() {
        return this.fTransportConfig;
    }

    private IThreadFactory getThreadFactory() {
        return this.fThreadFactory;
    }

    void asyncNotifyObservers(ObserverAction action) {
        this.getExecutionQueue().IExecutionQueue_addExecutableItem(new AsyncObserverCallback(this, action));
    }

    void syncNotifyObservers(ObserverAction action) {
        this.fClientObservers.forEachObserverDo(action, null);
    }

    @Override
    public String getActualAgentName() {
        return this.fActualAgentName;
    }

    @Override
    public synchronized void addNegotiatedNameChangeListener(INameChangeListener listener) {
        this.fNameChangeListeners.add(listener);
        if (this.fActualAgentName != null) {
            this.fExecutionQueue.IExecutionQueue_addExecutableItem(new NotifyNameChange(listener, this.fActualAgentName));
        }
    }

    @Override
    public synchronized void removeNegotiatedNameChangeListener(INameChangeListener listener) {
        this.fNameChangeListeners.remove(listener);
    }

    public synchronized void negotiatedNameChanged(String name) {
        Iterator i = this.fNameChangeListeners.iterator();
        while (i.hasNext()) {
            this.fExecutionQueue.IExecutionQueue_addExecutableItem(new NotifyNameChange((INameChangeListener)i.next(), this.getActualAgentName()));
        }
    }

    @Override
    public void reportTransactions(TransactionComponentData[] transactions) {
        this.getFeedbackChannel().trace(sModule, "reportTransactions");
        if (this.getAgent().IAgent_getPlatformServerConnection() != null) {
            this.fReportingQueue.sendingMetricFromPlatform();
        }
        if (this.getIsAgentBridgeInitialized().get()) {
            this.reportTransactionsForNamedAgentBridges(transactions);
        } else {
            this.addToReportingQueue(new TransactionAgentCommand(null, this, transactions));
        }
    }

    private void reportTransactionsForNamedAgentBridges(TransactionComponentData[] transactions) {
        String name;
        ArrayList<TransactionComponentData> regularTransactionList = new ArrayList<TransactionComponentData>();
        HashMap<String, ArrayList<TransactionComponentData>> txListMap = new HashMap<String, ArrayList<TransactionComponentData>>();
        for (int i = 0; i < transactions.length; ++i) {
            TransactionComponentData root;
            TransactionComponentData cur = root = transactions[i];
            name = null;
            String component = cur.getResource();
            while (!component.startsWith("!BRIDGE!") && cur.getSubNodeCount() == 1) {
                cur = cur.getSubNodes()[0];
                component = cur.getResource();
            }
            if (component.startsWith("!BRIDGE!")) {
                int index = component.indexOf("|");
                name = index > 0 ? component.substring("!BRIDGE!".length(), index) : component.substring("!BRIDGE!".length());
                ArrayList<TransactionComponentData> l = (ArrayList<TransactionComponentData>)txListMap.get(name);
                if (l == null) {
                    l = new ArrayList<TransactionComponentData>();
                    txListMap.put(name, l);
                }
                IsengardServerConnectionManager.cleanBridgeRoutingPrefix(root);
                l.add(root);
            }
            if (name != null) continue;
            regularTransactionList.add(root);
        }
        for (Map.Entry e : txListMap.entrySet()) {
            IAgentBridgeService bridge;
            name = (String)e.getKey();
            List txs = (List)e.getValue();
            NamedAgentBridgeInfo entry = this.getfNamedAgentBridges().get(name);
            if (entry == null || (bridge = entry.getAgentBridge()) == null || txs == null || txs.isEmpty()) continue;
            TransactionComponentData[] array = txs.toArray(new TransactionComponentData[0]);
            this.addToReportingQueue(new TransactionAgentCommand(name, this, array));
        }
        if (!regularTransactionList.isEmpty()) {
            TransactionComponentData[] array = regularTransactionList.toArray(new TransactionComponentData[0]);
            this.addToReportingQueue(new TransactionAgentCommand(null, this, array));
        }
    }

    public static String cleanBridgeRoutingPrefix(String path) {
        String cleanedPath = path;
        if (path.startsWith("!BRIDGE!")) {
            int index = path.indexOf("|");
            cleanedPath = index > 0 && index < path.length() ? path.substring(index + 1) : path.substring("!BRIDGE!".length());
        }
        return cleanedPath;
    }

    static void cleanBridgeRoutingPrefix(TransactionComponentData root) {
        String component = root.getResource();
        root.setResource(IsengardServerConnectionManager.cleanBridgeRoutingPrefix(component));
        String param = root.getParameterValue("Error Message");
        if (param != null) {
            root.setParameterValue("Error Message", IsengardServerConnectionManager.cleanBridgeRoutingPrefix(param));
        }
        if ((param = root.getParameterValue("Resource Name")) != null) {
            root.setParameterValue("Resource Name", IsengardServerConnectionManager.cleanBridgeRoutingPrefix(param));
        }
        if ((param = root.getParameterValue("Exception")) != null) {
            root.setParameterValue("Exception", IsengardServerConnectionManager.cleanBridgeRoutingPrefix(param));
        }
        for (int i = 0; i < root.getSubNodeCount(); ++i) {
            IsengardServerConnectionManager.cleanBridgeRoutingPrefix((TransactionComponentData)root.getSubNode(i));
        }
    }

    public void reportTransactionsINTERNAL(TransactionComponentData[] transactions) throws Exception {
        new TransactionAgentCommand(null, this, transactions).handleAgentCommand();
    }

    @Override
    public void reportTimeslice(AgentMetric[] newMetrics, AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, int timesliceType) {
        this.reportTimeslice(timeslicedBindings, deadMetrics, timesliceType);
    }

    private static int getMetricClampSize() {
        int value;
        AgentMetric.IAgentMetricPool pool = AgentMetric.getAgentMetricPool();
        int clamp = 50000;
        if (pool instanceof ConcurrentAgentMetricPool && (value = ((ConcurrentAgentMetricPool)pool).getMetricClamp()) > 0) {
            clamp = value;
        }
        return clamp;
    }

    @Override
    protected boolean addToReportingQueue(String name, int timesliceType, List<AgentMetric> deadMetricsList, AgentMetricData[] allbindings, String qualifiedAgent) {
        AgentMetric[] emptyArray = new AgentMetric[]{};
        AgentMetric[] dead = deadMetricsList != null ? deadMetricsList.toArray(emptyArray) : emptyArray;
        this.addToReportingQueue(new TimesliceAgentCommand(name, this, allbindings, dead, timesliceType == 1));
        return false;
    }

    public void reportTimesliceINTERNAL(AgentMetric[] newMetrics, AgentMetricData[] timeslicedBindings, AgentMetric[] deadMetrics, boolean initialTimeslice) throws Exception {
        new TimesliceAgentCommand(null, this, timeslicedBindings, deadMetrics, initialTimeslice).handleAgentCommand();
    }

    @Override
    public boolean reportClientNameChange(String newName) {
        this.getFeedbackChannel().trace(sModule, "reportClientNameChange");
        this.fRequestedAgentName = newName;
        if (this.fLastUsedAgentName == null || !this.fLastUsedAgentName.equals(this.fRequestedAgentName)) {
            return this.addToCommandQueue(new RenameAgentCommand(this.fRequestedAgentName, this.getActualAgentName(), this.fClientInfo, this.getFeedbackChannel(), this.getStringLocalizer(), this.fHarvester));
        }
        this.getFeedbackChannel().info(sModule, "Requested new agent name is already used by connection thread while connecting to EM. Ignoring the client name change request");
        return true;
    }

    public void reportDynamicInstrumentationStatusChanged(final int newStatus, final IReportQueueCallback callback) {
        this.getFeedbackChannel().debug(sModule, "reportDynamicInstrumentationStatusChange");
        this.addToCommandQueue(new IAgentBridgeCommand(){

            @Override
            public void handleAgentCommand(IAgentBridgeService service) throws ConnectionException {
                service.handleClientDynamicStatusChanged(newStatus);
            }

            @Override
            public void onAgentCommandCompletion(int status) {
                callback.noticeSuccess();
            }
        });
    }

    public boolean addToCommandQueue(IAgentBridgeCommand command) {
        if (command != null) {
            AgentCommandBridgeWrapper wrapper = new AgentCommandBridgeWrapper(command, this.fAgentBridge, this.fConnectedServer);
            return this.fCommandQueue.add(wrapper);
        }
        this.getFeedbackChannel().debug(sModule, "Attempt to queue null command ignored.");
        return false;
    }

    public boolean addToCommandQueue(IAppMapAgentServiceCommand command) {
        if (command != null) {
            AgentCommandAppMapServiceWrapper wrapper = new AgentCommandAppMapServiceWrapper(command, this.fAppMapAgentService, this.fConnectedServer);
            return this.fCommandQueue.add(wrapper);
        }
        this.getFeedbackChannel().debug(sModule, "Attempt to queue null command ignored.");
        return false;
    }

    private IExecutionQueue getExecutionQueue() {
        return this.fExecutionQueue;
    }

    @Override
    public void setMetricShutoffState(final AgentMetric metric, final boolean isShutoff) {
        this.getFeedbackChannel().trace(sModule, "setMetricShutoffState");
        this.addToCommandQueue(new IAgentBridgeCommand(){

            @Override
            public void handleAgentCommand(IAgentBridgeService service) throws ConnectionException {
                service.setMetricShutoffState(metric, isShutoff);
            }

            @Override
            public void onAgentCommandCompletion(int status) {
            }
        });
    }

    public boolean harvest(int type, boolean harvestTraces) {
        this.fHarvester.harvest(MasterClock.currentTimeMillis(), type, harvestTraces);
        return true;
    }

    public boolean sendData() {
        boolean keepSending = true;
        while (keepSending) {
            try {
                keepSending = this.sendNextItem();
            }
            catch (MessageUndeliverableException mue) {
                if (!this.getConnectedServer().getPostOffice().isClosed()) {
                    this.getFeedbackChannel().error(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reporter_Exception_Message"));
                    if (this.getFeedbackChannel().isVerboseEnabled(sModule)) {
                        this.getFeedbackChannel().verbose(mue);
                    }
                }
                return false;
            }
            catch (Exception e) {
                this.getFeedbackChannel().error(sModule, this.getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_JIP_Protocol_Reporter_Exception_Message"));
                if (this.getFeedbackChannel().isVerboseEnabled(sModule)) {
                    this.getFeedbackChannel().verbose(e);
                }
                return false;
            }
        }
        return true;
    }

    public long getAgentHarvestTimeMillis() {
        return this.fHarvester.getHarvestPeriodInMillis();
    }

    public synchronized void watchDog() {
        ConnectedServer server = this.getConnectedServer();
        if (server != null && server.isConnected()) {
            if (this.fWatchdogCommandCount == this.fCommandCount.get()) {
                this.getFeedbackChannel().warn("Enterprise Manager responding too slowly, disconnecting");
                server.forceDisconnect();
            }
            this.fWatchdogCommandCount = this.fCommandCount.get();
        }
    }

    @Override
    protected void connectNamedAgentBridge(NamedAgentBridgeInfo entry) {
        try {
            ConnectedServer server = this.getConnectedServer();
            NamedAsyncAgentControlChannel asyncAgentControlChannel = new NamedAsyncAgentControlChannel(this, this.fAsyncAgentControlChannel.getPostOffice(), entry.getName());
            SyncAgentControlChannel syncAgentControlChannel = new SyncAgentControlChannel(this, this.fSyncAgentControlChannel.getPostOffice());
            MessageServiceInfo info = this.fAgentManager.createNewAgentBridgeService(asyncAgentControlChannel.getPipeAddress(), syncAgentControlChannel.getServiceInfo());
            IAgentBridgeService bridge = MessageServiceFactory.getService(this.getPostOffice(), IAgentBridgeService.class, info, 30000L);
            if (this.getFeedbackChannel().isDebugEnabled(sModule)) {
                this.getFeedbackChannel().debug(sModule, "AGENT-NAME: connectNamedAgentBridge Agent Name: " + entry.getAgentName() + ",  Actual Agent Name: " + this.fActualAgentName);
            }
            if (entry.getHost() == null) {
                entry.setHost(this.fClientInfo.getHostName());
            }
            if (entry.getIpaddr() == null) {
                entry.setIpaddr(this.fClientInfo.getIPAddress());
            }
            bridge.handleRegisterAgent(entry.getHost(), entry.getIpaddr(), entry.getProcess(), entry.getAgentName(), this.fClientInfo.isClonedAgent(), false, this.fServerLocator.getSocketType(), this.getSupportedTransactionTraceFilterTypes());
            entry.setAgentBridge(bridge);
            entry.setAsyncControlChannel(asyncAgentControlChannel);
            IAgent agent = entry.getAgent();
            if (agent == null) {
                entry.setAgent(new NamedAgentAdapter(this.getAgent(), entry));
            }
            server.addBean(AutoTracingTriggerServiceBean.class, entry.getAgent());
            String[] agentTriplet = this.getAgent().IAgent_getHostProcessAgentTriplet();
            String hostingAgent = agentTriplet[0] + "|" + agentTriplet[1] + "|" + agentTriplet[2];
            long now = System.currentTimeMillis();
            AgentMetricData metric = new AgentMetricData(new AgentMetric(":Hosting Infrastructure Agent", 21), Frequency.kDefaultAgentFrequency, new StringTimeslicedValue(21, now, now, null, hostingAgent));
            AgentMetricData metricAgentType = new AgentMetricData(new AgentMetric(":Agent Type", 21), Frequency.kDefaultAgentFrequency, new StringTimeslicedValue(21, now, now, null, entry.getAgentType()));
            bridge.recordTimesliceBindingList(new AgentMetricData[]{metric, metricAgentType});
        }
        catch (ConnectionException e) {
            this.getFeedbackChannel().error(sModule, "Failed to connect agent bridge: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
        catch (ServiceException e) {
            this.getFeedbackChannel().error(sModule, "Failed to connect agent bridge: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
        catch (InvalidIsengardInterface e) {
            this.getFeedbackChannel().error(sModule, "Failed to connect agent bridge: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
        catch (BeanActivationException e) {
            this.getFeedbackChannel().error(sModule, "Failed to connect agent bridge: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
        catch (BadlyFormedNameException e) {
            this.getFeedbackChannel().error(sModule, "Failed to connect agent bridge: " + e.getMessage());
            this.getFeedbackChannel().debug(e);
        }
    }

    @Override
    protected Module getModule() {
        return sModule;
    }

    @Override
    public void addNamedAgentBridge(String name, String host, String ipaddr, String process, String agent) {
        this.addNamedAgentBridge(new NamedAgentBridgeInfo(name, host, ipaddr, process, agent, null, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reportNamedAgentMetrics(int timesliceType, Map deadMetricsMap, String name, List bindings, NamedAgentBridgeInfo entry) {
        if (entry != null) {
            IAgentBridgeService bridge = entry.getAgentBridge();
            if (bridge == null && this.shouldSendData()) {
                Lock lock = this.getLockByKey().lock(name);
                try {
                    if (entry.getAgentBridge() == null) {
                        this.connectNamedAgentBridge(entry);
                    }
                }
                finally {
                    this.getLockByKey().unlock(name, lock);
                }
                bridge = entry.getAgentBridge();
            }
            if (bridge != null && bindings != null && !bindings.isEmpty()) {
                this.reportQualifiedAgentMetrics(timesliceType, deadMetricsMap, name, bindings, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void addNamedAgentBridge(NamedAgentBridgeInfo namedAgentBridgeInfo) {
        name = namedAgentBridgeInfo.getName();
        if (name == null) {
            return;
        }
        if (!this.getIsAgentBridgeInitialized().get()) {
            this.getIsAgentBridgeInitialized().compareAndSet(false, true);
            IsengardServerConnectionManager.sMetricClampSize = IsengardServerConnectionManager.getMetricClampSize();
            if (this.getFeedbackChannel().isTraceEnabled(IsengardServerConnectionManager.sModule)) {
                this.getFeedbackChannel().trace(IsengardServerConnectionManager.sModule, "AGENT-NAME: addNamedAgentBridge First Time - Actual Agent Name: " + this.fActualAgentName);
            }
        }
        if ((entry = this.getfNamedAgentBridges().get(name)) == null) {
            lock = this.getLockByKey().lock(name);
            try {
                if (this.getfNamedAgentBridges().containsKey(name)) ** GOTO lbl25
                server = this.getConnectedServer();
                if (server != null && server.isConnected() && this.shouldSendData()) {
                    this.connectNamedAgentBridge(namedAgentBridgeInfo);
                    this.getAgent().IAgent_getEnvironmentAdministrator().reportNamedAgentBridgeInformation(namedAgentBridgeInfo);
                }
                this.getfNamedAgentBridges().put(name, namedAgentBridgeInfo);
            }
            finally {
                this.getLockByKey().unlock(name, lock);
            }
        } else {
            ++entry.fInstanceCount;
        }
lbl25:
        // 3 sources

        if ((platformServerConnectionManager = this.getAgent().IAgent_getPlatformServerConnection()) != null) {
            if (this.getIsAgentBridgeInitialized().get()) {
                platformServerConnectionManager.getIsAgentBridgeInitialized().compareAndSet(false, true);
            }
            platformServerConnectionManager.getfNamedAgentBridges().putAll(this.getfNamedAgentBridges());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNamedAgentBridge(String name) {
        if (name == null) {
            return;
        }
        if (!this.getIsAgentBridgeInitialized().get()) {
            return;
        }
        Lock lock = this.getLockByKey().lock(name);
        try {
            NamedAgentBridgeInfo entry = this.getfNamedAgentBridges().get(name);
            if (entry == null) {
                return;
            }
            if (entry.fInstanceCount > 1) {
                --entry.fInstanceCount;
                return;
            }
            IAgentBridgeService bridge = entry.getAgentBridge();
            try {
                if (bridge != null) {
                    bridge.handleClientDisconnect();
                }
            }
            catch (ConnectionException e) {
                this.getFeedbackChannel().error(sModule, "Failed to disconnect agent bridge: " + e.getMessage());
                this.getFeedbackChannel().debug(e);
            }
            this.getfNamedAgentBridges().remove(name);
        }
        finally {
            this.getLockByKey().unlock(name, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectNamedAgentBridges() {
        if (!this.getIsAgentBridgeInitialized().get()) {
            return;
        }
        for (Map.Entry<String, NamedAgentBridgeInfo> mapEntry : this.getfNamedAgentBridges().entrySet()) {
            NamedAgentBridgeInfo entry = mapEntry.getValue();
            String name = mapEntry.getKey();
            Lock lock = this.getLockByKey().lock(name);
            try {
                this.connectNamedAgentBridge(entry);
            }
            finally {
                this.getLockByKey().unlock(name, lock);
            }
        }
    }

    @Override
    public void acceptNamedAgentBridgeVisitor(NamedAgentBridgeVisitor v) {
        if (!this.getIsAgentBridgeInitialized().get()) {
            return;
        }
        for (NamedAgentBridgeInfo info : this.getfNamedAgentBridges().values()) {
            v.visit(info);
        }
    }

    public IAgentBridgeService getAgentBridgeServiceByName(String name) {
        if (name == null || !this.getIsAgentBridgeInitialized().get()) {
            return this.fAgentBridge;
        }
        NamedAgentBridgeInfo info = this.getfNamedAgentBridges().get(name);
        if (info != null && info.getAgentBridge() != null) {
            return info.getAgentBridge();
        }
        return this.fAgentBridge;
    }

    public static StaleMetricService getStaleMetricsService() {
        return fStaleMetricsService;
    }

    public static void setStaleMetricsService(StaleMetricService service) {
        fStaleMetricsService = service;
    }

    public void setSendHistoricalData(boolean value) {
        fSendHistoricalData = value;
        if (value) {
            this.fReportingQueue.turnOnBufferingWhileOffline();
        } else {
            this.fReportingQueue.turnOffBufferingWhileOffline();
        }
    }

    public static void turnOffSendHistoricalData() {
        fSendHistoricalData = false;
    }

    public static boolean getSendHistoricalData() {
        return fSendHistoricalData;
    }

    public static class NamedAgentAdapter
    extends AgentAdapter {
        private final NamedAgentBridgeInfo fInfo;

        public NamedAgentAdapter(IAgent delegate, NamedAgentBridgeInfo info) {
            super(delegate);
            this.fInfo = info;
        }

        @Override
        public String IAgent_getName() {
            return this.fInfo.getAgentName();
        }

        @Override
        public String[] IAgent_getHostProcessAgentTriplet() {
            String[] result = new String[]{this.fInfo.getHost(), this.fInfo.getProcess(), this.fInfo.getAgentName()};
            return result;
        }

        public String getName() {
            return this.fInfo.getName();
        }
    }

    public static class NamedAsyncAgentControlChannel
    extends AAsyncMessagePipeEndpoint
    implements IAsyncAgentControlChannel {
        private IsengardServerConnectionManager fConnectionManager;
        private final String fNamedPrefix;

        public NamedAsyncAgentControlChannel(IsengardServerConnectionManager connectionManager, PostOffice po, String name) throws InvalidIsengardInterface {
            super(po, IAsyncAgentControlChannel.class);
            this.fNamedPrefix = "!BRIDGE!" + name + "|";
            this.fConnectionManager = connectionManager;
        }

        @Override
        public void setMetricShutoff(AgentMetric metric, boolean isOff) {
            try {
                AgentMetric prefixedMetric = new AgentMetric(this.fNamedPrefix + metric.getAttributeURL(), metric.getAttributeType());
                this.fConnectionManager.tellObserversAboutMetricShutoff(prefixedMetric, isOff);
            }
            catch (BadlyFormedNameException e) {
                this.getFeedbackChannel().debug(sModule, "Failed to build metric name: " + e.getMessage());
                this.getFeedbackChannel().debug(e);
            }
        }

        @Override
        public void updateTTFilter(ITransactionTraceFilter filter, boolean add) {
            this.fConnectionManager.tellObserversToUpdateTTFilter(filter, add);
        }

        @Override
        public void startSendingData() {
        }

        @Override
        public void handleAckRefreshConnection() {
        }

        @Override
        public void setActualName(String name) {
        }

        @Override
        public void setReportingState(boolean isEnabled) {
        }

        @Override
        public void close() {
            super.close();
        }
    }

    private class LoadBalancerNotificationListener
    implements ILoadBalancerNotificationListener {
        private LoadBalancerNotificationListener() {
        }

        @Override
        public void closing() throws ConnectionException {
        }

        @Override
        public void noticeLoadBalancerUpdated(AdvancedReconnectInfo reconnectInfo) throws ConnectionException {
            IsengardServerConnectionManager.this.getFeedbackChannel().info("New list via update: " + reconnectInfo);
            if (IsengardServerConnectionManager.this.fFailoverPolicy.setAdditionalFailoverServers(IsengardServerConnectionManager.this.fFailoverPolicy.getAuthoritativeServer(), reconnectInfo)) {
                IsengardServerConnectionManager.this.getFeedbackChannel().info("New list accepted");
                if (IsengardServerConnectionManager.this.shouldSendData() != reconnectInfo.getAllowSend()) {
                    IsengardServerConnectionManager.this.fConnectionRunnable.setLostConnection(true);
                } else {
                    IsengardServerConnectionManager.this.fConnectionRunnable.setLostConnection(!reconnectInfo.getStayConnected());
                }
                IsengardServerConnectionManager.this.setStartSendingData(reconnectInfo.getAllowSend());
            }
        }
    }

    private static class NotifyNameChange
    implements IExecutableItem {
        private final INameChangeListener fListener;
        private final String fName;

        public NotifyNameChange(INameChangeListener listener, String name) {
            this.fListener = listener;
            this.fName = name;
        }

        @Override
        public boolean IExecutableItem_shouldStillExecute() {
            return true;
        }

        @Override
        public void IExecutableItem_executionAborted() {
        }

        @Override
        public void IExecutableItem_execute() {
            this.fListener.INameChangeListener_nameChanged(this.fName);
        }
    }

    private static class CachedTimesliceInfo {
        List timeslices = new ArrayList(2);
        int position;
        AgentMetricData metric;
        Class specificType;

        CachedTimesliceInfo(int position, AgentMetricData metric, Class specificType) {
            this.position = position;
            this.metric = metric;
            this.specificType = specificType;
        }

        ATimeslicedValue aggregate() {
            Assertion.wilyAssert(this.specificType.equals(IntegerTimeslicedValue.class), "Illegal type: can't aggregate");
            return this.aggregateIntVals();
        }

        IntegerTimeslicedValue aggregateIntVals() {
            long startTime = 0L;
            long endTime = 0L;
            long dataPointCount = 0L;
            boolean dataIsAbsent = true;
            int val = 0;
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            ATimeslicedValue example = null;
            for (Object obj : this.timeslices) {
                if (!(obj instanceof IntegerTimeslicedValue)) continue;
                IntegerTimeslicedValue iVal = (IntegerTimeslicedValue)obj;
                example = iVal;
                if (iVal.getStartTimestampInMillis() > startTime) {
                    startTime = iVal.getStartTimestampInMillis();
                }
                if (iVal.getStopTimestampInMillis() > endTime) {
                    endTime = iVal.getStopTimestampInMillis();
                }
                dataPointCount += iVal.getDataPointCount();
                dataIsAbsent &= iVal.dataIsAbsent();
                val += iVal.getValue();
                min = Math.min(min, iVal.getMinimum());
                max = Math.max(max, iVal.getMaximum());
            }
            return new IntegerTimeslicedValue(example.getType(), startTime, endTime, BlameStackSnapshot.kEmptyBlameStackSnapshot, dataPointCount, dataIsAbsent, val, min, max);
        }
    }

    private static class AgentCommandAppMapServiceWrapper
    implements IConsolidatedAgentCommand {
        private final IAppMapAgentServiceCommand fAgentCommand;
        private final IAppMapAgentService fService;
        private final ConnectedServer fServer;

        public AgentCommandAppMapServiceWrapper(IAppMapAgentServiceCommand agentCommand, IAppMapAgentService service, ConnectedServer server) {
            Assertion.wilyAssert(agentCommand != null, "Command is null");
            this.fAgentCommand = agentCommand;
            this.fService = service;
            this.fServer = server;
        }

        @Override
        public void handleAgentCommand() throws Exception {
            if (this.fService == null) {
                this.fAgentCommand.onAgentCommandCompletion(1);
            } else {
                try {
                    this.fAgentCommand.handleAgentCommand(this.fService);
                }
                catch (MessageUndeliverableException mue) {
                    if (this.fServer.getPostOffice().isClosed()) {
                        this.fAgentCommand.onAgentCommandCompletion(1);
                    }
                    throw mue;
                }
                catch (Exception e) {
                    this.fAgentCommand.onAgentCommandCompletion(2);
                    throw e;
                }
                this.fAgentCommand.onAgentCommandCompletion(0);
            }
        }

        @Override
        public void add(IConsolidatedAgentCommand command) {
            if (this.fAgentCommand instanceof IConsolidableAgentCommand) {
                ((IConsolidableAgentCommand)((Object)this.fAgentCommand)).merge(command.getConsolidableAgentCommand());
            }
        }

        @Override
        public IConsolidableAgentCommand getConsolidableAgentCommand() {
            if (this.fAgentCommand instanceof IConsolidableAgentCommand) {
                return (IConsolidableAgentCommand)((Object)this.fAgentCommand);
            }
            return null;
        }
    }

    private static class AgentCommandBridgeWrapper
    implements IConsolidatedAgentCommand {
        private final IAgentBridgeCommand fAgentBridgeCommand;
        private final IAgentBridgeService fService;
        private final ConnectedServer fServer;

        public AgentCommandBridgeWrapper(IAgentBridgeCommand agentBridgeCommand, IAgentBridgeService service, ConnectedServer server) {
            Assertion.wilyAssert(agentBridgeCommand != null, "Command is null");
            this.fAgentBridgeCommand = agentBridgeCommand;
            this.fService = service;
            this.fServer = server;
        }

        @Override
        public void handleAgentCommand() throws Exception {
            if (this.fService == null) {
                this.fAgentBridgeCommand.onAgentCommandCompletion(1);
            } else {
                try {
                    this.fAgentBridgeCommand.handleAgentCommand(this.fService);
                }
                catch (MessageUndeliverableException mue) {
                    if (this.fServer.getPostOffice().isClosed()) {
                        this.fAgentBridgeCommand.onAgentCommandCompletion(1);
                    }
                    throw mue;
                }
                catch (Exception e) {
                    this.fAgentBridgeCommand.onAgentCommandCompletion(2);
                    throw e;
                }
                this.fAgentBridgeCommand.onAgentCommandCompletion(0);
            }
        }

        @Override
        public void add(IConsolidatedAgentCommand command) {
            if (this.fAgentBridgeCommand instanceof IConsolidableAgentCommand) {
                ((IConsolidableAgentCommand)((Object)this.fAgentBridgeCommand)).merge(command.getConsolidableAgentCommand());
            }
        }

        @Override
        public IConsolidableAgentCommand getConsolidableAgentCommand() {
            if (this.fAgentBridgeCommand instanceof IConsolidableAgentCommand) {
                return (IConsolidableAgentCommand)((Object)this.fAgentBridgeCommand);
            }
            return null;
        }
    }

    public static interface IReportQueueCallback {
        public void noticeSuccess();
    }
}

