/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.ClientInfo;
import com.wily.introscope.agent.connection.IAgentBridgeCommand;
import com.wily.introscope.agent.connection.IAgentHarvester;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;

class RenameAgentCommand
implements IAgentBridgeCommand {
    private final String fActualAgentName;
    private final String fRequestedAgentName;
    private final ClientInfo fClientInfo;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IAgentHarvester fHarvester;

    public RenameAgentCommand(String requestedAgentName, String actualAgentName, ClientInfo clientInfo, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IAgentHarvester harvester) {
        this.fRequestedAgentName = requestedAgentName;
        this.fActualAgentName = actualAgentName;
        this.fClientInfo = clientInfo;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fHarvester = harvester;
    }

    @Override
    public void handleAgentCommand(IAgentBridgeService agentBridge) throws ConnectionException {
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Request_Agent_Name_Change_Message", this.fActualAgentName, this.fRequestedAgentName));
        agentBridge.handleClientNameChanged(this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), this.fRequestedAgentName, this.fClientInfo.isClonedAgent());
    }

    @Override
    public void onAgentCommandCompletion(int status) {
        this.fHarvester.resendConstantMetricsAtNextHarvest();
    }
}

