/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;

class TransactionAgentCommand
implements IAgentCommand {
    private final String fAgentBridgeName;
    private final IsengardServerConnectionManager fManager;
    private final TransactionComponentData[] fTransactionData;
    private final long fTimeStamp;

    public TransactionAgentCommand(String agentBridgeName, IsengardServerConnectionManager manager, TransactionComponentData[] transactions) {
        this.fAgentBridgeName = agentBridgeName;
        this.fManager = manager;
        this.fTransactionData = transactions;
        this.fTimeStamp = System.currentTimeMillis();
    }

    @Override
    public void handleAgentCommand() throws Exception {
        IAgentBridgeService agentBridge = this.fManager.getAgentBridgeServiceByName(this.fAgentBridgeName);
        agentBridge.handleTransactions(this.fTransactionData);
    }

    public long getSize() {
        return this.fTransactionData != null ? (long)this.fTransactionData.length : 0L;
    }

    public long getTimestamp() {
        return this.fTimeStamp;
    }
}

