/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.detection;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.TraceRecorder;
import com.wily.introscope.agent.intelligent.detection.BasicRuleEngine;
import com.wily.introscope.agent.intelligent.detection.BoundaryDetectionAdmin;
import com.wily.introscope.agent.intelligent.detection.Logger;
import com.wily.introscope.agent.intelligent.entrypoint.RuleEngineConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.ExecutionStatus;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.apis.Rule;
import com.wily.introscope.agent.intelligent.entrypoint.apis.RuleEngine;
import com.wily.introscope.agent.intelligent.entrypoint.apis.StackTraceFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class AutomaticBoundaryDetectionAdmin
implements BoundaryDetectionAdmin {
    private AtomicReference<RuleEngine> entryPointDetectionRuleEngine = new AtomicReference();
    private AtomicReference<TraceRecorder> traceRecorder = new AtomicReference();
    private final TraceRecorder NO_OP_TRACE_RECORDER = new TraceRecorder(){

        @Override
        public boolean record() {
            return false;
        }
    };
    private final RuleEngine NO_OP_RULE_ENGINE = new RuleEngine(){
        private final IndexAwareTraceElement[] EMPTY_TRACE = new IndexAwareTraceElement[0];
        private final List<IndexAwareTraceElement> EMPTY_LIST = new ArrayList<IndexAwareTraceElement>(0);

        @Override
        public IndexAwareTraceElement[] doExecuteNextFilter(IndexAwareTraceElement[] trace) {
            return this.EMPTY_TRACE;
        }

        @Override
        public void doExecuteNextRule(int currentElementIndex, IndexAwareTraceElement[] trace, ExecutionStatus status) {
        }

        @Override
        public boolean removeRule(Rule rule) {
            return false;
        }

        @Override
        public boolean removeFilter(StackTraceFilter filter) {
            return false;
        }

        @Override
        public boolean registerRules(Collection<? extends Rule> rules) {
            return false;
        }

        @Override
        public boolean registerRule(Rule rule) {
            return false;
        }

        @Override
        public boolean registerFilters(Set<StackTraceFilter> filters) {
            return false;
        }

        @Override
        public boolean registerFilter(StackTraceFilter filter) {
            return false;
        }

        @Override
        public IndexAwareTraceElement[] preExecute(IndexAwareTraceElement[] trace) {
            return this.EMPTY_TRACE;
        }

        @Override
        public List<IndexAwareTraceElement> execute(IndexAwareTraceElement[] trace) {
            return this.EMPTY_LIST;
        }
    };

    private AutomaticBoundaryDetectionAdmin() {
        this.traceRecorder.set(this.NO_OP_TRACE_RECORDER);
        this.entryPointDetectionRuleEngine.set(this.NO_OP_RULE_ENGINE);
    }

    @Override
    public RuleEngine getEntryPointDetectionRuleEngine() {
        return this.entryPointDetectionRuleEngine.get();
    }

    @Override
    public boolean registerEntryPointDetectionRuleEngine(RuleEngine ruleEngine) {
        Logger.logDebugMessage("BoundaryDetectionAdmin received request to register entry point detection rule engine");
        boolean regStatus = this.entryPointDetectionRuleEngine.compareAndSet(this.NO_OP_RULE_ENGINE, ruleEngine);
        if (!regStatus) {
            Logger.logDebugMessage("BoundaryDetectionAdmin could not register entry point detection rule engine");
        }
        return regStatus;
    }

    @Override
    public TraceRecorder getStrackTraceRecorder() {
        return this.traceRecorder.get();
    }

    @Override
    public void setTraceRecorder(TraceRecorder traceRecorder) {
        this.traceRecorder.set(traceRecorder);
    }

    public static AutomaticBoundaryDetectionAdmin getInstance() {
        return SingletonHolder.INSTANCE;
    }

    static {
        IAgent agent = null;
        try {
            agent = AgentShim.getAgent();
            RuleEngineConfiguration.init(agent);
            BasicRuleEngine defaultEngine = new BasicRuleEngine(RuleEngineConfiguration.getNumberOfInitialEntryPointCandidatesToDetect(), RuleEngineConfiguration.getMaxDepthToTraverseInStackTrace());
            AutomaticBoundaryDetectionAdmin.getInstance().registerEntryPointDetectionRuleEngine(defaultEngine);
        }
        catch (AgentNotAvailableException e) {
            AgentShim.handleDebug("Agent is not available while loading BoundaryDetectionAdmin", e);
        }
    }

    private static class SingletonHolder {
        private static final AutomaticBoundaryDetectionAdmin INSTANCE = new AutomaticBoundaryDetectionAdmin();

        private SingletonHolder() {
        }
    }
}

