/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sustainability;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sustainability.ISustainabilityReportLogger;
import com.wily.introscope.agent.sustainability.SustainabilityReportEntry;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.resource.FileBasedResource;
import com.wily.util.resource.IResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.List;

public class SustainabilityReportLogger
implements IConfigurationListener,
ISustainabilityReportLogger {
    private static final String baseFileName = "MetricReport.cvs";
    private final IResource fResource;
    private final IAgent fAgent;
    private volatile String filePath;

    SustainabilityReportLogger(IAgent agent, IResource resource) {
        this.fAgent = agent;
        this.fResource = resource;
        if (this.fAgent != null) {
            this.onChange(agent.IAgent_getIndexedProperties());
        }
    }

    @Override
    public void onChange(IndexedProperties newProps) {
        if (this.fAgent != null && this.fResource != null) {
            String appenderFilePath = newProps.getTrimmedProperty("com.wily.introscope.agent.sustainabilitymetrics.tracer.report.basedir");
            if (appenderFilePath == null) {
                this.fAgent.IAgent_getModuleFeedback().debug(SustainabilityService.kModule, "The property com.wily.introscope.agent.sustainabilitymetrics.report.basedir is not specified. Reports will not be written for sustainability metrics");
                this.filePath = null;
                return;
            }
            File testAbsolutePath = new File(appenderFilePath);
            boolean isAbsolute = testAbsolutePath.isAbsolute();
            if (!isAbsolute) {
                IResource logResource = FileBasedResource.getRelativeResource(appenderFilePath, this.fResource);
                appenderFilePath = logResource.IResource_getLocation();
            }
            this.fAgent.IAgent_getModuleFeedback().warn(SustainabilityService.kModule, "The metric reports will be written to " + appenderFilePath);
            this.filePath = appenderFilePath;
        }
    }

    @Override
    public void log(List result) {
        try {
            String fileName = System.currentTimeMillis() + "." + baseFileName;
            File f = new File(this.filePath, fileName);
            FileOutputStream fos = new FileOutputStream(f);
            PrintWriter w = new PrintWriter(fos);
            w.println("Runtime Class Name,Class Name,Method Name, Number of Tracers, Total time traced (ns), Total time in tracers (ns), percentage overhead");
            for (SustainabilityReportEntry ri : result) {
                w.print(ri.getInfo().getProbeIdentification().getRuntimePackageAndClassName());
                w.print(",");
                w.print(ri.getInfo().getProbeIdentification().getProbeClassName());
                w.print(",");
                w.print(ri.getInfo().getProbeIdentification().getProbeMethodName());
                w.print(",");
                w.print(ri.getInfo().getTracerCount());
                w.print(",");
                w.print(ri.getTotal());
                w.print(",");
                w.print(ri.getInTracers());
                w.print(",");
                w.println(ri.getPercentage());
            }
            w.flush();
            fos.flush();
            fos.close();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.fAgent.IAgent_getModuleFeedback().debug(SustainabilityService.kModule, "error while writing sustainability report", t);
        }
    }
}

