/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.hc2.HttpServletTracer;
import com.wily.introscope.agent.trace.hc2.UrlGroupingProvider;
import com.wily.introscope.agent.trace.servlet.IHttpRequestHelper;
import com.wily.introscope.agent.transactiontrace.TransactionTraceController;
import com.wily.util.adt.LazyMap;
import java.util.Map;
import java.util.Set;

public final class HttpRequestLazyMapProvider
implements LazyMap.ILazyMapProvider {
    private volatile InvocationData data;
    private volatile IAgent agent;
    private volatile Map cacheParameterMap;
    private volatile IHttpRequestHelper helper;
    private volatile String charEncoding;
    private volatile Object request;
    private TransactionTraceController ttc;

    public HttpRequestLazyMapProvider(Object request, InvocationData data, IAgent agent, Map cacheParameterMap, IHttpRequestHelper helper, String charEncoding) {
        this.data = data;
        this.agent = agent;
        this.cacheParameterMap = cacheParameterMap;
        this.helper = helper;
        this.charEncoding = charEncoding;
        this.request = request;
        this.ttc = this.agent.IAgent_getTransactionTraceController();
    }

    @Override
    public void warn(String string) {
        if (HttpServletTracer.fIsDebugEnabled) {
            this.agent.IAgent_getModuleFeedback().debug(string);
        }
    }

    @Override
    public Set getKeySet() {
        return this.helper.getKeySet();
    }

    public String getCharEncoding() {
        return this.charEncoding;
    }

    public void setCharEncoding(String charEncoding) {
        this.charEncoding = charEncoding;
    }

    @Override
    public Object get(Object key) {
        if (key.equals("Normalized URL")) {
            return UrlGroupingProvider.getNormalizedURL(this.agent, this.cacheParameterMap, this.helper, this.request, this.data, this.charEncoding);
        }
        if (key.equals("Session ID")) {
            if (!this.ttc.isSessionIdPropagationEnabled()) {
                return null;
            }
        } else {
            if (key.equals("Context Path")) {
                return this.helper.getContextPath(this.request);
            }
            if (key.equals("Scheme")) {
                return this.helper.getScheme(this.request);
            }
            if (key.equals("Server Port")) {
                return Integer.toString(this.helper.getServerPort(this.request));
            }
            if (key.equals("Remote Client Address")) {
                return this.helper.getRemoteAddr(this.request);
            }
            if (key.equals("Server Name")) {
                return this.helper.getServerName(this.request);
            }
            if (key.equals("URL")) {
                return this.helper.getRequestURI(this.request);
            }
            if (key.equals("URL Query")) {
                return this.helper.getQueryString(this.request);
            }
            if (key.equals("Refering URL")) {
                return this.helper.getHeader(this.request, (String)key);
            }
            if (key.equals("HTTP Method")) {
                return this.helper.getMethod(this.request);
            }
            if (key.equals("introscope.agent.HttpServletTracer.headerParameters")) {
                return this.helper.getHeaderParamMap(this.request);
            }
            if (key.equals("XWTG")) {
                return this.helper.getXWTGParamMap(this.request);
            }
            if (key.equals("introscope.agent.HttpServletTracer.cookieParameters")) {
                return this.helper.getCookieMap(this.request);
            }
            if (key.equals("x-apm-bt")) {
                return this.helper.getExternalbtParamter(this.request);
            }
            if (key.equals("x-apm-bt")) {
                return this.helper.getBRTMbtParamter(this.request);
            }
            return null;
        }
        return null;
    }

    void reset(InvocationData data, IAgent agent, IHttpRequestHelper helper, String charEncoding, Object request) {
        this.data = data;
        this.agent = agent;
        this.helper = helper;
        this.charEncoding = charEncoding;
        this.request = request;
        this.cacheParameterMap.clear();
    }
}

