/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.BlameStackAnnotationHelper;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.IBlameStackAnnotator;
import com.wily.introscope.agent.IHarvester;
import com.wily.introscope.agent.LazyMetricNameProvider;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.VirtualElement;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.connection.IAppMapAgentServiceCommand;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.enterprise.EnterpriseAgent;
import com.wily.introscope.agent.enterprise.IServerConnectionObserver;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.feature.StallFeatureBase;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.probe.net.DefaultBackendHelper;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IDataAccumulatorTracker;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.sustainability.ISustainabilityMetricsCallback;
import com.wily.introscope.agent.sustainability.SustainabilityService;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.WrappedInvocationData;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.ACrossCorrelationElement;
import com.wily.introscope.agent.trace.cas.APureMapTransactionElement;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IChildEditor;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.IStackElementCallbackOnRecursion;
import com.wily.introscope.agent.trace.cas.IStringRepresentable;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstance;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceListProvider;
import com.wily.introscope.agent.trace.cas.ITransactionInstanceProvider;
import com.wily.introscope.agent.trace.cas.SetElement;
import com.wily.introscope.agent.trace.cas.StackRecursionHelper;
import com.wily.introscope.agent.trace.cas.TransactionStructure;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.cas.impl.AChildReadEditorStack;
import com.wily.introscope.agent.trace.hc2.AElementCreationWatchdog;
import com.wily.introscope.agent.trace.hc2.BizTCChildrenEditor;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.FeatureConfigAgingChildrenEditor;
import com.wily.introscope.agent.trace.hc2.RemoveSubtreeEditor;
import com.wily.introscope.agent.trace.hc2.SocketTransactionElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.hc2.VerifyAgingChildrenEditor;
import com.wily.introscope.agent.trace.hc2.WilyAggregateMetricsHarvester;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.intelligent.AutoTracingHelper;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.spec.agent.beans.autotracing.AgentMetricThresholdTrigger;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.introscope.spec.server.beans.agent.IAppMapAgentService;
import com.wily.introscope.spec.server.transactiontrace.ITransactionTraceFilter;
import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.util.IConfigurationListener;
import com.wily.util.WilyStringBuilder;
import com.wily.util.adt.IConcurrentMapFactory;
import com.wily.util.adt.IConcurrentMapHealthStatus;
import com.wily.util.adt.IConcurrentMapHealthStatusProvider;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.heartbeat.WaitAndExecuteBehavior;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.resource.IResource;
import com.wily.util.task.AsynchExecutionQueue;
import com.wily.util.task.IExecutableItem;
import com.wily.util.task.IExecutionQueue;
import com.wily.util.task.TaskAlreadyStartedException;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.AssertionFailureException;
import java.io.PrintStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class WilyTransactionStructure
extends TransactionStructure
implements IServerConnectionObserver,
IHarvester,
ITransactionInstanceListProvider {
    public static boolean developmentDebug = false;
    public static final Module kStackModule = new Module("VirtualStack");
    static final Module kWilyHarvestingModule = new Module("WilyTransactionStructure");
    private static final String kHarvesterSustainabilityMetricsEnablingProperty = "com.wily.introscope.agent.sustainabilitymetrics.harvesting.enabled";
    private static final String kOptimizeHarvestingEnablingProperty = "com.wily.introscope.agent.harvesting.optimize.enabled";
    private static final String kCEMForceTraceEnablingProperty = "com.wily.introscope.agent.cem.force.trace.enabled";
    private static final String kTransactionTraceEnablingProperty = "com.wily.introscope.agent.blame.transaction.doTransactionTrace";
    private static final String kHighConcurrencyEnablingProperty = "com.wily.introscope.agent.blame.highconcurrency.enabled";
    private static final String kShouldUseSharedAccumulatorsForSameMetricProperty = "com.wily.introscope.agent.blame.usesharedaccumulators.enabled";
    private static final String kHighConcurrencyStripesDefaultProperty = "com.wily.introscope.agent.blame.highconcurrency.stripes";
    private static final String kStallTraceEnablingProperty = "com.wily.introscope.agent.blame.stall.trace.enabled";
    private static final String kErrorEnablingProperty = "com.wily.introscope.agent.blame.error.enabled";
    private static final String kConcurrentEnablingProperty = "com.wily.introscope.agent.blame.concurrent.enabled";
    private static final String kPerIntervalEnablingProperty = "com.wily.introscope.agent.blame.perinterval.enabled";
    private static final String kTimerEnablingProperty = "com.wily.introscope.agent.blame.timer.enabled";
    private static final String kSynchronizedEnablingProperty = "com.wily.introscope.agent.blame.synchronized.enabled";
    private static final String kGenerateMetricsLengthProperty = "com.wily.introscope.agent.blame.transactions.metrics.maxlength";
    private static final String kGenerateSustainabilityMetricsEnablingProperty = "com.wily.introscope.agent.sustainabilitymetrics.blame.transactions.enabled";
    private static final String kGenerateContextualMetricsEnablingProperty = "com.wily.introscope.agent.blame.transactions.contextualmetrics.enabled";
    private static final String kTransactionStructureAgingProperty = "com.wily.introscope.agent.harvesting.transaction.aging.period";
    private static final String kTransactionStructureAgingDurationMaxProperty = "com.wily.introscope.agent.harvesting.transaction.aging.duration.max";
    private static final String kTransactionStructureAgingCheckProperty = "com.wily.introscope.agent.harvesting.transaction.aging.checkperiod";
    private static final String kTransactionStructureAgingPercentageAttentionLevelProperty = "com.wily.introscope.agent.harvesting.transaction.aging.attentionlevel.percentage";
    private static final String kTransactionStructureAgingAbsoluteAttentionLevelProperty = "com.wily.introscope.agent.harvesting.transaction.attentionlevel.absolute";
    private static final String kTransactionStructureCreationAbsoluteAttentionLevelProperty = "com.wily.introscope.agent.harvesting.transaction.creation.attentionlevel.absolute";
    private static final String kTransactionStructureCreationCheckProperty = "com.wily.introscope.agent.harvesting.transaction.creation.checkperiod";
    private static final String fConcurrentMapSustainabilityMetricProperty = "com.wily.introscope.agent.sustainabilitymetrics.concurrent.map.enabled";
    private static final String kBusinessComponentBackendsEnablingProperty = "com.wily.introscope.agent.blame.backend.BTC.enable";
    private static final String kBackendSocketAnnotationEnablingProperty = "com.wily.introscope.agent.blame.socket.annotation.enabled";
    private static final String kMaxTraceableStackDepthProperty = "com.wily.introscope.agent.blame.transactions.depth.max";
    public static final String kMaxStackElementsCallerHasSeenProperty = "wily.TransactionCache.maxCallerHasSeenStackElements";
    public static final String kStalledInvocationDataThreshold = "com.wily.introscope.agent.blame.stall.invocationData.max";
    public static final String kMaxInvocationDatasFromWebServicesProperty = "wily.TransactionCache.maxInvocationDatasFromWebServices";
    public static final String kMaxDBConnectionsProperty = "wily.TransactionCache.maxDBConnections";
    public static final String kMaxDecorationsProperty = "wily.VirtualStackCursor.maxDecorations";
    public static final int kDefaultMaxStackElementsCallerHasSeen = 20;
    public static final int kDefaultMaxInvocationDatasFromWebServices = 20;
    public static final int kDefaultMaxDBConnections = 100;
    public static final int kDefaultMaxDecorations = 5000;
    private static final int kDefaultClenerInterval = 30000;
    private static final int kDefaultMemoryModelInterval = 30000;
    private static final int kConcurrentMapHeathStatusInterval = 7000;
    private static final int kDefaultAgingTime = 60000;
    private static final int kDefaultAgingDurationMax = 30000;
    private static final int kDoubleBufferConstant = 2;
    private static final int kDefaultAttentionLevel = 5;
    private static final int kDefaultAbsoluteAttentionLevel = 100000;
    private static final long kMinimumAppMapAgingValue = 15000L;
    private static final int kDefaultTransactionStructureMetricsMaxLength = 1000;
    private static final int kCleanupInterval = 120000;
    private static final short kDefaultMaxTraceableStackDepth = 4096;
    private static final int kDefaultStalledInvocationDataThreshold = 1000;
    private static final int kMaxWarnMsgsForTransactionTraceComponentLimitReached = 50;
    static final int kDefaultCreationAttentionLevel = 100000;
    private static volatile boolean fTransactionTraceEnablingProperty = true;
    public static volatile boolean fSuggestHighConcurrency = false;
    public static volatile boolean fShouldUseSharedAccumulatorsForSameMetric = true;
    public static volatile boolean fSuggestStallTraceProperty = true;
    public static volatile boolean fSuggestConcurrentProperty = true;
    public static volatile boolean fSuggestErrorProperty = true;
    public static volatile boolean fSuggestPerIntervalProperty = true;
    public static volatile boolean fSuggestTimerProperty = true;
    public static volatile boolean fDoBackendForTransactionComponents = false;
    public static volatile boolean fGenerateSustainabilityMetrics = false;
    public static volatile boolean fGenerateContextualMetrics = false;
    public static volatile int fTransactionStructureMetricsMaxLength = 1000;
    public static volatile int fDefaultNumberOfStripes = 16;
    public static volatile int fComponentCountClamp;
    public static volatile boolean fSuggestSynchronizedProperty;
    public static volatile boolean fConcurrentMapSustainabilityMetrics;
    public static volatile boolean fHeadFilterClampEventLogged;
    public static volatile short sMaxTraceableStackDepth;
    private static final AtomicReference kListUsedToRemoveNullWeakReferences;
    private static int fCountWarnMsgsForTransactionTraceComponentLimitReached;
    static EmergencyInvocationDataCleaner kEmergencyCallbackInstance;
    static EmergencyAllInvocationDataCleaner cleanupAllDataEmergencyCallback;
    private volatile IAgent fAgent;
    private volatile AbortedTransactionReportLogger logger;
    private volatile int fCleanerInterval = 30000;
    private volatile int fMemoryModelInterval = 30000;
    private volatile int fAgingTime = 60000;
    private volatile int fAgingDurationMax = 30000;
    private volatile int fAbsoluteAttentionLevel = 100000;
    private volatile int fPercentageAttentionLevel = 5;
    public static volatile int fstalledInvocationDataThreshold;
    private volatile IWeakIdentityMap fKeyCacheMap;
    public final CopyOnWriteArraySet privateMetricHolder = new CopyOnWriteArraySet();
    private final ConcurrentHashMap globalGatherers = new ConcurrentHashMap();
    private final ConcurrentHashMap globalGatherersElements = new ConcurrentHashMap();
    private volatile IWeakIdentityMap reportedStallPoints;
    private volatile IDataAccumulatorTracker fTracker;
    private volatile AElementCreationWatchdog fChecker = new AElementCreationWatchdog();
    private static final ITransactionElementProvider kDefaultCrossCorrelationProvider;
    private static final AtomicReference abortMaxHandle;
    public static final AtomicReference memoryModelHandle;
    public static final AtomicReference agingHandle;
    public static final AtomicReference agingTransactionStructureHandle;
    public static final AtomicReference appMapFetchingBehavior;
    public static final AtomicReference concurrentMapHealthStatusFetchBehavior;
    public static final AtomicReference cleanupHandle;
    static volatile HarvesterSustainabilityMetricsConfigurationProperty fHarvesterMetricProperty;
    static volatile OptimizeHarvestingConfigurationProperty fOptimizeHarvestingProperty;
    static volatile CEMForceTraceConfigurationProperty fCEMForceTraceConfigurationProperty;
    private static final WilyTransactionStructure instance;
    private final WilyAggregateMetricsHarvester aggharvester = new WilyAggregateMetricsHarvester();
    private volatile boolean enableFeature;
    private volatile boolean fShouldCleanup = true;
    private volatile AsynchExecutionQueue fAgeAllQueue;
    private AtomicInteger fAppMapAgingCounter = new AtomicInteger(0);
    private static volatile int fIntelligentInstrumentationMinComponentCount;
    private static final String kAgingTotalNodesAged = "Agent Stats|Sustainability|Aging:Aged nodes (total)";
    private static final String kAgingNodesAged = "Agent Stats|Sustainability|Aging:Aged nodes";
    private static final String kAgingAgingTime = "Agent Stats|Sustainability|Aging:Aging time";
    private static final String kAgingAgingTimeInGlobal = "Agent Stats|Sustainability|Aging:Aging time in gatherers structure";
    private static final String kAgingSizeInGlobal = "Agent Stats|Sustainability|Aging:Size of gatherers Element structure";
    private static final String kAgingNullInGlobal = "Agent Stats|Sustainability|Aging:Null in gatherers Element structure";
    private static final String kAgingGathererSize = "Agent Stats|Sustainability|Aging:Size in gatherers structure";
    private static final String kAgingGatherersRemoved = "Agent Stats|Sustainability|Aging:Gatherers structure elements removed";
    private static final String kAgingGatherersElementsRemoved = "Agent Stats|Sustainability|Aging:Gatherers Elements structure elements removed";
    private static final String kAgingPrepareAgingTime = "Agent Stats|Sustainability|Aging:Prepare Aging time";
    private static final String kAgingSizeAtCount = "Agent Stats|Sustainability|Aging:Size at count";
    private static final String kAgingSizeBeforeAging = "Agent Stats|Sustainability|Aging:Size Before aging";
    private static final String kAgingEmergencyAging = "Agent Stats|Sustainability|Aging:Emergency Aging count";

    private static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    private static boolean computeSynchronized() {
        String property = System.getProperty("java.specification.version");
        return property == null || !property.startsWith("1.5");
    }

    public Iterator iterateOverGlobalGatherer() {
        return this.globalGatherers.entrySet().iterator();
    }

    public static IRepository getGlobalGatherer(AAgentMetricArray metricArray) {
        return (IRepository)WilyTransactionStructure.getInstance().globalGatherers.get(metricArray);
    }

    public static IRepository removeGlobalGatherer(AAgentMetricArray metricArray) {
        return (IRepository)WilyTransactionStructure.getInstance().globalGatherers.remove(metricArray);
    }

    public static IRepository putIntoGlobalGathererIfAbsent(AgentMetric metric, IRepository sds) {
        if (metric == AgentMetric.kNullAgentMetric) {
            throw new AssertionFailureException("The input metric is null and cannot be put into global gatherer.");
        }
        return WilyTransactionStructure.putIntoGlobalGathererIfAbsent(AAgentMetricArray.getInstance(metric), sds);
    }

    public static IRepository putIntoGlobalGathererIfAbsent(AgentMetric metric, IRepository sds, ITransactionElement referrer) {
        return WilyTransactionStructure.putIntoGlobalGathererIfAbsent(metric, sds);
    }

    public static IRepository putIntoGlobalGathererIfAbsent(AAgentMetricArray metric, IRepository sds, ITransactionElement referrer) {
        return WilyTransactionStructure.putIntoGlobalGathererIfAbsent(metric, sds);
    }

    public static IRepository putIntoGlobalGathererIfAbsent(AAgentMetricArray metric, IRepository sds) {
        AAgentMetricArray.assertNoNullMetric(metric);
        IRepository result = null;
        IRepository alreadyInMap = WilyTransactionStructure.getInstance().globalGatherers.putIfAbsent(metric, sds);
        result = alreadyInMap != null ? alreadyInMap : sds;
        return result;
    }

    public static void addTransactionElementReferrer(IRepository globalRepository, ITransactionElement referrer) {
        CopyOnWriteArraySet existingElements;
        CopyOnWriteArraySet elements = (CopyOnWriteArraySet)WilyTransactionStructure.getInstance().globalGatherersElements.get(globalRepository);
        if (elements == null) {
            elements = WilyTransactionStructure.initializeElementCollection(referrer);
        }
        if ((existingElements = WilyTransactionStructure.getInstance().globalGatherersElements.putIfAbsent(globalRepository, elements)) != null) {
            existingElements.add(new TransitiveWeakReference(referrer));
        }
    }

    private static CopyOnWriteArraySet initializeElementCollection(ITransactionElement referrer) {
        CopyOnWriteArraySet<TransitiveWeakReference> result = new CopyOnWriteArraySet<TransitiveWeakReference>();
        result.add(new TransitiveWeakReference(referrer));
        return result;
    }

    public static boolean removeTransactionElementReferrer(IRepository globalRepository, ITransactionElement referrer) {
        CopyOnWriteArraySet elements = (CopyOnWriteArraySet)WilyTransactionStructure.getInstance().globalGatherersElements.get(globalRepository);
        if (elements == null) {
            return true;
        }
        elements.remove(new TransitiveWeakReference(referrer));
        return elements.size() == 0;
    }

    public WilyTransactionStructure(IAgent agent, ITransactionElementProvider provider) {
        super(provider);
        this.fAgent = agent;
        if (agent != null) {
            developmentDebug = agent.IAgent_getModuleFeedback().isTraceEnabled(kStackModule);
        }
    }

    public WilyTransactionStructure(IAgent agent) {
        this(agent, new DefaultStructureProvider());
    }

    public static final WilyTransactionStructure getInstance() {
        return instance;
    }

    public static IDataAccumulatorTracker getSharedElementTracker(IAgent fAgent) {
        return new SharedElementTracker(fAgent);
    }

    public synchronized boolean setAgent(final IAgent agent) {
        if (this.fAgent == null) {
            this.fAgent = agent;
            developmentDebug = agent.IAgent_getModuleFeedback().isTraceEnabled(kStackModule);
            this.fAgeAllQueue = new AsynchExecutionQueue("Transaction Structure Queue", this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer(), this.fAgent.IAgent_getAgentThreadFactory(), false);
            try {
                this.fAgeAllQueue.start();
            }
            catch (TaskAlreadyStartedException taskAlreadyStartedException) {
                // empty catch block
            }
            fHarvesterMetricProperty = new HarvesterSustainabilityMetricsConfigurationProperty(this.fAgent);
            fOptimizeHarvestingProperty = new OptimizeHarvestingConfigurationProperty(this.fAgent);
            fCEMForceTraceConfigurationProperty = new CEMForceTraceConfigurationProperty(this.fAgent);
            this.fAgent.IAgent_getConfigurationManager().add(fHarvesterMetricProperty, true);
            this.fAgent.IAgent_getConfigurationManager().add(fOptimizeHarvestingProperty, true);
            this.fAgent.IAgent_getConfigurationManager().add(fCEMForceTraceConfigurationProperty, false);
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionEnablingProperty(kTransactionTraceEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer()));
            this.fAgent.IAgent_getConfigurationManager().add(new HighConcurrencyConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new ShouldUseSharedAccumulatorsForSameMetricConfigurationProperty(this.getAgent()), true);
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureAgingProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureAgingDurationMaxProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureAgingCheckProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureAgingAbsoluteAttentionLevelProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureAgingAgingPercentageAttentionLevelProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new SynchronizedConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TimerConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new PerIntervalConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new ErrorConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new ConcurrentConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new StallTraceConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new DoBusinessComponentBackendsConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new HighConcurrencyStripesConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureCreationAbsoluteAttentionLevelProperty(this.fAgent), true);
            this.fAgent.IAgent_getConfigurationManager().add(new TransactionStructureCreationCheckProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new TTComponentClampConfigurationProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new DoGenerateSustainabilityMetricsProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new DoGenerateContextualMetricsProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new DoGenerateMetricLengthProperty(this.getAgent()));
            this.fAgent.IAgent_getConfigurationManager().add(new DoConcurrentMapSustainablityMetricsProperty(this.getAgent()), true);
            this.fAgent.IAgent_getConfigurationManager().add(new MaxTraceableStackDepthProperty(this.getAgent()), true);
            this.fAgent.IAgent_getConfigurationManager().add(new MaxStalledInvocationDataThresholdProperty(this.getAgent()), true);
            this.fAgent.IAgent_getConfigurationManager().add(new IntelligentInstrumentationMinComponentCountConfigurationProperty(this.getAgent()), true);
            this.fAgent.IAgent_getConfigurationManager().add(new CrossJVMFilterEnableProperty(this.getAgent()), true);
            this.fKeyCacheMap = this.fAgent.IAgent_getConcurrentMapFactory().getConcurrentCappedWeakIdentityMap("ObjectToBlameKeyMap");
            this.fTracker = WilyTransactionStructure.getSharedElementTracker(this.fAgent);
            this.fChecker = new AElementCreationWatchdog(agent, this);
            agent.IAgent_getModuleFeedback().info(kWilyHarvestingModule, "Wily Transaction Structure is adding the callback for incoming correlations");
            SharedCrossProcessData.addOnCorrelationIncomingCallback(new CrossProcessCorrelationTransactionCallback(), agent);
            StallFeatureBase.startStallFeature(agent);
            ErrorFeature.startErrorFeature(agent);
            this.startDefaultBackendFeature();
            final WilyTransactionStructure observer = this;
            final WilyTransactionStructure harvester = this;
            WaitAndExecuteBehavior b = new WaitAndExecuteBehavior(agent.IAgent_getCommonHeartbeat(), 1000L, "Register Wily TransactionStructure Observer"){

                @Override
                protected boolean execute() {
                    IsengardServerConnectionManager manager = WilyTransactionStructure.this.fAgent.IAgent_getIsengardServerConnection();
                    if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected()) {
                        manager.addConnectionObserver(observer);
                        ((EnterpriseAgent)agent).addHarvester(harvester);
                        return true;
                    }
                    return false;
                }
            };
            this.restartAppMapFetchingBehavior();
            this.restartAging();
            this.restartMemoryModel();
            this.restartCleanup();
            FilterController.init(this.fAgent);
            this.logger = new AbortedTransactionReportLogger(this.fAgent, this.fAgent.IAgent_getConfigurationResource());
            VirtualStack stackInstance = new VirtualStack(this.fAgent);
            InvocationData.setCacheHelper(VirtualStack.sCacheProviderFactory);
            ComponentTracer.setDefaultBoundaryBlameStackHelperProvider(stackInstance);
            ArrayList<TransitiveWeakReference> oneList = new ArrayList<TransitiveWeakReference>(1);
            oneList.add(new TransitiveWeakReference((Object)null));
            kListUsedToRemoveNullWeakReferences.compareAndSet(null, oneList);
            SustainabilityService.addSustainabilityMetricCallback(new SustainabilityMetricUpdater());
            return true;
        }
        return false;
    }

    @Override
    public AgentMetricData[] harvest() {
        AgentMetricData[] result = null;
        long startTime = System.nanoTime();
        boolean doSustainabilityMetrics = fHarvesterMetricProperty.isEnabled();
        if (doSustainabilityMetrics) {
            this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "Starting harvesting of metrics");
        }
        result = this.aggharvester.doHarvest(this.fAgent);
        int ms = (int)((System.nanoTime() - startTime) / 1000000L);
        if (doSustainabilityMetrics) {
            this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "Harvesting completed in " + ms + " nanoseconds");
            IIntegerFluctuatingCounterDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator("Agent Stats|Sustainability|Harvester:Time to harvest");
            accumulator.IIntegerCounterDataAccumulator_setValue(ms);
        }
        if ((long)ms > 7500L) {
            this.fAgent.IAgent_getModuleFeedback().warn(kWilyHarvestingModule, "The harvesting took " + ms + "; this is too long and could lead to data loss. Please review your system");
        }
        return result;
    }

    @Override
    public final void agentControlAddTTFilter(ITransactionTraceFilter filter) {
        FilterController.addFilter(filter);
    }

    @Override
    public void agentControlRemoveTTFilter(ITransactionTraceFilter filter) {
        FilterController.removeFilter(filter);
    }

    @Override
    public void agentControlSetReportingState(boolean report) {
        this.fShouldCleanup = !report;
    }

    @Override
    public void agentControlStartReportingMetric(AgentMetric metric) {
    }

    @Override
    public void agentControlStopReportingMetric(AgentMetric metric) {
    }

    @Override
    public void serverConnected() {
        this.fShouldCleanup = false;
    }

    @Override
    public void serverConnectionCycleFailed(int cycleCount) {
        this.fShouldCleanup = true;
    }

    @Override
    public void serverDisconnected() {
        this.fShouldCleanup = true;
    }

    private void startDefaultBackendFeature() {
        DefaultBackendHelper.getInstance().setAgent(this.fAgent);
        BlameStackAnnotationHelper.registerBlameStackAnnotator(BlameStackAnnotationHelper.kDefaultBackendBlameStackAnnotator, new DefaultBackendBlameStackAnnotator(this.fAgent));
    }

    @Override
    public final boolean shouldTraceTransactionInstances(IStackElement data) {
        return fTransactionTraceEnablingProperty && (FilterController.shouldTraceTransactionInstances(data) || AutoTracingHelper.checkForAutoTracing(data));
    }

    public DataAccumulatorFactory getDataAccumulatorFactory() {
        return this.fAgent.IAgent_getDataAccumulatorFactory();
    }

    @Override
    public IAgent getAgent() {
        return this.fAgent;
    }

    public int advanceAppMapAgingCounter() {
        this.getAgent().IAgent_getModuleFeedback().info(kWilyHarvestingModule, "AppMap counter advanced - discovery traces will be sent");
        return this.fAppMapAgingCounter.incrementAndGet();
    }

    public int getAppMapAgingCounter() {
        return this.fAppMapAgingCounter.get();
    }

    @Override
    public void dump(PrintStream out) {
        super.dump(out);
        out.println("[Size of map of shared reps=" + this.globalGatherers.values().size());
    }

    @Override
    protected void printNodeString(PrintStream out, ITransactionElement leaf) {
        if (leaf instanceof IStringRepresentable) {
            out.print(((IStringRepresentable)((Object)leaf)).getStringRepresentation());
        } else if (leaf instanceof SetElement) {
            if ((leaf = ((SetElement)leaf).getElement()) instanceof IStringRepresentable) {
                out.print(((IStringRepresentable)((Object)leaf)).getStringRepresentation());
            } else if (leaf instanceof ITransactionElement) {
                out.print(leaf.toString() + "[" + leaf.countChildren() + "]");
            }
        } else if (leaf instanceof ITransactionElement) {
            out.print(leaf.toString() + "[" + leaf.countChildren() + "]");
        }
    }

    @Override
    protected void addReps(Set reps, ITransactionElement leaf) {
        if (leaf instanceof WilyTransactionElement) {
            reps.add(((WilyTransactionElement)leaf).getErrorsRepository());
            reps.add(((WilyTransactionElement)leaf).getStallsRepository());
            reps.add(((WilyTransactionElement)leaf).getTimerRepository());
            reps.add(((WilyTransactionElement)leaf).getPerIntervalRepository());
            reps.add(((WilyTransactionElement)leaf).getConcurrentInvocations());
            CopyOnWriteArraySet concRep = ((WilyTransactionElement)leaf).getConcurrentInvocationsRepository();
            reps.addAll(concRep);
        } else if (leaf instanceof SetElement && (leaf = ((SetElement)leaf).getElement()) instanceof WilyTransactionElement) {
            reps.add(((WilyTransactionElement)leaf).getErrorsRepository());
            reps.add(((WilyTransactionElement)leaf).getStallsRepository());
            reps.add(((WilyTransactionElement)leaf).getTimerRepository());
            reps.add(((WilyTransactionElement)leaf).getPerIntervalRepository());
            reps.add(((WilyTransactionElement)leaf).getConcurrentInvocations());
            CopyOnWriteArraySet concRep = ((WilyTransactionElement)leaf).getConcurrentInvocationsRepository();
            reps.addAll(concRep);
        }
    }

    @Override
    public List<ITransactionInstance> getTransactionInstanceList() {
        return VirtualStack.getTransactionCache().transactionInstanceList;
    }

    @Override
    public boolean validateTransaction(ITransactionInstance tFirstEnd) {
        ITransactionElement firstElement;
        ITransactionInstance tFirstStart = tFirstEnd.getStartInstance();
        if (tFirstStart != null && (firstElement = tFirstStart.getTransactionElement()) != null) {
            ITransactionElement parent = firstElement.getParent();
            if (VirtualStack.getTransactionCache().isCrossCorrelationElementEndedTxn()) {
                return true;
            }
            return parent == this.getRoot();
        }
        return false;
    }

    @Override
    protected void refreshTransactionCollectionStatus(IStackElement data) {
        this.updateTransactionCollectionStatus(data, false, false, 0);
    }

    protected TransactionCollectStatus updateTransactionCollectionStatus(IStackElement data, boolean stopTracingFlag, boolean stopCheckingFlag, int headComponentCount) {
        return FilterController.updateTransactionCollectStatus(data, stopTracingFlag, stopCheckingFlag, headComponentCount);
    }

    @Override
    protected void conditionalEndTransactionInstanceCreate(ITransactionInstanceProvider instanceProvider, IStackElement data, ITransactionElement element, int tracerIndex) {
        if (!fTransactionTraceEnablingProperty) {
            return;
        }
        if (!instanceProvider.isActive()) {
            return;
        }
        if (data.getStartInstancePositionAt(tracerIndex) == -1) {
            return;
        }
        TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
        if (tcs != null) {
            if (!tcs.getStartedTrackingOnStartTransaction()) {
                return;
            }
            if (tcs.getStopCheckingFlag() && tcs.getStopTracingFlag()) {
                if (TransactionHarvestHelper.fIntelligentInstrumentationEnabled) {
                    instanceProvider.offerNewTransactionInstanceElementOnEndTrace(tracerIndex, data, element);
                }
                return;
            }
            instanceProvider.offerNewTransactionInstanceElementOnEndTrace(tracerIndex, data, element);
        }
    }

    @Override
    protected final boolean conditionalStartTransactionInstanceCreate(ITransactionInstanceProvider instanceProvider, IStackElement data, ITransactionElement element, int tracerIndex, boolean onStartTransaction, boolean doTrySampling) {
        TransactionCollectStatus tcs;
        boolean result = false;
        if (!fTransactionTraceEnablingProperty) {
            return false;
        }
        if (!instanceProvider.isActive()) {
            return false;
        }
        boolean isTraceEnabled = this.fAgent.IAgent_getModuleFeedback().isTraceEnabled(kWilyHarvestingModule);
        if (isTraceEnabled) {
            this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "WilyTransactionStructure: conditionalTransactionInstanceCreate element " + element + " tracerIndex " + tracerIndex + " onStartTransaction " + onStartTransaction + " doTrySampling " + doTrySampling);
        }
        if ((tcs = data.getTransactionCollectionStatus()) != null) {
            if (onStartTransaction) {
                if (tcs.fComponentCountInTT != 0) {
                    this.getAgent().IAgent_getModuleFeedback().debug(kWilyHarvestingModule, Thread.currentThread().getName() + ": A corruption in the counting of transaction trace element blocks a transaction from being traced. The stack appears to have a count of element not equal to zero: " + tcs.fComponentCountInTT + ";" + tcs.doTraceFlag + ";" + tcs.getSampled().shouldStartSampling());
                    return false;
                }
                FilterController.prepareFiltersForTransaction(tcs, this.getAgent());
            }
            if (tcs.isComponentClampAlreadyHitForTxn()) {
                data.setStartInstancePositionAt(-1, tracerIndex);
                tcs.incrementComponentClampAfterCount();
                return false;
            }
            if (tcs.incrementAndGetTxnTraceComponentCount() > fComponentCountClamp) {
                int currentWarnMsgsCount;
                if ((currentWarnMsgsCount = ++fCountWarnMsgsForTransactionTraceComponentLimitReached) < 50) {
                    this.getAgent().IAgent_getModuleFeedback().warn(kWilyHarvestingModule, "Transaction trace component limit of " + fComponentCountClamp + " reached, recording of any new components will cease for this transaction.");
                }
                if (this.getAgent().IAgent_getModuleFeedback().isDebugEnabled(kWilyHarvestingModule)) {
                    this.getAgent().IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "last traced component: " + element.toString());
                }
                data.setStartInstancePositionAt(-1, tracerIndex);
                tcs.markComponentClampAlreadyHitForTxn();
                return false;
            }
            if (isTraceEnabled) {
                this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "WilyTransactionStructure: conditionalTransactionInstanceCreate tcs stopcheckingflag " + tcs.stopCheckingFlag + " stopTracingFlag " + tcs.stopTracingFlag + " cmpCount " + tcs.headComponentCount);
            }
            if (!onStartTransaction && !tcs.getStartedTrackingOnStartTransaction()) {
                return false;
            }
            if (tcs.getStopCheckingFlag()) {
                if (tcs.getStopTracingFlag()) {
                    if (TransactionHarvestHelper.fIntelligentInstrumentationEnabled) {
                        if (tcs.isComponentClampAlreadyHitForTxn()) {
                            data.setStartInstancePositionAt(-1, tracerIndex);
                            tcs.incrementComponentClampAfterCount();
                            return false;
                        }
                        if (tcs.getTxnTraceComponentCount() > fIntelligentInstrumentationMinComponentCount) {
                            if (this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kWilyHarvestingModule)) {
                                this.getAgent().IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "Transaction trace component limit of top " + fIntelligentInstrumentationMinComponentCount + " reached, recording of any new components will cease for this transaction.");
                                this.getAgent().IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "last traced component: " + element.toString());
                            }
                            data.setStartInstancePositionAt(-1, tracerIndex);
                            tcs.markComponentClampAlreadyHitForTxn();
                            return false;
                        }
                        instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                        result = true;
                    }
                    return false;
                }
                instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                result = true;
            } else {
                ISamplingResult.Choice headFilterStatus = ISamplingResult.Choice.NO;
                long filterEnablerKey = element.getFilterEnablerBit();
                int headComponentCount = tcs.getHeadComponentCount();
                if (!tcs.isSamplingEvaluated()) {
                    ISamplingResult sample = FilterController.samplingExecute(filterEnablerKey, instanceProvider, data, this.getAgent());
                    tcs.setSampled(sample);
                    if (sample != null) {
                        tcs.setSamplingEvaluated(true);
                        headFilterStatus = sample.shouldStartSampling().choice;
                    }
                }
                tcs.fTriggerHeadFilterPass = VirtualStack.getTransactionCache().isfTriggerHeadFilterPass();
                if (tcs.fTriggerHeadFilterPass) {
                    headFilterStatus = ISamplingResult.Choice.YES;
                } else if (headFilterStatus != ISamplingResult.Choice.YES && FilterController.optimisticFilterExecute(filterEnablerKey, tcs, data, this.getAgent())) {
                    headFilterStatus = ISamplingResult.Choice.YES;
                }
                if (isTraceEnabled) {
                    this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "WilyTransactionStructure: conditionalTransactionInstanceCreate stopChecking is false  filterEnableKey " + filterEnablerKey + " headFilterStaus " + (Object)((Object)headFilterStatus));
                }
                result = this.postHeadFilterEvaluate(headFilterStatus, instanceProvider, data, element, tcs, tracerIndex, headComponentCount, FilterController.getHeadFilterComponentLimit());
            }
        } else {
            tcs = this.updateTransactionCollectionStatus(data, false, false, 0);
            tcs.fTriggerHeadFilterPass = VirtualStack.getTransactionCache().isfTriggerHeadFilterPass();
            ISamplingResult.Choice headFilterStatus = ISamplingResult.Choice.NO;
            int headComponentCount = 0;
            if (tcs.fTriggerHeadFilterPass) {
                headFilterStatus = ISamplingResult.Choice.YES;
            } else {
                long filterEnablerKey = element.getFilterEnablerBit();
                if (!tcs.isSamplingEvaluated()) {
                    ISamplingResult sample = FilterController.samplingExecute(filterEnablerKey, instanceProvider, data, this.getAgent());
                    tcs.setSampled(sample);
                    if (sample != null) {
                        tcs.setSamplingEvaluated(true);
                        headFilterStatus = sample.shouldStartSampling().choice;
                    }
                }
                if (headFilterStatus != ISamplingResult.Choice.YES) {
                    FilterController.prepareFiltersForTransaction(tcs, this.getAgent());
                    if (FilterController.optimisticFilterExecute(filterEnablerKey, tcs, data, this.getAgent())) {
                        headFilterStatus = ISamplingResult.Choice.YES;
                    }
                }
            }
            if (isTraceEnabled) {
                this.fAgent.IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "WilyTransactionStructure: conditionalTransactionInstanceCreate NEW TCS  headFilterStaus " + (Object)((Object)headFilterStatus));
            }
            result = this.postHeadFilterEvaluate(headFilterStatus, instanceProvider, data, element, tcs, tracerIndex, headComponentCount, FilterController.getHeadFilterComponentLimit());
        }
        if (result && onStartTransaction) {
            tcs.setStartedTrakingOnStartTransaction();
        }
        return result;
    }

    private boolean postHeadFilterEvaluate(ISamplingResult.Choice headFilterStatus, ITransactionInstanceProvider instanceProvider, IStackElement data, ITransactionElement element, TransactionCollectStatus tcs, int tracerIndex, int headComponentCount, int headFilterClamp) {
        boolean result = false;
        if (headFilterStatus != ISamplingResult.Choice.NO) {
            tcs.setStopCheckingFlag(true);
            tcs.setDoTraceFlag(headFilterStatus == ISamplingResult.Choice.YES);
            instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
            result = true;
        } else if (!tcs.anyPendingHeadFilters()) {
            tcs.setStopCheckingFlag(true);
            if (!tcs.anyPendingTailFilters()) {
                tcs.setStopTracingFlag(true);
                if (TransactionHarvestHelper.fIntelligentInstrumentationEnabled) {
                    instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                    result = true;
                }
            } else {
                instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                result = true;
            }
        } else if (headComponentCount >= headFilterClamp) {
            if (!fHeadFilterClampEventLogged) {
                fHeadFilterClampEventLogged = true;
                this.fAgent.IAgent_getModuleFeedback().info(kWilyHarvestingModule, "Head filter check has reached component clamp at " + headComponentCount);
            }
            tcs.setStopCheckingFlag(true);
            result = FilterController.finalFiltersExecute(tcs);
            if (result) {
                tcs.setDoTraceFlag(true);
                instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                result = true;
            } else if (!tcs.anyPendingTailFilters()) {
                tcs.setStopTracingFlag(true);
                if (TransactionHarvestHelper.fIntelligentInstrumentationEnabled) {
                    instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                    result = true;
                    tcs.incrementHeadComponentCount();
                }
            } else {
                instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
                tcs.incrementHeadComponentCount();
            }
        } else {
            instanceProvider.offerNewTransactionInstanceElementOnStartTrace(tracerIndex, data, element);
            result = true;
            tcs.incrementHeadComponentCount();
        }
        return result;
    }

    public IDataAccumulatorTracker getTracker() {
        return this.fTracker;
    }

    public Object getFromKeyCacheMap(Object objectKey) {
        if (this.fKeyCacheMap != null) {
            return this.fKeyCacheMap.getWeak(objectKey);
        }
        return null;
    }

    public Object putInKeyCacheMap(Object objectKey, Object blameComponent) {
        if (this.fKeyCacheMap != null) {
            return this.fKeyCacheMap.putWeak(objectKey, blameComponent);
        }
        return blameComponent;
    }

    @Override
    public void abortTransaction(Throwable th, IStackElement data) {
        super.abortTransaction(th, data);
        this.logAbortTransaction(th, data);
        Runnable t = data.getMyThread();
        if (t == null) {
            t = Thread.currentThread();
        }
        StallFeatureBase.getStallPoints().removeWeak(t);
        TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
        if (tcs == null) {
            tcs = VirtualStack.getTransactionCollectStatus();
        }
        if (tcs != null) {
            tcs.setStopTracingFlag(true);
            tcs.setStopCheckingFlag(true);
        }
        StackRecursionHelper.staticSafeRecurseAccessAll(data, kEmergencyCallbackInstance, sMaxTraceableStackDepth);
    }

    public void abortTransactionAsync(Throwable th, IStackElement data) {
        ITransactionCacheProviderFactory stack = InvocationData.getCacheHelper();
        Runnable t = data.getMyThread();
        if (stack.isUseExternalThreadId() && t != null) {
            this.logAbortTransaction(th, data);
            stack.clearExternalThread(t);
            StallFeatureBase.getStallPoints().removeWeak(t);
            TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
            if (tcs != null) {
                tcs.setStopTracingFlag(true);
                tcs.setStopCheckingFlag(true);
            }
            StackRecursionHelper.staticSafeRecurseAccessAll(data, cleanupAllDataEmergencyCallback, sMaxTraceableStackDepth);
        }
    }

    private void logAbortTransaction(Throwable th, IStackElement data) {
        this.logger.log(th, data);
    }

    public boolean notifyNewElement(ITransactionElementProvider provider, Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
        if (this.fChecker.checkAddedElement()) {
            return true;
        }
        if (fHarvesterMetricProperty.isEnabled()) {
            try {
                ILongIntervalCounterDataAccumulator accumulator = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator("Agent Stats|Sustainability|Memory Model:Vetoed Elements");
                accumulator.ILongIntervalCounterDataAccumulator_addSingleIncident();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private long[] ageTransactionStructureAndReturnCount(final long nowInMillis, final long[] previousNumberOfElements) {
        final long[] newCounters = this.prepareTransactionStructureForAgingAndReturnCount();
        this.fAgeAllQueue.IExecutionQueue_addExecutableItem(new IExecutableItem(){

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void IExecutableItem_execute() {
                double percentageIncrease;
                boolean isDebugEnabled = WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(kWilyHarvestingModule);
                double d = percentageIncrease = previousNumberOfElements[0] == 0L ? 100.0 : 100.0 * (((double)newCounters[0] - (double)previousNumberOfElements[0]) / (double)previousNumberOfElements[0]);
                if (percentageIncrease > (double)WilyTransactionStructure.this.fPercentageAttentionLevel || newCounters[0] > (long)WilyTransactionStructure.this.fAbsoluteAttentionLevel || WilyTransactionStructure.this.fAbsoluteAttentionLevel == 0) {
                    if (isDebugEnabled) {
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Executing aging");
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "percentageIncrease = " + percentageIncrease);
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Elements = " + newCounters[0]);
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "fAbsoluteAttentionLevel = " + WilyTransactionStructure.this.fAbsoluteAttentionLevel);
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "fPercentageAttentionLevel = " + WilyTransactionStructure.this.fPercentageAttentionLevel);
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "percentageIncrease > fPercentageAttentionLevel " + (percentageIncrease > (double)WilyTransactionStructure.this.fPercentageAttentionLevel));
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "elements >  fAbsoluteAttentionLevel " + (newCounters[0] > (long)WilyTransactionStructure.this.fAbsoluteAttentionLevel));
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "fAbsoluteAttentionLevel == 0 " + (WilyTransactionStructure.this.fAbsoluteAttentionLevel == 0));
                    }
                    try {
                        if (!WilyTransactionStructure.this.fChecker.setIsExecutingAging(this)) {
                            if (isDebugEnabled) {
                                WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Executing aging not performed because " + ((WilyTransactionStructure)WilyTransactionStructure.this).fChecker.fStartedAging.get() + " is already aging");
                            }
                        } else {
                            VerifyAgingChildrenEditor editor;
                            ITransactionElement root = WilyTransactionStructure.this.getRoot();
                            if (WilyTransactionStructure.this.executeAging(root, editor = new VerifyAgingChildrenEditor(WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback(), nowInMillis, WilyTransactionStructure.this.fAgingTime, 2)) && isDebugEnabled) {
                                WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Executing aging failed, aging all");
                            }
                        }
                    }
                    finally {
                        WilyTransactionStructure.this.fChecker.unsetIsExecutingAging(this);
                    }
                    if (isDebugEnabled) {
                        WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "End Executing aging");
                    }
                }
            }
        });
        return newCounters;
    }

    boolean executeAging(ITransactionElement root, final IChildEditor editor) {
        boolean isAgingDebugActive = fHarvesterMetricProperty.isEnabled();
        long start = 0L;
        if (isAgingDebugActive) {
            start = System.currentTimeMillis();
        }
        final IModuleFeedbackChannel feedback = this.getAgent().IAgent_getModuleFeedback();
        boolean isTraceEnabled = feedback.isTraceEnabled(kWilyHarvestingModule);
        final boolean isDebugEnabled = feedback.isDebugEnabled(kWilyHarvestingModule);
        final long startTime = System.currentTimeMillis();
        final Stack<ITransactionElement> target = new Stack<ITransactionElement>();
        final int[] countRemoved = new int[1];
        int[] countExecuted = new int[1];
        final boolean[] forceExit = new boolean[]{false};
        IChildEditor localEditor = new IChildEditor(){

            @Override
            public boolean removeElement(ITransactionElement e, Object key) {
                boolean result = editor.removeElement(e, key);
                if (result) {
                    countRemoved[0] = countRemoved[0] + 1;
                } else if (e instanceof IEditableTransactionElement) {
                    target.push(e);
                }
                long elapsed = System.currentTimeMillis() - startTime;
                if (elapsed > (long)WilyTransactionStructure.this.fAgingDurationMax) {
                    if (isDebugEnabled) {
                        feedback.debug(kWilyHarvestingModule, "The aging process started at " + new Date(startTime) + " took more than " + WilyTransactionStructure.this.fAgingDurationMax + " ms.");
                    }
                    forceExit[0] = true;
                }
                return result;
            }

            @Override
            public void onPostRemove(ITransactionElement removed) {
                editor.onPostRemove(removed);
            }
        };
        target.push(this.getRoot());
        while (!target.isEmpty() && !forceExit[0]) {
            long elapsed;
            ITransactionElement cursor = (ITransactionElement)target.pop();
            if (cursor instanceof SetElement) {
                cursor = ((SetElement)cursor).element;
            }
            IEditableTransactionElement element = null;
            if (cursor instanceof IEditableTransactionElement) {
                element = (IEditableTransactionElement)((Object)cursor);
            }
            if (element != null) {
                element.offerChildrenForEdit(localEditor);
                countExecuted[0] = countExecuted[0] + 1;
            }
            if ((elapsed = System.currentTimeMillis() - startTime) > (long)this.fAgingDurationMax) {
                forceExit[0] = true;
            }
            if (!forceExit[0] || !isDebugEnabled) continue;
            feedback.debug(kWilyHarvestingModule, "The aging process started at " + new Date(startTime) + " took more than " + this.fAgingDurationMax + " ms. Ending it now. Elements left in the stack" + target.size() + "; processed elements: " + countExecuted[0]);
        }
        if (isTraceEnabled) {
            feedback.trace(kWilyHarvestingModule, "aged out " + countRemoved[0] + " subtrees");
        }
        long start2 = System.currentTimeMillis();
        int removedGlobalGatherers = 0;
        int removedGlobalGathererElements = 0;
        int consideredGlobalGatherersElement = 0;
        int consideredGlobalGatherersElementThatAreEmpty = 0;
        int numberOfEntries = 0;
        Iterator i = this.globalGatherersElements.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry e = i.next();
            ++numberOfEntries;
            Collection map = (Collection)e.getValue();
            int countNotNull = this.isCleanOrNullWeakReferenceCollection(map);
            consideredGlobalGatherersElement += map.size();
            consideredGlobalGatherersElementThatAreEmpty += map.size() - countNotNull;
            if (countNotNull != 0) continue;
            IRepository rep = (IRepository)e.getKey();
            Iterator j = this.globalGatherers.entrySet().iterator();
            while (j.hasNext()) {
                Collection gatherers;
                Map.Entry ej = j.next();
                if (ej.getValue() != rep || (gatherers = (Collection)this.globalGatherersElements.get(rep)) == null || this.isCleanOrNullWeakReferenceCollection(gatherers) != 0) continue;
                j.remove();
                if (isTraceEnabled) {
                    feedback.trace(kWilyHarvestingModule, "Repository " + rep + " is aging out");
                }
                ++removedGlobalGatherers;
            }
            Collection gatherers = (Collection)this.globalGatherersElements.get(rep);
            if (gatherers == null || this.isCleanOrNullWeakReferenceCollection(gatherers) != 0) continue;
            i.remove();
            ++removedGlobalGathererElements;
        }
        if (isAgingDebugActive) {
            this.logGathererStructureSize(consideredGlobalGatherersElement);
            this.logGathererStructureNullSize(consideredGlobalGatherersElementThatAreEmpty);
            this.logGathererSize(this.globalGatherers.size());
            this.logGathererRemoved(removedGlobalGatherers);
            this.logGathererElementsRemoved(removedGlobalGathererElements);
        }
        if (isTraceEnabled) {
            feedback.trace(kWilyHarvestingModule, "consideredGlobalGatherersElement: " + consideredGlobalGatherersElement + ";  consideredGlobalGatherersElementThatAreEmpty:  " + consideredGlobalGatherersElementThatAreEmpty + "; removedGlobalGatherers: " + removedGlobalGatherers + "; remaining global gatherers = " + this.globalGatherers.size());
        }
        long end = System.currentTimeMillis();
        long time = end - start;
        long time2 = end - start2;
        if (isAgingDebugActive) {
            this.logTimeToAgeInGlobal(time2);
            this.logTimeToAge((int)time);
            this.logNodesAged(countRemoved[0]);
        }
        return forceExit[0];
    }

    private int isCleanOrNullWeakReferenceCollection(Collection collection) {
        Collection toBeUsed;
        if (collection.size() == 0) {
            return 0;
        }
        Iterator i = collection.iterator();
        int result = 0;
        boolean hasNulls = false;
        if (i.hasNext()) {
            while (i.hasNext()) {
                WeakReference wr = (WeakReference)i.next();
                if (wr.get() != null) {
                    ++result;
                    continue;
                }
                hasNulls = true;
            }
        }
        if (hasNulls && (toBeUsed = (Collection)kListUsedToRemoveNullWeakReferences.get()) != null) {
            collection.removeAll(toBeUsed);
        }
        return result;
    }

    protected void updateAllPaths(ITransactionElement cursor, long[] counters) {
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        stack.push(cursor);
        long nowTimeStamp = System.currentTimeMillis();
        long sumOfTimeStamps = 0L;
        long countOfTimeStamps = 0L;
        ITransactionElement pivot = cursor;
        ITransactionElement next = cursor;
        while (!stack.isEmpty()) {
            next = (ITransactionElement)stack.peek();
            boolean processNow = true;
            Iterator children = next.iterateChildren();
            if (children != null && children.hasNext()) {
                processNow = false;
                while (children.hasNext()) {
                    ITransactionElement child = (ITransactionElement)children.next();
                    if (child != pivot) continue;
                    processNow = true;
                    break;
                }
                if (!processNow) {
                    children = next.iterateChildren();
                    while (children.hasNext()) {
                        stack.push((ITransactionElement)children.next());
                    }
                }
            }
            if (!processNow) continue;
            counters[0] = counters[0] + 1L;
            long timeStamp = next.lastTouched();
            if (timeStamp != 0L && timeStamp != Long.MAX_VALUE && timeStamp != Long.MIN_VALUE) {
                sumOfTimeStamps += nowTimeStamp - timeStamp;
                ++countOfTimeStamps;
                ITransactionElement parent = next.getParent();
                if (parent != null) {
                    long maxBetweenNextAndParent = Math.max(timeStamp, parent.lastTouched());
                    parent.touch(maxBetweenNextAndParent);
                }
            }
            stack.pop();
            pivot = next;
        }
        counters[1] = nowTimeStamp - sumOfTimeStamps / countOfTimeStamps;
    }

    long[] prepareTransactionStructureForAgingAndReturnCount() {
        long start = 0L;
        if (fHarvesterMetricProperty.isEnabled()) {
            start = System.currentTimeMillis();
        }
        long[] counters = new long[3];
        this.updateAllPaths(this.getRoot(), counters);
        if (fHarvesterMetricProperty.isEnabled()) {
            long end = System.currentTimeMillis();
            long time = end - start;
            this.logTimeToPrepareAging(time);
            this.logDataStructureSize((int)counters[0]);
        }
        return counters;
    }

    private int countElements(AChildReadEditorStack target) {
        int numberOfAliveElement = 0;
        target.clear();
        IChildRead read = target.getEditor();
        target.push(this.getRoot());
        while (!target.isEmpty()) {
            ++numberOfAliveElement;
            ITransactionElement cursor = (ITransactionElement)target.pop();
            if (cursor instanceof SetElement) {
                cursor = ((SetElement)cursor).element;
            }
            if (!cursor.hasChildren()) continue;
            IEditableTransactionElement element = null;
            if (cursor instanceof IEditableTransactionElement) {
                element = (IEditableTransactionElement)((Object)cursor);
            }
            if (element == null) continue;
            element.offerChildrenForRead(read);
        }
        if (fHarvesterMetricProperty.isEnabled()) {
            this.logDataStructureCount(numberOfAliveElement);
        }
        if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(kWilyHarvestingModule)) {
            this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Transaction structure count = " + numberOfAliveElement);
        }
        return numberOfAliveElement;
    }

    public static final int countElements() {
        return WilyTransactionStructure.getInstance().countElements(new AChildReadEditorStack());
    }

    private void clear() throws Exception {
        this.fAgent = null;
        this.fChecker = null;
        this.fKeyCacheMap = null;
        this.fTracker = null;
        this.globalGatherers.clear();
        this.globalGatherersElements.clear();
        appMapFetchingBehavior.getAndSet(null);
        Method clear = this.getRoot().getClass().getSuperclass().getDeclaredMethod("clear", new Class[0]);
        clear.setAccessible(true);
        clear.invoke((Object)this.getRoot(), new Object[0]);
    }

    private void restartAppMapFetchingBehavior() {
        FetchGranularityFromEmBehavior fetchAppMapGranularityFromServer;
        IntervalHeartbeat ih;
        IAgent agent;
        WaitAndExecuteBehavior currentBehavior = appMapFetchingBehavior.getAndSet(null);
        if (currentBehavior != null) {
            currentBehavior.kill();
        }
        if ((agent = this.getAgent()) != null && (ih = agent.IAgent_getCommonHeartbeat()) != null && !appMapFetchingBehavior.compareAndSet(null, fetchAppMapGranularityFromServer = new FetchGranularityFromEmBehavior(ih, 1000L, System.currentTimeMillis() + "Fetch App Map Granularity for Wily Transaction Structure"))) {
            fetchAppMapGranularityFromServer.kill();
        }
    }

    private void restartAging() {
        IRegisteredBehavior agingBehavior;
        IRegisteredBehavior currentBehavior = agingHandle.getAndSet(null);
        if (currentBehavior != null) {
            currentBehavior.close();
        }
        if (!agingHandle.compareAndSet(null, agingBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new AgingTransactionStructureNodesBehavior(), "Aging Transaction Structure Behavior", true, (long)this.fCleanerInterval, false))) {
            agingBehavior.close();
        }
    }

    private void restartAppMapAging(long appMapAging) {
        IRegisteredBehavior agingBehavior;
        AsyncVirtualStack.disoveryTraceAgingPeriod = appMapAging;
        IRegisteredBehavior currentBehavior = agingTransactionStructureHandle.getAndSet(null);
        if (currentBehavior != null) {
            currentBehavior.close();
        }
        if (!agingTransactionStructureHandle.compareAndSet(null, agingBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Advancing AppMap aging counter.");
                WilyTransactionStructure.this.advanceAppMapAgingCounter();
            }
        }, "AppMap Aging Transaction Structure Behavior", true, appMapAging, true))) {
            agingBehavior.close();
        }
    }

    private void restartMemoryModel() {
        IRegisteredBehavior memoryModelBehavior;
        IRegisteredBehavior currentBehavior = memoryModelHandle.getAndSet(null);
        if (currentBehavior != null) {
            currentBehavior.close();
        }
        if (this.fMemoryModelInterval > 0 && !memoryModelHandle.compareAndSet(null, memoryModelBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)new CountTransactionStructureElementsBehavior(), "Memory Model Behavior", true, (long)this.fMemoryModelInterval, false))) {
            memoryModelBehavior.close();
        }
    }

    private void restartCleanup() {
        IRegisteredBehavior memoryModelBehavior;
        IRegisteredBehavior currentBehavior = cleanupHandle.getAndSet(null);
        if (currentBehavior != null) {
            currentBehavior.close();
        }
        if (!cleanupHandle.compareAndSet(null, memoryModelBehavior = this.fAgent.IAgent_getConfigHeartbeat().addBehavior(new ITimestampedRunnable(){

            @Override
            public void ITimestampedRunnable_execute(long nowInMillis) {
                try {
                    WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().trace(kWilyHarvestingModule, "Cleaning the concurrent harvest structures");
                    WilyTransactionStructure.this.cleanupConcurrentHarvestStructures();
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, "Cleanup new data structures Behavior", true, 120000L, false))) {
            memoryModelBehavior.close();
        }
    }

    public void ageImmediately(final InvocationData data) {
        this.fAgeAllQueue.IExecutionQueue_addExecutableItem(new IExecutableItem(){

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            @Override
            public void IExecutableItem_execute() {
                if (WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("Executing aging from invocation data immediately");
                }
                ((IEditableTransactionElement)((Object)WilyTransactionStructure.this.getRoot())).offerChildrenForEdit(new RemoveSubtreeEditor(WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback(), data.getStartTransactionElement()));
                if (WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("End executing aging from invocation data immediately");
                }
            }
        });
    }

    public void ageImmediately(final ITransactionElement element) {
        this.fAgeAllQueue.IExecutionQueue_addExecutableItem(new IExecutableItem(){

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            @Override
            public void IExecutableItem_execute() {
                if (WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("Executing aging from invocation data immediately");
                }
                ((IEditableTransactionElement)((Object)WilyTransactionStructure.this.getRoot())).offerChildrenForEdit(new RemoveSubtreeEditor(WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback(), element));
                if (WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().isDebugEnabled()) {
                    WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("End executing aging from invocation data immediately");
                }
            }
        });
    }

    public void ageAllImmediately() {
        this.fAgeAllQueue.IExecutionQueue_addExecutableItem(new IExecutableItem(){

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            @Override
            public void IExecutableItem_execute() {
                long start = 0L;
                if (fHarvesterMetricProperty.isEnabled()) {
                    start = System.currentTimeMillis();
                }
                WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("Executing aging all immediately");
                ((IEditableTransactionElement)((Object)WilyTransactionStructure.this.getRoot())).offerChildrenForEdit(new IChildEditor(){

                    @Override
                    public boolean removeElement(ITransactionElement e, Object key) {
                        return true;
                    }

                    @Override
                    public void onPostRemove(ITransactionElement removed) {
                        AChildReadEditorStack stack = new AChildReadEditorStack();
                        stack.push(removed);
                        IChildRead read = stack.getEditor();
                        while (!stack.isEmpty()) {
                            ITransactionElement e = (ITransactionElement)stack.pop();
                            if (e == null) continue;
                            e.notifyRemoved();
                            if (!(e instanceof IEditableTransactionElement)) continue;
                            IEditableTransactionElement ee = (IEditableTransactionElement)((Object)e);
                            ee.offerChildrenForRead(read);
                            ee.clearAllChildren();
                        }
                    }
                });
                WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback().debug("End executing aging all immediately");
                if (fHarvesterMetricProperty.isEnabled()) {
                    long end = System.currentTimeMillis();
                    int time = (int)(end - start);
                    WilyTransactionStructure.this.logEmergencyAging(time);
                }
            }
        });
    }

    public void ageBizTrxDataImmediately(final long bizId) {
        this.getAgent().IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){
            final IChildEditor bizTrxEditor;
            {
                this.bizTrxEditor = new BizTCChildrenEditor(WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback(), bizId);
            }

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            @Override
            public void IExecutableItem_execute() {
                ITransactionElement root = WilyTransactionStructure.this.getRoot();
                WilyTransactionStructure.this.executeAging(root, this.bizTrxEditor);
            }
        });
    }

    public void ageFeatureDataImmediately(final int agentFeatureIndicant) {
        this.getAgent().IAgent_getSharedAsyncQueue().IExecutionQueue_addExecutableItem(new IExecutableItem(){
            final IChildEditor featureEditor;
            {
                this.featureEditor = new FeatureConfigAgingChildrenEditor(WilyTransactionStructure.this.fAgent.IAgent_getModuleFeedback(), agentFeatureIndicant);
            }

            @Override
            public boolean IExecutableItem_shouldStillExecute() {
                return true;
            }

            @Override
            public void IExecutableItem_executionAborted() {
            }

            @Override
            public void IExecutableItem_execute() {
                ITransactionElement root = WilyTransactionStructure.this.getRoot();
                WilyTransactionStructure.this.executeAging(root, this.featureEditor);
            }
        });
    }

    private void cleanupConcurrentHarvestStructures() {
        if (this.fShouldCleanup) {
            this.aggharvester.doCleanup(this.fAgent);
        }
    }

    public static short getDepth(ITransactionElement parent) {
        short parentDepth = parent == null ? (short)0 : parent.getDepth();
        short result = (short)(parentDepth + 1);
        if (result > sMaxTraceableStackDepth) {
            throw new TransactionTransitionException("Max depth of traceable stack reached (" + sMaxTraceableStackDepth + "). The agent will not record further information on this transaction. Consider reviewing the level of intrumentation");
        }
        return result;
    }

    public IExecutionQueue getTransactionStructureQueue() {
        return this.fAgeAllQueue;
    }

    public static AgentMetricThresholdTrigger findArtMetricInArrayForThresholdTrigger(AgentMetric[] metrics, Map<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholds, IModuleFeedbackChannel feedback, Module module) {
        for (int i = 0; i < metrics.length; ++i) {
            AgentMetric candidateMetric = metrics[i];
            AgentMetric.AgentMetricKey key = new AgentMetric.AgentMetricKey(candidateMetric.getAttributeURL(), candidateMetric.getAttributeType());
            AgentMetricThresholdTrigger threshold = thresholds.get(key);
            if (feedback != null) {
                feedback.trace(module, "Auto trace threshold: searching for " + key.toString());
            }
            if (threshold == null) continue;
            if (feedback != null) {
                feedback.trace(module, "Auto trace threshold: setting " + key.toString() + " to " + threshold.getElapsedTimeThreshold());
            }
            return threshold;
        }
        return null;
    }

    public boolean setElapsedTimeAutoTracingThresholds(AgentMetricThresholdTrigger[] thresholds) {
        Module module;
        IModuleFeedbackChannel feedback = this.fAgent.IAgent_getModuleFeedback();
        if (!feedback.isTraceEnabled(module = new Module("IntelligentInstrumentationService"))) {
            feedback = null;
        }
        HashMap<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholdMap = this.getThresholdMap(thresholds);
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        stack.push(this.getRoot());
        boolean result = false;
        while (!stack.isEmpty()) {
            Iterator children;
            ITransactionElement pivot = (ITransactionElement)stack.pop();
            if (pivot instanceof SetElement) {
                pivot = ((SetElement)pivot).element;
            }
            if (pivot instanceof BlameTransactionElement) {
                BlameTransactionElement element = (BlameTransactionElement)pivot;
                boolean res = element.setElapsedTimeAutoTraceThreshold(thresholdMap, feedback, module);
                boolean bl = result = result || res;
            }
            if ((children = pivot.iterateChildren()) == null || !children.hasNext()) continue;
            while (children.hasNext()) {
                stack.push((ITransactionElement)children.next());
            }
        }
        Iterator it = this.iterateOverGlobalGatherer();
        while (it.hasNext()) {
            IRepository rep;
            CopyOnWriteArraySet elements;
            Map.Entry e = (Map.Entry)it.next();
            AAgentMetricArray metricArray = (AAgentMetricArray)e.getKey();
            AgentMetric[] metrics = (AgentMetric[])metricArray.getMetrics();
            AgentMetricThresholdTrigger threshold = WilyTransactionStructure.findArtMetricInArrayForThresholdTrigger(metrics, thresholdMap, feedback, module);
            if (threshold == null || (elements = (CopyOnWriteArraySet)this.globalGatherersElements.get(rep = (IRepository)e.getValue())) == null) continue;
            Iterator it2 = elements.iterator();
            while (it2.hasNext()) {
                ITransactionElement element = (ITransactionElement)((TransitiveWeakReference)it2.next()).get();
                if (!(element instanceof BlameTransactionElement)) continue;
                ((BlameTransactionElement)element).setElapsedTimeAutoTraceThreshold(threshold.getElapsedTimeThreshold());
                result = true;
            }
        }
        return result |= AsyncVirtualStack.getInstance(this.fAgent).setElapsedTimeAutoTraceThreshold(thresholdMap);
    }

    public boolean clearElapsedTimeAutoTracingThresholds(AgentMetricThresholdTrigger[] thresholds) {
        Module module;
        IModuleFeedbackChannel feedback = this.fAgent.IAgent_getModuleFeedback();
        if (!feedback.isTraceEnabled(module = new Module("IntelligentInstrumentationService"))) {
            feedback = null;
        }
        HashMap<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholdMap = this.getThresholdMap(thresholds);
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        stack.push(this.getRoot());
        boolean result = false;
        while (!stack.isEmpty()) {
            Iterator children;
            ITransactionElement pivot = (ITransactionElement)stack.pop();
            if (pivot instanceof SetElement) {
                pivot = ((SetElement)pivot).element;
            }
            if (pivot instanceof BlameTransactionElement) {
                BlameTransactionElement element = (BlameTransactionElement)pivot;
                boolean res = element.clearElapsedTimeAutoTraceThreshold(thresholdMap, feedback, module);
                boolean bl = result = result || res;
            }
            if ((children = pivot.iterateChildren()) == null || !children.hasNext()) continue;
            while (children.hasNext()) {
                stack.push((ITransactionElement)children.next());
            }
        }
        Iterator it = this.iterateOverGlobalGatherer();
        while (it.hasNext()) {
            IRepository rep;
            CopyOnWriteArraySet elements;
            Map.Entry e = (Map.Entry)it.next();
            AAgentMetricArray metricArray = (AAgentMetricArray)e.getKey();
            AgentMetric[] metrics = (AgentMetric[])metricArray.getMetrics();
            AgentMetricThresholdTrigger threshold = WilyTransactionStructure.findArtMetricInArrayForThresholdTrigger(metrics, thresholdMap, feedback, module);
            if (threshold == null || (elements = (CopyOnWriteArraySet)this.globalGatherersElements.get(rep = (IRepository)e.getValue())) == null) continue;
            Iterator it2 = elements.iterator();
            while (it2.hasNext()) {
                ITransactionElement element = (ITransactionElement)((TransitiveWeakReference)it2.next()).get();
                if (!(element instanceof BlameTransactionElement)) continue;
                ((BlameTransactionElement)element).clearElapsedTimeAutoTraceThreshold();
                result = true;
            }
        }
        return result |= AsyncVirtualStack.getInstance(this.fAgent).clearElapsedTimeAutoTraceThreshold(thresholdMap);
    }

    public void clearAllElapsedTimeAutoTracingThresholds() {
        Module module;
        IModuleFeedbackChannel feedback = this.fAgent.IAgent_getModuleFeedback();
        if (!feedback.isTraceEnabled(module = new Module("IntelligentInstrumentationService"))) {
            feedback = null;
        }
        Stack<ITransactionElement> stack = new Stack<ITransactionElement>();
        stack.push(this.getRoot());
        while (!stack.isEmpty()) {
            Iterator children;
            ITransactionElement pivot = (ITransactionElement)stack.pop();
            if (pivot instanceof SetElement) {
                pivot = ((SetElement)pivot).element;
            }
            if (pivot instanceof BlameTransactionElement) {
                BlameTransactionElement element = (BlameTransactionElement)pivot;
                if (feedback != null) {
                    feedback.trace(module, "Auto trace threshold  : clearing " + pivot.toString());
                }
                element.clearElapsedTimeAutoTraceThreshold();
            }
            if ((children = pivot.iterateChildren()) == null || !children.hasNext()) continue;
            while (children.hasNext()) {
                stack.push((ITransactionElement)children.next());
            }
        }
        AsyncVirtualStack.getInstance(this.fAgent).clearAllElapsedTimeAutoTraceThresholds();
    }

    private HashMap<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> getThresholdMap(AgentMetricThresholdTrigger[] thresholds) {
        HashMap<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger> thresholdMap = new HashMap<AgentMetric.AgentMetricKey, AgentMetricThresholdTrigger>();
        for (int i = 0; i < thresholds.length; ++i) {
            if (thresholds[i] == null) continue;
            thresholdMap.put(thresholds[i].getMetricKey(), thresholds[i]);
        }
        return thresholdMap;
    }

    private long updateStartTime(long lastExecuted) {
        return 0L;
    }

    private void logNodesAged(int totalNodesAged) {
        if (this.fAgent != null) {
            IDataAccumulator accumulator;
            try {
                accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(kAgingTotalNodesAged);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerFluctuatingCounterDataAccumulator_add(totalNodesAged);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable td) {
                // empty catch block
            }
            try {
                accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingNodesAged);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(totalNodesAged);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logTimeToAge(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingAgingTime);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logGathererStructureSize(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingSizeInGlobal);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logGathererStructureNullSize(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingNullInGlobal);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logGathererSize(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingGathererSize);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logGathererRemoved(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingGatherersRemoved);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logGathererElementsRemoved(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingGatherersElementsRemoved);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logTimeToAgeInGlobal(long value) {
        if (this.fAgent != null) {
            try {
                ILongIntervalCounterDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgingAgingTimeInGlobal);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.ILongAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logTimeToPrepareAging(long value) {
        if (this.fAgent != null) {
            try {
                ILongIntervalCounterDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAgingPrepareAgingTime);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.ILongAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logEmergencyAging(long value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingEmergencyAging);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(1);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logDataStructureSize(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingSizeBeforeAging);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void logDataStructureCount(int value) {
        if (this.fAgent != null) {
            try {
                IIntegerAverageDataAccumulator accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerAverageDataAccumulator(kAgingSizeAtCount);
                if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                    accumulator.IIntegerAggregatingDataAccumulator_recordDataPoint(value);
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static {
        fSuggestSynchronizedProperty = WilyTransactionStructure.computeSynchronized();
        fConcurrentMapSustainabilityMetrics = false;
        fHeadFilterClampEventLogged = false;
        sMaxTraceableStackDepth = (short)4096;
        kListUsedToRemoveNullWeakReferences = new AtomicReference();
        fCountWarnMsgsForTransactionTraceComponentLimitReached = 0;
        kEmergencyCallbackInstance = new EmergencyInvocationDataCleaner();
        cleanupAllDataEmergencyCallback = new EmergencyAllInvocationDataCleaner();
        fstalledInvocationDataThreshold = 1000;
        kDefaultCrossCorrelationProvider = new DefaultCrossCorrelationProvider();
        abortMaxHandle = new AtomicReference<Object>(null);
        memoryModelHandle = new AtomicReference<Object>(null);
        agingHandle = new AtomicReference<Object>(null);
        agingTransactionStructureHandle = new AtomicReference<Object>(null);
        appMapFetchingBehavior = new AtomicReference<Object>(null);
        concurrentMapHealthStatusFetchBehavior = new AtomicReference<Object>(null);
        cleanupHandle = new AtomicReference<Object>(null);
        instance = new WilyTransactionStructure(null);
    }

    public static class AbortedTransactionReportLogger
    implements IConfigurationListener {
        private static final String kAbortLogTotalMetricString = "Agent Stats|Sustainability|Memory Model:Non Traced Transactions (total)";
        private static final String kAbortLogMetricString = "Agent Stats|Sustainability|Memory Model:Non Traced Transactions";
        private static final String kMaxAbortPeriodPropertyName = "com.wily.transactionstructure.abort.log.resetmaxperiod";
        private static final String kMaxAbortPeriodDay = "day";
        private static final String kMaxAbortPeriodHour = "hour";
        private static final String kMaxAbortPeriodMinute = "minute";
        private static final long kMaxAbortPeriodDayValue = 86400000L;
        private static final long kMaxAbortPeriodHourValue = 3600000L;
        private static final long kMaxAbortPeriodMinuteValue = 60000L;
        private static final String kMaxAbortLogPropertyName = "com.wily.transactionstructure.abort.log.maxreportperperiod";
        private static final int kDefaultMaxAbortReportValue = 30;
        private volatile String fMaxAbortLogPeriod;
        private volatile int fMaxAbortLogReportingPerPeriod;
        private final IResource fResource;
        private final IAgent fAgent;
        private final IGuaranteedCounter fCounter;

        AbortedTransactionReportLogger(IAgent agent, IResource resource) {
            this.fAgent = agent;
            if (this.fAgent != null) {
                this.fCounter = this.fAgent.IAgent_getGuaranteedCounter();
                this.fResource = resource;
                this.onChange(agent.IAgent_getIndexedProperties());
            } else {
                this.fResource = null;
                this.fCounter = null;
            }
        }

        @Override
        public void onChange(IndexedProperties newProps) {
            if (this.fAgent != null) {
                this.fMaxAbortLogPeriod = newProps.getTrimmedProperty(kMaxAbortPeriodPropertyName, kMaxAbortPeriodMinute);
                this.fMaxAbortLogReportingPerPeriod = newProps.getIntProperty(kMaxAbortLogPropertyName, 30);
                this.restartAbortLoggingMaxCleaning();
            }
        }

        private void restartAbortLoggingMaxCleaning() {
            IRegisteredBehavior currentBehavior = abortMaxHandle.getAndSet(null);
            if (currentBehavior != null) {
                currentBehavior.close();
            }
            long interval = 60000L;
            if (this.fMaxAbortLogPeriod.equalsIgnoreCase(kMaxAbortPeriodDay)) {
                interval = 86400000L;
            }
            if (this.fMaxAbortLogPeriod.equalsIgnoreCase(kMaxAbortPeriodHour)) {
                interval = 3600000L;
            }
            IRegisteredBehavior agingBehavior = this.fAgent.IAgent_getCommonHeartbeat().addBehavior(new ITimestampedRunnable(){

                @Override
                public void ITimestampedRunnable_execute(long nowInMillis) {
                    AbortedTransactionReportLogger.this.fCounter.reset();
                }
            }, "Abort Logging Max In Interval clean Behavior", true, interval, false);
            if (!abortMaxHandle.compareAndSet(null, agingBehavior)) {
                agingBehavior.close();
            }
        }

        public void log(Throwable th, IStackElement data) {
            if (this.fAgent != null) {
                if (fHarvesterMetricProperty.isEnabled()) {
                    IDataAccumulator accumulator;
                    try {
                        accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(kAbortLogTotalMetricString);
                        if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                            accumulator.IIntegerFluctuatingCounterDataAccumulator_increment();
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable td) {
                        // empty catch block
                    }
                    try {
                        accumulator = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(kAbortLogMetricString);
                        if (accumulator != null && !(accumulator instanceof DataAccumulatorFactory.NullAccumulatorImpl)) {
                            accumulator.ILongAggregatingDataAccumulator_recordDataPoint(1L);
                        }
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable td) {
                        // empty catch block
                    }
                }
                int valueOfCounter = this.fCounter.next();
                try {
                    if (this.fMaxAbortLogReportingPerPeriod < 0 || valueOfCounter <= this.fMaxAbortLogReportingPerPeriod) {
                        this.reportAbort(th, data);
                    } else if (valueOfCounter == this.fMaxAbortLogReportingPerPeriod + 1) {
                        this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Reached " + valueOfCounter + " stopped transaction traces in the time period of one " + this.fMaxAbortLogPeriod + ". This is above the clamp limit of " + this.fMaxAbortLogReportingPerPeriod + ". No more log information will be reported in this time period");
                    }
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        private void reportAbort(Throwable th, IStackElement data) {
            if (this.fAgent.IAgent_getModuleFeedback().isDebugEnabled(kWilyHarvestingModule)) {
                String localizedMessage = th.getLocalizedMessage();
                if (localizedMessage == null) {
                    localizedMessage = th.getMessage();
                }
                if (localizedMessage == null) {
                    localizedMessage = th.toString();
                }
                this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, Thread.currentThread().getName() + " Transaction tracing can't continue: " + localizedMessage);
                WilyStringBuilder result = new WilyStringBuilder("-------------------<start>--------------------");
                result.append("\n").append("Report of stop of transaction tracing").append("\n");
                try {
                    result.append("----- Thread and Stack Trace").append("\n");
                    String threadSignature = Thread.currentThread().getName();
                    result.append("Thread name: ").append(threadSignature).append("]").append("\n");
                    result.append(th.toString()).append("\n");
                }
                catch (Exception threadSignature) {
                    // empty catch block
                }
                Throwable pivot = th;
                while (pivot != null) {
                    try {
                        StackTraceElement[] ste = pivot.getStackTrace();
                        for (int i = 0; i < ste.length; ++i) {
                            try {
                                result.append("  ").append(ste[i].getClassName()).append(".").append(ste[i].getMethodName()).append("(").append(ste[i].getLineNumber()).append("\n");
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if ((pivot = pivot.getCause()) == null) continue;
                        result.append("Caused by").append("\n");
                    }
                    catch (Exception ste) {}
                }
                result.append("----- Transaction Structure path").append("\n");
                try {
                    ITransactionElement leaf;
                    int leafCounter = 0;
                    if (leaf != null) {
                        String path = "\n";
                        for (leaf = data.getCursor(); leaf != null; leaf = leaf.getParent()) {
                            if (leaf instanceof IStringRepresentable) {
                                path = "->" + ((IStringRepresentable)((Object)leaf)).getStringRepresentation() + path;
                                continue;
                            }
                            if (leaf instanceof SetElement) {
                                if ((leaf = ((SetElement)leaf).getElement()) instanceof IStringRepresentable) {
                                    path = "->" + ((IStringRepresentable)((Object)leaf)).getStringRepresentation() + path;
                                    continue;
                                }
                                if (!(leaf instanceof ITransactionElement)) continue;
                                path = "->" + leaf.toString() + "[" + leaf.countChildren() + "]" + path;
                                continue;
                            }
                            if (!(leaf instanceof ITransactionElement)) continue;
                            path = "->" + leaf.toString() + "[" + leaf.countChildren() + "]" + path;
                            if (leafCounter++ <= 256) continue;
                        }
                        result.append(path.substring(0, Math.min(2048, path.length() - 1))).append("\n");
                    }
                }
                catch (Exception leaf) {
                    // empty catch block
                }
                int stackCounter = 0;
                while (data != null) {
                    if (data instanceof InvocationData) {
                        InvocationData iData = (InvocationData)data;
                        result.append("----- Stack Information").append("\n");
                        try {
                            result.append("Invocation Object: ").append(iData.getInvocationObject().toString()).append("\n");
                        }
                        catch (Exception path) {
                            // empty catch block
                        }
                        try {
                            result.append("Invocation class: ").append(iData.getInvocationObject().getClass().getName()).append("\n");
                        }
                        catch (Exception path) {
                            // empty catch block
                        }
                        try {
                            ITracer[] tracers = iData.getTracersByType(null);
                            for (int i = 0; i < tracers.length; ++i) {
                                try {
                                    result.append(tracers[i].getClass().getName()).append(";").append(iData.getComponentNameAt(i)).append("\n");
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        catch (Exception exception) {}
                    } else if (data instanceof VirtualElement) {
                        try {
                            VirtualElement element = (VirtualElement)data;
                            result.append("-------------").append("\n");
                            result.append(element.getComponentName()).append("\n");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    data = data.getParent();
                    if (stackCounter++ <= 64) continue;
                }
                result.append("-------------------<end>----------------------").append("\n");
                this.fAgent.IAgent_getModuleFeedback().debug(kWilyHarvestingModule, result.toString());
            }
        }
    }

    static class TransitiveWeakReference
    extends WeakReference {
        public TransitiveWeakReference(Object referent) {
            super(referent);
        }

        public int hashCode() {
            Object o = this.get();
            return o == null ? 0 : o.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (other instanceof WeakReference) {
                Object otherObject = ((WeakReference)other).get();
                Object mine = this.get();
                if (mine == null) {
                    return otherObject == null;
                }
                return mine.equals(otherObject);
            }
            return false;
        }
    }

    private static class DefaultBackendBlameStackAnnotator
    implements IBlameStackAnnotator {
        boolean isBackendAnnotationEnabled = true;

        public DefaultBackendBlameStackAnnotator(IAgent agent) {
            this.isBackendAnnotationEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty(WilyTransactionStructure.kBackendSocketAnnotationEnablingProperty, true);
        }

        @Override
        public void annotateBlameStack(Object key, String localAddress, String host, String address, int port, LazyMetricNameProvider lazyMetricNameProvider, InvocationData data, boolean alsoDoAppMap) {
            IStackElement element = VirtualStack.peek();
            boolean isElementWrappedData = element instanceof WrappedInvocationData;
            boolean isElementInvocationData = element instanceof InvocationData;
            if (element != null && (isElementInvocationData || isElementWrappedData)) {
                InvocationData parentData = null;
                if (isElementInvocationData) {
                    parentData = (InvocationData)element;
                } else if (isElementWrappedData) {
                    parentData = ((WrappedInvocationData)element).getInvocationData();
                }
                if (!parentData.isTransactionAborted()) {
                    ITransactionElement currentCursor = parentData.getCursor();
                    this.annotateBlameStack(key, localAddress, host, address, port, lazyMetricNameProvider, currentCursor, parentData, true);
                    if (!alsoDoAppMap && data != null && parentData != null) {
                        data.setHasNewCursor();
                        data.setParent(parentData);
                    }
                }
            }
        }

        private void annotateBlameStack(Object key, String localAddress, String host, String address, int port, LazyMetricNameProvider lazyMetricNameProvider, ITransactionElement currentCursor, IStackElement data, boolean alsoDoAppMap) {
            if (currentCursor != null && (this.isBackendAnnotationEnabled || VirtualStack.getTransactionCache().getBackendsCount() == 0)) {
                SocketTransactionElement cursorElement = null;
                cursorElement = DefaultBackendHelper.getInstance().submitNextDefaultBackendCursor(key, localAddress, host, address, port, lazyMetricNameProvider, currentCursor, data, alsoDoAppMap);
                if (cursorElement != null) {
                    data.addAppMapSocketCursor(cursorElement);
                }
            }
        }

        @Override
        public void annotateBlameStack(Object key, String localAddress, String host, String address, int port, ITransactionElement currentCursor, IStackElement data, boolean alsoDoAppMap) {
            if (!data.isTransactionAborted()) {
                this.annotateBlameStack(key, localAddress, host, address, port, null, currentCursor, data, alsoDoAppMap);
            }
        }

        private boolean hasBackendInStack(ITransactionElement cursor) {
            while (cursor != null) {
                if (cursor instanceof IBlameTransactionElement) {
                    return ((IBlameTransactionElement)cursor).hasBackendInStack();
                }
                cursor = cursor.getParent();
            }
            return false;
        }
    }

    private static class DefaultStructureProvider
    implements ITransactionElementProvider {
        private DefaultStructureProvider() {
        }

        @Override
        public ITransactionElement getElement(Object key, ITransactionElement parent) {
            return new APureMapTransactionElement(parent, false){

                @Override
                public void notifyPublished() {
                }

                @Override
                public void notifyRemoved() {
                    this.invalidate();
                }
            };
        }

        @Override
        public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return this.getElement(key, parent);
        }

        @Override
        public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return this.getElement(key, parent);
        }
    }

    static final class DefaultCrossCorrelationProvider
    implements ITransactionElementProvider,
    ITransactionInstanceProvider {
        DefaultCrossCorrelationProvider() {
        }

        @Override
        public ITransactionElement getElement(Object key, ITransactionElement parent) {
            return this.getElementOnStartTrace(key, 0, null, parent);
        }

        @Override
        public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            data.notifyStackElementOfNewCrossCorrelation(key);
            return new ACrossCorrelationElement(key, parent, true, kDefaultCrossCorrelationProvider);
        }

        @Override
        public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement data, ITransactionElement parent) {
            return new ACrossCorrelationElement(key, parent, false, kDefaultCrossCorrelationProvider);
        }

        @Override
        public boolean isActive() {
            return true;
        }

        @Override
        public void offerNewTransactionInstanceElementOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        }

        @Override
        public void offerNewTransactionInstanceElementOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
            TransactionCollectStatus tcs = data.getTransactionCollectionStatus();
            if (tcs != null) {
                tcs.decrementTxnTraceComponentCount();
            }
        }

        @Override
        public void suggestEndTrace(int tracerIndex, IStackElement data, ITransactionElement newElement) {
        }

        @Override
        public ISamplingResult preSample(IStackElement data) {
            return ISamplingResult.NO;
        }
    }

    static final class EmergencyInvocationDataCleaner
    extends EmergencyAllInvocationDataCleaner {
        EmergencyInvocationDataCleaner() {
        }

        @Override
        public boolean doOnElement(IStackElement pivot) {
            if (pivot instanceof InvocationData && pivot.getParent() != null) {
                this.doOnEmergency((InvocationData)pivot);
                return true;
            }
            return false;
        }
    }

    static class EmergencyAllInvocationDataCleaner
    implements IStackElementCallbackOnRecursion {
        EmergencyAllInvocationDataCleaner() {
        }

        @Override
        public boolean doOnElement(IStackElement pivot) {
            if (pivot instanceof InvocationData) {
                this.doOnEmergency((InvocationData)pivot);
                return true;
            }
            return false;
        }

        protected void doOnEmergency(InvocationData data) {
            BlamePointTracer.doOnSetEmergencyMode(data);
            StallFeatureBase.doOnTransactionAbort(data);
            data.setEmergencyMode();
        }
    }

    public static class MaxStalledInvocationDataThresholdProperty
    extends PositiveIntegerConfigurationProperty {
        private MaxStalledInvocationDataThresholdProperty(IAgent agent) {
            super(WilyTransactionStructure.kStalledInvocationDataThreshold, 1000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fstalledInvocationDataThreshold = (Integer)newValue;
        }
    }

    private final class MaxTraceableStackDepthProperty
    extends PositiveIntegerConfigurationProperty {
        private MaxTraceableStackDepthProperty(IAgent agent) {
            super(WilyTransactionStructure.kMaxTraceableStackDepthProperty, 4096, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            sMaxTraceableStackDepth = ((Integer)newValue).shortValue();
            StackRecursionHelper.initializeMaxRecursionHelper(sMaxTraceableStackDepth);
            WilyTransactionStructure.this.ageAllImmediately();
        }
    }

    static final class CrossJVMFilterEnableProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private CrossJVMFilterEnableProperty(IAgent agent) {
            super("introscope.agent.transactiontracer.crossjvm.enabled", Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        @Override
        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    static final class CEMForceTraceConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private CEMForceTraceConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kCEMForceTraceEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        @Override
        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    static final class OptimizeHarvestingConfigurationProperty
    extends BooleanConfigurationProperty {
        volatile boolean value;

        private OptimizeHarvestingConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kOptimizeHarvestingEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.value;
        }

        @Override
        public void set(Object newValue) {
            this.value = (Boolean)newValue;
        }
    }

    static final class HarvesterSustainabilityMetricsConfigurationProperty
    extends BooleanConfigurationProperty {
        private volatile boolean areHarvesterMetricsEnabled = false;
        private volatile boolean areSustainabilityMetricsEnabled = false;

        private HarvesterSustainabilityMetricsConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kHarvesterSustainabilityMetricsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        public boolean isEnabled() {
            return this.areSustainabilityMetricsEnabled && this.areHarvesterMetricsEnabled;
        }

        public void setSustainabilityMetricsEnabled(boolean value) {
            this.areSustainabilityMetricsEnabled = value;
        }

        @Override
        public void set(Object newValue) {
            this.areHarvesterMetricsEnabled = (Boolean)newValue;
        }
    }

    private static final class HighConcurrencyStripesConfigurationProperty
    extends PositiveIntegerConfigurationProperty {
        private HighConcurrencyStripesConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kHighConcurrencyStripesDefaultProperty, 16, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fDefaultNumberOfStripes = (Integer)newValue;
        }
    }

    private final class TransactionStructureAgingAbsoluteAttentionLevelProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureAgingAbsoluteAttentionLevelProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureAgingAbsoluteAttentionLevelProperty, 100000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fAbsoluteAttentionLevel = (Integer)newValue;
        }
    }

    private final class TransactionStructureAgingAgingPercentageAttentionLevelProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureAgingAgingPercentageAttentionLevelProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureAgingPercentageAttentionLevelProperty, 5, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fPercentageAttentionLevel = (Integer)newValue;
        }
    }

    private final class TransactionStructureAgingDurationMaxProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureAgingDurationMaxProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureAgingDurationMaxProperty, 30000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fAgingDurationMax = (Integer)newValue;
        }
    }

    private final class TransactionStructureAgingProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureAgingProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureAgingProperty, 60000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fAgingTime = (Integer)newValue;
        }
    }

    private static final class IntelligentInstrumentationMinComponentCountConfigurationProperty
    extends PositiveIntegerConfigurationProperty {
        private IntelligentInstrumentationMinComponentCountConfigurationProperty(IAgent agent) {
            super("com.wily.introscope.agent.intelligentinstrumentation.min.componentcount", 3, "TT_Min_Component_Count", agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fIntelligentInstrumentationMinComponentCount = (Integer)newValue;
        }
    }

    private static final class TTComponentClampConfigurationProperty
    extends PositiveIntegerConfigurationProperty {
        private TTComponentClampConfigurationProperty(IAgent agent) {
            super("introscope.agent.transactiontrace.componentCountClamp", 5000, "TT_Component_Count_Limit", agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fComponentCountClamp = (Integer)newValue;
        }
    }

    private final class TransactionStructureCreationCheckProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureCreationCheckProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureCreationCheckProperty, 30000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fMemoryModelInterval = (Integer)newValue;
            WilyTransactionStructure.this.restartMemoryModel();
        }
    }

    private final class TransactionStructureAgingCheckProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureAgingCheckProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureAgingCheckProperty, 30000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            WilyTransactionStructure.this.fCleanerInterval = (Integer)newValue;
            WilyTransactionStructure.this.restartAging();
        }
    }

    private static final class TransactionEnablingProperty
    extends BooleanConfigurationProperty {
        private TransactionEnablingProperty(String name, Boolean defaultValue, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer) {
            super(name, defaultValue, feedback, module, localizer);
        }

        @Override
        public void set(Object newValue) {
            fTransactionTraceEnablingProperty = (Boolean)newValue;
        }
    }

    static final class StallTraceConfigurationProperty
    extends BooleanConfigurationProperty {
        private StallTraceConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kStallTraceEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestStallTraceProperty = (Boolean)newValue;
        }
    }

    static final class ConcurrentConfigurationProperty
    extends BooleanConfigurationProperty {
        private ConcurrentConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kConcurrentEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestConcurrentProperty = (Boolean)newValue;
        }
    }

    static final class ErrorConfigurationProperty
    extends BooleanConfigurationProperty {
        private ErrorConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kErrorEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestErrorProperty = (Boolean)newValue;
        }
    }

    static final class PerIntervalConfigurationProperty
    extends BooleanConfigurationProperty {
        private PerIntervalConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kPerIntervalEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestPerIntervalProperty = (Boolean)newValue;
        }
    }

    static final class TimerConfigurationProperty
    extends BooleanConfigurationProperty {
        private TimerConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kTimerEnablingProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestTimerProperty = (Boolean)newValue;
        }
    }

    final class SynchronizedConfigurationProperty
    extends BooleanConfigurationProperty {
        private SynchronizedConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kSynchronizedEnablingProperty, WilyTransactionStructure.computeSynchronized() ? Boolean.TRUE : Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestSynchronizedProperty = (Boolean)newValue;
            if (fSuggestSynchronizedProperty) {
                WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().info(kWilyHarvestingModule, "Newly created concurrent counters will use synchronized approach");
            } else {
                WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().info(kWilyHarvestingModule, "Newly created concurrent counters will use CAS approach");
            }
        }
    }

    static final class ShouldUseSharedAccumulatorsForSameMetricConfigurationProperty
    extends BooleanConfigurationProperty {
        private ShouldUseSharedAccumulatorsForSameMetricConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kShouldUseSharedAccumulatorsForSameMetricProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fShouldUseSharedAccumulatorsForSameMetric = (Boolean)newValue;
        }
    }

    static final class HighConcurrencyConfigurationProperty
    extends BooleanConfigurationProperty {
        private HighConcurrencyConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kHighConcurrencyEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fSuggestHighConcurrency = (Boolean)newValue;
        }
    }

    static final class DoBusinessComponentBackendsConfigurationProperty
    extends BooleanConfigurationProperty {
        private DoBusinessComponentBackendsConfigurationProperty(IAgent agent) {
            super(WilyTransactionStructure.kBusinessComponentBackendsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fDoBackendForTransactionComponents = (Boolean)newValue;
        }
    }

    static final class DoGenerateContextualMetricsProperty
    extends BooleanConfigurationProperty {
        private DoGenerateContextualMetricsProperty(IAgent agent) {
            super(WilyTransactionStructure.kGenerateContextualMetricsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fGenerateContextualMetrics = (Boolean)newValue;
        }
    }

    static final class DoGenerateMetricLengthProperty
    extends PositiveIntegerConfigurationProperty {
        private DoGenerateMetricLengthProperty(IAgent agent) {
            super(WilyTransactionStructure.kGenerateMetricsLengthProperty, 1000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fTransactionStructureMetricsMaxLength = (Integer)newValue;
        }
    }

    static final class DoGenerateSustainabilityMetricsProperty
    extends BooleanConfigurationProperty {
        private DoGenerateSustainabilityMetricsProperty(IAgent agent) {
            super(WilyTransactionStructure.kGenerateSustainabilityMetricsEnablingProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fGenerateSustainabilityMetrics = (Boolean)newValue;
        }
    }

    private static final class TransactionStructureCreationAbsoluteAttentionLevelProperty
    extends PositiveIntegerConfigurationProperty {
        private TransactionStructureCreationAbsoluteAttentionLevelProperty(IAgent agent) {
            super(WilyTransactionStructure.kTransactionStructureCreationAbsoluteAttentionLevelProperty, 100000, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            AElementCreationWatchdog.kAbsoluteCreationAttentionLevel = (Integer)newValue;
        }
    }

    final class DoConcurrentMapSustainablityMetricsProperty
    extends BooleanConfigurationProperty {
        private DoConcurrentMapSustainablityMetricsProperty(IAgent agent) {
            super(WilyTransactionStructure.fConcurrentMapSustainabilityMetricProperty, Boolean.FALSE, agent.IAgent_getModuleFeedback(), kWilyHarvestingModule, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            fConcurrentMapSustainabilityMetrics = (Boolean)newValue;
        }
    }

    private final class SustainabilityMetricUpdater
    implements ISustainabilityMetricsCallback {
        private SustainabilityMetricUpdater() {
        }

        @Override
        public void sustainabilityMetricInterval(long nowInMillis) {
            IConcurrentMapFactory factory;
            if (WilyTransactionStructure.checkWithOverheadMgr()) {
                return;
            }
            if (fConcurrentMapSustainabilityMetrics && (factory = WilyTransactionStructure.this.getAgent().IAgent_getConcurrentMapFactory()) != null && factory instanceof IConcurrentMapHealthStatusProvider) {
                DataAccumulatorFactory daf = WilyTransactionStructure.this.getAgent().IAgent_getDataAccumulatorFactory();
                IConcurrentMapHealthStatusProvider provider = (IConcurrentMapHealthStatusProvider)((Object)factory);
                try {
                    IConcurrentMapHealthStatus status = provider.getConcurrentMapHealthStatus();
                    Iterator i = status.getCurrentHealthStatusItems();
                    while (i.hasNext()) {
                        try {
                            IConcurrentMapHealthStatus.IConcurrentMapHealthStatusItem item = (IConcurrentMapHealthStatus.IConcurrentMapHealthStatusItem)i.next();
                            String baseMetricName = "Agent Stats|Sustainability|Singleton Maps|" + item.getName();
                            String statusString = this.getStatusString(item);
                            daf.safeGetStringConstantDataAccumulator(baseMetricName + ":type", statusString);
                            if (item.isCapped()) {
                                daf.safeGetIntegerFluctuatingCounterDataAccumulator(baseMetricName + ":max capacity").IIntegerCounterDataAccumulator_setValue(item.getMaxCapacity());
                            }
                            daf.safeGetIntegerFluctuatingCounterDataAccumulator(baseMetricName + ":initial capacity").IIntegerCounterDataAccumulator_setValue(item.getStartCapacity());
                            daf.safeGetIntegerFluctuatingCounterDataAccumulator(baseMetricName + ":current size").IIntegerCounterDataAccumulator_setValue(item.getCurrentSize());
                        }
                        catch (ThreadDeath t) {
                            throw t;
                        }
                        catch (Throwable throwable) {
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            SustainabilityService.reportAgentErrorMetrics();
            SustainabilityService.reportAutoProbeErrorCountMetric();
        }

        private String getStatusString(IConcurrentMapHealthStatus.IConcurrentMapHealthStatusItem item) {
            String result = "Standard";
            if (item.isAging()) {
                result = "Aging";
            }
            if (item.isCapped()) {
                result = result + ", Capped";
            }
            if (item.isWeakKey()) {
                result = result + ", Weak";
            }
            return result;
        }

        @Override
        public void sustainabilityMetricsEnabled() {
            fHarvesterMetricProperty.setSustainabilityMetricsEnabled(true);
        }

        @Override
        public void sustainabilityMetricsDisabled() {
            fHarvesterMetricProperty.setSustainabilityMetricsEnabled(false);
        }
    }

    private final class AgingTransactionStructureNodesBehavior
    implements ITimestampedRunnable {
        volatile long[] numberOfElements = new long[3];

        private AgingTransactionStructureNodesBehavior() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            block3: {
                IModuleFeedbackChannel feedback = WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback();
                boolean isDebugEnabled = feedback.isDebugEnabled(kWilyHarvestingModule);
                try {
                    this.numberOfElements = WilyTransactionStructure.this.ageTransactionStructureAndReturnCount(nowInMillis, this.numberOfElements);
                }
                catch (ThreadDeath td) {
                    throw td;
                }
                catch (Throwable t) {
                    if (!isDebugEnabled) break block3;
                    feedback.debug(kWilyHarvestingModule, "Error while checking transaction structure for aging", t);
                }
            }
        }
    }

    private final class CountTransactionStructureElementsBehavior
    implements ITimestampedRunnable {
        final AChildReadEditorStack target = new AChildReadEditorStack();

        private CountTransactionStructureElementsBehavior() {
        }

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            int elements = WilyTransactionStructure.this.countElements(this.target);
            WilyTransactionStructure.this.fChecker.setTotalNumberOfNodesAsOfNow(elements);
            WilyTransactionStructure.this.fChecker.checkTransactionStructure(elements);
            developmentDebug = WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().isTraceEnabled(kStackModule);
        }
    }

    private static final class CrossProcessCorrelationTransactionCallback
    implements SharedCrossProcessData.IOnCorrelationIncomingCallBack {
        private CrossProcessCorrelationTransactionCallback() {
        }

        @Override
        public void doOnCorrelation(SharedCrossProcessData data) {
            String key = data.getCorrelationBlameKey();
            if (key != null) {
                VirtualStack.pushPlaceholder(key, kDefaultCrossCorrelationProvider, (ITransactionInstanceProvider)((Object)kDefaultCrossCorrelationProvider));
            }
        }
    }

    private static final class SharedElementTracker
    implements IDataAccumulatorTracker {
        private final IAgent fAgent;

        private SharedElementTracker(IAgent fAgent) {
            this.fAgent = fAgent;
        }

        @Override
        public void IDataAccumulatorTracker_trackAccumulator(IDataAccumulator accumulator) {
            this.fAgent.IAgent_getMetricRecordingAdministrator().trackMetricOnSharedElement(accumulator.IDataAccumulator_getMetric(), accumulator);
        }

        @Override
        public void IDataAccumulatorTracker_untrackAccumulator(IDataAccumulator accumulator) {
            this.fAgent.IAgent_getMetricRecordingAdministrator().untrackMetric(accumulator.IDataAccumulator_getMetric());
        }
    }

    private final class WilyTransactionStructureAgingValueCommand
    implements IAppMapAgentServiceCommand {
        public static final String kMapAgingOverride = "introscope.agent.map.aging.granularity.override";
        private final FetchGranularityFromEmBehavior behavior;
        private long valueFromEm = -1L;

        WilyTransactionStructureAgingValueCommand(FetchGranularityFromEmBehavior behavior) {
            this.behavior = behavior;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAgentCommandCompletion(int status) {
            if (status == 0) {
                try {
                    if (this.valueFromEm > 0L) {
                        if (this.valueFromEm < 15000L) {
                            this.valueFromEm = 15000L;
                            WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().warn(kWilyHarvestingModule, "Retrieved value " + this.valueFromEm + " for Triage Map ageing. The value is too small, increasing it to " + 15000L + " . Please check configuration");
                        } else {
                            WilyTransactionStructure.this.getAgent().IAgent_getModuleFeedback().debug(kWilyHarvestingModule, "Retrieved value " + this.valueFromEm + " for Triage Map ageing");
                        }
                        WilyTransactionStructure.this.restartAppMapAging(this.valueFromEm);
                    }
                    this.behavior.kill();
                }
                catch (Throwable t) {
                    Object object = this.behavior.lock;
                    synchronized (object) {
                        this.behavior.sent = false;
                    }
                }
            } else {
                Object object = this.behavior.lock;
                synchronized (object) {
                    this.behavior.sent = false;
                }
            }
        }

        @Override
        public void handleAgentCommand(IAppMapAgentService service) throws ConnectionException {
            int valueFromProp = WilyTransactionStructure.this.getAgent().IAgent_getIndexedProperties().getIntProperty(kMapAgingOverride, -1);
            this.valueFromEm = valueFromProp == -1 ? service.getGranularityForAgent() : (long)valueFromProp;
        }
    }

    private final class FetchGranularityFromEmBehavior
    extends WaitAndExecuteBehavior {
        final Object lock;
        volatile boolean sent;

        private FetchGranularityFromEmBehavior(IntervalHeartbeat register, long wait, String name) {
            super(register, wait, name);
            this.lock = new Object();
            this.sent = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean execute() {
            IsengardServerConnectionManager manager = WilyTransactionStructure.this.fAgent.IAgent_getIsengardServerConnection();
            if (manager != null && manager.getConnectedServer() != null && manager.getConnectedServer().isConnected()) {
                Object object = this.lock;
                synchronized (object) {
                    if (!this.sent) {
                        WilyTransactionStructureAgingValueCommand command = new WilyTransactionStructureAgingValueCommand(this);
                        this.sent = manager.addToCommandQueue(command);
                    }
                }
                return false;
            }
            return false;
        }
    }
}

