/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.ASocketCounter;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.util.properties.AttributeListing;

public abstract class SocketConcurrentInvocationCounter
extends ASocketCounter
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public SocketConcurrentInvocationCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    protected final IIntegerFluctuatingCounterDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(formattedMetricName);
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
        SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
        this.increaseCacheQuantity(cache);
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        SocketFormatMetricsCache cache = (SocketFormatMetricsCache)data.getPartialSocketFormattedName();
        this.decreaseCacheQuantity(cache);
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    protected abstract void increaseCacheQuantity(SocketFormatMetricsCache var1);

    protected abstract void decreaseCacheQuantity(SocketFormatMetricsCache var1);

    @Override
    protected IDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName = this.quickFormat(data, this.getMetricPosition());
        if (formattedName != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }
}

