/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketFormatterCache;
import com.wily.util.properties.AttributeListing;
import java.net.Socket;

public class SocketFormatterCacheOnFinishTrace
extends SocketFormatterCache {
    public SocketFormatterCacheOnFinishTrace(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return;
        }
        this.executeCache(data);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        return this;
    }

    private void executeCache(InvocationData data) {
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof Socket) {
            Socket socket = (Socket)invocationObject;
            if (!socket.isBound() && !socket.isConnected()) {
                data.setSocketRequired(false);
                data.setHasSocketResource(false);
                return;
            }
            this.allocateTracerAndCache(data, invocationObject, socket);
        } else {
            Object resultObject = data.getInvocationReturnValueAsObject();
            if (resultObject == null) {
                return;
            }
            Socket socket = (Socket)resultObject;
            this.allocateTracerAndCache(data, invocationObject, socket);
        }
    }

    @Override
    protected final int getMetricPosition() {
        return 1;
    }
}

