/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io.clamp;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.clamp.ASocketClampManager;
import com.wily.introscope.agent.trace.io.clamp.TracedSockets;
import com.wily.util.properties.AttributeListing;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketInitClampManager
extends ASocketClampManager {
    public SocketInitClampManager(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    protected void decideOnClamp(InvocationData data) {
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        boolean traced = false;
        try {
            Socket socket;
            InetSocketAddress endPoint = (InetSocketAddress)data.getInvocationParameterAsObject(0);
            Object invocationObject = data.getInvocationObject();
            if (invocationObject instanceof Socket && (socket = (Socket)invocationObject).isBound() && socket.isConnected()) {
                traced = TracedSockets.isTraced(endPoint);
                if (!traced) {
                    traced = TracedSockets.add(endPoint);
                }
                if (!traced) {
                    data.setSocketClamp(!traced);
                }
            }
        }
        catch (Exception e) {
            this.getModuleFeedback().error(e);
        }
    }
}

