/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.nio;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.nio.ChannelPerIntervalCounter;
import com.wily.introscope.agent.trace.nio.SelectorOpenWatcher;
import com.wily.introscope.agent.trace.nio.SocketAcceptMappingTracer;
import com.wily.introscope.agent.trace.nio.SocketChannelMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public final class SocketConnectPerIntervalCounter
extends ChannelPerIntervalCounter
implements ITracer {
    public SocketConnectPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof SocketChannel) {
            if (SelectorOpenWatcher.isInSelectorOpen()) {
                return null;
            }
            Object addressObject = data.getInvocationParameterAsObject(0);
            if (addressObject instanceof InetSocketAddress) {
                return this;
            }
            Assertion.wilyAssert("Instrumentation error: method parameter is not an InetSocketAddress");
        } else {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a SocketChannel");
        }
        return null;
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        ILongIntervalCounterDataAccumulator count;
        if (SocketAcceptMappingTracer.checkWithOverheadMgr()) {
            return;
        }
        if (data.isSocketClamped()) {
            return;
        }
        if (!data.hasInvocationThrownException() && data.hasMethodResultAvailable() && ((Boolean)data.getInvocationReturnValueAsObject()).booleanValue() && (count = this.createDataAccumulator(data)) != null && !count.IDataAccumulator_isShutOff()) {
            count.ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        Object invocationObject = data.getInvocationObject();
        SocketChannel channel = (SocketChannel)invocationObject;
        if (SocketChannelMap.isRequired(channel, this.getAgent()) && (formattedName = this.formatParameterizedName(data)) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }
}

