/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transformer.dynamic;

import com.wily.introscope.agent.transformer.dynamic.IOverheadListener;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;

public class OverheadAdministrator {
    private static CopyOnWriteArrayList<IOverheadListener> overheadListeners = new CopyOnWriteArrayList();
    private static volatile OverheadMode overheadMode = null;
    private static long lastModifiedOverheadMode = 0L;
    public static volatile int OVERHEAD_MODE_CHANGE_FREQUENCY_LIMIT_IN_MIN = 30;

    public static boolean setOverheadMode(OverheadMode mode, IModuleFeedbackChannel feedbackChannel, boolean checkModifiedTime) {
        if (checkModifiedTime) {
            long longTimeDiffInMs;
            long diff;
            if (lastModifiedOverheadMode > 0L && (diff = (long)(OVERHEAD_MODE_CHANGE_FREQUENCY_LIMIT_IN_MIN * 60 * 1000) - (longTimeDiffInMs = System.currentTimeMillis() - lastModifiedOverheadMode)) > 0L) {
                feedbackChannel.warn("Ignore to change overhead level to " + OverheadAdministrator.getDisplayValue(mode) + ", please modify the overhead level property again after " + TimeUnit.MILLISECONDS.toMinutes(diff) + " minute(s)");
                return false;
            }
            if (overheadMode != null) {
                lastModifiedOverheadMode = System.currentTimeMillis();
            }
        }
        overheadMode = mode;
        for (IOverheadListener listener : overheadListeners) {
            listener.setOverheadMode(mode);
        }
        return true;
    }

    public static String getDisplayValue(OverheadMode mode) {
        if (OverheadMode.ABSOLUTE_LOW == mode) {
            return "none";
        }
        if (OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == mode) {
            return "low";
        }
        return "normal";
    }

    public static void registerOverheadControlSubscriber(IOverheadListener listener) {
        overheadListeners.add(listener);
    }

    public static void unregisterOverheadControlSubscriber(IOverheadListener listener) {
        overheadListeners.remove(listener);
    }

    public static OverheadMode getOverheadMode() {
        return overheadMode;
    }
}

