/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.util.AgentFileUtil;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public final class LogFileUtilities {
    public static final char kIllegalCharReplacement = '_';
    public static final String kLogExtension = "log";
    public static final String kWellKnownLog4jAppenderPrefix = "log4j.appender";
    public static final String kWellKnownLog4jAppenderSuffix = "File";
    public static final String kWellKnownLog4jLogFilePropKey = "log4j.appender.logfile.File";
    public static final String kInheritanceLog4jLogFilePropKey = "log4j.appender.pbdlog.File";
    private static final String kTimestampFormatString = "yyyyMMdd-HHmmss";
    private static final SimpleDateFormat kTimestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    public static final int kMaxRenameAppendFileLengthInBytes = 262144;
    private static final String kAppendFileTooLongSuffix = "old";

    private LogFileUtilities() {
    }

    public static String appendUniqueTimestampToLogFileName(String fileName) throws IOException {
        Calendar rightNow = Calendar.getInstance();
        String timestamp = kTimestampFormat.format(rightNow.getTime());
        fileName = LogFileUtilities.appendIdentifierToLogFileName(fileName, timestamp, false);
        fileName = LogFileUtilities.appendUniqueIdentifierToLogFile(fileName);
        return fileName;
    }

    public static String appendUniqueIdentifierToLogFile(String fileName) throws IOException {
        if (fileName == null) {
            return null;
        }
        File logFile = new File(fileName);
        int i = 1;
        boolean success;
        while (!(success = logFile.createNewFile())) {
            fileName = fileName.toLowerCase(Locale.US).endsWith(".log") ? fileName.substring(0, fileName.lastIndexOf(46)) + '_' + i + '.' + kLogExtension : fileName + '_' + i;
            logFile = new File(fileName);
            ++i;
        }
        return fileName;
    }

    private static String appendIdentifierToLogFileName(String fileName, String identifier, boolean replaceIllegalChars) {
        if (fileName == null) {
            return null;
        }
        if (replaceIllegalChars) {
            identifier = StringUtils.replaceNonAlphaNumericCharacters(identifier, '_');
        }
        fileName = fileName.toLowerCase(Locale.US).endsWith(".log") ? fileName.substring(0, fileName.lastIndexOf(46)) + '.' + identifier + '.' + kLogExtension : fileName + '.' + identifier + '.' + kLogExtension;
        return fileName;
    }

    public static String appendIdentifierToLogFileName(String fileName, String identifier) {
        return LogFileUtilities.appendIdentifierToLogFileName(fileName, identifier, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameLogFile(String oldFilename, String newFilename, boolean appendMode, int maxFileLengthInBytes) {
        File oldFile = new File(oldFilename);
        File newFile = new File(newFilename);
        FileOutputStream fos = null;
        FileInputStream fis = null;
        if (!oldFile.exists()) {
            return false;
        }
        try {
            boolean success = false;
            if (newFile.exists()) {
                if (appendMode) {
                    if (oldFile.length() > (long)maxFileLengthInBytes) {
                        String renamedNewFilename = LogFileUtilities.appendIdentifierToLogFileName(newFilename, kAppendFileTooLongSuffix);
                        renamedNewFilename = LogFileUtilities.appendUniqueIdentifierToLogFile(renamedNewFilename);
                        File renamedNewFile = new File(renamedNewFilename);
                        renamedNewFile.delete();
                        newFile.renameTo(renamedNewFile);
                        success = oldFile.renameTo(newFile);
                    } else {
                        fos = new FileOutputStream(newFilename, true);
                        fis = new FileInputStream(oldFile);
                        byte[] bytes = new byte[(int)oldFile.length()];
                        fis.read(bytes);
                        fos.write(bytes);
                        fis.close();
                        fos.close();
                        oldFile.delete();
                        success = true;
                    }
                } else {
                    newFile.delete();
                    success = oldFile.renameTo(newFile);
                }
            } else {
                success = oldFile.renameTo(newFile);
            }
            boolean bl = success;
            return bl;
        }
        catch (IOException ioe) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void ensureLogFilePath(String desiredPath) {
        LogFileUtilities.ensureLogFilePath(desiredPath, null);
    }

    public static void ensureLogFilePath(String desiredPath, IModuleFeedbackChannel feedback) {
        if (desiredPath != null) {
            try {
                File file = new File(desiredPath);
                File parent = file.getParentFile();
                if (parent != null && !parent.exists()) {
                    parent.mkdirs();
                    AgentFileUtil.fixGroupPermissionsAndOwner(parent);
                    if (feedback != null && feedback.isDebugEnabled()) {
                        feedback.debug("Making directories for path: " + parent.getAbsolutePath());
                    }
                }
                if (!file.exists()) {
                    file.createNewFile();
                    AgentFileUtil.fixGroupPermissionsAndOwner(file);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static List<String> getAppendersBasedOnFile(Properties newProps) {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<?> enumeration = newProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!propertyName.startsWith(kWellKnownLog4jAppenderPrefix) || !propertyName.endsWith(kWellKnownLog4jAppenderSuffix)) continue;
            result.add(propertyName);
        }
        return result;
    }

    public static void makeSureParentExists(File file) {
        File parent = file.getParentFile();
        if (parent == null) {
            return;
        }
        if (!parent.exists()) {
            LogFileUtilities.makeSureParentExists(parent);
            parent.mkdirs();
            AgentFileUtil.fixGroupPermissionsAndOwner(parent);
        }
    }
}

