/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.etc;

import com.wily.introscope.etc.BannerPrinter;
import com.wily.util.ALifeCycle;
import com.wily.util.ApplicationHelper;
import com.wily.util.clock.MasterClock;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;

public abstract class AIntroscopeApplication
extends ALifeCycle {
    private final String fFullName;
    private final String fShortName;
    private final ApplicationFeedback fFeedback;
    private IStringLocalizer fStringLocalizer;
    private final IVersion fVersion;
    private final BannerPrinter fBannerPrinter;
    private final long fLaunchTime = MasterClock.currentTimeMillis();

    protected AIntroscopeApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String localizedFullName, String localizedShortName) {
        this(feedback, localizer, version, localizedFullName, localizedShortName, true, true);
    }

    protected AIntroscopeApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String localizedFullName, String localizedShortName, boolean showStartingMessage) {
        this(feedback, localizer, version, localizedFullName, localizedShortName, showStartingMessage, true);
    }

    protected AIntroscopeApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String localizedFullName, String localizedShortName, boolean showStartingMessage, boolean callFinish) {
        this.fFullName = localizedFullName;
        this.fShortName = localizedShortName;
        this.fStringLocalizer = localizer;
        this.fVersion = version;
        this.fBannerPrinter = new BannerPrinter(feedback, localizer);
        this.fFeedback = feedback;
        this.fFeedback.setApplicationName(localizedShortName);
        if (callFinish) {
            this.finishStartup(showStartingMessage);
        }
    }

    public final ApplicationFeedback getApplicationFeedback() {
        return this.fFeedback;
    }

    public final IModuleFeedbackChannel getModuleFeedback() {
        return this.getApplicationFeedback();
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void setStringLocalizer(IStringLocalizer localizer) {
        this.fStringLocalizer = localizer;
    }

    public IVersion getVersion() {
        return this.fVersion;
    }

    public String getFullName() {
        return this.fFullName;
    }

    public String getShortName() {
        return this.fShortName;
    }

    public long getLaunchTime() {
        return this.fLaunchTime;
    }

    private BannerPrinter getBannerPrinter() {
        return this.fBannerPrinter;
    }

    private final void writeAppSpecificBanner() {
        this.doWriteAppSpecificBanner();
    }

    protected void doWriteAppSpecificBanner() {
    }

    protected void finishStartup(boolean showStartingMessage) {
        this.getBannerPrinter().printVersionBanner(this.getVersion(), this.getFullName());
        this.writeAppSpecificBanner();
        this.getBannerPrinter().printLegaleseBanner();
        if (showStartingMessage) {
            this.getModuleFeedback().info(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("FormattedApplicationStartingString", this.getFullName()));
        }
    }

    public static void handleLaunchFailure(String message) {
        ApplicationHelper.handleLaunchFailure(message);
    }

    public static void handleLaunchFailure(String[] messages) {
        ApplicationHelper.handleLaunchFailure(messages);
    }
}

