/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.spec.server.transactiontrace;

import com.wily.introscope.spec.server.transactiontrace.ATransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.IFailFastTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.ILegacyTransactionTraceFilter;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;

public class CEMBusinessTransactionTraceFilter
extends ATransactionTraceFilter
implements IFailFastTransactionTraceFilter,
ILegacyTransactionTraceFilter,
Externalizable {
    private static final long serialVersionUID = 4701750805504271919L;
    private static final String kGuidKey = "CorGUID";
    private static final int kGuidMapMaximumSize = 1000;
    private static final int kGUIDSetSize = 32;
    private static final int kInvalidHashCode = 1;
    private String fBusinessTransactionName;
    private static volatile boolean fFilterPassed = false;
    private static LinkedList[] brtaGUIDArray = new LinkedList[32];

    static {
        int i = 0;
        while (i < 32) {
            CEMBusinessTransactionTraceFilter.brtaGUIDArray[i] = new LinkedList();
            ++i;
        }
    }

    public CEMBusinessTransactionTraceFilter(String businessTransactionName) {
        this();
        this.fBusinessTransactionName = businessTransactionName;
    }

    public CEMBusinessTransactionTraceFilter() {
    }

    @Override
    public boolean shouldCollect(Map parameters) {
        return "true".equals(parameters.get("CEM Force Trace")) || fFilterPassed || this.shouldCollectTT(parameters);
    }

    private boolean shouldCollectTT(Map parameters) {
        Assertion.wilyAssert(false);
        return "true".equals(parameters.get("CEM Force Trace")) || this.fBusinessTransactionName.equals(parameters.get("EUM Business Transaction")) || this.fBusinessTransactionName.equals(parameters.get("CEM Business Transaction"));
    }

    private boolean cemTransactionMatches(TransactionComponentData data) {
        if (data == null) {
            return false;
        }
        Map<String, String> params = data.getParameters();
        return this.shouldCollectTT(params);
    }

    private boolean shouldCollectBrta(Map parameters) {
        LinkedList guidSet;
        boolean guidKeyToCompare;
        int hashCode;
        Assertion.wilyAssert(false);
        String guidKey = (String)parameters.get(kGuidKey);
        if (guidKey != null && (hashCode = this.getHashCode(guidKey)) != 1 && (guidKeyToCompare = (guidSet = brtaGUIDArray[hashCode]).contains(guidKey))) {
            this.removeGUIDFromMap(guidKey);
            return true;
        }
        return false;
    }

    private boolean brtaTransactionMatches(TransactionComponentData data) {
        if (data == null) {
            return false;
        }
        if (data.getSubNodeCount() > 0) {
            return false;
        }
        Map<String, String> params = data.getParameters();
        return this.shouldCollectBrta(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addGUIDMap(TransactionComponentData root) {
        Map<String, String> parameters = root.getParameters();
        String guidKey = parameters.get(kGuidKey);
        int hashCode = this.getHashCode(guidKey);
        if (hashCode != 1) {
            LinkedList linkedList = brtaGUIDArray[hashCode];
            synchronized (linkedList) {
                LinkedList guidSet = brtaGUIDArray[hashCode];
                guidSet.add(guidKey);
                this.cleanGUIDMap(this.getHashCode(guidKey));
            }
            return;
        }
        TransactionComponentData child1 = null;
        if (root.getSubNodeCount() > 0) {
            child1 = root.getCalledComponent(0);
        }
        if (child1 != null) {
            parameters = child1.getParameters();
            guidKey = parameters.get(kGuidKey);
            hashCode = this.getHashCode(guidKey);
            if (hashCode != 1) {
                LinkedList guidSet = brtaGUIDArray[hashCode];
                synchronized (guidSet) {
                    LinkedList guidSet2 = brtaGUIDArray[hashCode];
                    guidSet2.add(guidKey);
                    this.cleanGUIDMap(hashCode);
                }
                return;
            }
        } else {
            return;
        }
        TransactionComponentData child1ofchild1 = null;
        if (child1.getSubNodeCount() > 0) {
            child1ofchild1 = child1.getCalledComponent(0);
        }
        if (child1ofchild1 != null && (hashCode = this.getHashCode(guidKey = (parameters = child1ofchild1.getParameters()).get(kGuidKey))) != 1) {
            LinkedList linkedList = brtaGUIDArray[hashCode];
            synchronized (linkedList) {
                LinkedList guidSet = brtaGUIDArray[hashCode];
                guidSet.add(guidKey);
                this.cleanGUIDMap(hashCode);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeGUIDFromMap(String guidKey) {
        int hashCode = this.getHashCode(guidKey);
        if (hashCode != 1) {
            LinkedList linkedList = brtaGUIDArray[hashCode];
            synchronized (linkedList) {
                LinkedList guidSet = brtaGUIDArray[hashCode];
                guidSet.remove(guidKey);
            }
        }
    }

    private void cleanGUIDMap(int hashCode) {
        LinkedList guidSet;
        if (hashCode != 1 && (guidSet = brtaGUIDArray[hashCode]).size() > 1000) {
            Iterator iter = guidSet.iterator();
            Object firstObject = iter.next();
            guidSet.remove(firstObject);
        }
    }

    private int getHashCode(String guidKey) {
        if (guidKey == null) {
            return 1;
        }
        int key = guidKey.hashCode();
        return key & 0x1F;
    }

    private boolean cemPassesFilter(TransactionComponentData root) {
        if (this.cemTransactionMatches(root)) {
            this.addGUIDMap(root);
            return true;
        }
        TransactionComponentData child1 = null;
        if (root.getSubNodeCount() > 0) {
            child1 = root.getCalledComponent(0);
        }
        if (child1 == null) {
            return false;
        }
        if (child1 != null && this.cemTransactionMatches(child1)) {
            this.addGUIDMap(root);
            return true;
        }
        TransactionComponentData child1of1 = null;
        if (child1 != null && child1.getSubNodeCount() > 0) {
            child1of1 = child1.getCalledComponent(0);
        }
        if (child1of1 == null) {
            return false;
        }
        if (child1of1 != null && this.cemTransactionMatches(child1of1)) {
            this.addGUIDMap(root);
            return true;
        }
        return false;
    }

    @Override
    public boolean ITransactionTraceFilter_passesFilter(TransactionComponentData root) {
        if (root == null) {
            return false;
        }
        if (this.cemPassesFilter(root)) {
            if (!fFilterPassed) {
                fFilterPassed = true;
            }
            return true;
        }
        if (this.brtaTransactionMatches(root)) {
            this.setTraceTypeToNormal(root);
            if (!fFilterPassed) {
                fFilterPassed = true;
            }
            return true;
        }
        return false;
    }

    private void setTraceTypeToNormal(TransactionComponentData root) {
        if (root.getParameterValue("Trace Type") == null) {
            root.setParameterValue("Trace Type", "Normal");
        }
    }

    public static int getFilterType() {
        return 9;
    }

    @Override
    public int ITransactionTraceFilter_getFilterType() {
        return CEMBusinessTransactionTraceFilter.getFilterType();
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedDescription(IStringLocalizer localizer) {
        return localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Generic_Filter_Description_Message", this.ITransactionTraceFilter_getLocalizedStatusMessage(localizer));
    }

    public CEMBusinessTransactionTraceFilter read(DataInput in) throws IOException {
        CEMBusinessTransactionTraceFilter filter = new CEMBusinessTransactionTraceFilter();
        filter.readInternal(in);
        return filter;
    }

    public String getBusinessTransactionName() {
        return this.fBusinessTransactionName;
    }

    public int hashCode() {
        return this.fBusinessTransactionName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CEMBusinessTransactionTraceFilter) {
            CEMBusinessTransactionTraceFilter filter = (CEMBusinessTransactionTraceFilter)obj;
            return this.fBusinessTransactionName.equals(filter.fBusinessTransactionName);
        }
        return false;
    }

    @Override
    public void ITransactionTraceFilter_write(DataOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        this.writeInternal(out);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readInternal(in);
    }

    public void writeInternal(DataOutput out) throws IOException {
        out.writeUTF(this.fBusinessTransactionName);
    }

    private void readInternal(DataInput in) throws IOException {
        this.fBusinessTransactionName = in.readUTF();
    }

    public String toString() {
        return "[businesstransactionname = " + this.fBusinessTransactionName + "]";
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer) {
        String name = "EUM Business Transaction";
        String value = this.fBusinessTransactionName == null ? "" : this.fBusinessTransactionName;
        String operation = localizer.IStringLocalizer_getLocalizedString("Transaction_Trace_Parameter_Operator_Equals_Text");
        String text = localizer.IStringLocalizer_getFormattedLocalizedString("Transaction_Trace_Status_Bar_Parameter_Filter_Message", new String[]{name, operation, value});
        return text;
    }

    @Override
    public String ITransactionTraceFilter_getLocalizedStatusMessage(IStringLocalizer localizer, Locale locale) {
        String name = "EUM Business Transaction";
        String value = this.fBusinessTransactionName == null ? "" : this.fBusinessTransactionName;
        String operation = localizer.IStringLocalizer_getLocalizedString(locale, "Transaction_Trace_Parameter_Operator_Equals_Text");
        String text = localizer.IStringLocalizer_getFormattedLocalizedString(locale, "Transaction_Trace_Status_Bar_Parameter_Filter_Message", new String[]{name, operation, value});
        return text;
    }

    @Override
    public boolean isHeadFilter() {
        return true;
    }

    @Override
    public Boolean shouldCollectHead(Map parameters) {
        return this.shouldCollect(parameters) ? Boolean.TRUE : null;
    }

    @Override
    public boolean shouldCollectFinal() {
        return false;
    }
}

