/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.blame;

import com.wily.util.HashCodeUtils;
import com.wily.wilyassert.Assertion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class BlameStackSnapshot
implements Externalizable {
    private static final long serialVersionUID = 963713399615289694L;
    public static final BlameStackSnapshot kEmptyBlameStackSnapshot = new BlameStackSnapshot(null, "");
    private BlameStackSnapshot fParent;
    private String fComponent;
    private transient int fComponentCount;
    private transient int fHashCode;

    public static BlameStackSnapshot getBlameStackSnapshot(BlameStackSnapshot parent, String component) {
        Assertion.wilyAssert(false);
        Assertion.wilyAssert(false);
        return new BlameStackSnapshot(parent, component);
    }

    public static BlameStackSnapshot getBlameStackSnapshot(String component) {
        return BlameStackSnapshot.getBlameStackSnapshot(kEmptyBlameStackSnapshot, component);
    }

    public BlameStackSnapshot() {
    }

    private BlameStackSnapshot(BlameStackSnapshot parent, String component) {
        this.fParent = parent;
        this.fComponent = component;
        this.fComponentCount = this.calculateComponentCount();
        this.fHashCode = this.calculateHashCode();
    }

    private int calculateComponentCount() {
        return this.fParent == null ? 0 : this.fParent.getComponentCount() + 1;
    }

    public BlameStackSnapshot getParent() {
        return this.fParent;
    }

    public String getLastComponent() {
        return this.fComponent;
    }

    public int getComponentCount() {
        return this.fComponentCount;
    }

    public String getComponent(int index) {
        if (index < 0 || index >= this.fComponentCount) {
            throw new IndexOutOfBoundsException("Index " + index + " is outside the range [0," + this.fComponentCount + ")");
        }
        return this.internalGetComponent(index);
    }

    private String internalGetComponent(int index) {
        if (index == this.fComponentCount - 1) {
            return this.fComponent;
        }
        return this.fParent.internalGetComponent(index);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == BlameStackSnapshot.class) {
            return this.equals((BlameStackSnapshot)obj);
        }
        return false;
    }

    public boolean equals(BlameStackSnapshot snapshot) {
        if (snapshot != null) {
            if (this.fParent == null) {
                return snapshot.fParent == null;
            }
            return this.fComponent.equals(snapshot.fComponent) && this.fParent.equals(snapshot.fParent);
        }
        return false;
    }

    private int calculateHashCode() {
        int hash = 17;
        hash = HashCodeUtils.accumulateHashCode(hash, this.fComponent == null ? 0 : this.fComponent.hashCode());
        hash = HashCodeUtils.accumulateHashCode(hash, this.fParent == null ? 0 : this.fParent.hashCode());
        return hash;
    }

    public int hashCode() {
        return this.fHashCode;
    }

    private void addComponents(StringBuffer buffer, boolean addTrailingSeparator) {
        if (this.fParent != null) {
            this.fParent.addComponents(buffer, true);
            buffer.append(this.fComponent);
            if (addTrailingSeparator) {
                buffer.append("|");
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        this.addComponents(buffer, false);
        buffer.append("]");
        return buffer.toString();
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.fParent);
        out.writeObject(this.fComponent);
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fParent = (BlameStackSnapshot)in.readObject();
        this.fComponent = (String)in.readObject();
        this.fComponentCount = this.calculateComponentCount();
        this.fHashCode = this.calculateHashCode();
    }
}

