/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.messageprimitives.service;

import com.wily.isengard.messageprimitives.ConnectionException;
import com.wily.isengard.messageprimitives.service.IMessageReplyTimeout;
import com.wily.isengard.messageprimitives.service.IllegalAccessException;
import com.wily.isengard.messageprimitives.service.IllegalServiceAccessException;
import com.wily.isengard.messageprimitives.service.MessageServiceClient;
import com.wily.isengard.messageprimitives.service.MessageServiceInfo;
import com.wily.isengard.messageprimitives.service.Messages;
import com.wily.isengard.messageprimitives.service.ServiceException;
import com.wily.isengard.messageprimitives.service.ServiceNotFoundException;
import com.wily.isengard.postoffice.Address;
import com.wily.isengard.postoffice.PostOffice;
import com.wily.isengard.registry.IRegistryService;
import com.wily.isengard.registry.RegistryEntry;
import com.wily.isengard.util.tree.DirectoryPath;
import com.wily.isengard.util.tree.EntryNotFoundException;
import com.wily.isengard.util.tree.InvalidPathException;
import com.wily.util.exception.UnexpectedExceptionError;

public final class MessageServiceFactory {
    private static final char kRootPath = '/';

    private MessageServiceFactory() {
    }

    @Deprecated
    public static <T> T getInterface(PostOffice po, Class<T> interfaceClass) throws ConnectionException, IllegalServiceAccessException {
        return MessageServiceFactory.getInterface(po, interfaceClass, null);
    }

    @Deprecated
    public static <T> T getInterface(PostOffice po, Class<T> interfaceClass, MessageServiceInfo info) throws ConnectionException, IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, info);
    }

    @Deprecated
    public static <T> T getInterface(PostOffice po, Class<T> interfaceClass, String location) throws ConnectionException, IllegalServiceAccessException {
        try {
            return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, location, null);
        }
        catch (IllegalAccessException e) {
            throw new IllegalServiceAccessException(Messages.getString("MessageServiceFactory.IllegalServiceAccessException"), e);
        }
        catch (ServiceException e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static <T> T getServiceSafe(PostOffice po, Class<T> interfaceClass) {
        try {
            return MessageServiceFactory.getService(po, interfaceClass);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static <T> T getServiceSafe(PostOffice po, Class<T> interfaceClass, String location) {
        try {
            return MessageServiceFactory.getService(po, interfaceClass, location);
        }
        catch (Exception e) {
            throw new UnexpectedExceptionError(e);
        }
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, null);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, IMessageReplyTimeout timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, timeout);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, long timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, null, timeout);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, String location, long timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, location, timeout);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, String location) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, location, null);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, Address address) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, address, 600000L);
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, Address address, long timeout) throws IllegalServiceAccessException {
        if (address.getInvocationHandler() != null) {
            return interfaceClass.cast(address.getInvocationHandler());
        }
        MessageServiceClient<T> client = new MessageServiceClient<T>(po, interfaceClass, address, timeout);
        return client.proxyInterface();
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, MessageServiceInfo serviceInfo) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, serviceInfo.getServiceAddress());
    }

    public static <T> T getService(PostOffice po, Class<T> interfaceClass, MessageServiceInfo serviceInfo, long timeout) throws IllegalServiceAccessException {
        return MessageServiceFactory.getService(po, interfaceClass, serviceInfo.getServiceAddress(), timeout);
    }

    private static <T> T internalGetServiceInterface(PostOffice po, Class<T> interfaceClass, String relativeServiceName, long timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, relativeServiceName, timeout, null);
    }

    private static <T> T internalGetServiceInterface(PostOffice po, Class<T> interfaceClass, String relativeServiceName, IMessageReplyTimeout timeout) throws ConnectionException, ServiceException {
        return MessageServiceFactory.internalGetServiceInterface(po, interfaceClass, relativeServiceName, -1L, timeout);
    }

    private static <T> T internalGetServiceInterface(PostOffice po, Class<T> interfaceClass, String relativeServiceName, long timeout, IMessageReplyTimeout timeoutCallback) throws ConnectionException, ServiceException {
        if (po == null) {
            throw new ConnectionException(Messages.getString("MessageServiceFactory.NoPostOfficeSpecifiedException"));
        }
        String absoluteServiceName = relativeServiceName != null ? "/service/" + interfaceClass.getName() + "/" + relativeServiceName : "/service/" + interfaceClass.getName();
        try {
            IRegistryService regClient = po.getRegistry();
            RegistryEntry entry = regClient.getEntry(new DirectoryPath(absoluteServiceName));
            Address address = entry.getAddress();
            if (address != null && address.getInvocationHandler() != null) {
                return interfaceClass.cast(address.getInvocationHandler());
            }
            MessageServiceClient<T> client = null;
            client = timeoutCallback != null ? new MessageServiceClient<T>(po, interfaceClass, address, timeoutCallback) : (timeout != -1L ? new MessageServiceClient<T>(po, interfaceClass, address, timeout) : new MessageServiceClient<T>(po, interfaceClass, address));
            return interfaceClass.cast(client.proxyInterface());
        }
        catch (IllegalServiceAccessException e) {
            throw new IllegalAccessException(Messages.getString("MessageServiceFactory.IllegalServiceAccessException"), e);
        }
        catch (InvalidPathException ipe) {
            throw new ServiceNotFoundException(String.valueOf(Messages.getString("MessageServiceFactory.InvalidRegistryPathException")) + ": " + absoluteServiceName, ipe);
        }
        catch (EntryNotFoundException e) {
            throw new ServiceNotFoundException(Messages.getString("MessageServiceFactory.EntryNotFoundException"), e);
        }
    }
}

