/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.util;

import com.wily.isengard.api.TransportConfiguration;
import com.wily.isengard.postoffice.ClassLoaderManager;
import com.wily.isengard.postoffice.PostOfficeHub;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectInputStream;
import com.wily.isengard.postofficehub.link.v1.IsengardObjectOutputStream;
import com.wily.isengard.util.SanitizingClassLoaderObjectInputStream;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.SystemOutFeedbackChannel;
import com.wily.util.io.FastGZIPInputStream;
import com.wily.util.io.IKeyedClassLoader;
import com.wily.util.io.NonSyncBufferedInputStream;
import com.wily.util.io.NonSyncBufferedOutputStream;
import com.wily.util.io.NonSyncByteArrayInputStream;
import com.wily.util.io.NonSyncByteArrayOutputStream;
import com.wily.util.thread.DefaultThreadFactory;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPOutputStream;

public class AgentSerializationUtils {
    private static final IModuleFeedbackChannel kDebugFeedback = new SystemOutFeedbackChannel("DEFAULT", SeverityLevel.DEBUG);
    public static final ClassLoaderManager kClassLoaderManager;
    public static final IKeyedClassLoader kKeyedClassLoader;

    static {
        PostOfficeHub hub = new PostOfficeHub(new TransportConfiguration(), kDebugFeedback, new DefaultThreadFactory(true));
        kClassLoaderManager = hub.getClassLoaderManager();
        kKeyedClassLoader = kClassLoaderManager.getKeyedClassLoader();
    }

    private AgentSerializationUtils() {
    }

    public static String serializableObjectToString(Object serializableObject) throws IOException {
        NonSyncByteArrayOutputStream byteArrayOutputStream = new NonSyncByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializableObject);
        String result = StringUtils.byteArrayToString(byteArrayOutputStream.toByteArray());
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return result;
    }

    public static Object getSerializableObjectFromString(String objectString) throws IOException, ClassNotFoundException {
        return AgentSerializationUtils.getSerializableObjectFromString(objectString, null);
    }

    public static Object getSerializableObjectFromString(String objectString, ClassLoader cl) throws IOException, ClassNotFoundException {
        return AgentSerializationUtils.getSerializableObjectFromString(objectString, cl, null, null);
    }

    public static Object getSerializableObjectFromString(String objectString, ClassLoader cl, String[] allowedClasses, String[] deniedClasses) throws IOException, ClassNotFoundException, SecurityException {
        byte[] byteArray = StringUtils.stringToByteArray(objectString);
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        NonSyncByteArrayInputStream byteArrayInputStream = new NonSyncByteArrayInputStream(byteArray);
        SanitizingClassLoaderObjectInputStream objectInputStream = new SanitizingClassLoaderObjectInputStream(cl, byteArrayInputStream, allowedClasses, deniedClasses);
        Object result = objectInputStream.readObject();
        objectInputStream.close();
        byteArrayInputStream.close();
        return result;
    }

    public static byte[] serializableObjectToByteArray(Object serializable) throws IOException {
        NonSyncByteArrayOutputStream byteStream = new NonSyncByteArrayOutputStream();
        IsengardObjectOutputStream outputStream = new IsengardObjectOutputStream(byteStream, 2, kKeyedClassLoader, kDebugFeedback);
        outputStream.writeObject(serializable);
        return byteStream.toByteArray();
    }

    public static Object getSerializableObjectFromByteArray(byte[] bytes) throws IOException, ClassNotFoundException {
        NonSyncByteArrayInputStream byteStream = new NonSyncByteArrayInputStream(bytes);
        IsengardObjectInputStream inputStream = new IsengardObjectInputStream(kKeyedClassLoader, byteStream, kDebugFeedback);
        return inputStream.readObject();
    }

    public static byte[] serializeObjectToCompressedByteArray(IsengardObjectOutputStream parentOutStream, Object object) throws IOException {
        NonSyncByteArrayOutputStream byteOutput = new NonSyncByteArrayOutputStream();
        GZIPOutputStream gzipOutput = new GZIPOutputStream(byteOutput){
            {
                this.def.setLevel(1);
            }
        };
        NonSyncBufferedOutputStream fastOutput = new NonSyncBufferedOutputStream(gzipOutput);
        IsengardObjectOutputStream zipObjectOut = new IsengardObjectOutputStream(parentOutStream, fastOutput);
        zipObjectOut.writeObject(object);
        zipObjectOut.close();
        return byteOutput.toByteArray();
    }

    public static Object getCompressedSerializedObjectFromByteArray(IsengardObjectInputStream parentInputStream, byte[] inData) throws IOException, ClassNotFoundException {
        NonSyncByteArrayInputStream byteInput = new NonSyncByteArrayInputStream(inData);
        FastGZIPInputStream gzipInput = new FastGZIPInputStream(byteInput);
        NonSyncBufferedInputStream fastInput = new NonSyncBufferedInputStream(gzipInput);
        IsengardObjectInputStream zipObjectInput = new IsengardObjectInputStream(parentInputStream, fastInput);
        Object result = zipObjectInput.readObject();
        zipObjectInput.close();
        return result;
    }
}

