/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class IntHashtable {
    private static final int kDefaultInitialCapacity = 11;
    private static final float kLoadFactor = 1.0f;
    private Entry[] fTable;
    private int fCount;

    public IntHashtable() {
        this(11);
    }

    public IntHashtable(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("Capacity must be positive: " + initialCapacity);
        }
        this.fCount = 0;
        this.fTable = new Entry[initialCapacity];
    }

    public synchronized int getSize() {
        return this.fCount;
    }

    public synchronized void put(int key, Object value) {
        Entry newEntry;
        int index = (++key & Integer.MAX_VALUE) % this.fTable.length;
        Entry e = this.fTable[index];
        while (e != null) {
            if (e.fKey == key) {
                e.fValue = value;
                return;
            }
            e = e.fNext;
        }
        e = this.fTable[index];
        this.fTable[index] = newEntry = new Entry(key, value, e);
        ++this.fCount;
        if ((float)this.fCount > (float)this.fTable.length * 1.0f) {
            this.rehash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int key) {
        Entry[] table = this.fTable;
        int index = (++key & Integer.MAX_VALUE) % table.length;
        if (key == 0) {
            IntHashtable intHashtable = this;
            synchronized (intHashtable) {
                Entry e = table[index];
                while (e != null) {
                    if (e.fKey == key) {
                        return e.fValue;
                    }
                    e = e.fNext;
                }
            }
        } else {
            Entry e = table[index];
            while (e != null) {
                if (e.fKey == key) {
                    return e.fValue;
                }
                e = e.fNext;
            }
        }
        return null;
    }

    private void rehash() {
        Entry[] newTable = new Entry[this.fTable.length * 2 + 1];
        int i = 0;
        while (i < this.fTable.length) {
            Entry e = this.fTable[i];
            Entry nextE = null;
            while (e != null) {
                Entry newNext;
                nextE = e.fNext;
                int newIndex = (e.fKey & Integer.MAX_VALUE) % newTable.length;
                e.fNext = newNext = newTable[newIndex];
                newTable[newIndex] = e;
                e = nextE;
            }
            ++i;
        }
        this.fTable = newTable;
    }

    public synchronized Enumeration elements() {
        return new HashtableEnumerator(this.fTable);
    }

    private static final class Entry {
        int fKey;
        Object fValue;
        Entry fNext;

        private Entry(int key, Object val, Entry next) {
            this.fKey = key;
            this.fValue = val;
            this.fNext = next;
        }
    }

    private static final class HashtableEnumerator
    implements Enumeration {
        int fIndex;
        Entry[] fTableSnapshot;
        Entry fEntry;

        HashtableEnumerator(Entry[] table) {
            this.fTableSnapshot = table;
            this.fIndex = table.length;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasMoreElements() {
            if (this.fEntry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.fEntry = this.fTableSnapshot[this.fIndex];
                if (this.fEntry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.fIndex-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.fEntry == null) {
                while (this.fIndex-- > 0 && (this.fEntry = this.fTableSnapshot[this.fIndex]) == null) {
                }
            }
            if (this.fEntry != null) {
                Entry e = this.fEntry;
                this.fEntry = e.fNext;
                return e.fValue;
            }
            throw new NoSuchElementException("HashtableEnumerator");
        }
    }
}

