/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.classfile.java;

import com.wily.util.classfile.FullyQualifiedFieldName;
import com.wily.util.classfile.FullyQualifiedMethodName;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.classfile.IContainerName;
import com.wily.util.classfile.IContainerPrefix;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IPackageName;
import com.wily.util.classfile.IPackagePrefix;
import com.wily.util.classfile.ISlotSignature;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidContainerNameException;
import com.wily.util.classfile.InvalidFieldDescriptorException;
import com.wily.util.classfile.InvalidFieldNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.InvalidPackageNameException;
import com.wily.util.classfile.java.ClassFileFieldDescriptor;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.ContainerName;
import com.wily.util.classfile.java.ContainerPrefix;
import com.wily.util.classfile.java.FieldName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.classfile.java.PackageName;
import com.wily.util.classfile.java.PackagePrefix;

public class JavaClassSchemaPolicy
implements IClassSchemaPolicy {
    private static final IClassSchemaPolicy sSingleton = new JavaClassSchemaPolicy();

    private JavaClassSchemaPolicy() {
    }

    public static IClassSchemaPolicy getJavaClassSchemaPolicy() {
        return sSingleton;
    }

    @Override
    public IContainerName getContainerName(String containerName) throws InvalidContainerNameException {
        return ContainerName.getDefaultContainerName();
    }

    @Override
    public IContainerPrefix getContainerPrefix(String prefix) throws InvalidContainerNameException {
        return ContainerPrefix.getDefaultContainerPrefix();
    }

    @Override
    public IClassName getClassName(String className) throws InvalidClassNameException {
        return ClassName.getClassName(className);
    }

    @Override
    public IPackageName getPackageName(String packageName) throws InvalidPackageNameException {
        return PackageName.getPackageName(packageName);
    }

    @Override
    public IPackageName getNonDefaultPackageName(String packageName) throws InvalidPackageNameException {
        return PackageName.getNonDefaultPackageName(packageName);
    }

    @Override
    public IPackagePrefix getPackagePrefix(String prefix) throws InvalidPackageNameException {
        return PackagePrefix.getPackagePrefix(prefix);
    }

    @Override
    public ISlotSignature getVoidSlotSignature() {
        return ClassFileFieldDescriptor.getVoidDescriptor();
    }

    @Override
    public ISlotSignature getSlotSignature(String descriptor) throws InvalidFieldDescriptorException {
        return ClassFileFieldDescriptor.getFieldDescriptor(descriptor);
    }

    @Override
    public IMethodSignature getMethodSignature() {
        return new ClassFileMethodDescriptor();
    }

    @Override
    public IMethodSignature getMethodSignature(String methodDescriptor) throws InvalidMethodDescriptorException {
        return new ClassFileMethodDescriptor(methodDescriptor);
    }

    @Override
    public IMethodName getMethodName(String name) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        return MethodName.getMethodName(name);
    }

    @Override
    public IMethodName getMethodNameWithDescriptor(String name) throws InvalidMethodDescriptorException, InvalidMethodNameException {
        return MethodName.getMethodNameWithDescriptor(name);
    }

    @Override
    public FullyQualifiedFieldName getFullyQualifiedFieldName(String name) throws InvalidClassNameException, InvalidFieldNameException, InvalidFieldDescriptorException {
        return this.getFullyQualifiedFieldNameWithDescriptor(name, null);
    }

    @Override
    public FullyQualifiedFieldName getFullyQualifiedFieldNameWithDescriptor(String name, ISlotSignature descriptor) throws InvalidClassNameException, InvalidFieldNameException, InvalidFieldDescriptorException {
        String normalizedName = name == null ? "" : name.replace('.', '/');
        String className = "";
        String fieldName = normalizedName;
        int separatorIndex = normalizedName.lastIndexOf(47);
        if (separatorIndex != -1) {
            className = normalizedName.substring(0, separatorIndex);
            fieldName = normalizedName.substring(separatorIndex + 1);
        }
        ClassName cls = ClassName.getClassName(className);
        FieldName field = FieldName.getFieldName(fieldName, (ClassFileFieldDescriptor)descriptor);
        return new FullyQualifiedFieldName(cls, field);
    }

    @Override
    public FullyQualifiedMethodName getFullyQualifiedMethodName(String name) throws InvalidClassNameException, InvalidMethodNameException, InvalidMethodDescriptorException {
        return JavaClassSchemaPolicy.parseMethodName(name == null ? "" : name, false);
    }

    @Override
    public FullyQualifiedMethodName getFullyQualifiedMethodNameWithDescriptor(String name) throws InvalidClassNameException, InvalidMethodNameException, InvalidMethodDescriptorException {
        return JavaClassSchemaPolicy.parseMethodName(name == null ? "" : name, true);
    }

    private static FullyQualifiedMethodName parseMethodName(String name, boolean descriptorIsRequired) throws InvalidClassNameException, InvalidMethodNameException, InvalidMethodDescriptorException {
        String fullyQualifiedMethodName = name;
        String methodDescriptor = "";
        int separatorIndex = name.indexOf(40);
        if (separatorIndex != -1) {
            fullyQualifiedMethodName = name.substring(0, separatorIndex);
            methodDescriptor = name.substring(separatorIndex);
        }
        String normalizedName = fullyQualifiedMethodName == null ? "" : fullyQualifiedMethodName.replace('.', '/');
        String className = "";
        String methodName = normalizedName;
        separatorIndex = normalizedName.lastIndexOf(47);
        if (separatorIndex != -1) {
            className = normalizedName.substring(0, separatorIndex);
            methodName = normalizedName.substring(separatorIndex + 1);
        }
        ClassName cls = ClassName.getClassName(className);
        MethodName method = null;
        method = descriptorIsRequired ? MethodName.getMethodNameWithDescriptor(String.valueOf(methodName) + methodDescriptor) : MethodName.getMethodName(String.valueOf(methodName) + methodDescriptor);
        return new FullyQualifiedMethodName(cls, method);
    }

    @Override
    public String getPatternMatchingFriendlyName(String name) {
        return name.replace('.', '/').trim();
    }
}

