/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.wilyassert.Assertion;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.SecureClassLoader;

public class DelegatingClassLoader
extends SecureClassLoader {
    private static final String fWilyOnWilyPrefix;
    private static final Permissions sPermissions;
    private ClassLoader[] delegateLoaders = new ClassLoader[0];

    static {
        String value = null;
        try {
            value = System.getProperty("com.wily.introscope.wilyForWilyPrefix");
        }
        catch (ThreadDeath t) {
            throw t;
        }
        catch (Throwable throwable) {
            value = null;
        }
        fWilyOnWilyPrefix = value;
        sPermissions = new Permissions();
        sPermissions.add(new AllPermission());
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        return sPermissions;
    }

    public DelegatingClassLoader(ClassLoader[] delegates) {
        this.init(delegates);
    }

    public DelegatingClassLoader(ClassLoader parentClassLoader, ClassLoader[] delegates) {
        super(parentClassLoader);
        this.init(delegates);
    }

    public void setClassLoaders(ClassLoader[] delegates) {
        this.init(delegates);
    }

    public ClassLoader[] getDelegates() {
        ClassLoader[] copy = new ClassLoader[this.delegateLoaders.length];
        System.arraycopy(this.delegateLoaders, 0, copy, 0, this.delegateLoaders.length);
        return copy;
    }

    private void init(ClassLoader[] delegates) {
        if (delegates != null && delegates.length > 0) {
            this.delegateLoaders = new ClassLoader[delegates.length];
            System.arraycopy(delegates, 0, this.delegateLoaders, 0, delegates.length);
        }
    }

    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (fWilyOnWilyPrefix != null && name != null && name.startsWith(fWilyOnWilyPrefix)) {
            Class c = this.findLoadedClass(name);
            if (c == null) {
                c = this.findClass(name);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        return super.loadClass(name, resolve);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        int i = 0;
        while (i < this.delegateLoaders.length) {
            try {
                if (this.delegateLoaders[i] != null) {
                    clazz = this.delegateLoaders[i].loadClass(name);
                }
                if (clazz != null) {
                    return clazz;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
            ++i;
        }
        Assertion.wilyAssert(clazz == null);
        throw new ClassNotFoundException("Class " + name + "not found");
    }

    @Override
    protected URL findResource(String name) {
        URL resource = null;
        int i = 0;
        while (i < this.delegateLoaders.length) {
            if (this.delegateLoaders[i] != null) {
                resource = this.delegateLoaders[i].getResource(name);
            }
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return resource;
    }
}

