/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.extension;

import com.wily.util.extension.DelegatingClassLoader;
import com.wily.util.extension.EagerAllPermissionsClassLoader;
import com.wily.util.extension.IExtension;
import com.wily.util.extension.IExtensionBroker;
import com.wily.util.extension.IExtensionClassPathResolver;
import com.wily.util.extension.IExtensionLocator;
import com.wily.util.extension.IExtensionProxy;
import com.wily.util.extension.IPlugin;
import com.wily.util.extension.InvalidExtensionException;
import com.wily.util.extension.JarExtensionProxy;
import com.wily.util.extension.KExtensionConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.topologicalsort.CycleExistsException;
import com.wily.util.topologicalsort.TopologicalSorter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ExtensionBroker
implements IExtensionBroker {
    private List fExtensionList = new ArrayList();
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IExtensionLocator[] fLocatorArray;
    private final ClassLoader fParentClassloader;
    private final IValidationFeedbackChannel fValidationFeedbackChannel;
    private static IExtensionClassPathResolver sClassPathResolver;

    public ExtensionBroker(ClassLoader parentClassloader, IExtensionLocator locator, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(parentClassloader, new IExtensionLocator[]{locator}, feedback, localizer);
    }

    public ExtensionBroker(ClassLoader parentClassloader, IExtensionLocator[] locatorArray, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this(parentClassloader, locatorArray, feedback, localizer, null);
    }

    public ExtensionBroker(ClassLoader parentClassloader, IExtensionLocator[] locatorArray, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IValidationFeedbackChannel validationFeedbackChannel) {
        this(parentClassloader, locatorArray, feedback, localizer, validationFeedbackChannel, null);
    }

    public ExtensionBroker(ClassLoader parentClassloader, IExtensionLocator[] locatorArray, IModuleFeedbackChannel feedback, IStringLocalizer localizer, IValidationFeedbackChannel validationFeedbackChannel, IndexedProperties properties) {
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
        this.fLocatorArray = locatorArray;
        this.fParentClassloader = parentClassloader;
        this.fValidationFeedbackChannel = validationFeedbackChannel;
        EagerAllPermissionsClassLoader.setProperties(properties);
    }

    public void loadExtensions() {
        this.loadExtensions(null);
    }

    public void loadExtensions(String[] extensionTypeMask) {
        List<String> types = null;
        if (extensionTypeMask != null) {
            types = Arrays.asList(extensionTypeMask);
        }
        this.fExtensionList.addAll(this.locateAndLoadExtensions(this.fLocatorArray, types));
    }

    public void loadExtensions(IExtensionLocator[] locatorArray, String[] extensionTypeMask, IExtension.IExtensionCallback cb) {
        List<String> types = null;
        if (extensionTypeMask != null) {
            types = Arrays.asList(extensionTypeMask);
        }
        List newExtensionList = this.locateAndLoadExtensions(locatorArray, types);
        for (IExtension currentExtension : newExtensionList) {
            currentExtension.IExtension_setCallback(cb);
            currentExtension.IExtension_load();
            this.fExtensionList.add(currentExtension);
        }
    }

    public void unloadExtensions(String[] extensionNames) {
        Iterator allExtensions = this.getExtensionsList().iterator();
        while (allExtensions.hasNext()) {
            IExtension currentExtension = (IExtension)allExtensions.next();
            int i = 0;
            while (i < extensionNames.length) {
                if (currentExtension.IExtension_getName().equals(extensionNames[i])) {
                    currentExtension.IExtension_getName();
                    this.fFeedback.info("Unloading extension classloader :" + currentExtension.IExtension_getClassLoader());
                    currentExtension.IExtension_unload();
                    allExtensions.remove();
                    this.fFeedback.info("Unloaded extension:" + currentExtension.IExtension_getName());
                }
                ++i;
            }
        }
    }

    @Override
    public IExtension[] IExtensionBroker_getFilteredExtensionList(String extensionTypeFilter) {
        Iterator allExtensions = this.getExtensionsList().iterator();
        ArrayList<IExtension> bag = new ArrayList<IExtension>();
        while (allExtensions.hasNext()) {
            IExtension currentExtension = (IExtension)allExtensions.next();
            if (!currentExtension.IExtension_getType().equals(extensionTypeFilter)) continue;
            bag.add(currentExtension);
        }
        return bag.toArray(KExtensionConstants.kZeroLengthExtensionArray);
    }

    public IExtension findExtension(String name) {
        for (IExtension currentExtension : this.getExtensionsList()) {
            if (!currentExtension.IExtension_getName().equals(name)) continue;
            return currentExtension;
        }
        return null;
    }

    @Override
    public IPlugin[] IExtensionBroker_getFilteredPluginList(String extensionTypeFilter, String pluginTypeFilter) {
        ArrayList<IPlugin> pluginBag = new ArrayList<IPlugin>();
        List<IExtension> extensionList = Arrays.asList(this.IExtensionBroker_getFilteredExtensionList(extensionTypeFilter));
        for (IExtension currentExtension : extensionList) {
            List<IPlugin> pluginsList = Arrays.asList(currentExtension.IExtension_getFilteredPluginList(pluginTypeFilter));
            for (IPlugin currentPlugin : pluginsList) {
                if (!currentPlugin.IPlugin_getType().equals(pluginTypeFilter)) continue;
                pluginBag.add(currentPlugin);
            }
        }
        return pluginBag.toArray(KExtensionConstants.kZeroLengthPluginArray);
    }

    public List getExtensionsList() {
        if (this.fExtensionList == null) {
            this.loadExtensions();
        }
        return this.fExtensionList;
    }

    private List locateAndLoadExtensions(IExtensionLocator[] locatorArray, Collection typeFilter) {
        HashMap<String, IExtensionProxy> extensionProxies = new HashMap<String, IExtensionProxy>();
        int x = 0;
        while (x < locatorArray.length) {
            IExtensionProxy[] locatedExtensionProxies = locatorArray[x].IExtensionLocator_locateExtensionProxies();
            int i = 0;
            while (i < locatedExtensionProxies.length) {
                IExtensionProxy extensionProxy = locatedExtensionProxies[i];
                if (typeFilter != null && !typeFilter.contains(extensionProxy.IExtensionProxy_getType())) {
                    this.fFeedback.verbose("Ignoring extension " + extensionProxy.IExtensionProxy_getName() + " of type " + extensionProxy.IExtensionProxy_getType() + ".");
                } else if (extensionProxies.containsKey(extensionProxy.IExtensionProxy_getName())) {
                    this.fFeedback.warn(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Extension_Duplicate_Message", new String[]{extensionProxy.IExtensionProxy_getName()}));
                    if (extensionProxy instanceof JarExtensionProxy) {
                        try {
                            ((JarExtensionProxy)extensionProxy).getfJarModule().close();
                        }
                        catch (IOException e) {
                            this.fFeedback.error("Error while closing lock for jar of " + extensionProxy.IExtensionProxy_getName());
                            this.fFeedback.debug("Exception: " + e.getMessage(), e);
                        }
                    }
                } else {
                    this.fFeedback.debug("adding extension proxy " + extensionProxy.IExtensionProxy_getName());
                    extensionProxies.put(extensionProxy.IExtensionProxy_getName(), extensionProxy);
                }
                ++i;
            }
            ++x;
        }
        return this.loadExtensionsFromProxies(extensionProxies);
    }

    private List loadExtensionsFromProxies(Map extensionProxies) {
        ArrayList extensionProxyList = new ArrayList(extensionProxies.values());
        try {
            TopologicalSorter.sort(extensionProxyList);
        }
        catch (CycleExistsException e) {
            this.fFeedback.error("Cycle exists in proxy list", e);
        }
        HashMap<String, IExtension> loadedExtensions = new HashMap<String, IExtension>();
        int i = 0;
        while (i < extensionProxyList.size()) {
            IExtensionProxy extensionProxy = (IExtensionProxy)extensionProxyList.get(i);
            String extensionProxyName = extensionProxy.IExtensionProxy_getName();
            String[] dependencies = extensionProxy.IExtensionProxy_getDependencies();
            IExtension extension = null;
            this.fFeedback.info("Extension Name ### ->" + extensionProxyName);
            this.fFeedback.debug("Dependency ->" + Arrays.asList(dependencies));
            this.fFeedback.debug("Loaded Extensions ########### ->" + loadedExtensions + (this.fExtensionList != null ? ", " + this.fExtensionList : ""));
            if (dependencies == null || dependencies.length == 0) {
                extension = this.loadExtension(extensionProxy, this.fParentClassloader);
            } else {
                ClassLoader[] parentClassLoaders = new ClassLoader[dependencies.length];
                int j = 0;
                while (j < dependencies.length) {
                    IExtension aParentExtension = (IExtension)loadedExtensions.get(dependencies[j]);
                    if (aParentExtension == null) {
                        aParentExtension = this.findExtension(dependencies[j]);
                    }
                    if (aParentExtension != null) {
                        parentClassLoaders[j] = aParentExtension.IExtension_getClassLoader();
                    } else {
                        this.fFeedback.error(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Extension_Invalid_Dependency_Message", new String[]{extensionProxyName, dependencies[j]}));
                    }
                    ++j;
                }
                ClassLoader theParentLoader = null;
                theParentLoader = parentClassLoaders.length == 1 ? parentClassLoaders[0] : new DelegatingClassLoader(parentClassLoaders);
                extension = this.loadExtension(extensionProxy, theParentLoader);
            }
            if (extension != null) {
                loadedExtensions.put(extensionProxy.IExtensionProxy_getName(), extension);
            }
            ++i;
        }
        return new ArrayList(loadedExtensions.values());
    }

    private IExtension loadExtension(IExtensionProxy extensionProxy, ClassLoader parentClassLoader) {
        try {
            IExtension extension = extensionProxy.IExtensionProxy_newInstance(this.fFeedback, parentClassLoader);
            return extension;
        }
        catch (InvalidExtensionException iee) {
            String message = iee.ILocalizableException_getLocalizableMessage().ILocalizableMessage_getLocalizedMessage(this.fLocalizer);
            this.fFeedback.warn(message);
        }
        catch (Throwable t) {
            this.fFeedback.error("Unexpected error loading extension ", t);
            this.logErrorValidationFeedback("Unexpected error loading extension ", t);
        }
        return null;
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }

    public static void finalizeClassLoaderDependencies(IModuleFeedbackChannel feedback, IExtension[] extensions, ClassLoader parentLoader) {
        HashMap<String, ClassLoader> loaderMap = new HashMap<String, ClassLoader>();
        try {
            TopologicalSorter.sort(extensions);
        }
        catch (CycleExistsException e) {
            feedback.error("Extensions contain circular dependency", e);
        }
        int i = 0;
        while (i < extensions.length) {
            ClassLoader parent;
            String[] dependencies = extensions[i].IExtension_getDependencies();
            if (dependencies == null || dependencies.length == 0) {
                parent = parentLoader;
            } else {
                ClassLoader[] parentLoaders = new ClassLoader[dependencies.length];
                int j = 0;
                while (j < dependencies.length) {
                    parentLoaders[j] = (ClassLoader)loaderMap.get(dependencies[j]);
                    if (parentLoaders[j] == null) {
                        feedback.error("Extension Depending Error. Extension: " + extensions[i].IExtension_getName() + " depends on extension " + dependencies[j] + " which wasn't found");
                    }
                    ++j;
                }
                parent = parentLoaders.length == 1 ? parentLoaders[0] : new DelegatingClassLoader(parentLoaders);
            }
            try {
                extensions[i].IExtension_setParentClassLoader(parent);
            }
            catch (InvalidExtensionException e) {
                feedback.error("Invalid extension", e);
            }
            loaderMap.put(extensions[i].IExtension_getName(), extensions[i].IExtension_getClassLoader());
            ++i;
        }
    }

    public static void setExtensionClassPathResolver(IExtensionClassPathResolver resolver) {
        sClassPathResolver = resolver;
    }

    public static IExtensionClassPathResolver getExtensionClassPathResolver() {
        return sClassPathResolver;
    }
}

